/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompilerParserException;
import oracle.bpm.compiler.FieldDeclaration;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.MethodTypeDescription;

public class ObjectConstructor
extends Method {
    static final long serialVersionUID = -6524952004439895718L;
    static final long serialCheck = 1485661756176558458L;

    public ObjectConstructor(MethodTypeDescription method) {
        super(method);
        this.setTypeDescription(method);
    }

    @Override
    public boolean isGenerateAdaptor() {
        return false;
    }

    @Override
    boolean isConstructor() {
        return true;
    }

    @Override
    Node checkType() throws TypeException {
        Block body = this.getStatements();
        assert (body != null) : "Missing body for '" + this.getMethodType() + "'. Tree: \n" + this.dump();
        Node first = null;
        Node last = null;
        for (FieldDeclaration field : this.getCurrentClass().getFields()) {
            Node init;
            if (field.isFinal() || field.isStatic() || field.isBitField() || (init = field.extractInit()) == null) continue;
            init.initialize(this);
            init.setParent(this);
            init.setSynthetic(true);
            if (first == null) {
                first = init;
            } else {
                last.setNext(init);
            }
            last = init;
        }
        if (first != null) {
            last.setNext(body.getFirst());
            body.setFirst(first);
        }
        super.checkType();
        return this;
    }

    @Override
    void parse(FuegoCompiler compiler) throws CompilerException {
        this.setFirst(null);
        MethodTypeDescription method = this.getMethodType();
        char[] source = method.getCodeText();
        try {
            if (source == null) {
                this.setBody(method.getName(), Block.makeEmpty(this));
            } else {
                Node m = compiler.parseMethod(method.getCode(), method.isFullParsing(), this);
                if (method.isFullParsing()) {
                    Node current = m.getFirst();
                    this.setFirst(current);
                } else {
                    this.setBody(method.getName(), m);
                }
            }
            this.addDeclarationsForVariables(method);
        }
        catch (CompilerParserException e) {
            e.setMember(this.getMethodType());
            this.setBody(method.getName(), Block.makeEmpty(this));
        }
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            current.setScope(this.getScope());
        }
    }
}

