/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.bcgen.ClassCode;
import fuego.bcgen.Mod;
import fuego.bcgen.ModSet;
import fuego.parser.collections.AST;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.cil.CilException;
import oracle.bpm.cil.UsageListener;
import oracle.bpm.compiler.Accessor;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.BaseObjectClass;
import oracle.bpm.compiler.CannotRedefineReadAccessException;
import oracle.bpm.compiler.CannotRedefineWriteAccessException;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CodeKit;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstantPool;
import oracle.bpm.compiler.CyclicInheritanceException;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.DuplicatedPositionException;
import oracle.bpm.compiler.FieldDeclaration;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.ForwardedMethod;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.FuegoInvokeable;
import oracle.bpm.compiler.Getter;
import oracle.bpm.compiler.IllegalTypeException;
import oracle.bpm.compiler.InnerTypeInheritanceException;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.InternalException;
import oracle.bpm.compiler.InvalidKeyTypeException;
import oracle.bpm.compiler.InvalidNameException;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.JVMByteCodeGenerator;
import oracle.bpm.compiler.JavaGenerator;
import oracle.bpm.compiler.JavaPrintWriter;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.MemberNotImplementedException;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.MissingPositionException;
import oracle.bpm.compiler.MissingPrimaryKeyException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NodeIterator;
import oracle.bpm.compiler.NotFuegoObjectException;
import oracle.bpm.compiler.ObjectConstructor;
import oracle.bpm.compiler.ObjectInvocator;
import oracle.bpm.compiler.PrimitiveTypeException;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.Setter;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.SymbolTable;
import oracle.bpm.compiler.Transform;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.UndefinedVirtualAttributeException;
import oracle.bpm.component.Modifiable;
import oracle.bpm.component.Replaceable;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Invocator;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaObject;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TransformTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NonNls;

public class ObjectClass
extends BaseObjectClass {
    private List<Accessor> accessors;
    private int attrCount;
    private ComponentCatalog catalog;
    private CodeKit.Check check;
    private Symbol classSymbol;
    private boolean codeGenerationInProgress;
    private boolean compiled = false;
    private List<Method> constructors;
    private List<Exception> errorsFound;
    private List<FieldDeclaration> fields;
    private Map<TypeDescription, FieldDeclaration> fieldsForSuperTypes;
    private boolean genBitSets;
    private boolean generateAdaptors;
    private boolean initFields;
    private Invocator invocator;
    private Map<String, String> mappings;
    private Map<String, Method> membersBySignature;
    private List<Method> methods;
    private Symbol parentSymbol;
    private Symbol superSymbol;
    private Map<String, MethodTypeDescription> syntheticMembers;
    private boolean topLevel;
    private CodeKit.ToString toString;
    private int uniqueNumber;
    @NonNls
    private static final String PARENT_SCOPE_GETTER_NAME = "$getParentScope";
    @NonNls
    private static final String PARENT_SCOPE_SETTER_NAME = "$setParentScope";
    static final String COMPARABLE_INTERFACE = Comparable.class.getName();
    private static final TypeDescription ANY = TypeFactory.getAny();
    private static final String PRESENTABLE = "Fuego.Lang.Presentable";
    private static final String COMPARABLE = "Java.Lang.Comparable";
    private static final String INTERNAL_PREFIX = "Fuego.Internal.";
    private static final String HIDDEN_PREFIX = "__";
    static final int BITS_PER_UNIT = 64;
    private static final String DELEGATE_SUFFIX = "_delegate";
    static final String MODIFIABLE_INTERFACE = Modifiable.class.getName();
    static final String REPLACEABLE_INTERFACE = Replaceable.class.getName();
    static final String BITSET_PREFIX = "__bitSet";

    ObjectClass(ObjectTypeDescription otd, FuegoCompiler compiler) {
        super(otd, compiler);
        this.objType = otd;
        this.setTopLevel(true);
        this.mappings = CollectionPool.getHashMap();
    }

    ObjectClass(ObjectTypeDescription otd, FuegoCompiler compiler, Node parent) {
        this(otd, compiler);
        this.setTopLevel(parent == null);
        this.setParent(parent);
        this.setTypeDescription(otd);
        this.classSymbol = new Symbol("this", otd);
        this.classSymbol.setAutoDeclared(this, true, true);
        if (otd.isInnerType()) {
            TypeDescription parentType = otd.getParent();
            this.parentSymbol = new Symbol(parentType.getText(), parentType);
            this.parentSymbol.setAutoDeclared(this, true, true);
            this.parentSymbol.setSignature("this_0");
        }
        this.createStructure(otd, compiler);
    }

    public static boolean isValidXMLObjectInterface(String className) {
        String fuegoObjectClassName = "oracle.bpm.xobject.runtime.components.FuegoObject";
        String presentableInterfaceName = "oracle.bpm.xobject.runtime.components.Presentable";
        return className.equals(MODIFIABLE_INTERFACE) || className.equals(REPLACEABLE_INTERFACE) || className.equals(fuegoObjectClassName) || className.equals(presentableInterfaceName);
    }

    @Override
    public String getText() {
        return "class " + this.objType.getName();
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    @Override
    public void generate(SourceGenerator cw) {
        cw.generate(this);
    }

    @Override
    public Method getCurrentMember() {
        return null;
    }

    @Override
    public Symbol getSymbol() {
        return this.classSymbol;
    }

    public void declareDependency(TypeRef dependency) {
        this.getObjectType().declareDependency(dependency);
    }

    @Override
    protected boolean splitToPrint() {
        return true;
    }

    static ObjectClass getOrCreate(FuegoCompiler compiler, TypeDescription type) {
        ObjectClass cl = null;
        if (type.isBpmObject() && (cl = compiler.getClassForType(type)) == null) {
            cl = (ObjectClass)compiler.addType(type.asObject());
        }
        return cl;
    }

    static TypeDescription findJavaBaseType(ObjectTypeDescription objType) {
        TypeDescription javaBaseType = null;
        for (SuperType superType : objType.getSuperTypes()) {
            boolean beInheritable;
            TypeDescription cl = superType.getType();
            if (javaBaseType != null && javaBaseType != ANY) continue;
            boolean javaInheritance = cl.getComponentType() != null && cl.getComponentType().equals("java") && !cl.isInterface();
            boolean fobjectInheritance = cl.isBpmObject();
            boolean bl = beInheritable = !cl.isNone() && !cl.isInvokeable() && !superType.isDelegated();
            if (!javaInheritance && !fobjectInheritance || !beInheritable) continue;
            javaBaseType = cl;
        }
        return javaBaseType;
    }

    Node addMember(MethodTypeDescription member) {
        Node node = member.isAttribute() ? this.addAttribute(member) : this.addMethod(member);
        return node;
    }

    void addSyntheticMember(Method member) {
        this.addChild((AST)member);
        if (member.getScope() == null && this.getScope() != null) {
            member.setScope(this.getScope());
        }
        this.addMethod(member);
        this.addSyntheticMember(member.getMethodType());
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        UsageListener listener = this.getCompiler().getUsageListener();
        try {
            boolean verbose = this.isVerbose();
            for (Node current = this.getFirst(); current != null; current = current.getNext()) {
                if (verbose) {
                    ObjectClass.message("flow-checking '" + current.getText() + "', type: '" + current.getTypeDescription().getText() + '\'');
                }
                context.setListener(listener);
                current.checkFlow(context);
            }
            context.breaksFlow(false);
        }
        catch (FlowException e) {
            this.reportError(e);
        }
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        ObjectTypeDescription objectType = this.getObjectType();
        this.setTypeDescription(objectType);
        if (this.errorsFound != null) {
            for (Exception anErrorsFound : this.errorsFound) {
                this.reportError((CilException)anErrorsFound);
            }
            throw (TypeException)this.errorsFound.get(0);
        }
        if (!objectType.isBpmObject()) {
            NotFuegoObjectException e = new NotFuegoObjectException((Node)this, objectType);
            this.reportError(e);
            throw e;
        }
        String name = objectType.getName();
        if (objectType.isInnerType() && name.equals(objectType.getParent().getName())) {
            this.reportError(new InvalidNameException(this, name));
        }
        for (SuperType superType : objectType.getSuperTypes()) {
            if (!superType.getType().isInnerType()) continue;
            this.reportError(new InnerTypeInheritanceException(this, objectType.getText(), superType.getType().getText(), superType.getType().getParent().getText()));
        }
        boolean comparable = Modifier.isComparable(objectType.getModifiers());
        if (comparable && !objectType.hasPrimaryKey()) {
            this.reportError(new MissingPrimaryKeyException((Node)this, objectType));
        }
        int count = objectType.getMemberCount();
        for (int i = 0; i < count; ++i) {
            MethodTypeDescription member = objectType.getMember(i);
            if (!member.isAttribute()) continue;
            boolean isVirtual = member.hasModifiers(0x20000000000L);
            TypeDescription resultType = member.getResultType();
            if (!isVirtual || member.hasGetter() || member.hasSetter()) continue;
            this.reportError(new UndefinedVirtualAttributeException((Node)this, member));
        }
        boolean verbose = this.isVerbose();
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            try {
                if (verbose) {
                    ObjectClass.message("type-checking '" + current.getText() + "', type: '" + current.getTypeDescription().getText() + '\'');
                }
                current = current.checkType();
                continue;
            }
            catch (TypeException e) {
                e.setMember(current.getTypeDescription());
                this.reportError(e);
                continue;
            }
            catch (Throwable unexpected) {
                this.reportError(new InternalException(current, unexpected));
            }
        }
        return this;
    }

    @Override
    Node compile(FuegoCompiler compiler) throws CompilerException {
        assert (!this.compiled) : "Already compiled: " + this.getObjectType();
        this.compiled = true;
        super.compile(compiler);
        if (this.errors == null && !compiler.getDirective(128)) {
            this.collectConstants();
        }
        return this;
    }

    FuegoInvokeable createInvokeable(Object[] args) {
        Invokeable superclass = this.createSuperInstance();
        FuegoInvokeable parent = null;
        if (!this.isTopLevel() && args != null) {
            List<Object> l = ArrayUtils.asList(args);
            parent = (FuegoInvokeable)l.remove(0);
            args = l.toArray();
        }
        FuegoInvokeable invokeable = new FuegoInvokeable(this, superclass, parent, args);
        if (this.objType instanceof XObjectTypeDescription) {
            invokeable.putResource("presentationsRes", ((XObjectTypeDescription)this.objType).getPresentations());
        }
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            if (!(current instanceof Method)) continue;
            Method method = (Method)current;
            invokeable.addMethod(method.getJavaSignature(), method);
            if (!method.isGenerateAdaptor() || method.isConstructor()) continue;
            Method.Adaptor adaptor = method.getDynamicObjectAdaptor();
            invokeable.addMethod(adaptor.getJavaSignature(), adaptor);
        }
        return invokeable;
    }

    Node createParentReference(Node init) {
        return new Deref(new LocalVar(this.getParentSymbol(), init));
    }

    Node createReference(Node init) {
        return new Deref(new LocalVar(this.getSymbol(), init));
    }

    Node createStaticReference(Node init) {
        return new TypeSpec(this.objType.get(), init);
    }

    Node createSuperReference(Node init) {
        return new Deref(new LocalVar(this.getSuperSymbol(), init));
    }

    MethodTypeDescription findSyntheticMember(String name) {
        MethodTypeDescription result = null;
        if (this.syntheticMembers != null) {
            result = this.syntheticMembers.get(name);
        }
        return result;
    }

    @Override
    void generate(CodeGenerator cg) throws CodeGenerationException {
        cg.generate(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generate(File targetDir) throws InternalException, CodeGenerationException {
        assert (!this.isCodeGenerationInProgress());
        boolean testMode = this.getCompiler().getDirective(16384);
        boolean javaSourceCompiler = this.getCompiler().getDirective(32768);
        this.setCodeGenerationInProgress(true);
        if (!javaSourceCompiler) {
            ModSet modifiers;
            File sourceName = this.getTargetJavaFile(targetDir, ".xcdl");
            ObjectTypeDescription objectType = this.getObjectType();
            String name = objectType.getJavaType();
            TypeDescription javaBaseType = ObjectClass.findJavaBaseType(objectType);
            String superClass = javaBaseType == null ? null : javaBaseType.getJavaType();
            ModSet modSet = modifiers = this.isTopLevel() ? Mod.PUBLIC : Mod.PUBLIC.STATIC();
            assert (name != null) : "Object type '" + objectType.getText() + "' does not have java type";
            ClassCode result = ClassCode.create(modifiers, name, superClass, sourceName.getName());
            try {
                this.gen(new JVMByteCodeGenerator(result, testMode, targetDir));
                result.endCode();
                result.save(targetDir);
            }
            catch (CodeGenerationException e) {
                this.reportError(e);
            }
            catch (Exception e) {
                throw new InternalException((Node)this, (Throwable)e);
            }
        } else {
            try {
                JavaPrintWriter pw = ObjectClass.createWriter(this, targetDir);
                try {
                    ObjectTypeDescription objectType = this.getObjectType();
                    TypeDescription module = objectType.getParent();
                    if (module != null) {
                        ObjectTypeDescription moduleType = module.asObject();
                        int count = moduleType.getInnerTypeCount();
                        for (int i = 0; i < count; ++i) {
                            String name = moduleType.getInnerType(i).getName();
                            pw.removeImportForClass(name);
                        }
                    }
                    int count = objectType.getInnerTypeCount();
                    for (int i = 0; i < count; ++i) {
                        String name = objectType.getInnerType(i).getName();
                        pw.removeImportForClass(name);
                    }
                    pw.removeImportForClass(this.getName());
                    this.gen(new JavaGenerator(pw, testMode));
                    pw.flush();
                    pw.close();
                }
                catch (Throwable throwable) {
                    StreamUtils.close(pw);
                    throw throwable;
                }
                StreamUtils.close(pw);
            }
            catch (IOException e) {
                throw new InternalException((Node)this, (Throwable)e);
            }
        }
    }

    @Override
    void generateCode(File targetDir) throws CilException {
        NodeIterator children = this.getChildren();
        while (children.hasNext()) {
            Node node = children.next();
            if (!(node instanceof ObjectClass)) continue;
            ObjectClass cl = (ObjectClass)node;
            cl.generateCode(targetDir);
        }
        if (this.isTopLevel()) {
            this.generate(targetDir);
        }
    }

    void generatingMessage(Node current) {
        if (this.isVerbose()) {
            ObjectClass.message("generating code for '" + current.getText() + "', type: '" + current.getTypeDescription().getText() + "' Node: " + current.getClass());
        }
    }

    List<Accessor> getAccessors() {
        return this.accessors;
    }

    @Override
    ComponentCatalog getCatalog() {
        return this.catalog != null ? this.catalog : this.getTypeDescription().getCatalog();
    }

    CodeKit.Check getCheck() {
        return this.check;
    }

    List<Method> getConstructors() {
        return this.constructors;
    }

    @Override
    ObjectClass getCurrentClass() {
        return this;
    }

    FuegoInvokeable getCurrentInvokeable() {
        SymbolTable symbols = this.getSymbolTable();
        return (FuegoInvokeable)symbols.get("this").getValue();
    }

    FieldDeclaration getFieldForSuperType(TypeDescription type) {
        return this.fieldsForSuperTypes != null ? this.fieldsForSuperTypes.get(type) : null;
    }

    List<FieldDeclaration> getFields() {
        return this.fields;
    }

    Invocator getInvocator() {
        if (this.invocator == null) {
            this.invocator = new ObjectInvocator(this);
        }
        return this.invocator;
    }

    Map<String, String> getMappings() {
        return Collections.unmodifiableMap(this.mappings);
    }

    Method getMemberBySignature(String signature) {
        if (this.membersBySignature == null) {
            this.membersBySignature = new HashMap<String, Method>();
            for (Node current = this.getFirst(); current != null; current = current.getNext()) {
                if (!(current instanceof Method)) continue;
                this.addMemberBySignature((Method)current);
            }
        }
        return this.membersBySignature.get(signature);
    }

    ObjectClass getParentClass() {
        ObjectClass parentClass = null;
        Node parent = this.getParent();
        if (parent != null) {
            parentClass = parent.getCurrentClass();
        }
        return parentClass;
    }

    @Override
    BaseObjectClass getTopLevelClass() {
        return this.isTopLevel() ? this : this.getParent().getTopLevelClass();
    }

    @Override
    int getUniqueNumber() {
        return this.uniqueNumber++;
    }

    @Override
    List<CilException> getWarnings() {
        return this.warnings == null ? super.getWarnings() : this.warnings;
    }

    boolean hasEmptyConstructor() {
        boolean hasEmptyConstructor = false;
        for (Method constructor : this.getConstructors()) {
            ObjectConstructor oc = (ObjectConstructor)constructor;
            if (oc.getMethodType().getArgumentCount() != 0) continue;
            hasEmptyConstructor = true;
            break;
        }
        return hasEmptyConstructor;
    }

    boolean hasMappings() {
        return this.mappings != null && !this.mappings.isEmpty();
    }

    boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    boolean isCodeGenerationInProgress() {
        return this.codeGenerationInProgress;
    }

    boolean isGenerateAdaptors() {
        return this.generateAdaptors;
    }

    boolean isGenerateBitSets() {
        return this.genBitSets;
    }

    boolean isReplaceable() {
        return Modifier.isReplaceable(this.objType.getModifiers());
    }

    @Override
    boolean isTopLevel() {
        return this.topLevel;
    }

    boolean isVerbose() {
        return this.getCompiler().getDirective(512);
    }

    boolean mustGenerateStubs() {
        return this.isProperty("generateStubs");
    }

    @Override
    void parse(FuegoCompiler compiler) throws CompilerException {
        boolean verbose = this.isVerbose();
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            if (verbose) {
                ObjectClass.message("parsing '" + current.getText() + "', type: '" + current.getTypeDescription().getText() + '\'');
            }
            current.parse(compiler);
        }
    }

    void setAccessors(List<Accessor> accessors) {
        this.accessors = accessors;
    }

    void setCatalog(ComponentCatalog catalog) {
        this.catalog = catalog;
    }

    void setCodeGenerationInProgress(boolean codeGenerationInProgress) {
        this.codeGenerationInProgress = codeGenerationInProgress;
    }

    void setConstructors(List<Method> constructors) {
        this.constructors = constructors;
    }

    void setCurrentInvokeable(FuegoInvokeable invokeable) {
        SymbolTable symbols = this.getSymbolTable();
        String currentName = this.getSymbol().getName();
        Symbol current = symbols.get(currentName);
        current.setValue(invokeable);
        TypeDescription type = this.getTypeDescription();
        if (type.isInnerType()) {
            String parentName = this.getParentSymbol().getName();
            Symbol symbol = symbols.get(parentName);
            if (invokeable != null) {
                symbol.setValue(invokeable.getParent());
            } else {
                symbol.setValue(null);
            }
        }
    }

    void setFields(List<FieldDeclaration> fields) {
        this.fields = fields;
    }

    void setMethods(List<Method> methods) {
        this.methods = methods;
    }

    @Override
    void setScope(Scope scp) {
        Scope classScope = new Scope(this.getCompiler());
        SymbolTable table = classScope.getSymbolTable();
        table.setDefaultTable(this.isTopLevel() ? this.getCompiler().getSymbolTable() : scp.getSymbolTable());
        table.push(this.classSymbol);
        if (this.parentSymbol != null) {
            table.push(this.parentSymbol);
        }
        table.setCurrentClass(this);
        ObjectTypeDescription objType = this.getObjectType();
        List<SuperType> superTypes = objType.getSuperTypes();
        if (!superTypes.isEmpty()) {
            boolean anyAsSuperType = false;
            TypeDescription superType = TypeFactory.getNone();
            for (SuperType sp : superTypes) {
                superType = sp.getType();
                if (sp.isDelegated() || superType.isInterface()) continue;
                if (superType != TypeFactory.getAny()) break;
                anyAsSuperType = true;
            }
            if (superType == TypeFactory.getNone() && anyAsSuperType) {
                superType = TypeFactory.getAny();
            }
            if (superType != TypeFactory.getNone()) {
                this.superSymbol = new Symbol("super", superType);
                this.superSymbol.setAutoDeclared(this, true, true);
                table.push(this.superSymbol);
            }
        }
        super.setScope(classScope);
    }

    void setTopLevel(boolean topLevel) {
        this.topLevel = topLevel;
    }

    @Override
    void collectConstants(ConstantPool cp) {
        this.collectConstants();
    }

    private static boolean isBuiltIn(SuperType superType) {
        String text = superType.getText();
        return superType.isHidden() || text.startsWith(INTERNAL_PREFIX) || text.equals(PRESENTABLE) || text.equals(COMPARABLE);
    }

    private static void message(String message) {
        System.out.println(message);
    }

    private static JavaPrintWriter createWriter(ObjectClass objectClass, File targetDir) throws FileNotFoundException, UnsupportedEncodingException {
        File target = objectClass.getTargetJavaFile(targetDir, ".java");
        FileOutputStream fos = new FileOutputStream(target);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
        return new JavaPrintWriter(writer, false);
    }

    private static boolean belongsToRootObject(MethodTypeDescription member) {
        boolean isFinalize;
        ObjectTypeDescription object = TypeFactory.getRootObject();
        boolean isClone = member.getName().equals("clone") && member.getArgumentCount() == 0 && member.getResultType().equals(object);
        boolean bl = isFinalize = member.getName().equals("finalize") && member.getArgumentCount() == 0 && member.getResultType().getKind() == 0;
        if (isClone || isFinalize) {
            return true;
        }
        int memberCount = object.getMemberCount();
        for (int i = 0; i < memberCount; ++i) {
            MethodTypeDescription objectMtd = object.getMember(i);
            if (!TypeUtils.sameSignature(objectMtd, member)) continue;
            return true;
        }
        return false;
    }

    private static TypeDescription getBaseType(TypeDescription objectType) {
        TypeDescription baseType = null;
        for (SuperType superType : objectType.getSuperTypes()) {
            TypeDescription type = superType.getType();
            if (!type.isBpmObject()) continue;
            baseType = type;
        }
        baseType = baseType != null ? ObjectClass.getBaseType(baseType) : objectType;
        return baseType;
    }

    private void addMapping(String signature, String target) {
        assert (signature != null) : "signature is null";
        assert (target != null) : "target is null";
        this.mappings.put(signature, target);
    }

    private void addAccessor(Accessor accessor) {
        if (this.membersBySignature != null) {
            this.addMemberBySignature(accessor);
        }
        this.getAccessors().add(accessor);
    }

    private Node addAttribute(MethodTypeDescription memberType) {
        AttributeTypeDescription attr = memberType.asAttribute();
        long mods = memberType.getModifiers();
        TypeSpec.checkValid(attr.getType(), this, attr);
        FieldDeclaration node = null;
        if (attr.getType().isVoid()) {
            IllegalTypeException error = new IllegalTypeException(this, attr.getType(), attr);
            error.setMember(attr);
            this.reportError(error);
        } else {
            boolean needsField;
            boolean virtual = attr.isVirtual();
            boolean needsGetter = !virtual || Modifier.hasGetter(mods);
            boolean needsSetter = !virtual || Modifier.hasSetter(mods);
            boolean bl = needsField = !virtual && !Modifier.isDetached(mods);
            if (needsGetter && !attr.getType().isUnknown()) {
                this.addAccessor(new Getter(attr, this.genBitSets ? this.attrCount : -1));
            }
            if (!Modifier.hasGetter(mods) && attr.getCode() != null) {
                this.reportError(new CannotRedefineReadAccessException((Node)this, attr));
            }
            if (needsField) {
                FieldDeclaration field;
                node = field = new FieldDeclaration(this, attr);
                field.setMustInit(this.isInitFields());
                this.addField(field);
            }
            if (needsSetter && !attr.getType().isUnknown()) {
                this.addAccessor(new Setter(attr, this.genBitSets ? this.attrCount : -1));
            }
            if (!Modifier.hasSetter(mods) && attr.getWriteCode() != null) {
                this.reportError(new CannotRedefineWriteAccessException((Node)this, attr));
            }
            if (attr.isRequired() && attr.getResultType().isPrimitive()) {
                this.reportWarning(new PrimitiveTypeException((Node)this, attr));
            }
        }
        ++this.attrCount;
        return node;
    }

    private void addBitSetsMembers() {
        int bitsetCount = this.attrCount > 0 ? this.attrCount / 64 + 1 : 0;
        this.addMethod(new CodeKit.IndexForField(this, this.getAccessors()));
        this.addMethod(new CodeKit.Reset(this, bitsetCount));
        this.addMethod(new CodeKit.IsModified(this, bitsetCount));
        for (int i = 0; i < bitsetCount; ++i) {
            long mods = 8192L;
            FieldDeclaration field = new FieldDeclaration(this, BITSET_PREFIX + i, TypeFactory.getPrimitiveInt(64), 8192L);
            this.addField(field);
        }
    }

    private void addCheckMethod() {
        this.addMethod(new CodeKit.OldCheck(this));
        this.check = new CodeKit.Check(this);
        this.addMethod(this.check);
    }

    private void addCloneMethod(ObjectTypeDescription otd) {
        MethodTypeDescription clone = otd.findMethod("clone", TypeFinder.Scope.INHERITED);
        if (clone == null) {
            this.addMethod(new CodeKit.Clone(this));
        }
    }

    private void addConstructor(Method constructor) {
        assert (constructor.isConstructor()) : "Not a constructor";
        this.getConstructors().add(constructor);
    }

    private void addDefaultConstructor(ObjectTypeDescription otd) {
        MethodTypeDescription member = otd.createConstructor();
        member.setParent(otd);
        ObjectConstructor constructor = new ObjectConstructor(member);
        constructor.setSynthetic(true);
        this.addConstructor(constructor);
    }

    private void addField(FieldDeclaration field) {
        this.getFields().add(field);
    }

    private void addInheritedMembers(AddedSuperType addedType, TypeDescription otd, Set<TypeDescription> addedTypes, List<AddedSuperType> hierarchy) {
        TypeDescription baseType = addedType.type;
        FieldDeclaration baseTypeField = addedType.field;
        if (addedTypes.contains(baseType) || baseType.isInterface()) {
            return;
        }
        addedTypes.add(baseType);
        int count = baseType.getMemberCount();
        for (int i = 0; i < count; ++i) {
            for (MethodTypeDescription member = baseType.getMemberType(i); member != null; member = member.getNextMethod()) {
                TypeDescription javaBaseType;
                long modifiers = member.getModifiers();
                boolean inherited = Modifier.isInherited(modifiers);
                MethodTypeDescription overridingMember = otd.overridingOf(member, TypeFinder.Scope.CURRENT);
                if (overridingMember == null && (javaBaseType = ObjectClass.findJavaBaseType(otd.asObject())) != null) {
                    overridingMember = javaBaseType.overridingOf(member, TypeFinder.Scope.CURRENT);
                }
                boolean overrides = overridingMember != null;
                boolean foundDuplicated = false;
                if (member.isMethod() && !member.isConstructor() && !overrides && !inherited && member.getReplacement() == null) {
                    for (MethodTypeDescription inheritedMember = otd.findMethod(member.getName(), TypeFinder.Scope.DELEGATED); inheritedMember != null && inheritedMember != member && !inheritedMember.getParent().isInterface(); inheritedMember = inheritedMember.getNextMethod()) {
                        if (!inheritedMember.matchArguments(member)) continue;
                        foundDuplicated = true;
                        break;
                    }
                    if (foundDuplicated || ObjectClass.belongsToRootObject(member)) continue;
                    this.addMethod(new ForwardedMethod(this, baseTypeField, member));
                    continue;
                }
                if (member.isAttribute() && !overrides && !inherited) {
                    AttributeTypeDescription attribute = member.asAttribute();
                    AttributeTypeDescription inheritedMember = otd.findAttribute(member.getName(), TypeFinder.Scope.DELEGATED);
                    boolean bl = foundDuplicated = inheritedMember != null && inheritedMember != attribute;
                    if (foundDuplicated) continue;
                    if (Modifier.hasGetter(modifiers) || Modifier.isOut(modifiers)) {
                        otd.findAttribute(attribute.getName()).addModifiers(8L);
                        this.addAccessor(new Getter.Forward(baseTypeField, attribute, -1));
                        this.addMapping(attribute.getSignature(), attribute.getJavaSignature());
                    }
                    if (!Modifier.hasSetter(modifiers) && !Modifier.isIn(modifiers)) continue;
                    otd.findAttribute(attribute.getName()).addModifiers(4L);
                    this.addAccessor(new Setter.Forward(baseTypeField, attribute, -1));
                    this.addMapping(attribute.getWriteSignature(), attribute.getJavaWriteSignature());
                    continue;
                }
                if (!overrides) continue;
                this.addMapping(member.getSignature(), overridingMember.getSignature());
            }
        }
        for (SuperType superType : baseType.getSuperTypes()) {
            TypeDescription type = superType.getType();
            hierarchy.add(new AddedSuperType(type, baseTypeField, superType.isDelegated()));
        }
    }

    private void addMemberBySignature(Method member) {
        Method replaced = this.membersBySignature.put(member.getJavaSignature(), member);
        assert (replaced == null) : "Two methods have the same signature: " + member.getJavaSignature();
        if (member.isGenerateAdaptor() && !member.isConstructor()) {
            Method.Adaptor adaptor = member.getDynamicObjectAdaptor();
            replaced = this.membersBySignature.put(adaptor.getJavaSignature(), adaptor);
            assert (replaced == null) : "Two methods have the same signature: " + adaptor.getJavaSignature();
        }
    }

    private void addMethod(Method method) {
        if (this.membersBySignature != null) {
            this.addMemberBySignature(method);
        }
        this.getMethods().add(method);
    }

    private Node addMethod(MethodTypeDescription memberType) {
        Method member;
        MethodTypeDescription method = memberType.asMethod();
        if (method.isConstructor()) {
            member = new ObjectConstructor(method);
            this.addConstructor(member);
        } else {
            if (memberType.isTransformation()) {
                member = new Transform(method, this);
                if (Transform.isToString((TransformTypeDescription)method)) {
                    this.toString = new CodeKit.ToString(this);
                    this.toString.setParent(this);
                }
            } else {
                member = new Method(method);
            }
            this.addMethod(member);
        }
        member.setGenerateAdaptor(this.generateAdaptors || Modifier.isAdaptors(method.getModifiers()));
        member.setParent(this);
        return member;
    }

    private void addParentField() {
        ObjectTypeDescription objType = this.getObjectType();
        assert (objType.isInnerType()) : "Not an inner type: " + objType;
        FieldDeclaration field = new FieldDeclaration(this, "this_0", objType.getParent(), 8192L);
        this.addField(field);
    }

    private void addReplacementId() {
        this.addField(new FieldDeclaration(this, "__replacementId", TypeFactory.getPrimitiveInt(64), 8192L));
        this.addSyntheticMember(new AttributeTypeDescription("__replacementId", TypeFactory.getPrimitiveInt(64), 32769L));
    }

    private void addSerialId(String serialId) {
        long mods = 139328L;
        FieldDeclaration serialField = new FieldDeclaration(this, "serialVersionUID", TypeFactory.getPrimitiveInt(64), 139328L);
        IntConst node = new IntConst(serialId);
        node.setTypeDescription(TypeFactory.getPrimitiveInt(64));
        serialField.setFirst(node);
        this.addField(serialField);
    }

    private void addSyntheticMember(MethodTypeDescription member) {
        if (member.getParent() == null) {
            member.setParent(this.getObjectType());
        }
        if (this.syntheticMembers == null) {
            this.syntheticMembers = CollectionPool.getHashMap();
        }
        MethodTypeDescription old = this.syntheticMembers.put(member.getName(), member);
        assert (old == null) : "Duplicated member " + member;
    }

    private void addValueOfMethod() {
        boolean hasDelegate = false;
        ObjectTypeDescription objectType = this.getObjectType();
        for (SuperType superType : objectType.getSuperTypes()) {
            String text = superType.getText();
            if (!"Fuego.Internal.XODelegate".equals(text)) continue;
            hasDelegate = true;
        }
        if (hasDelegate) {
            TypeDescription resultType = ObjectClass.getBaseType(objectType);
            CodeKit.ValueOf valueOf = new CodeKit.ValueOf(resultType);
            this.addMethod(valueOf);
        }
    }

    private void checkImplements(List typesStack, TypeDescription baseType) {
        int count = baseType.getMemberCount();
        for (int i = 0; i < count; ++i) {
            for (MethodTypeDescription member = baseType.getMemberType(i); member != null; member = member.getNextMethod()) {
                boolean isFinal = member.isFinal();
                boolean isAbstract = member.isAbstract();
                if (member.isStatic() || isFinal || !isAbstract) continue;
                this.checkImplements(typesStack, member);
            }
        }
    }

    private void checkImplements(List typesStack, MethodTypeDescription member) {
        MethodTypeDescription impl = null;
        boolean fuegoObject = member.getParent().isBpmObject();
        for (int i = 0; impl == null && i < typesStack.size(); ++i) {
            TypeDescription type = (TypeDescription)typesStack.get(i);
            for (impl = member.findIn(type, TypeFinder.Scope.CURRENT); impl != null && !impl.matchArguments(member, fuegoObject); impl = impl.getNextMethod()) {
            }
        }
        if (impl == null) {
            if (this.errorsFound == null) {
                this.errorsFound = CollectionPool.getArrayList();
            }
            TypeDescription type = (TypeDescription)typesStack.get(0);
            this.errorsFound.add(new MemberNotImplementedException(this, member, type));
        }
    }

    private CyclicInheritanceException checkSuperTypes() {
        CyclicInheritanceException cyclicError = null;
        List<TypeDescription> superTypes = CollectionPool.getArrayList();
        try {
            this.checkSuperTypes(this.getObjectType(), superTypes);
        }
        catch (CyclicInheritanceException e) {
            cyclicError = e;
        }
        CollectionPool.releaseArrayList(superTypes);
        return cyclicError;
    }

    private void checkSuperTypes(TypeDescription objectType, List<TypeDescription> typesStack) throws CyclicInheritanceException {
        if (objectType.isNone()) {
            return;
        }
        if (typesStack.contains(objectType)) {
            throw new CyclicInheritanceException(this, typesStack, objectType);
        }
        TypeSpec.checkValid(objectType, this, this.getTypeDescription());
        typesStack.add(objectType);
        for (SuperType superType : objectType.getSuperTypes()) {
            TypeDescription type = superType.getType();
            if (!ObjectClass.isBuiltIn(superType) && (superType.isInterface() || type.isAbstract() || type.isInterface())) {
                this.checkImplements(typesStack, type);
            }
            this.checkSuperTypes(type, typesStack);
        }
        typesStack.remove(typesStack.size() - 1);
    }

    private void collectConstants() {
        if (this.isVerbose()) {
            ObjectClass.message("collecting constants");
        }
        ConstantPool constantPool = new ConstantPool();
        super.collectConstants(constantPool);
        Const[] constants = constantPool.getConstants();
        Node last = null;
        for (Const constant : constants) {
            FieldDeclaration field = FieldDeclaration.createConstantField(this, constant);
            if (last == null) {
                this.addChild((AST)field);
            } else {
                last.setNext(field);
            }
            last = field;
        }
        constantPool.release();
    }

    private void createFieldsForSuperTypes(TypeDescription otd) {
        Set<TypeDescription> addedTypes = CollectionPool.getHashSet();
        List<AddedSuperType> hierarchy = CollectionPool.getArrayList();
        for (SuperType st : otd.getSuperTypes()) {
            boolean delegated;
            TypeDescription baseType = st.getType();
            if (baseType.isUnknown() || !(delegated = st.isDelegated()) && !baseType.isInvokeable() || baseType.isNone()) continue;
            String targetName = HIDDEN_PREFIX + Identifier.attribute(baseType.getName()) + DELEGATE_SUFFIX;
            AttributeTypeDescription attr = new AttributeTypeDescription(targetName, baseType, 0x10000000CL);
            attr.setParent(otd);
            FieldDeclaration field = new FieldDeclaration(this, attr);
            field.setParent(this);
            if (this.fieldsForSuperTypes == null) {
                this.fieldsForSuperTypes = CollectionPool.getHashMap();
            }
            this.fieldsForSuperTypes.put(baseType, field);
            this.initSuperTypeField(baseType, field, otd);
            Getter getter = new Getter(attr, -1);
            getter.setParent(this);
            getter.setOverride(true);
            this.addAccessor(getter);
            Setter setter = new Setter(attr, -1);
            setter.setParent(this);
            setter.setOverride(true);
            this.addAccessor(setter);
            this.addField(field);
            this.addSyntheticMember(attr);
            hierarchy.add(new AddedSuperType(baseType, field, delegated));
        }
        for (int i = 0; i < hierarchy.size(); ++i) {
            AddedSuperType superType = (AddedSuperType)hierarchy.get(i);
            this.addInheritedMembers(superType, otd, addedTypes, hierarchy);
        }
        CollectionPool.releaseArrayList(hierarchy);
        CollectionPool.releaseHashSet(addedTypes);
    }

    private List<ObjectClass> createInnerClasses(ObjectTypeDescription otd, FuegoCompiler compiler) {
        List<ObjectClass> classes = CollectionPool.getArrayList();
        int innerCount = otd.getInnerTypeCount();
        for (int i = 0; i < innerCount; ++i) {
            classes.add(new ObjectClass(otd.getInnerType(i), compiler, this));
        }
        return classes;
    }

    private void createStructure(ObjectTypeDescription otd, FuegoCompiler compiler) {
        CyclicInheritanceException cex = this.checkSuperTypes();
        if (cex != null) {
            if (this.errorsFound == null) {
                this.errorsFound = CollectionPool.getArrayList();
            }
            this.errorsFound.add(cex);
            return;
        }
        this.setInitFields(this.isProperty("initAllFields"));
        this.setGenerateAdaptors(compiler.getDirective(4) || Modifier.isAdaptors(otd.getModifiers()));
        this.setGenerateBitSets(this.isProperty("generateBitSets"));
        List<Method> constructorList = CollectionPool.getArrayList();
        this.setConstructors(constructorList);
        List<Method> methodList = CollectionPool.getArrayList();
        this.setMethods(methodList);
        List<Accessor> arrayList = CollectionPool.getArrayList();
        this.setAccessors(arrayList);
        List<FieldDeclaration> fieldList = CollectionPool.getArrayList();
        this.setFields(fieldList);
        this.attrCount = 0;
        int count = otd.getMemberCount();
        for (int i = 0; i < count; ++i) {
            MethodTypeDescription memberType = otd.getMemberType(i);
            assert (memberType.getParent() == otd) : "Type '" + otd + "' contains a member '" + memberType + "' that does not belong to it. (Belongs to '" + memberType.getParent() + "')";
            if (memberType.isAttribute()) {
                this.addAttribute(memberType);
                continue;
            }
            if (!memberType.isMethod() && !memberType.isTransformation()) continue;
            if (memberType.hasModifiers(0x10000000000L)) {
                AttributeTypeDescription cacheField = this.generateCacheMethodField(memberType);
                this.addAttribute(cacheField);
                MethodTypeDescription noCacheMethod = memberType.clone();
                noCacheMethod.setName(memberType.getName() + "_no_cache");
                this.addMethod(noCacheMethod);
                this.addSyntheticMember(noCacheMethod);
                CodeKit.MethodCache cachedMethod = new CodeKit.MethodCache(this, cacheField.getName(), memberType, noCacheMethod);
                this.addMethod(cachedMethod);
                continue;
            }
            this.addMethod(memberType);
        }
        this.notifyAttributeCountToAccessors();
        if (this.genBitSets) {
            this.addBitSetsMembers();
        }
        this.createFieldsForSuperTypes(otd);
        String serialId = otd.getProperty("javaSerialId");
        if (serialId != null) {
            this.addSerialId(serialId);
        }
        if (this.isReplaceable()) {
            this.addReplacementId();
        }
        if (this.getObjectType().isInnerType()) {
            this.addParentField();
        }
        boolean isGenerateSource = compiler.getDirective(1);
        Map<Integer, MethodTypeDescription> keys = CollectionPool.getTreeMap();
        Map<Integer, MethodTypeDescription> fieldsByPosition = CollectionPool.getHashMap();
        this.mapPositions(0, otd, fieldsByPosition, keys);
        if (!keys.isEmpty() && !isGenerateSource) {
            Collection<MethodTypeDescription> values = keys.values();
            MethodTypeDescription[] pks = values.toArray(new MethodTypeDescription[values.size()]);
            for (int i = 0; i < pks.length; ++i) {
                MethodTypeDescription pk = pks[i];
                if (otd.overridingOf(pk, TypeFinder.Scope.ALL_INHERITED) == null) continue;
                pks[i] = null;
            }
            if ((pks = ArrayUtils.trim(pks)).length > 0) {
                this.addMethod(new CodeKit.Equals(this, pks));
                this.addMethod(new CodeKit.HashCode(this, pks));
                if (this.toString == null) {
                    this.toString = new CodeKit.ToString(this, pks);
                }
                if (Modifier.isComparable(this.objType.getModifiers())) {
                    this.addMethod(new CodeKit.CompareTo(this, pks));
                }
            }
        }
        if (this.toString != null) {
            this.addMethod(this.toString);
        }
        this.addCloneMethod(otd);
        this.addCheckMethod();
        this.addValueOfMethod();
        List<Method> constructors = this.getConstructors();
        if (constructors.isEmpty()) {
            this.addDefaultConstructor(otd);
        }
        this.addAll(constructors);
        this.addAll(this.getAccessors());
        this.addAll(this.getMethods());
        this.addAll(this.getFields());
        this.addAll(this.createInnerClasses(otd, compiler));
        if (this.isTopLevel()) {
            this.setScope(null);
        }
        CollectionPool.releaseTreeMap(keys);
    }

    private AttributeTypeDescription generateCacheMethodField(MethodTypeDescription method) {
        TypeRef cacheType;
        try {
            cacheType = TypeUtils.getDefaultCatalog().find("Fuego.Internal.Cache");
            assert (cacheType != null) : "Fuego.Internal.Cache not found. Catalog: " + TypeUtils.getDefaultCatalog();
        }
        catch (AmbiguousTypeNameException e) {
            throw new Error(e.getMessage(), e);
        }
        String fieldName = method.getName() + "$cache";
        AttributeTypeDescription attribute = new AttributeTypeDescription(fieldName, cacheType);
        attribute.setModifiers(8264L);
        attribute.setRequired(true);
        this.addSyntheticMember(attribute);
        return attribute;
    }

    private Invokeable createSuperInstance() {
        try {
            ObjectTypeDescription objType = this.getObjectType();
            TypeDescription baseType = null;
            for (SuperType superType : objType.getSuperTypes()) {
                TypeDescription currentType = superType.getType();
                if (currentType.isInterface() || superType.isDelegated() || currentType.isInvokeable() || currentType.isNone() || baseType != null && baseType != ANY) continue;
                baseType = currentType;
            }
            Invokeable instance = null;
            if (baseType != null && !baseType.isInterface()) {
                boolean fuegoObject = baseType.isBpmObject();
                if (fuegoObject) {
                    ObjectClass objectClass = ObjectClass.getOrCreate(this.getCompiler(), baseType);
                    instance = objectClass.createInvokeable(null);
                } else {
                    Class javaClass = baseType.asObject().getJavaClass();
                    instance = (Invokeable)javaClass.newInstance();
                    instance = instance instanceof Invokeable ? (Invokeable)instance : new JavaObject<FuegoInvokeable>((FuegoInvokeable)instance);
                }
            }
            return instance;
        }
        catch (IllegalStateException e) {
            this.reportError(new InternalException((Node)this, (Throwable)e));
        }
        catch (InstantiationException e) {
            this.reportError(new InternalException((Node)this, (Throwable)e));
        }
        catch (IllegalAccessException e) {
            this.reportError(new InternalException((Node)this, (Throwable)e));
        }
        return null;
    }

    private long getModifiers() {
        return this.getTypeDescription().getModifiers();
    }

    private Symbol getParentSymbol() {
        return this.parentSymbol;
    }

    private Symbol getSuperSymbol() {
        return this.superSymbol;
    }

    private void initSuperTypeField(TypeDescription baseType, FieldDeclaration field, TypeDescription otd) {
        if (baseType.hasDefaultInit()) {
            field.setFirst(Const.valueOf("", baseType, this));
        } else {
            TypeDescription argType;
            MethodTypeDescription constructor = baseType.findMember(baseType.getName());
            if (constructor != null && constructor.getArgumentCount() == 1 && (argType = constructor.getArgument(0).getType()).isAssignableFrom(otd)) {
                Args args = new Args(1L);
                args.initialize(this);
                LocalVar local = new LocalVar(this.classSymbol, null);
                local.initialize(this);
                args.addInArgument(local);
                Invoke constrCall = new Invoke(null, constructor, args, false);
                constrCall.setExpression(true);
                constrCall.setParent(this);
                field.setFirst(constrCall);
            }
        }
    }

    private boolean isInitFields() {
        return this.initFields;
    }

    private boolean isProperty(String property) {
        return Boolean.parseBoolean(this.getObjectType().getProperty(property));
    }

    private int mapPositions(int start, TypeDescription type, Map<Integer, MethodTypeDescription> fieldsByPosition, Map<Integer, MethodTypeDescription> keys) {
        for (SuperType superType : type.getSuperTypes()) {
            if (superType.isHidden() || !superType.isDelegated()) continue;
            start = this.mapPositions(start, superType.getType(), fieldsByPosition, keys);
        }
        int maxPosition = start;
        int count = type.getMemberCount();
        for (int i = 0; i < count; ++i) {
            MethodTypeDescription old;
            MethodTypeDescription member = type.getMemberType(i);
            if (!member.isAttribute()) continue;
            AttributeTypeDescription attr = member.asAttribute();
            int position = attr.getPosition();
            if (position != -1 && (old = fieldsByPosition.put(position += start, attr)) != null) {
                this.reportError(new DuplicatedPositionException(this, position, attr, old));
            }
            if (attr.isPrimaryKey()) {
                TypeDescription attributeType = attr.getType();
                if (!attributeType.isAtomic() || attributeType.getKind() == 8) {
                    this.reportError(new InvalidKeyTypeException(this, attributeType, attr));
                }
                if (position == -1) {
                    this.reportError(new MissingPositionException((Node)this, attr));
                }
                keys.put(position, attr);
            }
            maxPosition = Math.max(maxPosition, position);
        }
        return maxPosition;
    }

    private void notifyAttributeCountToAccessors() {
        List<Accessor> accessors = this.getAccessors();
        int length = accessors.size();
        for (int i = 0; i < length; ++i) {
            Accessor accessor = accessors.get(i);
            accessor.setAttrCount(this.attrCount);
        }
    }

    private void setGenerateAdaptors(boolean generateAdaptors) {
        this.generateAdaptors = generateAdaptors;
    }

    private void setGenerateBitSets(boolean genBitSets) {
        this.genBitSets = genBitSets;
    }

    private void setInitFields(boolean init) {
        this.initFields = init;
    }

    private static class SyntheticMethod
    extends Method {
        SyntheticMethod(TypeDescription otd, String name, String code, TypeRef resultType, Argument ... args) {
            super(new MethodTypeDescription(name, 0x100000000L));
            MethodTypeDescription mtd = this.getMethodType();
            for (Argument arg : args) {
                mtd.addArgument(arg);
            }
            mtd.setResultType(resultType);
            mtd.setCode(code, "Fuego");
            this.setSynthetic(true);
            otd.asObject().addMember(mtd);
        }

        @Override
        String getFullName() {
            return this.getName();
        }

        @Override
        Node checkType() throws TypeException {
            Node result = super.checkType();
            ((DoBlock)result).setWrapTypedExceptions(false);
            return result;
        }
    }

    static class AddedSuperType {
        boolean delegation;
        FieldDeclaration field;
        TypeDescription type;

        AddedSuperType(TypeDescription type, FieldDeclaration field, boolean delegation) {
            this.type = type;
            this.field = field;
            this.delegation = delegation;
        }
    }
}

