/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Completion;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.InvalidNodeException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Return;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.TypeDescription;

public class NamedNode
extends Node {
    private TypeDescription nameType;
    static final long serialVersionUID = -5409311201112298029L;
    static final long serialCheck = 4442901379979642072L;

    public NamedNode(Token t) {
        super(t);
    }

    public NamedNode(AST id, AST node) {
        assert (id instanceof Identifier || id instanceof Return || id instanceof Completion) : "Invalid node: " + id + "(" + id.getClass() + ")";
        this.addChild(id);
        this.addChild(node);
        this.initialize(id);
        node.setNextSibling(null);
    }

    NamedNode(String name, Node node) {
        this((AST)new Identifier(name), (AST)node);
        this.initialize(node);
    }

    public String getName() {
        return this.getOp1().getText();
    }

    public void setNameType(TypeDescription nameType) {
        this.nameType = nameType;
    }

    public TypeDescription getNameType() {
        return this.nameType;
    }

    public Node getTargetNode() {
        return this.getOp2();
    }

    @Override
    public Node getTargetValue() {
        Node targetNode = this.getTargetNode();
        Node n = targetNode.getTargetValue();
        if (n == null) {
            return null;
        }
        this.getFirst().setNext(n);
        return this;
    }

    @Override
    public String getText() {
        return this.getOp1() instanceof Identifier ? this.getOp1().getText() : "";
    }

    @Override
    public void generate(SourceGenerator cw) {
        cw.generate(this);
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getKind() == -1) {
            Node name = this.getOp1();
            Node node = this.getOp2();
            if (node == null) {
                throw new InvalidNodeException(this);
            }
            if ((node = node.checkType()) != null) {
                this.setOperands(name, node);
                this.setTypeDescription(node.getTypeDescription());
            }
        }
        return this;
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        Node targetNode = this.getOp2();
        if (targetNode != null) {
            targetNode.gen(codeGenerator);
        }
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Node targetNode = this.getOp2();
        if (targetNode != null) {
            return targetNode.run(rm);
        }
        return null;
    }
}

