/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;

public class MissingReturnException
extends FlowException {
    static final long serialVersionUID = 6304934604584653879L;
    static final long serialCheck = 6078720460835186929L;

    public MissingReturnException(Node node, TypeDescription returnType) {
        super(node, CompilerMsg.MISSINGRETURN(MissingReturnException.text(returnType, node)));
        this.updateOffset(node);
    }

    private void updateOffset(Node node) {
        MethodTypeDescription method = node.getCurrentMember().getMethodType();
        char[] chars = method.getCodeText();
        if (chars != null) {
            int i;
            int line = 1;
            for (i = 0; i < chars.length; ++i) {
                char aChar = chars[i];
                if (aChar != '\n') continue;
                ++line;
            }
            this.setLine(line);
            this.setOffset(i);
            this.setLength(0);
            this.setColumn(1);
        }
    }
}

