/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.InternalException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.util.FixOption;

public class MemberReferenceException
extends TypeException {
    static final long serialVersionUID = -7795441091629037205L;
    static final long serialCheck = 8417132609015722036L;

    public MemberReferenceException(Node object) {
        super(object);
        String type;
        String string = type = object.getKind() == -1 ? object.getText() : MemberReferenceException.text(object.getTypeDescription(), object);
        if (object.getTypeDescription().isMethod()) {
            this.setKey(CompilerMsg.M_METHODNOTOBJ(type));
        } else {
            this.setKey(CompilerMsg.NOTANOBJECT(type));
        }
    }

    protected MemberReferenceException(Node node, Msg key) {
        super(node, key);
    }

    MemberReferenceException(Node node, TypeDescription objType, String wrongName, String rightName) {
        super(node, CompilerMsg.INVMEMBER_H(wrongName, MemberReferenceException.text(objType, node), rightName));
        this.addFixOption(new FixName(wrongName, rightName));
    }

    private MemberReferenceException(TypeDescription objType, Node member, TypeDescription type, boolean findClosest) {
        super(member);
        int length = 0;
        MethodTypeDescription[] members = null;
        String wrongName = member.getText();
        if (findClosest) {
            members = objType.findClosestMembers(wrongName, 2);
            length = members.length;
        }
        if (length == 0) {
            this.setKey(CompilerMsg.INVMEMBER(wrongName, MemberReferenceException.text(objType, this.node)));
            if (!objType.asObject().isDefault()) {
                this.addFixOption(new AddMember(wrongName, objType, type));
            }
        } else {
            FixOption[] options = new FixOption[++length];
            options[0] = new AddMember(wrongName, objType, type);
            for (int i = 1; i < length; ++i) {
                options[i] = new FixName(wrongName, members[i - 1].getName());
            }
            this.setFixOptions(options);
            this.setKey(CompilerMsg.INVMEMBER_H(wrongName, MemberReferenceException.text(objType, this.node), members[0].getName()));
        }
    }

    public static MemberReferenceException illegallMember(TypeDescription objType, Node member) {
        return MemberReferenceException.illegallMember(objType, member, null);
    }

    public static MemberReferenceException illegallMember(TypeDescription objType, Node member, TypeDescription type) {
        return new MemberReferenceException(objType, member, type, false);
    }

    public static MemberReferenceException illegallMemberSearchClosest(TypeDescription objType, Node member) {
        return MemberReferenceException.illegallMemberSearchClosest(objType, member, null);
    }

    public static MemberReferenceException illegallMemberSearchClosest(TypeDescription objType, Node member, TypeDescription type) {
        return new MemberReferenceException(objType, member, type, true);
    }

    class FixName
    extends FixOption {
        private String replacement;
        private String wrongId;

        public FixName(String wrongId, String replacement) {
            super("Use '" + replacement + "' instead of '" + wrongId + "'");
            this.wrongId = wrongId;
            this.replacement = replacement;
            this.setType(MemberReferenceException.this.getMember());
        }

        @Override
        public void fix() throws CompilerException {
            MethodTypeDescription method = (MethodTypeDescription)MemberReferenceException.this.getMember();
            int col = MemberReferenceException.this.getColumn() - 1;
            int line = MemberReferenceException.this.getLine() - 1;
            try {
                String[] lines = Str.split(Str.valueOf(method.getCodeText()), '\n', false);
                String wrongLine = lines[line];
                if (this.wrongId.equals(wrongLine.substring(col, col + this.wrongId.length()))) {
                    String left = wrongLine.substring(0, col);
                    String right = wrongLine.substring(col + this.wrongId.length(), wrongLine.length());
                    lines[line] = left + this.replacement + right;
                    method.setCode(Str.join(lines, '\n').toCharArray(), method.getCodeLanguage());
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new InternalException(null, (Throwable)e);
            }
        }
    }

    static class AddMember
    extends FixOption {
        private String name;
        private TypeDescription objectType;
        private TypeDescription type;

        public AddMember(String name, TypeDescription objectType) {
            this(name, objectType, null);
        }

        public AddMember(String name, TypeDescription objectType, TypeDescription type) {
            super("Declare variable");
            this.name = name;
            this.objectType = objectType;
            this.type = type;
            this.setFixType(0);
        }

        @Override
        public void fix() throws Exception {
            TypeDescription attributeType = TypeFactory.getAny();
            if (this.type != null) {
                attributeType = TypeFactory.forKind(this.type.getKind(), this.type.getLength(), this.type.getScale());
            }
            AttributeTypeDescription member = new AttributeTypeDescription(this.name, attributeType);
            this.setType(member);
            this.objectType.asObject().addMember(member);
        }
    }
}

