/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.lang.reflect.InvocationTargetException;
import oracle.bpm.compiler.ClassConst;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.ConstantPool;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.DefaultConst;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.EnumConst;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FieldDeclaration;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.FuegoInvokeable;
import oracle.bpm.compiler.Function;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.InvalidExpr;
import oracle.bpm.compiler.InvalidNodeException;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReferenceException;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.NoSuchArgumentException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NotInstantiableException;
import oracle.bpm.compiler.NullReferenceException;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.SymbolTable;
import oracle.bpm.compiler.TDKit;
import oracle.bpm.compiler.Template;
import oracle.bpm.compiler.TemplateSpec;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.UnexpectedMethodException;
import oracle.bpm.compiler.ValueReference;
import oracle.bpm.compiler.WriteOnlyMemberException;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.JavaObject;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.Operation;
import org.apache.bcel.generic.Type;
import org.jetbrains.annotations.NonNls;

public class MemberReference
extends MemberAccess {
    private ClassConst objectClass;
    static final long serialVersionUID = 8813180741848368235L;
    static final long serialCheck = -320938250896595401L;

    public MemberReference(Token t) {
        super(t);
    }

    MemberReference() {
    }

    MemberReference(@NonNls String obj, @NonNls String member) {
        this(new Identifier(obj), new Identifier(member));
    }

    MemberReference(Node obj, Node member) {
        this.copyParentFrom(obj);
        this.setOperands(obj, member);
    }

    MemberReference(Node obj, Node memberNode, MethodTypeDescription member) {
        this.copyParentFrom(obj);
        this.setMemberType(member);
        this.setOperands(obj, memberNode);
    }

    public ClassConst getObjectClass() {
        return this.objectClass;
    }

    @Override
    public Node getTargetValue() {
        return this;
    }

    @Override
    public String getText() {
        return Method.getText(this.getMemberType());
    }

    @Override
    public String getTypeText() {
        String object = this.getOp1() != null ? this.getOp1().getTypeText() : null;
        String member = this.getOp2() != null ? this.getOp2().getTypeText() : null;
        return object != null && member != null ? object + "." + member : null;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getObject(), this.getOp2());
    }

    protected MethodTypeDescription findMember(int requiredKind, TypeDescription objectType, Node memberNode, String memberName) throws MemberReferenceException, UnexpectedMethodException {
        MethodTypeDescription result;
        if (requiredKind != -1) {
            result = requiredKind == 14 ? this.findMethod(objectType, memberName, memberNode) : this.findMember(objectType, memberName, requiredKind, memberNode);
        } else {
            boolean isReadable;
            result = this.findMember(objectType, memberName, 18, memberNode);
            long modifiers = result != null ? result.getModifiers() : 0L;
            boolean bl = isReadable = Modifier.hasGetter(modifiers) || Modifier.isOut(modifiers);
            if (!isReadable) {
                MethodTypeDescription member = this.findMethod(objectType, memberName, memberNode);
                if (member == null) {
                    if (result != null) {
                        throw new WriteOnlyMemberException(this.getOp1(), memberNode);
                    }
                } else if (member.getArgumentCount() != 0 || member.getResultType().isVoid()) {
                    throw new UnexpectedMethodException(this.getOp1(), member, objectType);
                }
                result = member;
            }
        }
        return result;
    }

    @Override
    String getJavaType() {
        String javaType;
        MethodTypeDescription memberType = this.getMemberType();
        if (memberType != null) {
            javaType = memberType.getJavaType();
        } else {
            TypeDescription type = this.getTypeDescription();
            assert (type.isEnum()) : "Type should be an enum";
            javaType = type.getJavaType();
        }
        return javaType;
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        return new Operation(1, null, null, this.getMemberType().getSignature());
    }

    @Override
    boolean isPrimitiveAccess() {
        return this.isReferenceToCurrentGetter();
    }

    Type getResultTD() {
        return TDKit.getType(this.getTypeDescription(), this.getResultType());
    }

    Type getFieldTD() {
        return TDKit.getType(this.getTypeDescription(), this.getMemberType().getResultType().javaType());
    }

    String getResultType() {
        return this.getMemberType().getResultArgument().getJavaType();
    }

    boolean isSqlComponent() {
        ObjectTypeDescription objectTypeDescription = this.getObjType().asObject();
        String type = objectTypeDescription.getComponentType();
        return ComponentType.SQL.getText().equals(type) || ComponentType.SQL_QUERY.getText().equals(objectTypeDescription.getName());
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        Node object = this.getObject();
        Node member = this.getOp2();
        object.checkFlow(context);
        if (member != null) {
            member.checkFlow(context);
        }
        context.breaksFlow(false);
        if (member != null) {
            MethodTypeDescription memberType = this.getMemberType();
            context.use(memberType, member);
        }
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        return this.checkType(-1);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    Node checkType(int requiredKind) throws TypeException {
        block31: {
            if (this.getKind() != -1) {
                return this;
            }
            memberNode = this.getOp2();
            object = this.getOp1();
            if (memberNode instanceof InvalidExpr) {
                throw new InvalidNodeException(memberNode);
            }
            if (this.isArgReference()) {
                return this.derefArg();
            }
            symbols = this.getSymbolTable();
            try {
                type = TypeSpec.findType(this);
                typeText = type.getText();
                symbol = symbols.get(typeText);
                if (symbol != null) {
                    return new LocalVar(symbol, this);
                }
                parent = this.getParent();
                if (parent instanceof MemberReference || parent instanceof Invoke) {
                    typeSpec = new TypeSpec(type, this);
                    typeSpec.setParent(parent);
                    return typeSpec;
                }
            }
            catch (TypeException e) {
                // empty catch block
            }
            object.setLeftValue(this.isLeftValue());
            object = object.checkType();
            if (object == null || object instanceof TypeSpec) {
                try {
                    objectType = TypeSpec.findType(this);
                    return MemberReference.defaultInstanceFor(objectType, this);
                }
                catch (NotInstantiableException e) {
                    throw e;
                }
                catch (TypeException e) {
                    objectType = TypeSpec.findType(this.getOp1());
                    symbol = symbols.get(objectType.getName());
                    if (symbol == null) ** GOTO lbl48
                    object = new LocalVar(symbol, this);
                }
            } else if (object.getTypeDescription().isBinary()) {
                result /* !! */  = new Function("Fuego.Internal.Binary", object, this);
                result /* !! */  = result /* !! */ .checkType();
                object = result /* !! */ ;
                objectType = object.getTypeDescription();
            } else {
                symbol = (object = this.derefLocal(object)).getSymbol();
                if (symbol != null && symbol.getTarget() != null && (symbol = symbol.getTarget()).isFilteredIterable()) {
                    this.setParametric(false);
                }
                objectType = symbol != null && memberNode.getText().equals("delete") != false && symbol.getType().findMember("delete") != null ? symbol.getType() : object.getTypeDescription();
            }
lbl48:
            // 4 sources

            if (objectType == null) {
                throw new MemberReferenceException(this.getOp1());
            }
            if (memberNode.isCompletion()) {
                if (object == null) {
                    object = this.getOp1();
                    object.setTypeDescription(objectType);
                }
                memberNode.complete(2, object);
            }
            if ((member = this.findMember(requiredKind, objectType, memberNode, memberName = memberNode.getText())) == null) {
                this.setOperands(object != null ? object : this.getOp1(), memberNode);
                throw MemberReferenceException.illegallMemberSearchClosest(objectType, memberNode);
            }
            if (member.isConstructor()) {
                throw MemberReferenceException.illegallMember(objectType, memberNode);
            }
            if (objectType.isEnum() && member.isConst()) {
                return new EnumConst(objectType.asEnum(), member.asAttribute(), this);
            }
            this.delegationInClient = MemberReference.isDelegated(objectType, member);
            this.setTypeDescription(requiredKind == -1 ? member.getResultType() : member);
            if (objectType.isInvokeable()) {
                this.setTypeDescription(this.getTypeDescription().setReferenceType(true));
            }
            if (!(object != null && !(object instanceof TypeSpec) || member.isStatic() && !objectType.isInvokeable())) {
                if (object == null) {
                    object = new TypeSpec(objectType, this.getOp1());
                    object.setParent(this);
                }
                try {
                    object = MemberReference.defaultInstanceFor(objectType, object);
                    objectType = object.getTypeDescription();
                }
                catch (NotInstantiableException e) {
                    if (requiredKind == 14) break block31;
                    throw e;
                }
            }
        }
        if (MemberReference.isDelegatedBySignature(member.getSignature(), objectType)) {
            this.delegationInClient = true;
        }
        if (!MemberReference.$assertionsDisabled && objectType == null) {
            throw new AssertionError();
        }
        this.setObjType(objectType);
        this.setMemberType(member);
        if (!this.isGeneratingSource() && member.isStatic() && this.isLeftValue()) {
            this.objectClass = new ClassConst(objectType, (Node)this);
        }
        if (member.isAttribute()) {
            this.checkDeprecated(member, memberNode);
        }
        retArg = member.getResultArgument();
        this.setOperands(object == null ? this.getOp1() : object, memberNode);
        result /* !! */  = this;
        if (requiredKind != 14) {
            result /* !! */  = this.checkRefactor(member, object);
        }
        result /* !! */  = this.promote(member, result /* !! */ , retArg);
        this.getCurrentClass().declareDependency(objectType);
        return result /* !! */ ;
    }

    @Override
    void collectConstants(ConstantPool cp) {
        super.collectConstants(cp);
        if (this.objectClass != null) {
            this.objectClass.collectConstants(cp);
        }
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        codeGenerator.generate(this);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        if (this.isParameter()) {
            sql.append(" ? ");
        } else {
            assert (false);
            sql.append(this.getColumnReference().getSignature());
        }
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Class<?> argType;
        Object value;
        JavaObject<Object> invokeable;
        Object instance = this.runObjectReference(rm);
        MethodTypeDescription member = this.getMemberType();
        TypeDescription objType = this.getObjType();
        String getter = MemberReference.getSignature(objType, member);
        String setter = MemberReference.getWriteSignature(objType, member);
        if (instance == null && !member.isStatic() && !this.isDelegationInClient()) {
            throw new NullReferenceException(this.getObject(), new ValueReference(instance, objType, this.getOp1().getTypeText()));
        }
        if (!objType.isInvokeable()) {
            if (instance instanceof Invokeable) {
                invokeable = (Invokeable)instance;
            } else if (objType == this.getThis().getType()) {
                invokeable = (Invokeable)this.getThis().getValue();
            } else {
                Class<?> cl = instance != null ? instance.getClass() : (member.isStatic() ? member.getParent().getJavaClass() : objType.getJavaClass());
                if (MemberReference.isDelegatedBySignature(member.getSignature(), member.getParent())) {
                    try {
                        Object[] objectArray;
                        if (member.isStatic()) {
                            objectArray = null;
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = instance;
                        }
                        return member.invoke(null, objectArray);
                    }
                    catch (ComponentExecutionException e) {
                        throw new CompilerExceptionShell((Node)this, (Throwable)e);
                    }
                }
                JavaClass javaClass = (JavaClass)Cast.force(JavaClass.fromClass(cl));
                invokeable = new JavaObject<Object>(javaClass, instance);
            }
        } else {
            assert (instance == null || instance instanceof Invokeable) : "Not an invokeable: " + JavaClass.classInfo(instance);
            invokeable = (JavaObject<Object>)instance;
        }
        if (MemberReference.isDelegatedBySignature(getter, objType)) {
            Object[] args = null;
            if (!member.isStatic()) {
                args = new Object[]{this.getOp1().value(rm)};
            }
            try {
                value = member.getParent().invokeMethod(getter, null, args);
            }
            catch (Exception e) {
                throw new CompilerExceptionShell((Node)this, (Throwable)e);
            }
        } else {
            FuegoInvokeable fuegoInvokeable = MemberReference.fuegoInvokable(invokeable);
            if (fuegoInvokeable != null && this.isPrimitiveAccess()) {
                value = fuegoInvokeable.getField(FieldDeclaration.name(member.getName()));
            } else {
                assert (invokeable != null);
                if (!this.isLeftValue() || setter == null) {
                    value = ((Invokeable)invokeable).getAttributeValue(getter);
                } else {
                    value = ((Invokeable)invokeable).getAttributeValue(getter, setter);
                    if (this.isLeftValue() && value == null) {
                        value = new DefaultConst(this, member.getResultType()).run(rm);
                        ((Invokeable)invokeable).setAttributeValue(setter, value);
                    }
                }
            }
        }
        String type = objType.asObject().getComponentType();
        Class<?> clazz = argType = value != null ? value.getClass() : null;
        if (ComponentType.SQL.getText().equals(type) || ComponentType.SQL_QUERY.getText().equals(objType.getName())) {
            TypeDescription typeDescription = this.getTypeDescription();
            if (typeDescription.getKind() == 8) {
                return oracle.bpm.util.Conversion.toBinary(value);
            }
            String methodName = "to" + typeDescription.getJavaType().replace('.', '_');
            while (argType != null) {
                try {
                    java.lang.reflect.Method method = oracle.bpm.util.Conversion.class.getMethod(methodName, argType);
                    value = method.invoke(null, value);
                    return value;
                }
                catch (NoSuchMethodException nsme) {
                }
                catch (IllegalAccessException e) {
                    throw new CompilerExceptionShell((Node)this, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new CompilerExceptionShell((Node)this, (Throwable)e);
                }
                argType = argType.getSuperclass();
            }
        }
        return value;
    }

    private static FuegoInvokeable fuegoInvokable(Object invokeable) {
        return invokeable instanceof FuegoInvokeable ? (FuegoInvokeable)invokeable : null;
    }

    private boolean isArgReference() {
        return this.getOp1() instanceof Identifier && this.getOp1().getText().equals("arg");
    }

    private boolean isReferenceToCurrentGetter() {
        Method method = this.getCurrentMember();
        Symbol objectSymbol = this.getObject().getSymbol();
        return objectSymbol == this.getThis() && method != null && method.isGetter() && this.getMemberName().equals(method.getName()) && !method.getMethodType().hasModifiers(0x20000000000L);
    }

    private Node checkRefactor(MethodTypeDescription member, Node object) {
        Node result = this;
        if (Modifier.isRefactor(member.getModifiers())) {
            try {
                TemplateSpec spec = TemplateSpec.create(member.getCode());
                Template refactor = spec.instantiate(this);
                refactor.addParameter("object", object);
                result = refactor.apply();
            }
            catch (CompilerException e) {
                // empty catch block
            }
        }
        return result;
    }

    private Node derefArg() throws TypeException {
        String name;
        SymbolTable symbols;
        Symbol arg;
        Node memberNode = this.getOp2();
        if (memberNode.isCompletion()) {
            memberNode.complete(5, memberNode);
        }
        if ((arg = (symbols = this.getSymbolTable()).getArgument(name = this.getOp2().getText())) == null) {
            Method currentMember = this.getCurrentMember();
            throw new NoSuchArgumentException(this.getOp2(), currentMember.getMethodType(), name);
        }
        LocalVar var = new LocalVar(arg, this);
        Deref deref = new Deref(var);
        var.copyTreePositionFrom(this);
        deref.copyTreePositionFrom(this);
        return deref.checkType();
    }

    private Node promote(MethodTypeDescription member, Node node, Argument retArg) throws TypeException {
        if (!node.getTypeDescription().isMethod()) {
            if (this.getObjType().isInvokeable()) {
                if (this.isSqlComponent() || member.getResultType().isPredefined()) {
                    TypeDescription targetType = node.getTypeDescription();
                    ObjectTypeDescription sourceType = TypeFactory.getRootObject();
                    node.setTypeDescription(sourceType);
                    node = Conversion.promote(node, targetType);
                }
            } else if (Modifier.isExternal(retArg.getModifiers())) {
                TypeDescription targetType = retArg.getType();
                if (!retArg.getJavaType().equals(targetType.getJavaType())) {
                    node = Conversion.Import.create(node, retArg.getJavaType(), targetType).checkType();
                    return node;
                }
            }
        }
        return node;
    }
}

