/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.compiler.AmbiguousCallException;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.DeprecatedException;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.FieldDeclaration;
import oracle.bpm.compiler.FuegoInvokeable;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NotInstantiableException;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.Ternary;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeFinder;

public class MemberAccess
extends Ternary {
    protected boolean delegationInClient = false;
    protected MethodTypeDescription memberType;
    protected TypeDescription objType = null;
    private static final TypeDescription[] NUMERIC_TYPE_DISTANCE = new TypeDescription[]{TypeFactory.getInt(8), TypeFactory.getInt(16), TypeFactory.getInt(32), TypeFactory.getInt(64), TypeFactory.getDecimal(), TypeFactory.getReal(32), TypeFactory.getReal(), TypeFactory.getAny()};
    static final long serialVersionUID = -8374150792649580303L;
    static final long serialCheck = -2986576809012921839L;

    MemberAccess() {
    }

    MemberAccess(Token t) {
        super(t);
    }

    public MethodTypeDescription getMemberType() {
        return this.memberType;
    }

    public Node getObject() {
        return this.getOp1();
    }

    protected static Node defaultInstanceFor(TypeDescription type, Node init) throws TypeException {
        return MemberAccess.defaultInstanceFor(type, init, true);
    }

    protected static Node defaultInstanceFor(TypeDescription type, Node init, boolean useConstructor) throws TypeException {
        Node result;
        block8: {
            TypeDescription current;
            ObjectClass currentClass;
            block9: {
                block7: {
                    result = null;
                    String typeText = type.getText();
                    Symbol symbol = init.getSymbolTable().get(typeText);
                    currentClass = init.getCurrentClass();
                    current = currentClass.getTypeDescription();
                    if (symbol == null) break block7;
                    result = new LocalVar(symbol, init);
                    break block8;
                }
                if (!type.equals(current)) break block9;
                Method member = init.getCurrentMember();
                if (member.isStatic() && !member.isConstructor()) break block8;
                result = currentClass.createReference(init);
                break block8;
            }
            if (current.isInnerType() && current.getParent().equals(type)) {
                result = currentClass.createParentReference(init);
            } else {
                for (SuperType superType : current.getSuperTypes()) {
                    if (superType.getType() != type || type.getKind() == 10) continue;
                    if (superType.isDelegated() && !init.isGeneratingSource()) {
                        FieldDeclaration field = currentClass.getFieldForSuperType(type);
                        result = field.createReference(init);
                        break;
                    }
                    if (superType.getType().isInterface()) {
                        result = currentClass.createReference(init);
                        break;
                    }
                    result = currentClass.createSuperReference(init);
                    break;
                }
            }
        }
        if (result == null) {
            if (!type.hasDefaultInit() || !useConstructor) {
                throw NotInstantiableException.noDefaultInit(init);
            }
            result = Identifier.autodeclare(type.getText(), type, init, true);
            result.copyTreePositionFrom(init);
            result = new Deref(result);
        }
        result = result.checkType();
        return result;
    }

    protected static MethodTypeDescription select(List<MethodTypeDescription> memberList, Map<String, TypeDescription> namedInArgs, TypeDescription[] unnamedInArgs, boolean onlyExactMatch, Node node) {
        int count;
        MethodTypeDescription first;
        if (memberList.size() > 0) {
            MethodTypeDescription current = memberList.get(0);
            block0: while (current != null) {
                TypeDescription container = current.getParent();
                for (current = container.findMethod(current.getName(), TypeFinder.Scope.ALL_INHERITED); current != null; current = current.getNextMethod()) {
                    if (memberList.contains(current)) continue;
                    memberList.add(current);
                    continue block0;
                }
            }
        }
        if (memberList.size() == 1 && !onlyExactMatch && (first = memberList.get(0)).getNextMethod() == null) {
            return first;
        }
        MethodTypeDescription firstSelected = null;
        List selectedList = null;
        int maxHits = 0;
        Iterator<MethodTypeDescription> i$ = memberList.iterator();
        while (i$.hasNext()) {
            for (MethodTypeDescription current = i$.next(); current != null; current = current.getNextMethod()) {
                int hits = 0;
                int length = current.getArgumentCount();
                for (int j = 0; j < length; ++j) {
                    Argument arg = current.getArgument(j);
                    String name = arg.getName();
                    if (!arg.isIn() || name == null || name.equals("") || !namedInArgs.containsKey(name) && !namedInArgs.containsKey("arg" + (j + 1))) continue;
                    ++hits;
                }
                if (hits > maxHits) {
                    firstSelected = current;
                    if (selectedList != null) {
                        selectedList.clear();
                        selectedList.add(firstSelected);
                    }
                    maxHits = hits;
                    continue;
                }
                if (hits != maxHits) continue;
                if (firstSelected == null) {
                    firstSelected = current;
                    continue;
                }
                if (selectedList == null) {
                    selectedList = CollectionPool.getArrayList();
                    selectedList.add(firstSelected);
                }
                selectedList.add(current);
            }
        }
        int n = selectedList != null ? selectedList.size() : (count = firstSelected != null ? 1 : 0);
        if (count == 0 || count == 1 && !onlyExactMatch) {
            if (selectedList != null) {
                CollectionPool.releaseArrayList(selectedList);
            }
            return firstSelected;
        }
        if (selectedList == null) {
            selectedList = CollectionPool.getArrayList();
            selectedList.add(firstSelected);
        }
        int argCount = unnamedInArgs.length + maxHits;
        for (int i = count - 1; i >= 0; --i) {
            MethodTypeDescription current = (MethodTypeDescription)selectedList.get(i);
            int requiredArgCount = 0;
            int argc = current.getArgumentCount();
            for (int j = 0; j < argc; ++j) {
                if (current.getArgument(j).isOptional()) continue;
                ++requiredArgCount;
            }
            if (argCount >= requiredArgCount && argCount <= argc || count == 1 && !onlyExactMatch) continue;
            selectedList.remove(i);
            --count;
        }
        MethodTypeDescription result = null;
        if (selectedList.size() > 0) {
            result = (MethodTypeDescription)selectedList.get(0);
        }
        if (count == 0 || count == 1 && !onlyExactMatch) {
            return result;
        }
        List<MethodTypeDescription> applicable = CollectionPool.getArrayList();
        for (int i = 0; i < count; ++i) {
            MethodTypeDescription mtd = (MethodTypeDescription)selectedList.get(i);
            boolean assignable = MemberAccess.isAssignableFromArgs(mtd, unnamedInArgs, namedInArgs);
            if (!assignable) continue;
            applicable.add(mtd);
        }
        CollectionPool.releaseArrayList(selectedList);
        count = applicable.size();
        if (count == 0) {
            return onlyExactMatch ? null : result;
        }
        result = MemberAccess.chooseMostSpecific(applicable, unnamedInArgs, namedInArgs, node);
        CollectionPool.releaseArrayList(applicable);
        return result;
    }

    protected static MethodTypeDescription select(List<MethodTypeDescription> memberList, Args inputArgs, boolean onlyExactMatch, Node node) throws TypeException {
        Map<String, TypeDescription> namedInArgs = inputArgs != null ? inputArgs.getNamedArgs() : null;
        TypeDescription[] unnamedInArgs = inputArgs != null ? inputArgs.getUnnamedArgs() : null;
        return MemberAccess.select(memberList, namedInArgs, unnamedInArgs, onlyExactMatch, node);
    }

    protected static MethodTypeDescription select(MethodTypeDescription method, Args inputArgs, boolean onlyExactMatch, Node node) throws TypeException {
        List<MethodTypeDescription> members = CollectionPool.getArrayList();
        members.add(method);
        MethodTypeDescription result = MemberAccess.select(members, inputArgs, onlyExactMatch, node);
        CollectionPool.releaseArrayList(members);
        return result;
    }

    protected static MethodTypeDescription selectBest(MethodTypeDescription memberList, Map<String, TypeDescription> namedInArgs, TypeDescription[] unnamedInArgs, Node node) {
        if (memberList.getNextOrSuperMethod() == null) {
            return memberList;
        }
        List<MethodTypeDescription> members = CollectionPool.getArrayList();
        members.add(memberList);
        MethodTypeDescription result = MemberAccess.select(members, namedInArgs, unnamedInArgs, false, node);
        CollectionPool.releaseArrayList(members);
        return result;
    }

    protected static MethodTypeDescription selectBest(MethodTypeDescription method, Args inputArgs, Node node) throws TypeException {
        Map<String, TypeDescription> namedInArgs = inputArgs != null ? inputArgs.getNamedArgs() : null;
        TypeDescription[] unnamedInArgs = inputArgs != null ? inputArgs.getUnnamedArgs() : null;
        return MemberAccess.selectBest(method, namedInArgs, unnamedInArgs, node);
    }

    @Override
    protected TypeDescription getDeclarationFor(Node child) {
        return child == this.getObject() ? this.objType : this.getMemberType();
    }

    protected void checkDeprecated(MethodTypeDescription memberType, Node node) {
        long modifiers = memberType.getModifiers();
        if (Modifier.isDeprecated(modifiers) && this.getCurrentLanguage().isLastVersion()) {
            this.reportWarning(new DeprecatedException(node, memberType));
        }
    }

    protected Node derefLocal(Node object) throws TypeException {
        if (object instanceof LocalVar) {
            boolean isSynthetic = object.isSynthetic();
            object = new Deref(object);
            object = object.checkType();
            object.setSynthetic(isSynthetic);
        }
        return object;
    }

    static boolean isAssignableFromArgs(MethodTypeDescription member, TypeDescription[] unnamedInArgs, Map namedInArgs) {
        int argc = member.getArgumentCount();
        List argsList = CollectionPool.getArrayList();
        for (TypeDescription arg : unnamedInArgs) {
            argsList.add(arg);
        }
        for (int i = 0; i < argc; ++i) {
            Argument arg = member.getArgument(i);
            TypeDescription argType = (TypeDescription)namedInArgs.get(arg.getName());
            if (argType == null) {
                argType = (TypeDescription)namedInArgs.get("arg" + (arg.getNumber() + 1));
            }
            if (argType == null) continue;
            if (i > argsList.size()) {
                for (int j = argsList.size(); j < i; ++j) {
                    argsList.add(j, null);
                }
            }
            argsList.add(i, argType);
        }
        boolean assignable = true;
        for (int i = 0; i < argsList.size(); ++i) {
            TypeDescription argType = (TypeDescription)argsList.get(i);
            Argument argument = member.getArgument(i);
            if (argType != null) {
                if (argument.getType().isAssignableFrom(argType)) continue;
                assignable = false;
                break;
            }
            if (argument.isOptional()) continue;
            assignable = false;
            break;
        }
        CollectionPool.releaseArrayList(argsList);
        return assignable;
    }

    static boolean isCallToParent(TypeDescription objType, MethodTypeDescription member, Node init) {
        return objType.isInnerType() && init.findMember(objType, member.getName(), member.getKind(), init, false, false) == null;
    }

    static String getDelegateClass(String signature) {
        int index = signature.indexOf(";");
        return signature.substring(1, index);
    }

    static boolean isDelegated(TypeDescription source, MethodTypeDescription member) {
        boolean delegated = false;
        if (source != member.getParent() && !source.isBpmObject()) {
            for (SuperType current : source.getSuperTypes()) {
                if (!current.isDelegated() || current.getType() != member.getParent()) continue;
                delegated = true;
                break;
            }
        }
        return delegated;
    }

    static boolean isDelegatedBySignature(String signature, TypeDescription type) {
        String componentType = type.asObject().getComponentType();
        boolean isOk = !type.isObject() || componentType.equals("java") || componentType.equals("object");
        return signature != null && isOk && signature.length() > 0 && signature.charAt(0) == 'L' && signature.indexOf(";") != -1;
    }

    static String getDelegatedMember(String signature) {
        int index = signature.indexOf(";");
        return signature.substring(index + 1);
    }

    static String getSignature(TypeDescription type, MethodTypeDescription member) {
        return type.getSignature(member);
    }

    static String getWriteSignature(TypeDescription type, MethodTypeDescription member) {
        return type.getWriteSignature(member);
    }

    @Override
    boolean isComplexExpression() {
        return false;
    }

    boolean isDelegationInClient() {
        return this.delegationInClient;
    }

    @Override
    boolean isExternal() {
        return Modifier.isExternal(this.getMemberType().getModifiers());
    }

    String getMemberName() {
        return this.getMemberType().getName();
    }

    void setMemberType(MethodTypeDescription member) {
        this.memberType = member;
    }

    void setObjType(TypeDescription objType) {
        this.objType = objType;
    }

    TypeDescription getObjType() {
        return this.objType;
    }

    boolean isPrimitiveAccess() {
        return false;
    }

    @Override
    Node checkType() throws TypeException {
        return this.checkType(-1);
    }

    @Override
    List<Node> collectParameters(List<Node> params) {
        if (this.isParametric()) {
            this.setParameter(true);
            params.add(this);
        }
        return params;
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        if (this.isParameter()) {
            sql.append(" ? ");
        } else {
            sql.append(this.getColumnReference().getSignature());
        }
    }

    Object runObjectReference(RunningMonitor rm) throws ExecutionException {
        FuegoInvokeable fuegoInvokeable;
        Object result;
        TypeDescription objType = this.getObjType();
        MethodTypeDescription member = this.getMemberType();
        if (!objType.isObject() && this.isDelegationInClient()) {
            if (MemberAccess.isDelegatedBySignature(member.getSignature(), member.getParent())) {
                result = this.getObject().value(rm);
            } else if (member.isStatic()) {
                result = null;
            } else {
                MethodTypeDescription memberType;
                Object obj = this.getObject().value(rm);
                TypeDescription sourceOTD = this.getObject().getTypeDescription();
                TypeDescription targetOTD = member.getParent();
                MethodTypeDescription constr = null;
                int mn = targetOTD.getMemberIndex(targetOTD.getName());
                if (mn != -1 && (memberType = targetOTD.getMemberType(mn)).isMethod()) {
                    for (MethodTypeDescription method = memberType.asMethod(); method != null; method = method.getNextMethod()) {
                        if (method.getArgumentCount() != 1 || !sourceOTD.isStrictSubtype(method.getArgument(0).getType())) continue;
                        constr = method;
                        break;
                    }
                }
                try {
                    result = constr == null ? null : constr.invoke(null, new Object[]{obj});
                }
                catch (ComponentExecutionException e) {
                    throw new CompilerExceptionShell((Node)this, (Throwable)e);
                }
            }
        } else if (member.isStatic() && !objType.isInvokeable() && !member.isConstructor()) {
            result = member.isAttribute() && objType.isBpmObject() || member.isMethod() && member.getParent().isBpmObject() ? this.getObject().value(rm) : null;
        } else if (this.isDelegationInClient()) {
            result = this.getObject().value(rm);
            Class<?> delegate = member.getParent().getJavaClass();
            try {
                Constructor<?> constructor = delegate.getConstructor(this.getObject().getTypeDescription().getJavaClass());
                result = constructor.newInstance(result);
            }
            catch (NoSuchMethodException e) {
                throw new CompilerExceptionShell((Node)this, (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new CompilerExceptionShell((Node)this, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new CompilerExceptionShell((Node)this, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new CompilerExceptionShell((Node)this, e.getCause());
            }
        } else {
            result = this.getObject().value(rm);
        }
        if (MemberAccess.isCallToParent(objType, member, this) && result instanceof FuegoInvokeable) {
            FuegoInvokeable invokeable = (FuegoInvokeable)result;
            result = invokeable.getParent();
        }
        if (result instanceof FuegoInvokeable && (fuegoInvokeable = (FuegoInvokeable)result).getRunningMonitor() == null) {
            fuegoInvokeable.setRunningMonitor(rm);
        }
        return result;
    }

    private static boolean isBetterMatchThan(MethodTypeDescription currentBest, MethodTypeDescription candidate, TypeDescription[] unnamedInArgs, Map<String, TypeDescription> namedArgsSet) {
        for (int j = 0; j < unnamedInArgs.length; ++j) {
            TypeDescription candidateArgType;
            TypeDescription givenArgType = unnamedInArgs[j];
            TypeDescription bestArgType = currentBest.getArgument(j).getType();
            if (!MemberAccess.isBetterMatchThan(bestArgType, candidateArgType = candidate.getArgument(j).getType(), givenArgType)) continue;
            return true;
        }
        for (Map.Entry<String, TypeDescription> entry : namedArgsSet.entrySet()) {
            TypeDescription argType;
            String name = entry.getKey();
            TypeDescription givenArgType = entry.getValue();
            Argument resultArg = currentBest.findArgument(name);
            TypeDescription resultArgType = resultArg != null ? resultArg.getType() : null;
            resultArg = candidate.findArgument(name);
            TypeDescription typeDescription = argType = resultArg != null ? resultArg.getType() : null;
            if (resultArgType == null || argType == null || !MemberAccess.isBetterMatchThan(resultArgType, argType, givenArgType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isBetterMatchThan(TypeDescription best, TypeDescription candidate, TypeDescription given) {
        boolean result;
        assert (candidate.isAssignableFrom(given)) : "MemberAccess.isBetterMatchThan() : TypeDescription.isAssignableFrom(candidate, given)";
        switch (given.getKind()) {
            case 2: 
            case 3: 
            case 4: {
                TypeDescription nbest = best.primitiveEquivalent(false);
                TypeDescription ncandidate = candidate.primitiveEquivalent(false);
                TypeDescription ngiven = given.primitiveEquivalent(false);
                int ibest = -1;
                int icandidate = -1;
                int igiven = -1;
                for (int i = 0; i < NUMERIC_TYPE_DISTANCE.length && (ibest == -1 || icandidate == -1 || igiven == -1); ++i) {
                    TypeDescription typeDescription = NUMERIC_TYPE_DISTANCE[i];
                    if (ibest == -1 && typeDescription.equals(nbest)) {
                        ibest = i;
                    }
                    if (icandidate == -1 && typeDescription.equals(ncandidate)) {
                        icandidate = i;
                    }
                    if (igiven != -1 || !typeDescription.equals(ngiven)) continue;
                    igiven = i;
                }
                if (ibest == -1 || icandidate == -1 || igiven == -1) {
                    result = best.isAssignableFrom(candidate);
                    break;
                }
                int bestDistance = MemberAccess.computeDistance(igiven, ibest, NUMERIC_TYPE_DISTANCE.length);
                int candidateDistance = MemberAccess.computeDistance(igiven, icandidate, NUMERIC_TYPE_DISTANCE.length);
                result = candidateDistance < bestDistance;
                break;
            }
            case 5: {
                int givenLen;
                if (candidate.isString() && best.isString()) {
                    int bestLen = best.getLength();
                    int candidateLen = candidate.getLength();
                    int givenLen2 = given.getLength();
                    if (bestLen == -1) {
                        result = candidateLen != -1 && givenLen2 != -1 && candidateLen >= givenLen2;
                        break;
                    }
                    if (candidateLen == -1) {
                        result = givenLen2 == -1 || bestLen < givenLen2;
                        break;
                    }
                    if (givenLen2 == -1) {
                        result = candidateLen > bestLen;
                        break;
                    }
                    result = givenLen2 > bestLen && candidateLen > bestLen;
                    break;
                }
                boolean bl = result = best.isAssignableFrom(candidate) && !candidate.isAssignableFrom(best);
                if (!result || !candidate.isString()) break;
                int candidateLen = candidate.getLength();
                result = candidateLen >= (givenLen = given.getLength()) || candidateLen == -1;
                break;
            }
            case 9: {
                result = false;
                break;
            }
            default: {
                result = best.isAssignableFrom(candidate) && !candidate.isAssignableFrom(best);
            }
        }
        return result;
    }

    private static MethodTypeDescription chooseMostSpecific(List<MethodTypeDescription> memberList, TypeDescription[] unnamedInArgs, Map<String, TypeDescription> namedArgs, Node node) {
        MethodTypeDescription result = memberList.get(0);
        if (memberList.size() == 1) {
            return result;
        }
        for (int i = 1; i < memberList.size(); ++i) {
            MethodTypeDescription mtd = memberList.get(i);
            if (!MemberAccess.isBetterMatchThan(result, mtd, unnamedInArgs, namedArgs)) continue;
            result = mtd;
        }
        List ambiguous = CollectionPool.getArrayList();
        ambiguous.add(result);
        for (MethodTypeDescription mtd : memberList) {
            if (mtd == result || MemberAccess.isBetterMatchThan(mtd, result, unnamedInArgs, namedArgs) || mtd.getSignature().equalsIgnoreCase(result.getSignature())) continue;
            ambiguous.add(mtd);
        }
        if (ambiguous.size() >= 2) {
            node.reportWarning(new AmbiguousCallException(node, ambiguous, result));
        }
        CollectionPool.releaseArrayList(ambiguous);
        return result;
    }

    private static int computeDistance(int from, int to, int length) {
        int distance = from == -1 || to == -1 ? Integer.MAX_VALUE : (to >= from ? to - from : length - to - 1);
        return distance;
    }
}

