/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.IncompatibleTypesException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Not;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.LogicOperator;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.Operation;
import org.jetbrains.annotations.NonNls;

public class Logic
extends Diadic {
    private LogicOperator operator;
    static final long serialVersionUID = -6681808605775179074L;
    static final long serialCheck = -5816782332346362166L;

    Logic(Token t, LogicOperator op) {
        super(t);
        this.operator = op;
    }

    private Logic(Node op1, LogicOperator op, Node op2) {
        this(null, op);
        this.copyParentFrom(op1);
        if (this.needsParenthesis(op1)) {
            op1.setParenthesis(true);
        }
        if (this.needsParenthesis(op2)) {
            op2.setParenthesis(true);
        }
        this.setFirst(op1);
        op1.setNext(op2);
        op2.setNext(null);
        this.initialize(op1);
        this.operator = op;
    }

    public boolean isAnd() {
        return this.operator == LogicOperator.AND;
    }

    public LogicOperator getOperator() {
        return this.operator;
    }

    @Override
    public String getText() {
        return this.operator.getText();
    }

    public boolean isXor() {
        return this.operator == LogicOperator.XOR;
    }

    @Override
    public Node negate() throws TypeException {
        LogicOperator complement;
        Node result = this;
        LogicOperator logicOperator = this.operator == LogicOperator.AND ? LogicOperator.OR : (complement = this.operator == LogicOperator.OR ? LogicOperator.AND : null);
        if (complement != null) {
            Node op1 = this.getOp1();
            Node op2 = this.getOp2();
            Node nop1 = Not.not(Node.deepCopy(op1));
            Node nop2 = Not.not(Node.deepCopy(op2));
            result = new Logic(nop1, complement, nop2);
            result = ((Node)result).checkType();
        }
        return result;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    static Logic and(Node op1, Node op2) {
        return new Logic(op1, LogicOperator.AND, op2);
    }

    static Logic or(Node op1, Node op2) {
        return new Logic(op1, LogicOperator.OR, op2);
    }

    @Override
    Operation getOperationTree() {
        int operation;
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        Operation op1 = this.getOp1().getOperationTree();
        Operation op2 = this.getOp2().getOperationTree();
        Operation[] operands = new Operation[]{op1, op2};
        switch (this.operator) {
            case AND: {
                operation = 8;
                break;
            }
            case OR: {
                operation = 9;
                break;
            }
            case XOR: {
                operation = 10;
                break;
            }
            case IMPLIES: {
                operation = 11;
                break;
            }
            default: {
                throw new IllegalArgumentException("Operator: " + (Object)((Object)this.operator));
            }
        }
        return new Operation(operation, this.operator.getText(), operands);
    }

    String getOperatorSymbol() {
        String str;
        switch (this.getOperator()) {
            case AND: {
                str = "&&";
                break;
            }
            case OR: {
                str = "||";
                break;
            }
            case XOR: {
                str = "^";
                break;
            }
            default: {
                throw new IllegalArgumentException("Operator: " + (Object)((Object)this.getOperator()));
            }
        }
        return str;
    }

    @Override
    Node checkType() throws TypeException {
        boolean b;
        boolean notGeneratingSource;
        if (this.getKind() != -1) {
            return this;
        }
        super.checkType();
        boolean bl = notGeneratingSource = !this.isGeneratingSource();
        if (notGeneratingSource && this.operator == LogicOperator.IMPLIES) {
            return Logic.or(Not.not(this.getOp1()), this.getOp2());
        }
        this.setTypeDescription(TypeFactory.getPrimitiveBool());
        Node o1 = this.getOp1();
        Node o2 = this.getOp2();
        if (o1.getKind() != 1 || o2.getKind() != 1) {
            throw new IncompatibleTypesException(this, o1, o2);
        }
        if (notGeneratingSource && o1.isConstant()) {
            b = ((BoolConst)o1).booleanValue();
            switch (this.operator) {
                case AND: {
                    return b ? o2 : o1;
                }
                case OR: {
                    return b ? o1 : o2;
                }
                case XOR: {
                    return b ? Not.not(o2).checkType() : o1;
                }
            }
        }
        if (notGeneratingSource && o2.isConstant()) {
            b = ((BoolConst)o2).booleanValue();
            switch (this.operator) {
                case AND: {
                    return b ? o1 : o2;
                }
                case OR: {
                    return b ? o2 : o1;
                }
                case XOR: {
                    return b ? Not.not(o1).checkType() : o2;
                }
            }
        }
        this.setOperands(Conversion.UnBox.create(o1).checkType(), Conversion.UnBox.create(o2).checkType());
        return this;
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        codeGenerator.generate(this);
    }

    @Override
    void generateSQLCode(@NonNls StringBuffer sql) {
        if (this.checkParameter(sql)) {
            return;
        }
        sql.append("( ");
        this.getOp1().generateSQLCode(sql);
        switch (this.operator) {
            case AND: {
                sql.append(" AND ");
                break;
            }
            case OR: {
                sql.append(" OR ");
                break;
            }
            case XOR: {
                sql.append(" XOR ");
            }
        }
        this.getOp2().generateSQLCode(sql);
        sql.append(" )");
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Node op1 = this.getOp1();
        Node op2 = this.getOp2();
        boolean leftValue = op1.notNullValue(rm).equals(Boolean.TRUE);
        switch (this.operator) {
            case AND: {
                return !leftValue ? Boolean.FALSE : Boolean.valueOf(op2.notNullValue(rm).equals(Boolean.TRUE));
            }
            case OR: {
                return leftValue ? Boolean.TRUE : Boolean.valueOf(Boolean.TRUE.equals(op2.notNullValue(rm)));
            }
            case XOR: {
                boolean rightValue = Boolean.TRUE.equals(op2.notNullValue(rm));
                return leftValue ^ rightValue;
            }
        }
        return null;
    }

    private boolean needsParenthesis(Node op) {
        if (op instanceof Logic) {
            Logic logic = (Logic)op;
            return logic.operator != LogicOperator.AND;
        }
        return false;
    }

    public static class Xor
    extends Logic {
        static final long serialVersionUID = 269241110270112159L;
        static final long serialCheck = -7305892333861335375L;

        public Xor(Token t) {
            super(t, LogicOperator.XOR);
        }
    }

    public static class Or
    extends Logic {
        static final long serialVersionUID = 2043002333549943711L;
        static final long serialCheck = 9080883510992573606L;

        public Or(Token t) {
            super(t, LogicOperator.OR);
        }
    }

    public static class Implies
    extends Logic {
        static final long serialVersionUID = 8716356348010957498L;
        static final long serialCheck = -5480821883595276655L;

        public Implies(Token t) {
            super(t, LogicOperator.IMPLIES);
        }
    }

    public static class And
    extends Logic {
        static final long serialVersionUID = 4790688424865497892L;
        static final long serialCheck = -6774505948118636988L;

        public And(Token t) {
            super(t, LogicOperator.AND);
        }
    }
}

