/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.BreakPoint;
import oracle.bpm.compiler.BreakPointException;
import oracle.bpm.compiler.BreakPointExecutionException;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.lang.MethodTypeDescription;

public class LineBreakPoint
extends BreakPoint {
    private final String componentName;
    private int lineNumber;
    private String method;

    public LineBreakPoint(String componentName, String method, int codeLine) {
        this.componentName = componentName;
        this.method = method;
        this.lineNumber = codeLine;
    }

    public void setCodeLine(int line) {
        this.lineNumber = line;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFullName() {
        return this.getComponentName() + '.' + this.getMethod();
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getMethod() {
        return this.method;
    }

    @Override
    public String getDescription() {
        return "at line " + this.getLineNumber();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LineBreakPoint) {
            return this.lineNumber == ((LineBreakPoint)obj).lineNumber;
        }
        return false;
    }

    public int hashCode() {
        return this.lineNumber;
    }

    @Override
    public String toString() {
        return "LineBreakPoint(" + this.getComponentName() + '.' + this.getMethod() + "() at line " + this.getLineNumber() + ')';
    }

    boolean isApplicableTo(Node node) {
        return node.getLine() == this.lineNumber;
    }

    @Override
    void evaluate(Node step) throws BreakPointException, BreakPointExecutionException {
        MethodTypeDescription methodType;
        Method member;
        if (step.getLine() == this.lineNumber && (member = step.getCurrentMember()) != null && this.method.equals(member.getName()) && this.componentName.equals((methodType = member.getMethodType()).getParent().getText())) {
            throw new BreakPointException(step, this);
        }
    }
}

