/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.util.List;
import java.util.Set;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.Comp;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.ExitException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.InfinitLoopException;
import oracle.bpm.compiler.LoopStatement;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NonBooleanException;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Any;
import oracle.bpm.type.TypeFactory;

public class JavaFor
extends LoopStatement {
    static final long serialVersionUID = 5088534544925403855L;
    static final long serialCheck = -8320276316618240331L;

    public JavaFor(Token t) {
        super(t);
    }

    JavaFor() {
    }

    @Override
    public String getText() {
        return "for";
    }

    public boolean isArrayIterator() {
        Node init = this.getInit();
        Node cond = this.getCond();
        Node reinit = this.getReinit();
        if (init.childCount() == 1 && reinit.childCount() == 1 && cond instanceof Comp && reinit.getOp1().isIncrement() && init.getFirst() instanceof Declaration) {
            Declaration decl = (Declaration)init.getFirst();
            Node var = cond.getOp1();
            Node increment = reinit.getOp1();
            if (decl.getSymbol() == var.getSymbol() && var.getSymbol() == increment.getSymbol()) {
                MemberAccess ma;
                boolean isInt = decl.getSymbol().getKind() == 2;
                Comp comp = (Comp)cond;
                Node array = null;
                if (isInt && comp.isLessThan() && comp.getOp2() instanceof MemberAccess && Any.equals("length", (ma = (MemberAccess)comp.getOp2()).getMemberName()) && ma.getObjType().isArray()) {
                    array = ma.getObject();
                }
                return array != null;
            }
        }
        return false;
    }

    @Override
    public Node getBody() {
        return this.getReinit().getNext();
    }

    public Node getCond() {
        return this.getOp2();
    }

    public Node getInit() {
        return this.getOp1();
    }

    public Node getReinit() {
        return this.getOp2().getNext();
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    @Override
    protected boolean splitToPrint() {
        return true;
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        Node init = this.getFirst();
        Node cond = init.getNext();
        Node reinit = cond.getNext();
        Node body = reinit.getNext();
        init.checkFlow(context);
        cond.checkFlow(context);
        FlowContext split = context.split();
        Set<String> exit = split.backupExit();
        body.checkFlow(split);
        reinit.checkFlow(split);
        boolean exitCaught = split.catchExit(this.getName());
        split.restoreExit(exit);
        reinit.checkFlow(split);
        context.join(split);
        if (cond.isConstant() && ((BoolConst)cond).booleanValue()) {
            if (!exitCaught && !context.hasUnCaughtExit()) {
                this.reportError(new InfinitLoopException(this));
            }
            context.breaksFlow(!exitCaught);
        } else {
            context.breaksFlow(false);
        }
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getTypeDescription().isVoid()) {
            return this;
        }
        Node init = this.getFirst();
        Node cond = init.getNext();
        Node reinit = cond.getNext();
        Node body = reinit.getNext();
        init.setStatement(true);
        reinit.setStatement(true);
        init = init.checkType();
        cond = cond.checkType();
        if (!cond.getTypeDescription().isBool()) {
            this.reportError(new NonBooleanException(cond));
        }
        reinit = reinit.checkType();
        body = body.checkType();
        this.setFirst(init);
        init.setNext(cond);
        cond.setNext(reinit);
        reinit.setNext(body);
        this.setTypeDescription(TypeFactory.getVoid());
        return this;
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        codeGenerator.generate(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Node init = this.getFirst();
        Node cond = init.getNext();
        Node reinit = cond.getNext();
        Node body = reinit.getNext();
        List<Object> stack = CollectionPool.getLinkedList();
        DoBlock.pushVariables(init, stack);
        try {
            init.run(rm);
            try {
                while (((Boolean)cond.value(rm)).booleanValue()) {
                    body.run(rm);
                    reinit.run(rm);
                }
            }
            catch (ExitException exit) {
                if (exit.getLabel() != null && !exit.getLabel().equals(this.getName())) {
                    throw exit;
                }
            }
        }
        finally {
            DoBlock.popVariables(rm, init, stack);
        }
        CollectionPool.releaseLinkedList(stack);
        return null;
    }
}

