/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.bcgen.FieldD;
import fuego.bcgen.JVMCodeBuilder;
import fuego.bcgen.MethodD;
import fuego.bcgen.TD;
import oracle.bpm.compiler.ClassConst;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.ConversionGenerator;
import oracle.bpm.compiler.JVMByteCodeGenerator;
import oracle.bpm.compiler.MDKit;
import oracle.bpm.compiler.Node;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.JavaEnumTypeDescription;
import oracle.bpm.lang.TypeDescription;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class JVMConversionGenerator
implements ConversionGenerator {
    private JVMByteCodeGenerator cg;

    public JVMConversionGenerator(JVMByteCodeGenerator codeGenerator) {
        this.cg = codeGenerator;
    }

    @Override
    public void generate(Conversion.IntReal node) throws CodeGenerationException {
        this.operandGenerate(node);
        this.invoke(MDKit.objectTo(node.newType.getJavaType()));
    }

    @Override
    public void generate(Conversion.TimeInterval node) throws CodeGenerationException {
        ObjectType newType;
        ObjectType oldType;
        this.operandGenerate(node);
        TypeDescription oldTD = node.oldType;
        if (!oldTD.isPrimitive()) {
            oldType = TD.getObjectType(node.getSourceJavaType());
        } else {
            BasicType primitiveType;
            int oldKind = oldTD.getKind();
            if (oldKind == 2) {
                primitiveType = Type.LONG;
            } else if (oldKind == 4) {
                primitiveType = Type.DOUBLE;
            } else {
                throw new IllegalStateException("Invalid TimeInterval conversion type: " + oldTD);
            }
            this.convert((Type)primitiveType);
            oldType = primitiveType;
        }
        TypeDescription newTD = node.newType;
        Object mthd = newTD.isTime() ? MDKit.toTime(oldType.toString()) : ((newType = TD.getObjectType(newTD)).equals((Object)oldType) ? null : MethodD.createStatic((Type)newType, newType, "valueOf", new Type[]{oldType}));
        if (mthd != null) {
            this.invoke((MethodD)mthd);
        }
    }

    @Override
    public void generate(Conversion.Bool node) throws CodeGenerationException {
        this.operandGenerate(node);
        this.invoke(MDKit.toBoolean(node.newType.isPrimitive()));
    }

    @Override
    public void generate(Conversion.Binary node) throws CodeGenerationException {
        this.operandGenerate(node);
        this.invoke(MDKit.SERIALIZE);
    }

    @Override
    public void generate(Conversion.Wide node) throws CodeGenerationException {
        Node operand = node.getOp1();
        TypeDescription newType = node.getTypeDescription();
        TypeDescription oldType = operand.getTypeDescription();
        if (newType.isPrimitive() && oldType.isPrimitive()) {
            operand.gen(this.cg);
            this.convert(TD.valueOf(newType));
        } else if (newType.isAny() || !newType.isInt() && !newType.isReal()) {
            operand.gen(this.cg);
        } else {
            throw new IllegalStateException("Wide: " + oldType + " -> " + newType);
        }
    }

    @Override
    public void generate(Conversion.UnBox node) throws CodeGenerationException {
        TypeDescription newType = node.getTypeDescription();
        this.operandGenerate(node);
        if (newType.isInt() || newType.isEnum()) {
            this.invoke(MDKit.OBJ_TO_LONG);
            this.convert(TD.valueOf(newType));
        } else if (newType.isReal()) {
            this.invoke(MDKit.OBJ_TO_DOUBLE);
            this.convert(TD.valueOf(newType));
        } else if (newType.isBool()) {
            this.invoke(MDKit.OBJ_TO_BOOLEAN);
        } else if (newType.isString() && newType.isPrimitive() && newType.getLength() == 1 && node.getOperandType().isString()) {
            this.loadZero(TD.INT);
            this.invoke(MDKit.CHAR_AT);
        } else {
            throw new IllegalStateException("Invalid type: " + newType);
        }
    }

    @Override
    public void generate(Conversion.ToGMT node) throws CodeGenerationException {
        this.operandGenerate(node);
        this.invoke(MDKit.TO_GMT);
    }

    @Override
    public void generate(Conversion.Null node) {
        TypeDescription newType = node.getTypeDescription();
        if (!newType.isPrimitive() || newType.isArray()) {
            this.loadNull();
        } else if (newType.isNumber()) {
            this.loadZero(node.getTD());
        } else if (newType.isBool()) {
            this.loadConstant(false);
        } else if (newType.isString()) {
            this.loadZero(TD.CHAR);
        } else if (newType.isEnum()) {
            if (newType.isNativeEnum()) {
                this.loadNull();
            } else {
                this.loadConstant(node.findInvalidValue((JavaEnumTypeDescription)newType));
            }
        } else assert (false) : "Unexpected Null conversion : " + newType;
    }

    @Override
    public void generate(Conversion.Narrow node) throws CodeGenerationException {
        Node operand = node.getOp1();
        TypeDescription newType = node.getTypeDescription();
        TypeDescription oldType = operand.getTypeDescription();
        if (newType.isPrimitive() && oldType.isPrimitive() || (oldType.isAny() || oldType.isObject() || newType.isStrictSubtype(oldType)) && newType.isObject()) {
            operand.gen(this.cg);
            this.convert(TD.valueOf(newType));
        } else {
            this.generate((Conversion)node);
        }
    }

    @Override
    public void generate(Conversion.Import node) throws CodeGenerationException {
        if (node.newType.isTime()) {
            this.operandGenerate(node);
            this.invoke(MDKit.toTime(node.getJavaType()));
        } else {
            this.generate((Conversion)node);
        }
    }

    @Override
    public void generate(Conversion.FromGMT node) throws CodeGenerationException {
        this.operandGenerate(node);
        this.invoke(MDKit.FROM_GMT);
    }

    @Override
    public void generate(Conversion.Export node) throws CodeGenerationException {
        String targetJavaType = node.getTargetJavaType();
        Node operand = node.getFirst();
        operand.gen(this.cg);
        if (node.isArray()) {
            node.getTargetElementClass().gen(this.cg);
            this.invoke(MDKit.ARRAYP_CONVELEMENTS);
            this.convert(TD.valueOf(targetJavaType));
        } else if (operand.getTypeDescription().isMap()) {
            MethodD md = MDKit.fromMap(targetJavaType);
            if (md == null) {
                throw new IllegalStateException("Illegal Conversion ? Map  to " + targetJavaType);
            }
            this.invoke(md);
        } else if (operand.getTypeDescription().isArray()) {
            MethodD md = MDKit.fromList(targetJavaType);
            if (md == null) {
                throw new IllegalStateException("Illegal Conversion ? List  to " + targetJavaType);
            }
            this.invoke(md);
        } else if (operand.getTypeDescription().isTime()) {
            if (!(operand instanceof Conversion.Null)) {
                JVMCodeBuilder builder = this.cg.getCodeBuilder();
                builder.beginIf();
                builder.dup();
                builder.compareNull(true);
                builder.addThen();
                MethodD md = MDKit.fromTime(targetJavaType);
                if (md == null) {
                    throw new IllegalStateException("Illegal Conversion ? Time  to " + targetJavaType);
                }
                this.invoke(md);
                builder.addElse();
                builder.pop();
                builder.loadNull();
                builder.endExprIf();
            }
        } else {
            this.convert((Type)TD.getObjectType(targetJavaType));
        }
    }

    @Override
    public void generate(Conversion.DynamicView node) throws CodeGenerationException {
        this.operandGenerate(node);
        this.invoke(MDKit.MD_GET_CONTENT_TO_SHOW);
    }

    @Override
    public void generate(Conversion.Dynamic node) throws CodeGenerationException {
        this.operandGenerate(node);
        if (node.toDynamic()) {
            this.invoke(MDKit.toDynamic(node.oldType.getJavaType()));
        } else {
            ClassConst targetClass = node.getTargetClass();
            if (targetClass != null) {
                targetClass.generate(this.cg);
            }
            this.invoke(MDKit.fromDynamic(node.getTypeDescription().getJavaType()));
        }
    }

    @Override
    public void generate(Conversion.Box node) throws CodeGenerationException {
        Node operand = node.getOp1();
        TypeDescription newType = node.getTypeDescription();
        TypeDescription oldType = operand.getTypeDescription();
        this.operandGenerate(node);
        this.generateBox(oldType, newType);
    }

    @Override
    public void generate(Conversion.Stringify node) throws CodeGenerationException {
        int length = node.newType.getLength();
        this.operandGenerate(node);
        String javaType = node.getJavaType();
        MethodD md = MDKit.primitiveToString(javaType);
        if (md == null && length <= 0) {
            this.invoke(MDKit.OBJ_TO_STRING);
        } else if (md != null) {
            this.convert(md.getArgType(0));
            this.invoke(md);
        }
        if (length > 0) {
            this.loadConstant(length);
            this.invoke(MDKit.OBJ_TO_STRINGL);
        }
    }

    @Override
    public void generate(Conversion node) {
        throw new IllegalStateException("Conversion from: " + node.oldType + " to " + node.newType + " not defined.");
    }

    @Override
    public void generate(Conversion.Cast node) throws CodeGenerationException {
        Type to;
        this.operandGenerate(node);
        ObjectType from = TD.getObjectType(node.getTypeDescription());
        if (node.newType.isBinary()) {
            to = TD.valueOf(node.newType);
        } else {
            ObjectType toObj = TD.getObjectType(node.newType);
            if (from.isCastableTo((Type)toObj)) {
                System.out.println("Using Conversion: " + from + " --> " + toObj);
                this.getCodeBuilder().loadClassConstant(toObj.getClassName());
                this.invoke(MDKit.CONVERSION_CAST);
            }
            to = toObj;
        }
        this.convert(to);
    }

    @Override
    public void generate(Conversion.Char node) throws CodeGenerationException {
        this.operandGenerate(node);
        this.invoke(MDKit.toChar(node.getOp1().getTypeDescription().getJavaType(), node.newType.isPrimitive()));
    }

    @Override
    public void generate(Conversion.Deserialize node) throws CodeGenerationException {
        TypeDescription nt = node.newType;
        if (nt.getKind() != 11) {
            throw new IllegalStateException("Conversion from Binary to: " + nt);
        }
        this.operandGenerate(node);
        this.invoke(MDKit.DESERIALIZE);
        this.convert(TD.valueOf(nt));
    }

    @Override
    public void generate(Conversion.Blob node) throws CodeGenerationException {
        node.getFirst().gen(this.cg);
        this.invoke(MDKit.BINARY_TO_BLOB);
    }

    @Override
    public void generate(Conversion.ToArray node) throws CodeGenerationException {
        TypeDescription ot = node.oldType;
        TypeDescription nt = node.newType;
        Node operand = node.getFirst();
        if (nt.isMap()) {
            operand.gen(this.cg);
            this.invoke(nt.isOrdered() ? MDKit.TO_TREEMAP : MDKit.TO_LINKEDHASHMAP);
        } else if (nt.isIterator()) {
            operand.gen(this.cg);
            this.invoke(MDKit.TO_ITERATOR);
        } else {
            operand.setMustClone(false);
            operand.gen(this.cg);
            if (nt.isPrimitive()) {
                node.getTargetElementClass().gen(this.cg);
                this.invoke(MDKit.TO_ARRAY);
                this.convert(TD.valueOf(nt));
            } else {
                TypeDescription net;
                MethodD method = MDKit.TO_LISTWET;
                node.getTargetClass().gen(this.cg);
                ClassConst targetElement = node.getTargetElementClass();
                if (targetElement != null) {
                    method = MDKit.TO_LIST;
                    targetElement.gen(this.cg);
                }
                if ((net = nt.getElementType()) != null) {
                    TypeDescription oet = ot.getElementType();
                    int ol = oet == null ? -1 : oet.getLength();
                    int os = oet == null ? -1 : oet.getScale();
                    int nl = net.getLength();
                    int ns = net.getScale();
                    if (net.isDecimal() && ns != -1 && ns != os || net.isString() && nl != -1 && nl != ol) {
                        this.loadConstant(ns);
                        this.loadConstant(nl);
                        method = MDKit.TO_LISTSL;
                    }
                }
                this.invoke(method);
                this.convert(TD.valueOf(node.newType));
            }
        }
    }

    @Override
    public void generate(Conversion.Decimal node) throws CodeGenerationException {
        int scale;
        int length;
        TypeDescription nt = node.newType;
        TypeDescription ot = node.oldType;
        this.operandGenerate(node);
        if (ot.isDecimal()) {
            length = ot.getLength();
            scale = ot.getScale();
        } else {
            this.invoke(MDKit.toDecimal(ot.getJavaType()));
            length = -1;
            scale = -1;
        }
        int newScale = nt.getScale();
        int newLength = nt.getLength();
        if (newScale >= 0 && newScale != scale) {
            this.loadConstant(newScale);
            this.invoke(MDKit.MD_SCALE);
        }
        int digits = JVMConversionGenerator.getDecimalDigits(length, scale);
        int newDigits = JVMConversionGenerator.getDecimalDigits(newLength, newScale);
        if (newDigits < digits) {
            this.loadConstant(nt.getLength());
            this.invoke(MDKit.MD_DECIMAL_CHECKLENGTH);
        }
    }

    @Override
    public void generate(Conversion.ToEnum conversion) throws CodeGenerationException {
        Node operand = conversion.getFirst();
        TypeDescription ot = conversion.oldType;
        TypeDescription nt = conversion.newType;
        if (nt.isNativeEnum()) {
            ObjectType enumType = TD.getObjectType(nt.getJavaType());
            if (ot.isString()) {
                operand.gen(this.cg);
                this.invoke(MDKit.enumValueOf(enumType));
            } else {
                this.invoke(MDKit.enumValues(enumType));
                operand.gen(this.cg);
                this.invoke(MDKit.OBJ_TO_INT);
                this.getCodeBuilder().arrayLoad();
            }
        } else {
            EnumTypeDescription enumType = (EnumTypeDescription)nt;
            if (ot.isString()) {
                conversion.getEnumArray().gen(this.cg);
                operand.gen(this.cg);
                this.invoke(MDKit.MAP_GET);
                if (enumType.isPrimitive()) {
                    this.invoke(MDKit.OBJ_TO_INT);
                }
            } else if (ot.isAny() || ot.isObject()) {
                operand.gen(this.cg);
                this.invoke(MDKit.objectTo(nt.getJavaType()));
            } else {
                operand.gen(this.cg);
                if (!enumType.isPrimitive()) {
                    this.invoke(MDKit.boxInt());
                }
            }
        }
    }

    void generateBox(TypeDescription oldType, TypeDescription newType) {
        Type oldTd = TD.valueOf(oldType);
        if (newType.isString()) {
            this.generateToString(oldType);
        } else if (newType.isBool() && oldTd == TD.BOOLEAN) {
            this.invoke(MDKit.BOX_BOOLEAN);
        } else {
            assert (!newType.isPrimitive()) : "newType cannot be primitive: " + newType;
            ObjectType type = TD.getObjectType(newType);
            MethodD md = MDKit.getBoxMethod(type.getClassName());
            this.convert(md.getArgType(0));
            this.invoke(md);
        }
    }

    private static int getDecimalDigits(int length, int scale) {
        return length < 0 ? Integer.MAX_VALUE : (scale < 0 ? length : length - scale);
    }

    private JVMCodeBuilder getCodeBuilder() {
        return this.cg.getCodeBuilder();
    }

    private void convert(Type to) {
        this.getCodeBuilder().convert(to);
    }

    private void generateToString(TypeDescription type) {
        this.invoke(MDKit.toString(type.getJavaType()));
    }

    private void invoke(MethodD md) {
        this.getCodeBuilder().invoke(md);
    }

    private void loadConstant(boolean value) {
        this.getCodeBuilder().loadConstant(value);
    }

    private void loadConstant(int scale) {
        this.getCodeBuilder().loadConstant(scale);
    }

    private void loadField(FieldD field) {
        this.getCodeBuilder().loadField(field);
    }

    private void loadNull() {
        this.getCodeBuilder().loadNull();
    }

    private void loadZero(Type td) {
        this.getCodeBuilder().loadZero(td);
    }

    private void operandGenerate(Conversion n) throws CodeGenerationException {
        n.getFirst().gen(this.cg);
    }
}

