/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.bcgen.FieldD;
import fuego.bcgen.JVMCodeBuilder;
import fuego.bcgen.MethodD;
import fuego.bcgen.TD;
import java.math.BigDecimal;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.ClassConst;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.DecimalConst;
import oracle.bpm.compiler.DefaultConst;
import oracle.bpm.compiler.EnumConst;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.IntervalConst;
import oracle.bpm.compiler.JVMByteCodeGenerator;
import oracle.bpm.compiler.MDKit;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.compiler.RealConst;
import oracle.bpm.compiler.RegExpConst;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.compiler.TDKit;
import oracle.bpm.compiler.TimeConst;
import oracle.bpm.lang.Initialization;
import oracle.bpm.lang.TypeDescription;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

class JVMBCConstGenerator
implements ConstGenerator {
    private JVMByteCodeGenerator cg;
    private static final FieldD FD_FALSE = FieldD.createStatic(TD.BOOLEAN_CLASS, "FALSE", (Type)TD.BOOLEAN_CLASS);

    JVMBCConstGenerator(JVMByteCodeGenerator codeGenerator) {
        this.cg = codeGenerator;
    }

    @Override
    public void generate(ArrayConst c) throws CodeGenerationException {
        JVMCodeBuilder cb = this.getCodeBuilder();
        if (c.isMap()) {
            cb.construct(c.isOrdered() ? TD.TREE_MAP : TD.LMAP);
            for (Node element = c.getFirst(); element != null; element = element.getNext()) {
                cb.dup();
                element.gen(this.cg);
                element = element.getNext();
                element.gen(this.cg);
                cb.invoke(MDKit.MAP_SET);
                cb.pop();
            }
        } else if (c.isPrimitive()) {
            ArrayType type = new ArrayType(TD.valueOf(c.getElementType()), 1);
            int length = c.length();
            cb.createArray(type, length);
            Node element = c.getFirst();
            for (int i = 0; i < length; ++i) {
                cb.dup();
                cb.loadConstant(i);
                element.gen(this.cg);
                cb.arrayStore();
                element = element.getNext();
            }
        } else {
            Node element;
            int size = 0;
            for (element = c.getFirst(); element != null; element = element.getNext()) {
                ++size;
            }
            cb.newObject((Type)TD.ARRAY_LIST);
            cb.dup();
            cb.loadConstant(size);
            cb.invokeConstructor(TD.ARRAY_LIST, (Type)Type.INT);
            for (element = c.getFirst(); element != null; element = element.getNext()) {
                cb.dup();
                element.gen(this.cg);
                cb.invoke(MDKit.COLLECTION_ADD);
                cb.pop();
            }
        }
    }

    @Override
    public void generate(ClassConst node) {
        JVMCodeBuilder cb = this.getCodeBuilder();
        Type type = TD.valueOf(node.getText());
        if (type instanceof BasicType) {
            cb.loadField(MDKit.classField(node.getText()));
        } else {
            cb.loadClassConstant(type instanceof ObjectType ? ((ObjectType)type).getClassName() : type.getSignature().replace('/', '.'));
        }
    }

    @Override
    public void generate(DecimalConst c) {
        long lv = c.value.longValue();
        JVMCodeBuilder cb = this.getCodeBuilder();
        if (BigDecimal.valueOf(lv).equals(c.value)) {
            if (lv == 0L) {
                cb.loadField(TDKit.DECIMAL_ZERO);
            } else {
                cb.loadConstant(lv);
                cb.invoke(MDKit.MD_DECIMAL_VALUEOF);
            }
        } else {
            cb.loadConstant(c.value.toString());
            cb.invoke(MDKit.STRING_TO_DECIMAL);
        }
    }

    @Override
    public void generate(EnumConst c) {
        if (c.isNativeEnum()) {
            ObjectType type = TD.getObjectType(c.getTypeDescription());
            this.getCodeBuilder().loadField(FieldD.createStatic(type, c.getLabel(), (Type)type));
        } else {
            this.getCodeBuilder().loadConstant(Integer.parseInt(c.getValue()));
            if (!c.isPrimitive()) {
                this.getCodeBuilder().invoke(MDKit.boxInt());
            }
        }
    }

    @Override
    public void generate(IntervalConst node) throws CodeGenerationException {
        String txt = node.getText();
        JVMCodeBuilder cb = this.getCodeBuilder();
        if (txt.length() == 0) {
            cb.loadConstant(0);
            cb.invoke(MethodD.createStatic((Type)TDKit.INTERVAL, TDKit.INTERVAL, "valueOf", TD.INT));
        } else {
            cb.loadConstant(txt);
            cb.invoke(MethodD.createStatic((Type)TDKit.INTERVAL, TDKit.INTERVAL, "valueOf", new Type[]{TD.STRING}));
        }
    }

    @Override
    public void generate(RealConst cons) {
        TypeDescription type = cons.getTypeDescription();
        boolean isDouble = type.isDoubleWord();
        if (isDouble) {
            this.getCodeBuilder().loadConstant(cons.value);
        } else {
            this.getCodeBuilder().loadConstant((float)cons.value);
        }
        if (!type.isPrimitive()) {
            this.getCodeBuilder().invoke(MDKit.boxReal(isDouble));
        }
    }

    @Override
    public void generate(RegExpConst c) {
        if (c.value == null) {
            this.getCodeBuilder().loadNull();
        } else {
            this.getCodeBuilder().loadConstant(c.value);
        }
        this.getCodeBuilder().invoke(MDKit.REGEXP_VALUEOF);
    }

    @Override
    public void generate(TimeConst node) {
        if (node.getValue() == null) {
            this.getCodeBuilder().invoke(MDKit.NOW);
        } else {
            this.getCodeBuilder().loadConstant(node.getText());
            this.getCodeBuilder().invoke(MDKit.TIME_VALUEOF);
        }
    }

    @Override
    public void generate(BoolConst boolConst) {
        boolean value = boolConst.booleanValue();
        this.getCodeBuilder().loadConstant(value);
        if (!boolConst.isPrimitive()) {
            this.getCodeBuilder().invoke(MDKit.BOX_BOOLEAN);
        }
    }

    @Override
    public void generate(DefaultConst defaultConst) throws CodeGenerationException {
        TypeDescription type = defaultConst.getTypeDescription();
        JVMCodeBuilder cb = this.getCodeBuilder();
        if (type.isObject() && defaultConst.hasChildren()) {
            defaultConst.getFirst().gen(this.cg);
        } else if (type.isArray() && DefaultConst.isGroupArray(type)) {
            JVMBCConstGenerator.groupArrayGenerate(type, cb);
        } else {
            Initialization init = type.getInitialization();
            if (init == Initialization.NULL) {
                cb.loadNull();
            } else if (init == Initialization.ZERO) {
                cb.loadZero(TD.valueOf(type));
            } else if (init == Initialization.FALSE) {
                if (type.isPrimitive()) {
                    cb.loadConstant(false);
                } else {
                    cb.loadField(FD_FALSE);
                }
            } else if (init == Initialization.EMPTY_STRING) {
                cb.loadConstant("");
            } else {
                Type td = TD.valueOf(type.getImplementationType());
                if (init == Initialization.DEFAULT_CONSTRUCTOR) {
                    cb.construct((ObjectType)td);
                } else if (init == Initialization.CREATE) {
                    assert (td instanceof ObjectType);
                    cb.invoke(MethodD.createStatic(td, (ObjectType)td, "create", new Type[0]));
                } else if (init == Initialization.ZERO_CONSTRUCTOR) {
                    assert (td instanceof ObjectType);
                    Type ptd = TD.valueOf(type.primitiveEquivalent(true));
                    cb.newObject(td);
                    cb.dup();
                    cb.loadZero(ptd);
                    cb.invokeConstructor((ObjectType)td, ptd);
                } else if (init == Initialization.EMPTY_ARRAY) {
                    assert (td instanceof ArrayType);
                    cb.createArray((ArrayType)td, 0);
                } else assert (false) : "Invalid initialization: " + (Object)((Object)init);
            }
        }
    }

    @Override
    public void generate(StringConst stringConst) {
        this.getCodeBuilder().loadConstant(stringConst.getText());
    }

    @Override
    public void generate(NullConst n) {
        this.getCodeBuilder().loadNull();
    }

    @Override
    public void generate(IntConst intConst) {
        ObjectType targetType;
        TypeDescription type = intConst.getTypeDescription();
        Type basicType = TD.valueOf(type.primitiveEquivalent(true));
        JVMCodeBuilder cb = this.getCodeBuilder();
        boolean isInteger = basicType.equals(TD.INT);
        ObjectType objectType = targetType = type.isPrimitive() || isInteger ? null : this.cg.createObject(type);
        if (type.isDoubleWord()) {
            cb.loadConstant(intConst.value);
        } else {
            cb.loadConstant((int)intConst.value);
            cb.convert(basicType);
        }
        if (!type.isPrimitive()) {
            if (isInteger) {
                cb.invoke(MDKit.boxInt());
            } else {
                cb.invokeConstructor(targetType, basicType);
            }
        }
    }

    @Override
    public void generate(Const c) throws CodeGenerationException {
        String collectedConstant = c.getConstantFieldName();
        if (collectedConstant == null) {
            c.generate(this);
        } else {
            JVMCodeBuilder cb = this.getCodeBuilder();
            c.setUsed(true);
            Type fieldType = TD.valueOf(c.getTypeDescription());
            cb.loadField(FieldD.createStatic(cb.getType(), collectedConstant, fieldType));
            if (c.mustClone()) {
                cb.invoke(MDKit.MD_ANY_CLONE);
                cb.convert(fieldType);
            }
        }
    }

    private static void groupArrayGenerate(TypeDescription type, JVMCodeBuilder cb) {
        TypeDescription elementType = type.getElementType();
        String constructor = elementType.findMember(elementType.getName()).getJavaSignature();
        ObjectType ot = TD.getObjectType(type);
        cb.newObject((Type)ot);
        cb.dup();
        cb.loadConstant(elementType.getJavaType());
        cb.invoke(MDKit.JAVACLASS_FORNAME);
        cb.loadConstant(constructor);
        cb.createArray(TD.OBJECT_ARRAY, 1);
        cb.dup();
        cb.loadConstant(0);
        cb.loadThis();
        cb.arrayStore();
        cb.invokeConstructor(ot, new Type[]{TDKit.INVOCATOR, TD.STRING, TD.OBJECT_ARRAY});
    }

    private JVMCodeBuilder getCodeBuilder() {
        return this.cg.getCodeBuilder();
    }
}

