/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.bcgen.MethodD;
import fuego.bcgen.TD;
import fuego.parser.collections.AST;
import java.util.List;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.ArgumentNumberException;
import oracle.bpm.compiler.ArrayReference;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.ConstantPool;
import oracle.bpm.compiler.ConstructorIsPrivateException;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Extend;
import oracle.bpm.compiler.ExtractedMethod;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.FuegoInvokeable;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.IllegalArgumentException;
import oracle.bpm.compiler.IllegalRelayToException;
import oracle.bpm.compiler.IllegalTypeException;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReferenceException;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.NoSuchComponentException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NotFunctionException;
import oracle.bpm.compiler.NotInstantiableException;
import oracle.bpm.compiler.NotMethodException;
import oracle.bpm.compiler.NotStaticMemberException;
import oracle.bpm.compiler.NullReferenceException;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.Template;
import oracle.bpm.compiler.TemplateSpec;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.ValueReference;
import oracle.bpm.component.Component;
import oracle.bpm.component.ExecutionRelayedThrowable;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.type.filter.Operation;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.Utilities;

public class Invoke
extends MemberAccess {
    LocalVar returnArray;
    private Args args;
    private boolean constructorAllowed = false;
    private Object currentInstance;
    private Boolean delegateBySignature;
    private Extend.CreateInstance instanceCreator;
    private boolean isRelay = false;
    private Node methodCall;
    private boolean needsExtraction;
    private Identifier targetCIL = null;
    private Invoke targetInvoke;
    private static final String DELETE_METHOD = "delete";
    static final long serialVersionUID = -5457739980413461750L;
    static final long serialCheck = 3887454766930471932L;

    public Invoke() {
    }

    Invoke(String method, String object, Args args) {
        this(new Identifier(method), new Identifier(object), args);
    }

    Invoke(Node method, Node object, Args args) {
        this.copyParentFrom(args);
        this.setFirst(method);
        method.setNext(object);
        object.setNext(args);
        this.initialize(args);
        this.setStatement(true);
        args.setInvoke(this);
    }

    Invoke(Node object, MethodTypeDescription method, Args args, boolean delegated) {
        this(object, method.getParent(), method, args, delegated, null);
    }

    Invoke(Node object, TypeDescription objType, MethodTypeDescription method, Args args, boolean delegated, Node memberName) {
        this.setParent(args.getParent());
        args.setInvoke(this);
        if (memberName == null) {
            memberName = new Identifier(method.getName());
        }
        if (object == null) {
            object = new Identifier(method.getParent().getName());
            object.setSynthetic(true);
        }
        this.constructorAllowed = true;
        this.setFirst(memberName);
        memberName.setNext(object);
        object.setNext(args);
        this.initialize(args);
        this.setMemberType(method);
        this.setObjType(objType);
        this.delegationInClient = delegated;
        this.setStatement(true);
    }

    public Node getMethodCall() {
        return this.methodCall;
    }

    public Identifier getTargetCIL() {
        return this.targetCIL;
    }

    @Override
    public String getText() {
        return "invoke " + Method.getText(this.getMemberType());
    }

    public boolean hasInstanceCreator() {
        return this.instanceCreator != null;
    }

    @Override
    public Node getObject() {
        return this.getOp2();
    }

    public Args getOutputArgs() {
        Args in = this.getInputArgs();
        return in != null ? (Args)in.getNext() : null;
    }

    @Override
    public void setStatement(boolean statement) {
        super.setStatement(statement);
        if (this.methodCall != null) {
            this.methodCall.setStatement(statement);
        }
    }

    public Invoke getTargetInvoke() {
        return this.targetInvoke;
    }

    @Override
    public void generate(SourceGenerator cg) {
        String memberName;
        MethodTypeDescription memberType = this.getMemberType();
        if (memberType != null) {
            memberName = memberType.getName();
            if (memberType.getReplacement() != null) {
                memberName = memberType.getReplacement();
            }
        } else {
            memberName = this.getMethodName();
        }
        cg.generate(this, this.getObject(), this.getInputArgs(), this.getOutputArgs(), memberName);
    }

    @Override
    protected String getStatementSeparator() {
        return null;
    }

    protected Object clone() throws CloneNotSupportedException {
        Invoke newInvoke = (Invoke)super.clone();
        newInvoke.methodCall = Invoke.deepCopy(this.methodCall);
        if (newInvoke.methodCall instanceof InvokeCall) {
            ((InvokeCall)((Object)newInvoke.methodCall)).setInvoke(newInvoke);
        }
        return newInvoke;
    }

    protected void selectBest(Args inputArgs) throws TypeException {
        this.setMemberType(Invoke.selectBest(this.getMemberType(), inputArgs, this));
    }

    String getArgPrefix() {
        return this.getComponentName() + "$" + this.getMethodName() + "$arg$";
    }

    @Override
    String getComponentName() {
        return this.getMemberType().getParent().getName();
    }

    boolean isConstructor() {
        return this.getMemberType().isConstructor();
    }

    void setConstructorAllowed(boolean constructorAllowed) {
        this.constructorAllowed = constructorAllowed;
    }

    Node getCreatorOperator() {
        return this.instanceCreator.getOp1();
    }

    boolean isDelegated() {
        return this.delegationInClient && this.isDelegatedBySignature() && !this.getMemberType().isStatic();
    }

    boolean isDelegatedBySignature() {
        if (this.delegateBySignature == null) {
            this.setDelegateBySignature(Invoke.getSignature(this.objType, this.getMemberType()));
        }
        return this.delegateBySignature;
    }

    boolean isDynamic() {
        return this.getObjType().isInvokeable();
    }

    Args getInputArgs() {
        return (Args)this.getOp3();
    }

    void setInstanceCreator(Extend.CreateInstance creator) {
        this.instanceCreator = creator;
    }

    Node getMethod() {
        return this.getOp1();
    }

    MethodD getMethodD(boolean callToParent) throws CodeGenerationException {
        TypeDescription targetType;
        String signature = this.getSignature();
        if (this.isDelegatedBySignature()) {
            return MethodD.createFromSignature(signature);
        }
        TypeDescription typeDescription = targetType = callToParent || this.isDelegationInClient() ? this.memberType.getParent() : this.objType;
        if (targetType.isPrimitive()) {
            targetType = targetType.primitiveEquivalent(false);
        }
        return MethodD.createFromSignature(this.memberType.isStatic(), TD.getObjectType(targetType), signature);
    }

    String getMethodName() {
        return this.getMethod().getText();
    }

    String getMethodSignature() {
        String signature = this.getSignature();
        if (this.isDelegatedBySignature()) {
            signature = Invoke.getDelegatedMember(signature);
            assert (signature != null);
        }
        String method = JavaClass.getMethodNameFromSignature(signature);
        assert (method != null) : "Null signature. Method: " + this.memberType;
        return method;
    }

    Node getObjectNode() {
        return this.getObject() != null ? Node.deepCopy(this.getObject()) : new Identifier(this.getMemberType().getParent().getName());
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        Operation[] args = new Operation[]{};
        return new Operation(19, "()", args, this.getMethodName());
    }

    void setRelay(boolean relay) {
        this.isRelay = relay;
    }

    boolean isRelay() {
        return this.isRelay;
    }

    boolean isRemote() {
        TypeDescription objType = this.getObjType();
        return objType.isObject() && objType.asObject().isRemote();
    }

    Node getReturnArray() throws TypeException {
        if (this.returnArray == null) {
            TypeDescription td = TypeFactory.getPrimitiveArray(TypeFactory.getAny());
            this.returnArray = LocalVar.create("returnArray", td, this);
            this.returnArray.setParent(this);
        }
        return this.returnArray;
    }

    @Override
    void setScope(Scope scp) {
        super.setScope(scp);
        if (this.methodCall != null) {
            this.methodCall.setScope(scp);
        }
    }

    String getSignature() {
        String result = Invoke.getSignature(this.objType, this.memberType);
        this.setDelegateBySignature(result);
        return result;
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        Args outputArgs;
        Args inputArgs;
        if (this.returnArray != null) {
            context.initializeVariable(this.returnArray.getSymbol(), this.returnArray);
            this.returnArray.checkFlow(context);
        }
        if ((inputArgs = this.getInputArgs()) != null) {
            inputArgs.checkFlow(context);
        }
        if (this.methodCall != null) {
            this.methodCall.checkFlow(context);
        }
        if ((outputArgs = this.getOutputArgs()) != null) {
            outputArgs.checkFlow(context);
        }
        super.checkFlow(context);
        if (this.hasRelay()) {
            this.targetInvoke.checkFlow(context);
            context.breaksFlow(true);
        }
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        ObjectClass aClass;
        Argument resultArgument;
        if (this.getKind() != -1) {
            return this;
        }
        String methodName = this.getOp1().getText();
        this.extractTargetCil();
        this.setArgs((Args)this.getOp3());
        Node object = this.targetObject();
        if (this.getObjType() == null) {
            object = this.autoDeclare(methodName);
        } else {
            object = this.derefLocal(object);
            if (methodName.equals(DELETE_METHOD)) {
                object = this.processDeleteMethod(object);
            }
            if (this.getMemberType() == null) {
                this.setMemberType(this.getMethodType(this.getObjType(), methodName));
            }
        }
        this.ensureNotNullArgs();
        Args inputArgs = this.getArgs();
        Args outputArgs = (Args)inputArgs.getNext();
        inputArgs.setInvoke(this);
        outputArgs.setInvoke(this);
        inputArgs.setNext(outputArgs);
        if (object == null) {
            object = this.getOp1();
        }
        Method currentMethod = this.getCurrentMember();
        this.selectBest(inputArgs);
        inputArgs.checkArguments();
        inputArgs.addOutputOnlyHolders();
        if (this.hasRelay()) {
            assert (outputArgs.isRelay());
            this.checkRelayTo(outputArgs, currentMethod);
            outputArgs = new Args(2L);
            outputArgs.initialize(this);
            outputArgs.setParent(this);
            inputArgs.setNext(outputArgs);
        } else {
            outputArgs.checkArguments();
        }
        if (this.isExpression() && !this.isFunction()) {
            throw new NotFunctionException((Node)this, this.getMemberType());
        }
        TypeDescription td = this.getResultType();
        if (td.isUnknown()) {
            throw new IllegalTypeException((Node)this, td.getText());
        }
        this.setTypeDescription(this.isDynamic() ? td.setReferenceType(true) : td);
        this.createMethodCall();
        this.checkDelegation();
        object = this.createDefaultInstanceIfNeeded(object);
        this.setOperands(this.getOp1(), object, inputArgs);
        inputArgs.setNext(outputArgs);
        this.checkDeprecated(this.getMemberType(), this.getMethod());
        Arg retArg = outputArgs.getReturnArg();
        if (retArg != null && !this.hasRelay()) {
            this.methodCall.setExpression(true);
            Argument argument = retArg.getArgument();
            Node rval = !argument.isExternal() ? this.methodCall : Conversion.Import.create(this.methodCall, argument.getJavaType(), td).checkType(td);
            rval = Conversion.promote(rval, retArg.getValue().getTypeDescription());
            this.methodCall = new Assignment(retArg.getValue(), rval);
            this.methodCall.initialize(this);
            this.methodCall.setParent(this);
            this.methodCall = this.methodCall.checkType();
        } else if (this.isExpression() && (resultArgument = this.getResultArgument()).isExternal()) {
            TypeDescription targetType = this.getTypeDescription();
            return Conversion.Import.create(this, resultArgument.getJavaType(), targetType).checkType(targetType);
        }
        Node result = this.checkRefactor(this.getMemberType(), object, inputArgs);
        if (this.needsExtraction && !this.isGeneratingSource()) {
            result = this.extractMethod(this.getMemberType(), this.getObjType());
        }
        if (this.isDynamic() && this.methodCall.isExpression()) {
            Argument resultArgument2 = this.getResultArgument();
            TypeDescription resultType = resultArgument2.getType();
            result = Conversion.promote((Node)this, resultType);
        }
        if ((aClass = this.getCurrentClass()) != null) {
            aClass.declareDependency(this.getObjType());
        }
        return result;
    }

    @Override
    void collectConstants(ConstantPool cp) {
        assert (this.getTypeDescription() != TypeFactory.getNone()) : "collectConstants() cannot be called before checkType()";
        super.collectConstants(cp);
        if (this.returnArray != null) {
            this.returnArray.collectConstants(cp);
        }
        this.methodCall.collectConstants(cp);
        if (this.hasRelay()) {
            this.targetInvoke.collectConstants(cp);
        }
    }

    @Override
    void extractArguments(ExtractedMethod method) {
        super.extractArguments(method);
        this.methodCall.extractArguments(method);
        if (this.hasInstanceCreator()) {
            this.instanceCreator.extractArguments(method);
        }
    }

    Argument findArgument(String argName, Node init, long argsType) throws TypeException {
        long modifiers;
        MethodTypeDescription method = this.getMemberType();
        String resultName = method.getResultArgument().getName();
        String name = resultName != null ? resultName : "return";
        int number = method.getArgument(argName);
        if (number != -1) {
            return this.findArgument(number, argName, init);
        }
        if (name.equals(argName)) {
            return method.getResultArgument();
        }
        TypeDescription objType = this.getObjType();
        MethodTypeDescription member = objType.findMember(argName);
        if (member == null && (member = objType.findMember(oracle.bpm.util.Identifier.argument(argName))) == null) {
            IllegalArgumentException exc = new IllegalArgumentException(init, this.getMemberType(), argName);
            Argument closestArgument = method.findClosestArgument(argName, 0);
            if (closestArgument != null) {
                if (this.getCurrentLanguage().isLastVersion()) {
                    this.reportWarning(exc);
                }
                return this.findArgument(closestArgument.getName(), init, argsType);
            }
            member = this.findMember(objType, argName, 18, init);
            if (member == null) {
                throw exc;
            }
        }
        if (!member.isAttribute()) {
            throw new IllegalArgumentException(init, this.getMemberType(), argName);
        }
        if (!this.isNeedsExtraction()) {
            boolean dynamic = this.isDynamic();
            this.setNeedsExtraction(this.isExpression() && (!dynamic || argsType == 2L));
        }
        if (Modifier.hasGetter(modifiers = member.getModifiers())) {
            modifiers |= 2L;
        }
        if (Modifier.hasSetter(modifiers)) {
            modifiers |= 1L;
        }
        return new Argument(member.getName(), member, modifiers |= 0x20L, -1, member.getJavaType());
    }

    Argument findArgument(int number, String argName, Node init) throws ArgumentNumberException {
        MethodTypeDescription member = this.getMemberType();
        if (member.getArgumentCount() <= number) {
            throw new ArgumentNumberException(init, member);
        }
        Argument arg = member.getArgument(number);
        String javaType = null;
        long origMods = arg.getModifiers();
        argName = arg.getName();
        long modifiers = 0L;
        if (Modifier.isOut(origMods)) {
            modifiers |= 2L;
        }
        if (Modifier.isIn(origMods)) {
            modifiers |= 1L;
        }
        if (Modifier.isOptional(origMods)) {
            modifiers |= 0x80000000L;
        }
        if (Modifier.isExternal(origMods)) {
            javaType = arg.getJavaType();
            modifiers |= 0x800L;
        }
        if (argName == null) {
            argName = String.valueOf(number);
        }
        Argument copy = arg.copy();
        copy.setName(argName);
        copy.setModifiers(modifiers);
        copy.setNumber(number);
        copy.setJavaType(javaType);
        return copy;
    }

    @Override
    void generate(CodeGenerator cg) throws CodeGenerationException {
        cg.generate(this);
    }

    void generateInputArguments(CodeGenerator jvmByteCodeGenerator) throws CodeGenerationException {
        for (Node n = this.getInputArgs().getFirst(); n != null; n = n.getNext()) {
            Arg arg = (Arg)n;
            if (!arg.isArgument()) continue;
            arg.gen(jvmByteCodeGenerator);
        }
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        sql.append(" ? ");
    }

    boolean hasInputArgs() {
        Args inputArgs = this.getInputArgs();
        return inputArgs != null && inputArgs.getArgCount() > 0;
    }

    boolean hasRelay() {
        return this.targetCIL != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Object result;
        Object instance;
        assert (this.getKind() != -1);
        this.currentInstance = instance = this.runPreCall(rm);
        try {
            result = this.runCall(rm, instance);
            this.runPostCall(rm, this.getOutputArgs(), result);
        }
        finally {
            this.currentInstance = null;
        }
        return result;
    }

    Object runCall(RunningMonitor rm, Object instance) throws ExecutionException {
        Object result = this.methodCall instanceof MethodCall ? ((MethodCall)this.methodCall).run(rm, instance) : this.methodCall.run(rm);
        return result;
    }

    void runPostCall(RunningMonitor rm, Args outputArgs, Object instance) throws ExecutionException {
        if (this.isConstructor() && !this.isDynamic()) {
            this.getInputArgs().runInputAttr(rm, instance);
        }
        if (!this.hasRelay() && outputArgs != null && outputArgs.getArgCount() > 0) {
            outputArgs.runOutputAttr(rm);
        }
    }

    Object runPreCall(RunningMonitor rm) throws ExecutionException {
        Object instance = this.runObjectReference(rm);
        if (!this.isDynamic()) {
            Args inputArgs = this.getInputArgs();
            if (!this.isConstructor()) {
                inputArgs.runInputAttr(rm, instance);
            }
            inputArgs.runHolderInit(rm);
        }
        return instance;
    }

    private void setArgs(Args args) {
        this.args = args;
    }

    private Args getArgs() {
        return this.args;
    }

    private void setDelegateBySignature(String signature) {
        this.delegateBySignature = Invoke.isDelegatedBySignature(signature, this.objType);
    }

    private boolean isFuegoObject() {
        return this.getObjectType().isBpmObject();
    }

    private boolean isFunction() {
        return this.getMemberType().isFunction();
    }

    private boolean isInnerType() {
        return this.getObjType().isInnerType();
    }

    private MethodTypeDescription getMethodType(TypeDescription objType, String methodName) throws TypeException {
        MethodTypeDescription memberType = null;
        if (objType.isPredefined() && (memberType = objType.findMember(methodName, TypeFinder.Scope.DELEGATED)) != null) {
            boolean bl = this.delegationInClient = !objType.isBpmObject();
        }
        if (memberType == null) {
            memberType = this.findMethod(objType, methodName, this.getMethod());
        }
        if (memberType == null) {
            if (objType.findMember(methodName) != null) {
                throw new NotMethodException(this.getOp2(), this.getOp1());
            }
            throw MemberReferenceException.illegallMemberSearchClosest(objType, this.getOp1());
        }
        if (memberType.isConstructor() && !this.constructorAllowed) {
            throw new NotMethodException(this.getOp1(), this.getOp2());
        }
        return memberType;
    }

    private void setNeedsExtraction(boolean needsExtraction) {
        this.needsExtraction = needsExtraction;
    }

    private boolean isNeedsExtraction() {
        return this.needsExtraction;
    }

    private Argument getResultArgument() {
        return this.getMemberType().getResultArgument();
    }

    private TypeDescription getResultType() {
        return this.getMemberType().getResultType();
    }

    private boolean isStatic() {
        return this.memberType.isStatic();
    }

    private Node autoDeclare(String methodName) throws TypeException {
        Node object = this.getOp2();
        try {
            this.setObjType(TypeSpec.findType(object));
            this.setMemberType(this.getMethodType(this.getObjType(), methodName));
            TypeSpec typeSpec = new TypeSpec(this.getObjType(), this.getOp2());
            typeSpec.setParent(this);
            object = typeSpec;
            if (!this.isStatic() || this.isDynamic()) {
                object = Invoke.defaultInstanceFor(this.getObjType(), object);
                this.setObjType(object.getTypeDescription());
            }
        }
        catch (NoSuchComponentException exc) {
            throw new MemberReferenceException(this.getOp2());
        }
        return object;
    }

    private void checkDelegation() {
        String signature = Invoke.getSignature(this.getObjType(), this.getMemberType());
        if (Invoke.isDelegatedBySignature(signature, this.getObjType())) {
            this.delegationInClient = true;
        }
    }

    private Node checkRefactor(MethodTypeDescription member, Node object, Args inputArgs) {
        Node result = this;
        if (Modifier.isRefactor(member.getModifiers())) {
            try {
                TemplateSpec spec = TemplateSpec.create(member.getCode());
                Template refactor = spec.instantiate(this);
                refactor.addParameter("object", object);
                inputArgs.addParametersTo(refactor);
                result = refactor.apply();
            }
            catch (CompilerException e) {
                // empty catch block
            }
        }
        return result;
    }

    private void checkRelayTo(Args relayArgs, Method currentMethod) throws TypeException {
        if (!this.isRemote()) {
            throw new IllegalRelayToException(this);
        }
        Node current = new LocalVar(this.getThis(), this).checkType();
        relayArgs.setArgType(1L);
        relayArgs.setWasRelay(true);
        this.targetInvoke = new Invoke(this.targetCIL, current, relayArgs);
        this.targetInvoke.setRelay(true);
        this.targetInvoke.initialize(this);
        this.targetInvoke.setParent(this);
        this.targetInvoke.checkType();
        if (currentMethod.isStatic() && !this.targetInvoke.getMemberType().isStatic()) {
            throw new NotStaticMemberException(this.targetInvoke.getObject(), this.targetInvoke.getOp1(), current.getTypeDescription());
        }
    }

    private ConstructorCall createConstructorCall() throws ConstructorIsPrivateException {
        TypeDescription memberOwner;
        ObjectClass cl;
        TypeDescription currentType;
        ConstructorCall result = new ConstructorCall(this);
        TypeDescription parentTypeDescription = this.getMemberType().getParent();
        if (parentTypeDescription.isAbstract() && !parentTypeDescription.isInvokeable()) {
            this.reportError(NotInstantiableException.abstractType(result));
        }
        if (this.isFuegoObject() && this.isInnerType() && (currentType = (cl = this.getCurrentClass()).getTypeDescription()) != (memberOwner = this.getMemberType().getParent()) && currentType != memberOwner.getParent() && !this.hasInstanceCreator()) {
            throw new ConstructorIsPrivateException(this, memberOwner, currentType);
        }
        return result;
    }

    private Node createDefaultInstanceIfNeeded(Node object) throws TypeException {
        if (object instanceof TypeSpec && (!this.isStatic() || this.isDynamic())) {
            object = Invoke.defaultInstanceFor(this.getObjType(), this.getOp2());
            this.setObjType(object.getTypeDescription());
        }
        return object;
    }

    private void createMethodCall() throws ConstructorIsPrivateException {
        this.methodCall = this.isConstructor() ? this.createConstructorCall() : new MethodCall(this);
        this.methodCall.initialize(this);
        this.methodCall.setParent(this);
        this.methodCall.setStatement(this.isStatement());
    }

    private void ensureNotNullArgs() {
        this.args = Args.ensureNotNullArgs(this, this.args, this.getScope());
    }

    private Node extractMethod(MethodTypeDescription memberType, TypeDescription objType) throws TypeException {
        assert (this.getKind() != -1) : "not compiled";
        boolean constructor = memberType.isConstructor();
        String name = constructor ? "create" + objType.getName() : "invoke";
        Node parent = this.getParent();
        Block block = new Block();
        Identifier resultArg = new Identifier("result");
        this.methodCall = new Assignment(resultArg, this.methodCall);
        this.methodCall.setParent(this);
        block.addChild((AST)this);
        block.setParent(parent);
        Node resultArg2 = null;
        if (constructor) {
            resultArg2 = Invoke.deepCopy(resultArg);
            this.getObject().replace(resultArg2);
        }
        block.initialize(this);
        Node result = Method.extract(block, name, memberType.getResultType());
        ExtractedMethod.forceCompilation(resultArg);
        if (constructor) {
            ExtractedMethod.forceCompilation(resultArg2);
        }
        result.setExpression(true);
        return result;
    }

    private void extractTargetCil() {
        Args lastArgs;
        Node args = this.getOp3();
        if (args != null && (lastArgs = (Args)args.getLast()) != null && lastArgs.isRelay() && !this.isRelay()) {
            this.targetCIL = (Identifier)lastArgs.removeFirst();
        }
    }

    private Node processDeleteMethod(Node object) {
        Symbol symbol = object.getSymbol();
        if (object instanceof ArrayReference) {
            object = object.getFirst();
            Node index = object.getNext();
            this.ensureNotNullArgs();
            this.args.setInvoke(this);
            this.args.addInArgument(index);
            this.setObjType(object.getTypeDescription());
        } else if (symbol != null && symbol.getTarget() != null) {
            object = new Deref(new LocalVar(symbol, object, true));
            this.setObjType(symbol.getTarget().getType());
            symbol.markTargetUsed();
        }
        return object;
    }

    private Node targetObject() throws TypeException {
        Node object = this.getOp2();
        if (this.getObjType() == null && (object = object.checkType()) != null) {
            this.setObjType(object.getTypeDescription());
        }
        return object;
    }

    static class MethodCall
    extends Node
    implements InvokeCall {
        private Invoke invoke;
        static final long serialVersionUID = 215484201130611880L;
        static final long serialCheck = -1924252279884035149L;

        public MethodCall(Invoke invoke) {
            this.invoke = invoke;
        }

        @Override
        public void setInvoke(Invoke invoke) {
            this.invoke = invoke;
        }

        @Override
        public Invoke getInvoke() {
            return this.invoke;
        }

        @Override
        public TypeDescription getTypeDescription() {
            return this.invoke.getTypeDescription();
        }

        boolean getSynchronous() {
            Args outputArgs = this.invoke.getOutputArgs();
            return outputArgs != null && (!this.invoke.isRemote() || !this.isStatement() || outputArgs.getArgCount() > 0 || outputArgs.getReturnArg() != null);
        }

        @Override
        Node checkType() {
            return this;
        }

        @Override
        void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
            codeGenerator.generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            return this.run(rm, this.invoke.currentInstance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Object run(RunningMonitor rm, Object instance) throws ExecutionException {
            try {
                Node objectNode = this.invoke.getObject();
                Args inputArgs = this.invoke.getInputArgs();
                Args outputArgs = this.invoke.getOutputArgs();
                MethodTypeDescription member = this.invoke.getMemberType();
                boolean sendEvent = !(instance instanceof FuegoInvokeable);
                try {
                    Object result;
                    if (sendEvent) {
                        rm.beginEvent(member);
                    }
                    if (this.invoke.isDynamic()) {
                        Object[] outArgs = null;
                        if (this.invoke.returnArray != null) {
                            outArgs = outputArgs != null ? (Object[])outputArgs.runOutputArgs() : null;
                            this.invoke.returnArray.getSymbol().setValue(outArgs);
                        }
                        Invokeable invokeable = (Invokeable)instance;
                        Object[] inArgs = null;
                        if (inputArgs.getArgCount() != 0) {
                            inArgs = (Object[])inputArgs.runInputArgs(rm);
                        }
                        String signature = MemberAccess.getSignature(this.invoke.objType, member);
                        if (this.invoke.hasRelay()) {
                            Object[] bindings = this.invoke.getTargetInvoke().getInputArgs().runBindings(rm);
                            ExecutionRelayedThrowable ert = new ExecutionRelayedThrowable(this.getThis().getValue(), invokeable, signature, inArgs, this.invoke.targetCIL.getText(), bindings);
                            throw (ExecutionException)new ExecutionException(this).initCause(ert);
                        }
                        if (invokeable == null && !member.isStatic()) {
                            Symbol s = objectNode.getSymbol();
                            if (s == null) throw new NullReferenceException(this);
                            throw new NullReferenceException((Node)this, new ValueReference.VariableReference(s));
                        }
                        boolean synchronous = true;
                        Object object = invokeable.invoke(signature, true, inArgs, outArgs);
                        return object;
                    }
                    Object[] args = (Object[])inputArgs.runInputArgs(rm);
                    String signature = MemberAccess.getSignature(this.invoke.objType, member);
                    boolean delegateBySignature = MemberAccess.isDelegatedBySignature(signature, member.getParent());
                    if (this.invoke.delegationInClient && delegateBySignature && !member.isStatic()) {
                        int length = args != null ? args.length : 0;
                        Object[] fullArgs = new Object[length + 1];
                        fullArgs[0] = objectNode.value(rm);
                        System.arraycopy(args, 0, fullArgs, 1, length);
                        args = fullArgs;
                    }
                    if (this.invoke.objType.isBpmObject() && member.isStatic()) {
                        ObjectClass cl = ObjectClass.getOrCreate(this.getCompiler(), this.invoke.objType);
                        Method method = cl.getMemberBySignature(signature);
                        result = method.run(rm, args, null);
                    } else {
                        result = instance instanceof Invokeable ? ((Invokeable)instance).invoke(signature, args) : member.invoke(instance, args);
                    }
                    if (outputArgs != null) {
                        outputArgs.runOutputArgs();
                    }
                    Object object = result;
                    return object;
                }
                finally {
                    if (sendEvent) {
                        rm.endEvent(member);
                    }
                }
            }
            catch (ExecutionException exc) {
                throw exc;
            }
            catch (ComponentExecutionException exc) {
                Throwable nested = Utilities.unwrapException(exc);
                if (nested instanceof ExecutionException) {
                    throw (ExecutionException)nested;
                }
                CompilerExceptionShell exception = new CompilerExceptionShell((Node)this, (Throwable)exc);
                rm.exceptionEvent(exception);
                throw exception;
            }
            catch (Exception exc) {
                CompilerExceptionShell exception = new CompilerExceptionShell((Node)this, (Throwable)exc);
                rm.exceptionEvent(exception);
                throw exception;
            }
        }
    }

    static class ConstructorCall
    extends Node
    implements InvokeCall {
        private Invoke invoke;
        static final long serialVersionUID = -6263712181527203422L;
        static final long serialCheck = 6997690103988038119L;

        public ConstructorCall(Invoke invoke) {
            this.invoke = invoke;
        }

        @Override
        public void setInvoke(Invoke invoke) {
            this.invoke = invoke;
        }

        @Override
        public Invoke getInvoke() {
            return this.invoke;
        }

        @Override
        public TypeDescription getTypeDescription() {
            return this.invoke.getTypeDescription();
        }

        @Override
        public String getTypeText() {
            return this.invoke.getMemberType().getParent().getText();
        }

        @Override
        Node checkType() throws TypeException {
            return this;
        }

        String[] dynamicConstructorParameters() {
            TypeDescription objType = this.invoke.getObjType();
            String componentType = objType.asObject().getComponentType();
            String abstractConfigName = TypeSpec.getAbstractConfigName(objType);
            if (!"java".equalsIgnoreCase(componentType)) {
                abstractConfigName = this.getCompiler().getRealConfiguration(abstractConfigName);
            }
            return new String[]{componentType, abstractConfigName, objType.getText(), objType.getSignature(), MemberAccess.getSignature(objType, this.invoke.getMemberType())};
        }

        @Override
        void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
            codeGenerator.generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            Object[] inArgs = null;
            Args inputArgs = this.invoke.getInputArgs();
            if (inputArgs.getArgCount() != 0) {
                inArgs = (Object[])inputArgs.runInputArgs(rm);
            }
            try {
                Object instance;
                TypeDescription objType = this.invoke.getObjType();
                if (this.invoke.hasInstanceCreator()) {
                    instance = this.invoke.instanceCreator.value(rm);
                } else if (!this.invoke.isDynamic()) {
                    FuegoCompiler compiler = this.getCompiler();
                    ObjectClass classForType = ObjectClass.getOrCreate(compiler, objType);
                    if (classForType != null) {
                        if (objType.isInnerType()) {
                            if (inArgs != null) {
                                List<Object> args = ArrayUtils.asList(inArgs);
                                args.add(0, this.getCurrentClass().getSymbol().getValue());
                                inArgs = args.toArray();
                            } else {
                                inArgs = new Object[]{this.getCurrentClass().getSymbol().getValue()};
                            }
                        }
                        instance = compiler.createInvokeable(objType.asObject(), inArgs);
                    } else {
                        instance = this.invoke.getMemberType().invoke(null, inArgs);
                    }
                } else {
                    ObjectTypeDescription otd = objType.asObject();
                    String componentType = otd.getComponentType();
                    String configName = null;
                    for (TypeDescription current = otd; configName == null && current != null; current = current.getParent()) {
                        configName = current.asObject().getProperty("configName");
                    }
                    String sign = otd.getSignature();
                    Object[] args = null;
                    String constructor = MemberAccess.getSignature(objType, this.invoke.getMemberType());
                    if (inputArgs.getArgCount() > 0) {
                        args = (Object[])inputArgs.runInputArgs(rm);
                    }
                    instance = otd.isRemote() ? Component.instantiateRemoteDynamic(componentType, configName, objType.getText(), sign, constructor, args) : Component.instantiateDynamic(componentType, configName, objType.getText(), sign, constructor, args);
                }
                return instance;
            }
            catch (ComponentExecutionException e) {
                throw new CompilerExceptionShell((Node)this, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new CompilerExceptionShell((Node)this, (Throwable)e);
            }
            catch (CompilerException e) {
                throw new CompilerExceptionShell((Node)this, (Throwable)e);
            }
        }
    }

    static interface InvokeCall {
        public void setInvoke(Invoke var1);

        public Invoke getInvoke();
    }
}

