/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.collections.AST;
import java.util.List;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.InputField;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NodeIterator;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.type.TypeFactory;

public class InputFields
extends Node {
    private List<Node> defaultValues;
    private List<Node> labels = CollectionPool.getLinkedList();
    private List<Node> options;
    private List<Node> types = CollectionPool.getLinkedList();
    private List<Node> validValues;
    static final long serialVersionUID = 7439337586901353609L;
    static final long serialCheck = 721627970707268736L;

    public InputFields(AST ast) {
        super(ast);
        this.defaultValues = CollectionPool.getLinkedList();
        this.validValues = CollectionPool.getLinkedList();
        this.options = CollectionPool.getLinkedList();
    }

    InputFields() {
        this((AST)null);
    }

    @Override
    public String getText() {
        return "fields";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    Node getDefaultValues() throws TypeException {
        return ArrayConst.create(this.defaultValues, this, false, TypeFactory.getArray(TypeFactory.getAny()));
    }

    Node getLabels() throws TypeException {
        return ArrayConst.create(this.labels, this, true, null);
    }

    Node getOptions() throws TypeException {
        return ArrayConst.create(this.options, this, true, null);
    }

    Node getTypes() throws TypeException {
        return ArrayConst.create(this.types, this, true, null);
    }

    Node getValidValues() throws TypeException {
        return ArrayConst.create(this.validValues, this, true, null);
    }

    void addField(String name, Node value) {
        assert (!value.isConstant());
        StringConst str = new StringConst(name, -1, this);
        InputField field = new InputField(str, value);
        Node first = this.getFirst();
        if (first == null) {
            this.setFirst(field);
        } else {
            first.getLast().setNext(field);
        }
    }

    @Override
    Node checkType() throws TypeException {
        this.setTypeDescription(TypeFactory.getVoid());
        Node current = this.getFirst();
        int number = 0;
        while (current != null) {
            InputField field = (InputField)current;
            field.setFieldNumber(number);
            field = (InputField)field.checkType();
            this.labels.add(field.getLabelNode());
            this.types.add(field.getTypeNode());
            this.defaultValues.add(Conversion.Cast.create(field.getDefaultValueNode(), TypeFactory.getAny()));
            this.validValues.add(field.getValidValuesNode());
            List opts = field.getOptions();
            if (opts == null || opts.isEmpty()) {
                this.options.add(new NullConst(this));
            } else {
                this.options.add(ArrayConst.create(opts, this, false, null));
            }
            current = current.getNext();
            ++number;
        }
        return this;
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            current.gen(codeGenerator);
        }
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        NodeIterator it = this.getChildren();
        while (it.hasNext()) {
            it.next().run(rm);
        }
        return null;
    }
}

