/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import oracle.bpm.compiler.AmbiguousComponentNameException;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.ArgumentNumberException;
import oracle.bpm.compiler.ArrayReference;
import oracle.bpm.compiler.CloneNotSupportedException;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.ExpressionAsStatementException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.IllegalTypeException;
import oracle.bpm.compiler.InvalidExpr;
import oracle.bpm.compiler.InvalidOutputArgument;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.MemberReferenceException;
import oracle.bpm.compiler.NamedNode;
import oracle.bpm.compiler.NoSuchComponentException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NotFunctionException;
import oracle.bpm.compiler.NotStaticMemberException;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.UndefinedVariableException;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeFinder;

public class Function
extends MemberAccess {
    private boolean isClone = false;

    public Function(Token t) {
        super(t);
        this.setTypeDescription(TypeFactory.getNone());
    }

    Function() {
    }

    Function(String typeId, Node arg, Node init) {
        Identifier first = new Identifier(typeId);
        Arg.Type argument = new Arg.Type(1L);
        first.setNext(argument);
        ((Node)argument).setNext(arg);
        arg.setNext(null);
        this.setFirst(first);
        this.initialize(init);
        this.setParent(init);
        this.setTypeDescription(TypeFactory.getNone());
    }

    public static Args createArgs(Node firstArg, Node parent) {
        if (firstArg instanceof Args) {
            return (Args)firstArg;
        }
        Args inputArgs = new Args(1L);
        inputArgs.setParent(parent);
        inputArgs.initialize(parent);
        if (firstArg instanceof InvalidExpr) {
            return inputArgs;
        }
        Node current = firstArg;
        Node outputArgs = null;
        while (current != null && !(current instanceof Args)) {
            Arg.Type type;
            assert ((current instanceof Arg.Type || current instanceof InvalidExpr) && current.getNext() != null) : "Should have pair Arg.Type node";
            if (current instanceof InvalidExpr) {
                type = new Arg.Type(1L);
                type.initialize(current);
            } else {
                type = (Arg.Type)current;
            }
            final Node arg = current.getNext();
            current = arg.getNext();
            if (type.isIn()) {
                inputArgs.addOneChild(arg);
            }
            if (!type.isOut()) continue;
            Node outArg = type.isIn() ? Node.deepCopy(arg) : arg;
            Node op2 = outArg.getOp2();
            if (op2 instanceof Deref) {
                outArg.setOperands(outArg.getOp1(), op2.getFirst());
            }
            if ((outArg = outArg.getTargetValue()) == null) {
                outArg = new Node(){

                    @Override
                    Node checkType() throws TypeException {
                        throw new InvalidOutputArgument(arg);
                    }
                };
            }
            if (outputArgs == null) {
                outputArgs = new Args(2L);
                inputArgs.setNext(outputArgs);
            }
            outputArgs.addOneChild(outArg);
        }
        if (current != null) {
            if (outputArgs != null) {
                throw new IllegalStateException("Cannot use output args with relay-to");
            }
            inputArgs.setNext(current);
        }
        return inputArgs;
    }

    @Override
    public String getText() {
        return "call";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    @Override
    void setScope(Scope scp) {
        this.scope = scp;
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            current.setScope(scp);
        }
    }

    void addArg(Node value) {
        Arg.Type type = new Arg.Type(1L);
        this.addChild((AST)type);
        this.addChild((AST)value);
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            current.checkFlow(context);
        }
        context.breaksFlow(false);
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getKind() != -1) {
            return this;
        }
        Node funId = this.getFirst();
        if (funId instanceof Invoke || funId instanceof Conversion) {
            return funId;
        }
        int treeOffset = this.getTreeOffset();
        int treeLength = this.getTreeLength();
        Args inputArgs = Function.createArgs(funId.getNext(), this);
        int argc = inputArgs.childCount();
        funId.setNext(inputArgs);
        Node firstArg = inputArgs.getFirst();
        assert (firstArg != null || argc == 0);
        IllegalTypeException firstException = null;
        TypeDescription parsedType = null;
        try {
            parsedType = Declaration.parseTypeDescription(funId, this.getScope());
            if (!parsedType.isObject() && argc == 1) {
                if (this.isStatement()) {
                    this.reportError(new ExpressionAsStatementException(this));
                }
                firstArg = firstArg.checkType();
                this.setFirst(null);
                firstArg.setParent(this);
                Node result = Conversion.promote(firstArg, parsedType, false).checkType();
                result.setOffset(treeOffset);
                result.setLength(treeLength);
                this.setFirst(result);
                return result;
            }
        }
        catch (NoSuchComponentException ignore) {
        }
        catch (IllegalTypeException ignore) {
            firstException = ignore;
        }
        if (this.processClone(funId, inputArgs, argc)) {
            return this;
        }
        Node object = null;
        MethodTypeDescription memberType = null;
        TypeDescription objectType = this.getObjType();
        if (funId instanceof Identifier) {
            Symbol symbol = this.getSymbolTable().getFunction(funId.getText());
            if (symbol != null) {
                memberType = (MethodTypeDescription)symbol.getType();
                objectType = memberType.getParent();
            } else {
                boolean findClosest;
                String id;
                TypeDescription currentType = this.getCurrentClass().getTypeDescription();
                memberType = this.findMember(currentType, id = funId.getText(), 14, funId, findClosest = parsedType == null, true, false);
                if (memberType != null) {
                    memberType = this.select(memberType, inputArgs);
                }
                if (memberType != null) {
                    objectType = currentType;
                    object = memberType.isStatic() ? new TypeSpec(this.getThis().getType(), this) : new LocalVar(this.getThis(), null);
                    object.setSynthetic(true);
                    object.initialize(this);
                    object.setParent(this);
                    if (this.getCurrentMember().isStatic() && !memberType.isStatic()) {
                        throw new NotStaticMemberException(object, funId, currentType);
                    }
                } else if (argc > 0) {
                    Node next = firstArg.getNext();
                    try {
                        firstArg = firstArg.checkType();
                    }
                    catch (TypeException e) {
                        if (!(e instanceof UndefinedVariableException) && !(e instanceof MemberReferenceException)) {
                            throw e;
                        }
                        try {
                            TypeDescription argType = TypeSpec.findType(firstArg);
                            firstArg = Function.defaultInstanceFor(argType, new TypeSpec(argType, firstArg));
                        }
                        catch (AmbiguousComponentNameException ae) {
                            throw ae;
                        }
                        catch (TypeException e2) {
                            throw e;
                        }
                    }
                    firstArg.setNext(next);
                    inputArgs.setFirst(firstArg);
                    TypeDescription objType = firstArg.getTypeDescription();
                    MethodTypeDescription member = null;
                    if (!objType.isBpmObject()) {
                        member = objType.findMember(funId.getText(), TypeFinder.Scope.DELEGATED);
                        if (member != null && member.isConstructor()) {
                            member = null;
                        }
                        if (member != null) {
                            this.delegationInClient = true;
                        }
                    }
                    if (member == null) {
                        member = this.findMethod(objType, funId.getText(), funId);
                    }
                    objectType = objType;
                    if (member != null) {
                        object = inputArgs.removeFirstArgument();
                        memberType = member;
                    }
                }
            }
        }
        if (memberType == null && parsedType != null) {
            objectType = parsedType;
            memberType = this.findMethod(parsedType, parsedType.getName(), funId);
        }
        try {
            Node memberName;
            if (memberType == null) {
                Node method;
                try {
                    method = funId.checkType(14);
                }
                catch (MemberReferenceException e) {
                    throw new NotFunctionException(e.getNode(), e.getNode().getText());
                }
                if (method == null) {
                    if (firstException != null) {
                        throw firstException;
                    }
                    throw new NotFunctionException(funId, funId.getText());
                }
                if (method instanceof Conversion) {
                    method = ((Conversion)method).getOperand();
                }
                if (!(method instanceof MemberReference)) {
                    throw new NotFunctionException(funId, funId.getTypeText());
                }
                MemberReference ref = (MemberReference)method;
                memberType = method.getTypeDescription().asMethod();
                object = ref.getOp1();
                this.delegationInClient = ref.isDelegationInClient();
                objectType = ref.getObjType();
            }
            if (!this.delegationInClient && objectType.isPrimitive() && objectType.isPredefined()) {
                object = Conversion.Box.create(object).checkType();
            }
            if (funId instanceof Identifier) {
                memberName = funId;
            } else {
                memberName = new Identifier(memberType.getName());
                memberName.initialize(funId);
                memberName.setOffset(funId.getTreeOffset());
                memberName.setLength(funId.getTreeLength());
            }
            if (object == null) {
                object = new Identifier(memberType.getParent().getName());
                object.initialize(this);
            }
            Invoke invoke = new Invoke(object, objectType, memberType, inputArgs, this.delegationInClient, memberName);
            invoke.initialize(this);
            invoke.setStatement(this.isStatement());
            this.setFirst(invoke);
            this.getCurrentClass().declareDependency(objectType);
            return invoke.checkType();
        }
        catch (TypeException e) {
            if (parsedType != null && argc == 1) {
                Node operand = firstArg.checkType();
                Node result = Conversion.Cast.create(operand, parsedType).checkType();
                result.setOffset(treeOffset);
                result.setLength(treeLength);
                return result;
            }
            throw e;
        }
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        assert (this.isClone);
        codeGenerator.generate(this);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        sql.append(" ? ");
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        assert (this.isClone);
        try {
            Object source = this.getFirst().notNullValue(rm);
            return Any.clone(source);
        }
        catch (RuntimeException e) {
            throw new CompilerExceptionShell((Node)this, (Throwable)e);
        }
    }

    private MethodTypeDescription select(MethodTypeDescription memberType, Args inputArgs) throws TypeException {
        return Function.select(memberType, inputArgs, true, (Node)this);
    }

    private boolean processClone(Node funId, Args inputArgs, int argc) throws TypeException {
        boolean result;
        boolean bl = result = argc == 0 && funId instanceof MemberReference && funId.getOp2().getText().equals("clone");
        if (result) {
            MemberReference ref = (MemberReference)funId;
            Node object = ref.getObject();
            Node member = ref.getOp2();
            inputArgs = new Args(1L);
            if (object instanceof Identifier) {
                object = new Deref(object);
            }
            inputArgs.addOneChild(object);
            funId = member;
            this.addOneChild(funId);
            this.addChild((AST)inputArgs);
            argc = 1;
        }
        if (!result) {
            result = funId.getText().equals("clone");
        }
        if (result) {
            this.isClone = true;
            if (argc != 1) {
                TypeDescription any = TypeFactory.getAny();
                MethodTypeDescription method = new MethodTypeDescription("clone");
                method.setParent(this.getCurrentClass().getTypeDescription());
                method.addArgument(new Argument("arg1", any, 1L));
                method.setResultType(any);
                throw new ArgumentNumberException(funId, method);
            }
            Node argv = inputArgs.getFirst().checkType();
            if (!argv.getTypeDescription().isCloneable()) {
                throw new CloneNotSupportedException(argv);
            }
            this.setTypeDescription(argv.getTypeDescription());
            this.setFirst(argv);
        }
        return result;
    }

    public static class VisualBasic
    extends Function {
        public VisualBasic(Token t) {
            super(t);
        }

        @Override
        public Node getTargetValue() {
            return this.getKind() == -1 ? this : null;
        }

        @Override
        Node checkType() throws TypeException {
            Node id = this.getOp1();
            Node arg = this.getOp2();
            try {
                boolean hasOneArgument;
                boolean bl = hasOneArgument = this.childCount() == 3;
                if (hasOneArgument && !(arg.getNext() instanceof NamedNode)) {
                    Node parent = id.getParent();
                    id = Node.deepCopy(id);
                    id.setParent(parent);
                    id = id.checkType();
                    if (id != null && id.getTypeDescription().isArray()) {
                        if (id instanceof LocalVar) {
                            id = new Deref(id);
                        }
                        ArrayReference element = new ArrayReference();
                        element.addOneChild(id);
                        element.addOneChild(arg.getNext());
                        element.copyParentFrom(this);
                        element.setLeftValue(this.isLeftValue());
                        element.initialize(this);
                        return element.checkType();
                    }
                }
            }
            catch (TypeException typeException) {
                // empty catch block
            }
            return super.checkType();
        }
    }
}

