/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.lexer.FuegoLexerInputStream;
import fuego.lexer.LexerConfigurator;
import fuego.parser.FuegoToken;
import fuego.parser.NoViableAltForCharException;
import fuego.parser.RecognitionException;
import fuego.parser.Token;
import fuego.parser.TokenStream;
import fuego.parser.TokenStreamException;
import fuego.parser.TokenStreamRecognitionException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.type.SourceCode;
import oracle.bpm.util.CharArrayMap;
import oracle.bpm.util.StringCache;

public class FuegoLexer
implements TokenStream,
FuegoLexerInputStream {
    protected int state = 0;
    protected StringCache stringCache;
    private boolean[] caseInsensitive;
    private int columnNumber;
    private int completionIndex = -1;
    private boolean createIndentTokens;
    private int endOffset;
    private char escapeForNewLine;
    private boolean escapeNextId;
    private int exitState = 0;
    private int[] exitTokens;
    private LanguageSpec languageSpec;
    private boolean lastWasId;
    private LexerConfigurator lexerConfigurator;
    private int lineNumber;
    private boolean newLineToken;
    private int offset;
    private int prevColumnNumber;
    private boolean skipFormatTokens;
    private int startColNumber;
    private int startLineNumber;
    private int startOffset;
    private char[] text;
    public static final char EOF = '\u0000';

    public FuegoLexer(LanguageSpec languageSpec) {
        this.languageSpec = languageSpec;
        this.lexerConfigurator = languageSpec.getLexerConfigurator();
        this.setNewLineToken(this.lexerConfigurator.isNewLineToken());
        this.caseInsensitive = this.lexerConfigurator.getCaseInsensitiveByState();
        this.escapeForNewLine = this.lexerConfigurator.getEscapeForNewLine();
        this.stringCache = new StringCache();
    }

    public static void main(String[] args) throws InvalidLanguageException, TokenStreamException, IOException {
        FuegoLexer lexer = new FuegoLexer(LanguageSpec.getLanguageSpec(args[0]));
        lexer.setCreateIndentTokens(true);
        String[] code = new String[args.length];
        for (int i = 1; i < args.length; ++i) {
            String line;
            if (args[i].equals("-c")) continue;
            if (args[i].equals("-i")) {
                lexer.setCompletionIndex(Integer.parseInt(args[++i]));
                continue;
            }
            if (args[i].equals("-f")) {
                lexer.setSkipFormatTokens(false);
                continue;
            }
            BufferedReader reader = new BufferedReader(new FileReader(args[i]));
            StringBuilder buffer = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                buffer.append(line).append('\n');
            }
            code[i] = buffer.toString();
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        System.gc();
        long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long start = System.currentTimeMillis();
        for (String s : code) {
            if (s == null) continue;
            lexer.setCode(s);
            Token token = lexer.nextToken();
            while (token != null && token.getType() != 1) {
                tokens.add(token);
                try {
                    token = lexer.nextToken();
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                }
            }
            if (token == null) continue;
            tokens.add(token);
        }
        System.out.println("elapsed time: " + (System.currentTimeMillis() - start) + " ms");
        long used2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        System.out.println("Used memory: +" + (used2 - used) / 1024L + "Kb");
        System.gc();
        long used3 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        System.out.println("Used memory after GC: +" + (used3 - used) / 1024L + "Kb");
        System.out.println(lexer.stringCache);
        for (Token tk : tokens) {
            System.out.println(tk);
        }
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive[this.state];
    }

    public void setCode(String code) {
        this.setCode(code.toCharArray(), 0, code.length());
    }

    public void setCode(SourceCode code) {
        int offset = code.getOffset();
        this.setCode(code.getText(), offset, offset + code.getLength());
    }

    public void setCode(char[] buffer, int offset, int endOffset) {
        assert (endOffset <= buffer.length) : "endOffset out of bounds: buffer.length=" + buffer.length + ", endOffset=" + endOffset;
        assert (endOffset >= 0) : "underflow: endOffset=" + endOffset;
        this.text = buffer;
        this.offset = offset;
        this.endOffset = endOffset;
        this.columnNumber = 1;
        this.lineNumber = 1;
    }

    public SourceCode getCode() {
        return SourceCode.create(this.text, this.languageSpec.getId());
    }

    public void setCompletionIndex(int completionIndex) {
        this.completionIndex = completionIndex;
        if (completionIndex != -1 && completionIndex <= this.text.length) {
            this.endOffset = completionIndex;
        }
    }

    public int getCompletionIndex() {
        return this.completionIndex;
    }

    public void setCreateIndentTokens(boolean createIndentTokens) {
        this.createIndentTokens = createIndentTokens;
    }

    public void setExitState(int exitState) {
        this.exitState = exitState;
    }

    public int getExitState() {
        return this.exitState;
    }

    public void setExitTokens(int[] exitTokens) {
        this.exitTokens = exitTokens;
    }

    public int[] getExitTokens() {
        return this.exitTokens;
    }

    public String getLanguage() {
        return this.languageSpec.getId();
    }

    public void setNoReservedWords(boolean value) {
        this.lexerConfigurator.setNoReservedWords(value);
    }

    public LexerConfigurator getLexerConfigurator() {
        return this.lexerConfigurator;
    }

    public void setNewLineToken(boolean flag) {
        this.newLineToken = flag;
    }

    public boolean isNewLineToken() {
        return this.newLineToken;
    }

    public int getOffset() {
        return Math.min(this.offset, this.endOffset);
    }

    public void setSkipFormatTokens(boolean skipFormatTokens) {
        this.skipFormatTokens = skipFormatTokens;
    }

    public boolean isSkippingFormatTokens() {
        return this.skipFormatTokens;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public int getTokenForId(String id) {
        id = this.isCaseInsensitive() ? id.toLowerCase() : id;
        Integer type = (Integer)this.lexerConfigurator.getReservedWords(this.state).get(id);
        return type == null ? 7 : type;
    }

    public int getTokenForId(char[] code, int offset, int length) {
        if (this.isCaseInsensitive()) {
            return this.getTokenForId(this.stringCache.getString(code, offset, length));
        }
        CharArrayMap reservedWords = this.lexerConfigurator.getReservedWords(this.state);
        Integer type = (Integer)reservedWords.get(code, offset, length);
        return type == null ? 7 : type;
    }

    public int getTokenType(Token t) {
        FuegoToken token = (FuegoToken)t;
        if (token.getState() != this.getState()) {
            if (t.getType() == 7) {
                String text = token.getText();
                token.setType(this.getTokenForId(text));
            }
            token.setState(this.getState());
        }
        return token.getType();
    }

    public Token nextToken() throws TokenStreamException {
        FuegoToken result = this.readNextToken();
        int type = result.getType();
        boolean bl = this.lastWasId = type == 7;
        if (this.exitTokens != null) {
            for (int i = 0; i < this.exitTokens.length; ++i) {
                int tk = this.exitTokens[i];
                if (tk != type) continue;
                this.setState(this.exitState);
                this.exitTokens = null;
                break;
            }
        }
        this.escapeNextId = this.lexerConfigurator.isEscapeAfterToken(type);
        return result;
    }

    public char read() throws TokenStreamException {
        if (this.offset >= this.endOffset) {
            ++this.offset;
            return '\u0000';
        }
        if (this.wasNewLine()) {
            ++this.lineNumber;
            this.prevColumnNumber = this.columnNumber;
            this.columnNumber = 1;
        } else {
            ++this.columnNumber;
        }
        assert (this.offset < this.text.length) : "offset out of bounds: endOffset=" + this.endOffset + ", offset=" + this.offset + ", text.length=" + this.text.length + ", text='" + String.valueOf(this.text) + '\'';
        return this.text[this.offset++];
    }

    public void reset() {
        this.lineNumber = 1;
        this.columnNumber = 1;
        this.text = null;
        this.startOffset = -1;
        this.endOffset = -1;
        this.completionIndex = -1;
    }

    public void skipToNewLine() throws TokenStreamException {
        char c;
        while ((c = this.read()) != '\u0000' && c != '\n') {
        }
    }

    public void unread() {
        assert (this.offset > 0) : "underflow";
        --this.offset;
        if (this.offset < this.endOffset) {
            --this.columnNumber;
            if (this.columnNumber == 0) {
                this.columnNumber = this.prevColumnNumber;
                --this.lineNumber;
            }
            assert (this.columnNumber > 0) : "Column <= 0 " + this.offset + "  " + this.text.length + "  " + this.text[this.offset - 1] + ' ' + this.endOffset;
        }
    }

    protected FuegoToken makeToken(int tokenType, char[] text, int textOffset, int textLength, int offset, int length) {
        assert (textOffset >= 0) : "Invalid offset: " + textOffset;
        assert (textLength >= 0) : "Invalid length: " + textLength;
        String string = text != null ? this.stringCache.getString(text, textOffset, textLength) : null;
        return new FuegoToken(tokenType, string, offset, length, this.startLineNumber, this.startColNumber, this.state);
    }

    protected FuegoToken makeToken(int tokenType, StringBuffer text, int offset, int length) {
        return new FuegoToken(tokenType, text != null ? text.toString() : null, offset, length, this.startLineNumber, this.startColNumber, this.state);
    }

    private static boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    private static boolean isDigit(char c, int base) {
        return Character.digit(c, base) != -1;
    }

    private static boolean isIdentifierPart(char c) {
        return c != '\u0000' && LexerConfigurator.isIdentifierPart((char)c);
    }

    private static boolean isIdentifierStart(char c) {
        return LexerConfigurator.isIdentifierStart((char)c);
    }

    private static boolean isReservedWordEscape(char c) {
        return LexerConfigurator.isReservedWordEscape((char)c);
    }

    private boolean isCommentEnd(char c) throws TokenStreamException {
        return LexerConfigurator.isCommentEnd((char)c, (FuegoLexerInputStream)this);
    }

    private boolean isCommentStart(char c) throws TokenStreamException {
        return LexerConfigurator.isCommentStart((char)c, (FuegoLexerInputStream)this);
    }

    private boolean isLineCommentStart(char c) throws TokenStreamException {
        return this.lexerConfigurator.isLineCommentStart(c, (FuegoLexerInputStream)this);
    }

    private boolean isRegExpStart(char c) throws TokenStreamException {
        return this.lexerConfigurator.isRegExpStart(c, (FuegoLexerInputStream)this);
    }

    private boolean isStringDelimiter(char c) throws TokenStreamException {
        return this.lexerConfigurator.isStringDelimiter(c, (FuegoLexerInputStream)this);
    }

    private boolean isTimeLiteralDelimiter(char c) {
        return this.lexerConfigurator.isTimeLiteralDelimiter(c);
    }

    private boolean isWhiteSpace(char c) {
        return Character.isWhitespace(c) && (c != '\n' || !this.newLineToken);
    }

    private FuegoToken makeToken(int tokenType, char[] text, int textOffset, int textLength) {
        return this.makeToken(tokenType, text, textOffset, textLength, this.startOffset, this.offset - this.startOffset);
    }

    private FuegoToken makeToken(int tokenType, StringBuffer text) {
        return this.makeToken(tokenType, text, this.startOffset, this.offset - this.startOffset);
    }

    private String testRegExpEnd(char c) throws TokenStreamException {
        try {
            return this.lexerConfigurator.testRegExpEnd(c, (FuegoLexerInputStream)this);
        }
        catch (TokenStreamRecognitionException e) {
            if (e.recog != null) {
                int lineForOffset = SourceCode.getLineForOffset(this.text, 0, this.text.length, this.offset);
                int column = SourceCode.getColumnForOffset(this.text, 0, this.text.length, this.offset);
                e.recog.line = lineForOffset;
                e.recog.column = column;
            }
            throw e;
        }
    }

    private char parseEscapeSequence(char c) throws TokenStreamException {
        switch (c) {
            case '\"': 
            case '\'': 
            case '\\': {
                break;
            }
            case 'n': {
                c = (char)10;
                break;
            }
            case 'r': {
                c = (char)13;
                break;
            }
            case 't': {
                c = (char)9;
                break;
            }
            case 'v': {
                c = (char)11;
                break;
            }
            case 'a': {
                c = (char)7;
                break;
            }
            case 'b': {
                c = (char)8;
                break;
            }
            case 'f': {
                c = (char)12;
                break;
            }
            case 'u': {
                int val = 0;
                for (int i = 0; i < 4; ++i) {
                    c = this.read();
                    if (!FuegoLexer.isDigit(c, 16)) {
                        int lineForOffset = SourceCode.getLineForOffset(this.text, 0, this.text.length, this.offset);
                        int column = SourceCode.getColumnForOffset(this.text, 0, this.text.length, this.offset);
                        throw new TokenStreamRecognitionException((RecognitionException)new NoViableAltForCharException(c, "", lineForOffset, column));
                    }
                    val = val * 16 + Character.digit(c, 16);
                }
                c = (char)val;
                break;
            }
            default: {
                if (c >= '0' && c <= '7') {
                    int val = 0;
                    for (int i = 0; i < 3 && FuegoLexer.isDigit(c = this.read(), 8); ++i) {
                        val = val * 8 + Character.digit(c, 8);
                    }
                    c = (char)val;
                }
                int lineForOffset = SourceCode.getLineForOffset(this.text, 0, this.text.length, this.offset - 1);
                int column = SourceCode.getColumnForOffset(this.text, 0, this.text.length, this.offset - 1);
                throw new TokenStreamRecognitionException((RecognitionException)new NoViableAltForCharException(c, "", lineForOffset, column));
            }
        }
        return c;
    }

    private FuegoToken parseIdentifier(char c) throws TokenStreamException {
        boolean escape = false;
        if (FuegoLexer.isReservedWordEscape(c)) {
            c = this.read();
            if (!FuegoLexer.isIdentifierStart(c)) {
                this.unread();
                return null;
            }
            escape = true;
        } else if (!FuegoLexer.isIdentifierStart(c)) {
            return null;
        }
        while (FuegoLexer.isIdentifierPart(this.read())) {
        }
        this.unread();
        int tokenType = escape || this.escapeNextId ? 7 : this.getTokenForId(this.text, this.startOffset, this.offset - this.startOffset);
        this.escapeNextId = false;
        int length = this.offset - this.startOffset;
        if (this.completionIndex != -1 && this.completionIndex >= this.startOffset && this.completionIndex <= this.offset) {
            tokenType = 17;
            length = this.completionIndex - this.startOffset;
            this.completionIndex = -1;
        }
        return this.makeToken(tokenType, this.text, this.startOffset + (escape ? 1 : 0), length - (escape ? 1 : 0));
    }

    private FuegoToken parseLiteralString(char c) throws TokenStreamException {
        int start = this.startOffset + 1;
        int end = -1;
        StringBuffer text = null;
        char stringStart = c;
        while (this.isStringDelimiter(c)) {
            c = this.read();
            if (end != -1 && text == null) {
                text = new StringBuffer();
                text.append(this.text, start, end - start - 1);
            }
            while (c != stringStart && this.completionIndex != this.offset) {
                if (c == '\n' || c == '\u0000') {
                    int lineForOffset = SourceCode.getLineForOffset(this.text, 0, this.text.length, this.offset - 2);
                    int column = SourceCode.getColumnForOffset(this.text, 0, this.text.length, this.offset - 2);
                    throw new TokenStreamRecognitionException((RecognitionException)new LexerException("End of line without end of String", "", lineForOffset, column, this.makeToken(10, text)));
                }
                if (c == '\\') {
                    if (text == null) {
                        text = new StringBuffer();
                        text.append(this.text, start, this.offset - (end != -1 ? end : start) - 1);
                    }
                    c = this.parseEscapeSequence(this.read());
                }
                if (text != null) {
                    text.append(c);
                }
                c = this.read();
            }
            end = this.offset;
            if (this.completionIndex == this.offset) {
                this.completionIndex = -1;
                break;
            }
            while (this.isWhiteSpace(c = this.read())) {
            }
        }
        if (end == -1) {
            return null;
        }
        this.unread();
        return text != null ? this.makeToken(10, text) : this.makeToken(10, this.text, start, end - start - 1, this.startOffset, end - this.startOffset);
    }

    private FuegoToken parseNumber(char c) throws TokenStreamException {
        int t;
        int ttype = 0;
        if (FuegoLexer.isDigit(c)) {
            int base = c == '0' ? 8 : 10;
            ttype = 11;
            c = this.read();
            if (base == 8 && (c == 'x' || c == 'X')) {
                base = 16;
                c = this.read();
            }
            while (FuegoLexer.isDigit(c, base)) {
                c = this.read();
            }
        }
        if (c == '.') {
            c = this.read();
            if (ttype != 0) {
                if (c == '.' || !FuegoLexer.isDigit(c)) {
                    this.unread();
                    this.unread();
                    return this.makeToken(ttype, this.text, this.startOffset, this.offset - this.startOffset);
                }
            } else {
                if (!FuegoLexer.isDigit(c)) {
                    this.unread();
                    return null;
                }
                if (this.lastWasId) {
                    this.unread();
                    return null;
                }
            }
            ttype = 13;
            while (FuegoLexer.isDigit(c)) {
                c = this.read();
            }
        }
        if (ttype == 0) {
            return null;
        }
        if (c == 'e' || c == 'E') {
            ttype = 12;
            c = this.read();
            if (c == '-' || c == '+') {
                c = this.read();
            }
            while (FuegoLexer.isDigit(c)) {
                c = this.read();
            }
        }
        if ((t = this.lexerConfigurator.numberSuffixType(c)) == -1) {
            this.unread();
        } else {
            ttype = t;
        }
        return this.makeToken(ttype, this.text, this.startOffset, this.offset - this.startOffset);
    }

    private FuegoToken parseParameter(char c) throws TokenStreamException {
        if (c != '$') {
            return null;
        }
        while (FuegoLexer.isIdentifierPart(this.read())) {
        }
        this.unread();
        int textLength = this.offset - this.startOffset - 1;
        return this.makeToken(18, this.text, this.startOffset + 1, textLength);
    }

    private FuegoToken parseRegularExpressionString(char c) throws TokenStreamException {
        if (!this.isRegExpStart(c)) {
            return null;
        }
        StringBuffer text = new StringBuffer();
        text.append('/');
        c = this.read();
        int prev = 0;
        String end = "";
        while (prev == 92 || (end = this.testRegExpEnd(c)) == null) {
            if (this.offset == this.completionIndex) {
                this.completionIndex = -1;
                break;
            }
            if (c == '\n' || c == '\u0000') {
                int lineForOffset = SourceCode.getLineForOffset(this.text, 0, this.text.length, this.offset - 2);
                int column = SourceCode.getColumnForOffset(this.text, 0, this.text.length, this.offset - 2);
                throw new TokenStreamRecognitionException((RecognitionException)new LexerException("End of line without end of Regular Expression", "", lineForOffset, column, this.makeToken(16, text)));
            }
            text.append(c);
            if (prev == 92) {
                c = '\u0000';
            }
            prev = c;
            c = this.read();
        }
        text.append('/');
        text.append(end);
        return this.makeToken(16, text);
    }

    private FuegoToken parseTimeLiteral(char c) throws TokenStreamException {
        int length;
        if (!this.isTimeLiteralDelimiter(c)) {
            return null;
        }
        c = this.read();
        boolean timeConst = true;
        StringBuffer buffer = null;
        int start = this.startOffset + 1;
        block5: while (!this.isTimeLiteralDelimiter(c) && this.offset != this.completionIndex) {
            switch (c) {
                case '\u0000': 
                case '\n': {
                    int lineForOffset = SourceCode.getLineForOffset(this.text, 0, this.text.length, this.offset - 2);
                    int column = SourceCode.getColumnForOffset(this.text, 0, this.text.length, this.offset - 2);
                    throw new TokenStreamRecognitionException(new RecognitionException("End of line without end of Literal", "", lineForOffset, column));
                }
                case '\\': {
                    if (buffer == null) {
                        buffer = new StringBuffer();
                        buffer.append(this.text, start, this.endOffset - start);
                    }
                    c = this.parseEscapeSequence(this.read());
                    continue block5;
                }
                case 'D': 
                case 'H': 
                case 'M': 
                case 'S': 
                case 'Y': 
                case 'd': 
                case 'h': 
                case 'm': 
                case 's': 
                case 'x': {
                    timeConst = false;
                }
            }
            if (buffer != null) {
                buffer.append(c);
            }
            c = this.read();
        }
        if (this.offset == this.completionIndex) {
            this.completionIndex = -1;
        }
        boolean isNow = (length = this.offset - start - 1) == 3 && this.text[start] == 'n' && this.text[start + 1] == 'o' && this.text[start + 2] == 'w';
        int tokenType = timeConst || isNow ? 14 : 15;
        return buffer != null ? this.makeToken(tokenType, buffer) : this.makeToken(tokenType, this.text, start, length);
    }

    private FuegoToken readNextToken() throws TokenStreamException {
        char c = this.read();
        boolean isNewLineToken = this.newLineToken;
        while (this.isWhiteSpace(c) || c == this.escapeForNewLine || c == '\n' && !isNewLineToken) {
            if (this.offset == this.completionIndex) {
                this.completionIndex = -1;
                return this.makeToken(17, this.text, this.offset, 0, this.offset, 0);
            }
            if (c == this.escapeForNewLine) {
                char next = this.read();
                this.unread();
                if (FuegoLexer.isIdentifierPart(next)) break;
                isNewLineToken = false;
            }
            c = this.read();
        }
        this.startLineNumber = this.lineNumber;
        this.startColNumber = this.columnNumber;
        this.startOffset = this.offset;
        if (c == '\u0000') {
            if (this.completionIndex != -1 && this.offset >= this.completionIndex) {
                int completionOffset = this.completionIndex;
                this.completionIndex = -1;
                return this.makeToken(17, this.text, completionOffset, 0, completionOffset, 0);
            }
            int offset = this.startOffset <= this.endOffset ? this.startOffset : this.endOffset;
            return this.makeToken(1, this.text, offset, 0, offset, 0);
        }
        --this.startOffset;
        --this.startColNumber;
        if (this.startColNumber == 0) {
            this.startColNumber = this.prevColumnNumber;
            --this.startLineNumber;
        }
        if (c == '\n' && isNewLineToken) {
            return this.makeToken(5, this.text, this.startOffset, 1);
        }
        FuegoToken result = this.parseNumber(c);
        if (result != null) {
            return result;
        }
        if (this.isLineCommentStart(c)) {
            int textStart = this.offset;
            c = this.read();
            while (c != '\n' && c != '\u0000') {
                c = this.read();
            }
            if (c != '\n') {
                this.unread();
            }
            if (this.offset >= this.completionIndex) {
                this.completionIndex = -1;
            }
            if (this.createIndentTokens) {
                return this.makeToken(8, this.text, textStart, this.offset - textStart - (c == '\n' ? 1 : 0));
            }
            return (FuegoToken)this.nextToken();
        }
        if (this.isCommentStart(c)) {
            int textStart = this.offset;
            int textEnd = this.offset;
            c = this.read();
            while (!this.isCommentEnd(c) && c != '\u0000') {
                textEnd = this.offset;
                c = this.read();
            }
            if (this.offset >= this.completionIndex) {
                this.completionIndex = -1;
            }
            if (c == '\u0000') {
                this.unread();
            }
            int textLength = textEnd - textStart;
            FuegoToken token = this.makeToken(9, this.text, textStart, textLength);
            if (c == '\u0000') {
                int lineForOffset = SourceCode.getLineForOffset(this.text, 0, this.text.length, this.offset - 2);
                int column = SourceCode.getColumnForOffset(this.text, 0, this.text.length, this.offset - 2);
                throw new TokenStreamRecognitionException((RecognitionException)new LexerException("End of code without end of multiline comment", "", lineForOffset, column, token));
            }
            if (this.createIndentTokens) {
                return token;
            }
            return (FuegoToken)this.nextToken();
        }
        result = this.parseIdentifier(c);
        if (result != null) {
            return result;
        }
        result = this.parseLiteralString(c);
        if (result != null) {
            return result;
        }
        result = this.parseRegularExpressionString(c);
        if (result != null) {
            return result;
        }
        result = this.parseTimeLiteral(c);
        if (result != null) {
            return result;
        }
        result = this.parseParameter(c);
        if (result != null) {
            return result;
        }
        int ttype = this.lexerConfigurator.getMultiCharTokens(this.state).find(c, (FuegoLexerInputStream)this);
        if (ttype != -1) {
            return this.makeToken(ttype, this.text, this.startOffset, this.offset - this.startOffset);
        }
        int line = SourceCode.getLineForOffset(this.text, 0, this.text.length, this.startOffset);
        int column = SourceCode.getColumnForOffset(this.text, 0, this.text.length, this.startOffset);
        throw new TokenStreamRecognitionException((RecognitionException)new NoViableAltForCharException(c, "", line, column));
    }

    private boolean wasNewLine() {
        return this.offset >= 0 && this.offset < this.text.length && this.text[this.offset] == '\n';
    }

    public static class LexerException
    extends RecognitionException {
        public final FuegoToken supposedToken;
        static final long serialVersionUID = -8351851734382615581L;
        static final long serialCheck = -271236001817319474L;

        public LexerException(String s, String s2, int line, int column, FuegoToken supposedToken) {
            super(s, s2, line, column);
            this.supposedToken = supposedToken;
        }
    }
}

