/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.compiler.BasicMonitor;
import oracle.bpm.compiler.DebuggerPrincipal;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.Watch;
import oracle.bpm.component.ExecutionRelayedThrowable;
import oracle.bpm.component.ExecutionThread;
import oracle.bpm.component.ExecutorClient;
import oracle.bpm.component.Wanderer;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.JavaObject;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TraceableInvokeable;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.CILUtils;

public class FuegoInvokeable
extends TraceableInvokeable
implements Cloneable,
Serializable,
Comparable,
DynamicObject.Dynamizable,
Wanderer {
    private Object[] constructorArgs;
    private String constructorSignature;
    private Map defaultValues;
    private int id;
    private Map<String, Object> instanceVariables;
    private transient Map<String, Node> methods;
    private transient Map<String, String> methods2attrs;
    private transient RunningMonitor monitor;
    private transient ObjectClass objectClass;
    private FuegoInvokeable parent;
    private Invokeable superclass;
    static final long serialVersionUID = 3984005450863162761L;
    private static final String EQUALS_METHOD = "Mequals(Ljava.lang.Object;)Z";
    private static final String HASHCODE_METHOD = "MhashCode()I";
    private static final String TO_STRING_METHOD = "MtoString()Ljava.lang.String;";
    private static final String COMPARE_TO_METHOD = "McompareTo(Ljava.lang.Object;)I";
    private static Map<Integer, Object> serializedObjects = new HashMap<Integer, Object>();
    private static int nextSerialId;
    static final long serialCheck = -2193360835322749679L;

    FuegoInvokeable(ObjectClass objectClass, Invokeable superclass, FuegoInvokeable parent) {
        this(objectClass, superclass, parent, null);
    }

    FuegoInvokeable(ObjectClass objectClass, Invokeable superclass, FuegoInvokeable parent, Object[] args) {
        this.objectClass = objectClass;
        this.methods = new HashMap<String, Node>();
        this.methods2attrs = new HashMap<String, String>();
        this.defaultValues = new HashMap();
        this.instanceVariables = new HashMap<String, Object>();
        this.superclass = superclass;
        this.parent = parent;
        this.constructorArgs = args;
        TypeDescription type = objectClass.getTypeDescription();
        int length = type.getMemberCount();
        for (int i = 0; i < length; ++i) {
            MethodTypeDescription memberType = type.getMemberType(i);
            long mods = memberType.getModifiers();
            if (!memberType.isAttribute() || Modifier.isInherited(mods)) continue;
            String getter = MemberAccess.getSignature(type, memberType);
            String setter = MemberAccess.getWriteSignature(type, memberType);
            String name = memberType.getName();
            if (getter != null && getter.charAt(0) == 'M') {
                this.methods2attrs.put(getter, name);
            }
            if (setter == null || setter.charAt(0) != 'M') continue;
            this.methods2attrs.put(setter, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSerializedObject(int id) {
        Map<Integer, Object> map = serializedObjects;
        synchronized (map) {
            return serializedObjects.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addSerializedObject(Object instance) {
        int id;
        Map<Integer, Object> map = serializedObjects;
        synchronized (map) {
            id = nextSerialId++;
            serializedObjects.put(id, instance);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSerializedObjects() {
        Map<Integer, Object> map = serializedObjects;
        synchronized (map) {
            serializedObjects.clear();
        }
    }

    @Override
    public Object setAttributeValue(String signature, Object value) {
        try {
            if (signature.charAt(0) == 'M') {
                this.invoke(signature, value);
                return value;
            }
            this.checkConstructor(signature);
        }
        catch (ComponentExecutionException e) {
            throw new RuntimeExceptionShell(e);
        }
        String name = this.getAttrNameForSignature(signature);
        if (this.instanceVariables.containsKey(name)) {
            this.instanceVariables.put(name, value);
        } else if (this.superclass != null) {
            this.superclass.setAttributeValue(signature, value);
        } else {
            throw new RuntimeException("No such attribute : '" + signature + "'");
        }
        return value;
    }

    @Override
    public void setAttributeValue(String signature, int index, Object value) {
        try {
            if (signature.charAt(0) == 'M') {
                this.invoke(signature, value);
                return;
            }
        }
        catch (ComponentExecutionException e) {
            throw new RuntimeExceptionShell(e);
        }
        if (index == -1) {
            this.setAttributeValue(signature, value);
            return;
        }
        Object obj = this.getAttributeValue(signature);
        if (obj == null) {
            return;
        }
        if (obj instanceof List) {
            List list = (List)Cast.force(obj);
            if (index == list.size()) {
                list.add(value);
            } else {
                list.set(index, value);
            }
        } else if (obj.getClass().isArray()) {
            ArrayUtils.setElement(obj.getClass().getComponentType(), obj, index, value);
        }
    }

    @Override
    public Object getAttributeValue(String signature, String setter, int index) {
        Object result;
        try {
            if (signature.charAt(0) == 'M') {
                return this.invoke(signature, new Object[0]);
            }
            this.checkConstructor(signature);
        }
        catch (ComponentExecutionException e) {
            throw new RuntimeExceptionShell(e);
        }
        String name = this.getAttrNameForSignature(signature);
        if (name != null && (name.endsWith("_ELEMENT_") || name.endsWith("$element"))) {
            return this.defaultValues.get(name);
        }
        if (this.instanceVariables.containsKey(name)) {
            result = this.instanceVariables.get(name);
            if (result != null && index != -1) {
                if (result instanceof List) {
                    List list = (List)result;
                    result = list.get(index);
                } else if (result.getClass().isArray()) {
                    result = Array.get(result, index);
                }
            }
        } else if (this.superclass != null) {
            result = this.superclass.getAttributeValue(signature, setter);
        } else {
            throw new RuntimeException("No such attribute : '" + signature + "' attributes: " + this.instanceVariables + ", super:" + this.superclass);
        }
        return result;
    }

    public void setField(String name, Object value) {
        this.instanceVariables.put(name, value);
    }

    public Object getField(String name) {
        return this.instanceVariables.get(name);
    }

    @Override
    public String getName() {
        return this.objectClass.getTypeDescription().getText();
    }

    public TypeDescription getObjectType() {
        return this.objectClass.getTypeDescription();
    }

    public FuegoInvokeable getParent() {
        return this.parent;
    }

    public void setRunningMonitor(RunningMonitor rm) {
        this.monitor = rm;
    }

    public RunningMonitor getRunningMonitor() {
        return this.monitor;
    }

    public Invokeable getSuperInvokeable() {
        return this.superclass;
    }

    @Override
    public Object getTarget() {
        return this.createDynamicObject(new IdentityHashMap<Invokeable, DynamicObject>());
    }

    @Override
    public Object getType() {
        return this.getObjectType();
    }

    public void addWatch(Watch watch) {
        if (this.monitor != null) {
            this.monitor.addWatch(watch);
        }
    }

    public Object[] getConstructorArguments() {
        return this.constructorArgs;
    }

    public Object clone() {
        return Any.deepCopy(this);
    }

    public int compareTo(Object object) {
        if (this.methods.containsKey(COMPARE_TO_METHOD)) {
            Integer result = (Integer)this.internalInvoke(COMPARE_TO_METHOD, new Object[]{object});
            return result != null ? result : -1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (this.methods.containsKey(EQUALS_METHOD)) {
            Boolean result = (Boolean)this.internalInvoke(EQUALS_METHOD, new Object[]{obj});
            return result != null && result != false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.methods.containsKey(HASHCODE_METHOD)) {
            Integer result = (Integer)this.internalInvoke(HASHCODE_METHOD, null);
            return result != null ? result : 0;
        }
        return super.hashCode();
    }

    @Override
    public boolean isInstanceOf(String componentType, String signature) {
        ObjectTypeDescription currentType = this.objectClass.getObjectType();
        return this.isInstanceOf(currentType, componentType, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(String methodSignature, Object ... args) throws ComponentExecutionException {
        this.checkConstructor(methodSignature);
        Node method = this.methods.get(methodSignature);
        if (method == null) {
            method = this.objectClass.getMemberBySignature(methodSignature);
        }
        if (method == null) {
            if (methodSignature.equals("Mclone()Ljava.lang.Object;")) {
                return this.clone();
            }
            if (methodSignature.equals(EQUALS_METHOD)) {
                return this.equals(args[0]);
            }
            if (this.superclass == null) throw new ComponentExecutionException(new NoSuchMethodException("No such method: '" + methodSignature + "' in class '" + this.getName() + "'"));
            try {
                return this.superclass.invoke(methodSignature, args);
            }
            catch (InvocationTargetException e) {
                String name = JavaClass.getMethodNameFromSignature(methodSignature);
                throw new ComponentExecutionException(e, "", name);
            }
            catch (ComponentExecutionException e) {
                if (CILUtils.isInstanceOf((Object)e, NoSuchMethodException.class)) throw new ComponentExecutionException(new NoSuchMethodException("No such method: '" + methodSignature + "' in class '" + this.getName() + "'"));
                throw e;
            }
        }
        if (this.monitor == null) {
            this.monitor = new BasicMonitor();
        }
        if (this.isExecutionThread() || !(method instanceof Method) || !((Method)method).isRunsOnServer()) return method.run(this.monitor, args, this);
        RunningMonitor oldMonitor = this.monitor;
        try {
            this.monitor = new BasicMonitor();
            ExecutorClient client = new ExecutorClient(new DebuggerPrincipal(this, this.objectClass.getCompiler().getCommit()));
            Object object = client.invoke(methodSignature, args);
            this.monitor = oldMonitor;
            return object;
        }
        catch (Throwable throwable) {
            try {
                try {
                    this.monitor = oldMonitor;
                    throw throwable;
                }
                catch (Exception e) {
                    if (!(e.getCause() instanceof ExecutionRelayedThrowable)) throw new ComponentExecutionException(e);
                    throw new ComponentExecutionException(e.getCause());
                }
            }
            catch (ComponentExecutionException e) {
                if (!(e.getCause() instanceof NoSuchMethodException) || !Log.isDebugging()) throw e;
                Log.logDebug(e.getCause());
                throw e;
            }
        }
    }

    public void removeAllWatches() {
        for (Node node : this.methods.values()) {
            node.getScope().removeWatches();
        }
    }

    public void removeWatch(Watch watch) {
        for (Node node : this.methods.values()) {
            node.getScope().removeWatch(watch);
        }
    }

    public String toString() {
        if (this.methods.containsKey(TO_STRING_METHOD)) {
            return (String)this.internalInvoke(TO_STRING_METHOD, null);
        }
        return this.objectClass.getName();
    }

    void setAttribute(String name, Object value) {
        this.instanceVariables.put(name, value);
    }

    void setDefaultValues(Map defaultValues) {
        this.defaultValues = defaultValues;
    }

    void addMethod(String signature, Node method) {
        if (signature.charAt(0) == 'K' && this.constructorSignature == null) {
            this.constructorSignature = signature;
        }
        this.methods.put(signature, method);
    }

    DynamicObject writeDynamicObject(Map<Invokeable, DynamicObject> references) {
        return this.createDynamicObject(references);
    }

    private boolean isExecutionThread() {
        return Thread.currentThread() instanceof ExecutionThread;
    }

    private String getAttrNameForSignature(String signature) {
        String name;
        if (signature.charAt(0) == 'A') {
            name = JavaClass.getFieldNameFromSignature(signature);
        } else {
            assert (signature.charAt(0) == 'M') : "invalid signature: " + signature;
            name = this.methods2attrs.get(signature);
        }
        return name;
    }

    private boolean isInstanceOf(ObjectTypeDescription type, String componentType, String signature) {
        boolean isInstanceOf;
        boolean bl = isInstanceOf = Any.equals(type.getComponentType(), componentType) && Any.equals(type.getSignature(), signature);
        if (!isInstanceOf) {
            for (SuperType stype : type.getSuperTypes()) {
                if (!stype.isDelegated()) {
                    isInstanceOf = this.isInstanceOf(stype.getObjectType(), componentType, signature);
                }
                if (!isInstanceOf) continue;
                break;
            }
        }
        return isInstanceOf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConstructor(String signature) throws ComponentExecutionException {
        Method.Adaptor methodNode;
        MethodTypeDescription methodType;
        Node method = this.methods.get(signature);
        if (method == null) {
            method = this.objectClass.getMemberBySignature(signature);
        }
        if (method != null && method instanceof Method.Adaptor && (methodType = (methodNode = (Method.Adaptor)method).getMethodType()).isStatic() && !methodType.isConstructor()) {
            return;
        }
        if (this.constructorSignature != null) {
            String constructor = this.constructorSignature;
            this.constructorSignature = null;
            if (signature == null || !signature.equals(constructor)) {
                this.invoke(constructor, this.constructorArgs);
            }
        }
    }

    private DynamicObject createDynamicObject(Map<Invokeable, DynamicObject> references) {
        try {
            this.checkConstructor(null);
        }
        catch (ComponentExecutionException e) {
            throw new RuntimeExceptionShell(e);
        }
        DynamicObject target = DynamicObject.create();
        references.put(this, target);
        for (Map.Entry<String, Object> entry : this.instanceVariables.entrySet()) {
            String name = entry.getKey().toString();
            if (name.startsWith("__")) continue;
            Object value = entry.getValue();
            Map map = (Map)Cast.force(references);
            target.setField(name, DynamicObject.valueOf(value, false, map));
        }
        return target;
    }

    private Object internalInvoke(String signature, Object[] args) {
        try {
            return this.invoke(signature, args);
        }
        catch (ComponentExecutionException e) {
            throw (RuntimeException)new RuntimeException(e.getMessage()).initCause(e);
        }
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        stream.defaultReadObject();
        FuegoInvokeable source = (FuegoInvokeable)FuegoInvokeable.getSerializedObject(this.id);
        if (source == null) {
            throw new IOException("Could not deserialize invokeable");
        }
        this.methods = source.methods;
        this.methods2attrs = source.methods2attrs;
        this.objectClass = source.objectClass;
        this.monitor = source.monitor;
        if (this.superclass == null) {
            this.superclass = source.superclass;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws Exception {
        JavaObject javaObject;
        JavaClass cl;
        this.id = FuegoInvokeable.addSerializedObject(this);
        Invokeable superclass = this.superclass;
        if (this.superclass instanceof JavaObject && !(cl = (javaObject = (JavaObject)superclass).getJavaClass()).isSerializable()) {
            this.superclass = null;
        }
        stream.defaultWriteObject();
        this.superclass = superclass;
    }
}

