/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.RecognitionException;
import fuego.parser.TokenStreamException;
import fuego.parser.collections.AST;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.cil.CilCompiler;
import oracle.bpm.cil.CilException;
import oracle.bpm.cil.MessageListener;
import oracle.bpm.cil.UsageListener;
import oracle.bpm.compiler.BaseObjectClass;
import oracle.bpm.compiler.BasicMonitor;
import oracle.bpm.compiler.CodeStyle;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompilerParserException;
import oracle.bpm.compiler.CompletionException;
import oracle.bpm.compiler.CompletionResult;
import oracle.bpm.compiler.FuegoInvokeable;
import oracle.bpm.compiler.FuegoLexer;
import oracle.bpm.compiler.FuegoParser;
import oracle.bpm.compiler.InternalException;
import oracle.bpm.compiler.IntrospectedClass;
import oracle.bpm.compiler.InvalidAssignmentException;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.JVMByteCodeGenerator;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.SymbolTable;
import oracle.bpm.compiler.TypeNormalizer;
import oracle.bpm.io.IndentedWriter;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.InternalReportingService;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import org.jetbrains.annotations.Nullable;

public class FuegoCompiler
implements CilCompiler {
    private boolean commit;
    private int completionIndex = -1;
    private Map<String, String> configurations;
    private int directives = 256;
    private final List<BaseObjectClass> introspectedClasses = CollectionPool.getArrayList();
    private MessageListener msgListener;
    private final List<BaseObjectClass> objectClasses = CollectionPool.getArrayList();
    private Map<String, FuegoParser> parsers;
    private SymbolTable symbolTable = new SymbolTable();
    @Nullable
    private TypeNormalizer typeNormalizer;

    public FuegoCompiler() {
        this(null);
    }

    public FuegoCompiler(@Nullable Map<String, String> configurations) {
        this.parsers = new HashMap<String, FuegoParser>();
        this.configurations = configurations;
        this.loadFunctionCatalog();
    }

    public static FuegoInvokeable createInvokeable(XObjectTypeDescription xotd, MessageListener msgListener) throws CilException {
        FuegoCompiler compiler = new FuegoCompiler();
        compiler.setDirective(4);
        compiler.setMessageListener(msgListener);
        compiler.addObjectClass(xotd);
        compiler.compile();
        return compiler.createInvokeable(xotd, new Object[0]);
    }

    public void setTypeResolver(@Nullable TypeNormalizer typeNormalizer) {
        this.typeNormalizer = typeNormalizer;
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }

    public boolean getCommit() {
        return this.commit;
    }

    @Override
    public void setConfigurations(Map<String, String> configurations) {
        this.configurations = configurations;
    }

    public TypeDescription getDeclarationFor(TypeDescription member, int offset) {
        TypeDescription result = null;
        Node node = this.selectCodeAt(member, offset, -1);
        if (node != null) {
            result = node.getDeclaration();
        }
        return result;
    }

    @Override
    public void setDirective(int directive) {
        this.directives |= directive;
    }

    @Override
    public boolean getDirective(int directive) {
        return (this.directives & directive) != 0;
    }

    @Override
    public void setMessageListener(MessageListener listener) {
        this.msgListener = listener;
    }

    @Override
    public void addObjectClass(TypeRef instanceType) {
        this.addType(instanceType);
    }

    public void addObjectClass(ObjectTypeDescription obj, String source) {
        this.addType(obj).setSourceName(source);
    }

    @Override
    public void clearDirective(int directive) {
        this.directives &= ~directive;
    }

    @Override
    public void compile() throws CilException {
        ArrayList<BaseObjectClass> array = new ArrayList<BaseObjectClass>(this.objectClasses);
        array.addAll(this.introspectedClasses);
        int length = array.size();
        CilException firstError = null;
        for (int i = 0; i < length; ++i) {
            BaseObjectClass cl;
            block6: {
                cl = (BaseObjectClass)array.get(i);
                try {
                    cl.compile(this);
                }
                catch (CompilerException first) {
                    if (firstError == null) {
                        firstError = first;
                    }
                }
                catch (Throwable unexpected) {
                    InternalException e = new InternalException((Node)cl, unexpected);
                    this.reportError(e);
                    if (firstError != null) break block6;
                    firstError = e;
                }
            }
            CilException err = this.reportMessages(cl);
            cl.resetMessages();
            if (firstError != null) continue;
            firstError = err;
        }
        if (firstError != null) {
            throw firstError;
        }
    }

    @Override
    public void compile(TypeDescription type) throws CilException {
        Node member = this.findOrCreate(type);
        if (member == null) {
            throw new IllegalArgumentException("Invalid member: " + type);
        }
        CilException firstFatal = null;
        BaseObjectClass cl = null;
        try {
            cl = member.getTopLevelClass();
            member.compile(this);
        }
        catch (CompilerException first) {
            firstFatal = first;
        }
        catch (Throwable unexpected) {
            InternalException e = new InternalException(member, unexpected);
            this.reportError(e);
            firstFatal = e;
        }
        CilException err = this.reportMessages(cl);
        if (cl != null) {
            cl.resetMessages();
        }
        if (firstFatal == null) {
            firstFatal = err;
        }
        if (firstFatal != null) {
            throw firstFatal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionResult complete(MethodTypeDescription memberPath, int offset) throws CompilerException {
        if (offset < 0) {
            throw new IllegalArgumentException("Illegal offset: " + offset);
        }
        Node member = this.findOrCreate(memberPath);
        if (member == null) {
            throw new IllegalArgumentException("Invalid member: " + memberPath);
        }
        BaseObjectClass cl = null;
        try {
            this.completionIndex = offset;
            cl = member.getTopLevelClass();
            cl.resetMessages();
            member.compile(this);
        }
        catch (CompilerException first) {
            first.printStackTrace();
        }
        catch (Throwable unexpected) {
            InternalException e = new InternalException(member, unexpected);
            this.reportError(e);
        }
        finally {
            this.completionIndex = -1;
        }
        CompletionResult result = null;
        if (cl != null) {
            for (CilException error : cl.getErrors()) {
                if (!(error instanceof CompletionException)) continue;
                CompletionException completionException = (CompletionException)error;
                result = completionException.getResult();
                break;
            }
        }
        if (result == null) {
            result = new CompletionResult("");
        }
        return result;
    }

    public FuegoInvokeable createInvokeable(ObjectTypeDescription cl, Object[] args) {
        FuegoInvokeable invokeable = null;
        ObjectClass objectClass = this.getClassForType(cl);
        if (objectClass != null) {
            Object[] arguments = args;
            if (!objectClass.isTopLevel() && args != null && args.length == 0) {
                arguments = new Object[]{this.createInvokeable(cl.getParent().asObject(), new Object[0])};
            }
            invokeable = objectClass.createInvokeable(arguments);
            this.reportErrors(objectClass.getErrors());
        }
        return invokeable;
    }

    public Node createWatch(SourceCode code, Node where) {
        Node expr;
        try {
            expr = this.parse(code);
            Scope scope = new Scope(this);
            scope.setSuperScope(where.getScope());
            expr.setScope(scope);
            expr.setParent(where);
            expr = expr.checkType();
        }
        catch (CompilerException ignore) {
            expr = null;
        }
        return expr;
    }

    public Object evaluate(SourceCode code, TypeDescription expectedType) throws CompilerException {
        Node expr = this.parse(code);
        expr.compile(this);
        if (!expectedType.isAssignableFrom(expr.getTypeDescription())) {
            throw new InvalidAssignmentException(expr, expr.getTypeDescription(), expectedType);
        }
        return expr.value(new BasicMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateCode(File targetDir) throws CilException {
        try {
            Class<JVMByteCodeGenerator> clazz = JVMByteCodeGenerator.class;
            synchronized (JVMByteCodeGenerator.class) {
                try {
                    this.generateCode(targetDir, null);
                }
                finally {
                    JVMByteCodeGenerator.clearCache();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (InternalException e) {
            FuegoCompiler.crashReport(e);
            throw e;
        }
        {
            return;
        }
    }

    public void generateCode(File targetDir, TypeDescription objectClass) throws CilException {
        targetDir.mkdirs();
        CilException firstError = null;
        if (objectClass != null) {
            ObjectClass cl = (ObjectClass)this.findMember(objectClass);
            if (cl == null) {
                throw new IllegalArgumentException("Object class was not found: " + objectClass);
            }
            firstError = this.generateCode(cl, targetDir, firstError);
        } else {
            BaseObjectClass cl;
            int i;
            int length = this.objectClasses.size();
            for (i = 0; i < length; ++i) {
                cl = (ObjectClass)this.objectClasses.get(i);
                firstError = this.generateCode(cl, targetDir, firstError);
            }
            length = this.introspectedClasses.size();
            for (i = 0; i < length; ++i) {
                cl = (IntrospectedClass)this.introspectedClasses.get(i);
                firstError = this.generateCode(cl, targetDir, firstError);
            }
        }
        if (firstError != null) {
            throw firstError;
        }
    }

    public void generateSource(SourceGenerator sg) {
        int length = this.objectClasses.size();
        for (int i = 0; i < length; ++i) {
            ObjectClass cl = (ObjectClass)this.objectClasses.get(i);
            try {
                cl.generate(sg);
            }
            catch (Throwable unexpected) {
                this.reportError(new InternalException((Node)cl, unexpected));
            }
            this.reportErrors(cl.getErrors());
        }
    }

    public void generateSource(SourceGenerator sg, TypeDescription type) throws CompilerException {
        Node member = this.findMember(type);
        try {
            member.generate(sg);
        }
        catch (IllegalStateException e) {
            throw new InternalException(member, (Throwable)e);
        }
        sg.close();
    }

    public Node parse(SourceCode code) throws CompilerParserException, InvalidLanguageException {
        return this.parse(code, this.msgListener);
    }

    public Node parse(SourceCode code, MessageListener listener) throws CompilerParserException, InvalidLanguageException {
        try {
            FuegoParser parser = this.initParser(code);
            parser.setMessageListener(listener);
            parser.parseExpression();
            return (Node)parser.getAST();
        }
        catch (TokenStreamException e) {
            throw new CompilerParserException(e, code, true);
        }
        catch (RecognitionException e) {
            throw new CompilerParserException(e, code, true);
        }
    }

    @Deprecated
    public Node parseFuegoCode(String code, MessageListener listener) throws CompilerParserException, InvalidLanguageException {
        SourceCode sourceCode = SourceCode.create(code, "Fuego");
        try {
            FuegoParser parser = this.initParser(sourceCode);
            parser.setMessageListener(listener);
            parser.methodBody();
            return (Node)parser.getAST();
        }
        catch (TokenStreamException e) {
            throw new CompilerParserException(e, sourceCode, false);
        }
        catch (RecognitionException e) {
            throw new CompilerParserException(e, sourceCode, false);
        }
    }

    public Node parseMethod(SourceCode code, boolean fullParsing, MessageListener listener) throws CompilerParserException, InvalidLanguageException {
        try {
            FuegoParser parser = this.initParser(code);
            parser.setMessageListener(listener);
            if (fullParsing) {
                parser.method();
            } else {
                parser.methodBody();
            }
            return (Node)parser.getAST();
        }
        catch (TokenStreamException e) {
            CompilerParserException ce = new CompilerParserException(e, code, false);
            listener.reportError(ce);
            throw ce;
        }
        catch (RecognitionException e) {
            CompilerParserException ce = new CompilerParserException(e, code, false);
            listener.reportError(ce);
            throw ce;
        }
    }

    public void refactor(CodeStyle style) {
        int length = this.objectClasses.size();
        for (int i = 0; i < length; ++i) {
            ObjectClass cl = (ObjectClass)this.objectClasses.get(i);
            try {
                cl.refactor(style);
            }
            catch (Throwable unexpected) {
                this.reportError(new InternalException((Node)cl, unexpected));
            }
            this.reportErrors(cl.getErrors());
        }
    }

    public void refactor(CodeStyle style, TypeDescription type) {
        Node member = this.findMember(type);
        if (member != null) {
            member.refactor(style);
            List<CilException> errors = member.getCurrentClass().getErrors();
            if (errors != null) {
                this.reportErrors(errors);
            }
        }
    }

    public CilException reportError(RecognitionException error, SourceCode code) {
        CompilerParserException ce = new CompilerParserException(error, code, false);
        this.reportError(ce);
        return ce;
    }

    @Override
    public void reset() {
        this.objectClasses.clear();
        this.introspectedClasses.clear();
    }

    public void rewrite(MethodTypeDescription type) throws CompilerException {
        Method member = (Method)this.findMember(type);
        ObjectClass currentClass = member.getCurrentClass();
        if (!currentClass.getErrors().isEmpty() || !member.getErrors().isEmpty()) {
            throw new CompilerException(member);
        }
        member.rewrite();
    }

    public BaseObjectClass findObjectClass(TypeDescription type) {
        assert (type.isObject() || type.isEnum()) : "Type is not an object nor enum: " + type + " (kind: " + type.getKind() + ')';
        BaseObjectClass result = null;
        for (BaseObjectClass cl : this.objectClasses) {
            if (cl.getTypeDescription() != type) continue;
            result = cl;
            break;
        }
        if (result == null) {
            for (BaseObjectClass cl : this.introspectedClasses) {
                if (cl.getTypeDescription() != type) continue;
                result = cl;
                break;
            }
        }
        return result;
    }

    public Method findMethod(TypeDescription otd, String methodName) {
        BaseObjectClass aClass = this.findObjectClass(otd);
        List<Method> methods = ((ObjectClass)aClass).getMethods();
        Method expMethod = null;
        for (Method method : methods) {
            if (!methodName.equals(method.getName())) continue;
            expMethod = method;
            break;
        }
        return expMethod;
    }

    public Node findMember(TypeDescription member) {
        Node result;
        if (member.isObject() || member.isIntrospectedObject() || member.isModule()) {
            TypeDescription parent;
            result = this.findObjectClass(member);
            if (result == null && (parent = member.getParent()) != null) {
                BaseObjectClass cl = this.findObjectClass(parent);
                result = FuegoCompiler.findChild(cl, member);
            }
        } else {
            assert (member.isMember() || member.isTransformation());
            ObjectClass cl = (ObjectClass)this.findMember(member.getParent());
            result = cl != null ? FuegoCompiler.findChild(cl, member) : null;
        }
        return result;
    }

    public List<BaseObjectClass> getObjectClasses() {
        return this.objectClasses;
    }

    TypeRef canonicalType(@Nullable TypeRef type) {
        TypeNormalizer normalizer = this.typeNormalizer;
        return normalizer == null ? type : normalizer.canonical(type);
    }

    ObjectClass getClassForType(TypeDescription cl) {
        BaseObjectClass oc;
        ObjectClass result = null;
        Iterator<BaseObjectClass> i$ = this.objectClasses.iterator();
        while (i$.hasNext() && (result = FuegoCompiler.getClassForType((ObjectClass)(oc = i$.next()), cl)) == null) {
        }
        return result;
    }

    String getRealConfiguration(@Nullable String abstractName) {
        return abstractName == null ? null : (this.configurations == null ? abstractName : this.configurations.get(abstractName));
    }

    SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    UsageListener getUsageListener() {
        return this.msgListener instanceof UsageListener ? (UsageListener)this.msgListener : null;
    }

    BaseObjectClass addType(TypeRef ref) {
        ObjectClass cl;
        Node prev;
        String componentType = ref.getComponentType();
        if (!componentType.equals(ComponentType.XOBJECT.getText()) && !componentType.equals(ComponentType.OBJECT.getText())) {
            IntrospectedClass cl2 = new IntrospectedClass(ref, this);
            this.introspectedClasses.add(cl2);
            return cl2;
        }
        ObjectTypeDescription otd = ref.get().asObject();
        if (otd.getCatalog() == null) {
            throw new IllegalArgumentException("Invalid object class. It should belong to a type repository.");
        }
        if (otd.isInnerType()) {
            this.addType(otd.getParent().asObject());
            return this.getClassForType(otd);
        }
        int length = this.objectClasses.size();
        int removeIndex = -1;
        for (int i = 0; i < length; ++i) {
            ObjectClass cl3 = (ObjectClass)this.objectClasses.get(i);
            if (cl3.getTypeDescription() != otd) continue;
            removeIndex = i;
            break;
        }
        if (removeIndex != -1 && (prev = (cl = (ObjectClass)this.objectClasses.remove(removeIndex)).getPrev()) != null) {
            prev.setNext(cl.getNext());
        }
        length = this.objectClasses.size();
        cl = new ObjectClass(otd, this, null);
        if (length > 0) {
            ObjectClass last = (ObjectClass)this.objectClasses.get(length - 1);
            last.setNext(cl);
        }
        this.objectClasses.add(cl);
        return cl;
    }

    Node selectCodeAt(TypeDescription member, int offset, int length) {
        Node node = this.findMember(member);
        if (node != null) {
            node = node.findNodeAtPosition(offset);
        }
        return node;
    }

    @Nullable
    private static TypeDescription findGlobalFunctions() {
        TypeRef ref;
        MutableComponentCatalog repository = TypeUtils.getDefaultCatalog();
        if (repository == null) {
            return null;
        }
        try {
            ref = repository.find("Fuego.Util.Functions");
        }
        catch (AmbiguousTypeNameException e) {
            e.printStackTrace();
            return null;
        }
        return ref != null ? ref.get() : null;
    }

    private static ObjectClass getClassForType(ObjectClass parent, TypeDescription cl) {
        ObjectClass result = null;
        if (parent.getTypeDescription() == cl) {
            result = parent;
        } else {
            for (Node current = parent.getFirst(); !(current == null || current instanceof ObjectClass && (result = FuegoCompiler.getClassForType((ObjectClass)current, cl)) != null); current = current.getNext()) {
            }
        }
        return result;
    }

    private static Node findChild(Node node, TypeDescription type) {
        Node result = null;
        if (node != null) {
            for (Node current = node.getFirst(); current != null; current = current.getNext()) {
                if (current instanceof Method && ((Method)current).getMethodType() == type) {
                    result = current;
                    break;
                }
                if (!(current instanceof ObjectClass) || current.getTypeDescription() != type) continue;
                result = current;
                break;
            }
        }
        return result;
    }

    private static void crashReport(InternalException e) {
        InternalReportingService service = Platform.getInternalReportingService();
        if (service != null) {
            try {
                String detail = FuegoCompiler.buildDetail(e);
                service.reportIssue(e, detail);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static String buildDetail(InternalException e) {
        PrintWriter pw;
        IndentedWriter iw;
        StringWriter sw;
        block8: {
            sw = new StringWriter();
            iw = new IndentedWriter(sw);
            pw = new PrintWriter((Writer)iw, true);
            pw.println(">>> BEGIN Compiler error report");
            pw.flush();
            iw.indent();
            Node node = e.getNode();
            if (node != null) {
                try {
                    pw.println("*** Node dump start *** ");
                    pw.flush();
                    iw.indent();
                    node.dump(pw);
                    pw.flush();
                    iw.dedent();
                    pw.println("*** Node dump end *** ");
                    pw.println();
                    Method member = node.getCurrentMember();
                    MethodTypeDescription mtd = null;
                    if (member != null) {
                        mtd = member.getMethodType();
                    }
                    SourceCode sourceCode = null;
                    if (mtd != null) {
                        sourceCode = mtd.getCode();
                    }
                    if (sourceCode != null) {
                        pw.println("*****  Method dump start *****");
                        pw.println("Method: " + mtd.getName());
                        pw.println("Return Type: " + mtd.getResultType().getText());
                        pw.println("Modifiers: " + Modifier.getText(mtd.getModifiers()));
                        pw.println("Arguments: ");
                        Argument[] args = mtd.getArguments();
                        pw.flush();
                        iw.indent();
                        for (Argument arg : args) {
                            pw.println("Name: " + arg.getName());
                            pw.println("Type: " + arg.getTypeRef().getText());
                            pw.println("Modifiers: " + Modifier.getText(arg.getModifiers()));
                            pw.println();
                        }
                        pw.flush();
                        iw.dedent();
                        pw.println("Code:");
                        pw.flush();
                        iw.indent();
                        pw.println(new String(mtd.getCodeText() == null ? new char[]{} : mtd.getCodeText()));
                        pw.flush();
                        iw.dedent();
                        pw.println("*****  Method end *****");
                        break block8;
                    }
                    pw.println("*** Code not available for member: " + mtd);
                }
                catch (Throwable t) {
                    pw.println();
                    pw.println("**** Failed to complete dump! : ");
                    t.printStackTrace(pw);
                    pw.println();
                }
            } else {
                pw.println("No node available");
            }
        }
        pw.flush();
        iw.dedent();
        pw.println(">>> END Compiler error report");
        pw.close();
        return sw.toString();
    }

    private void loadFunctionCatalog() {
        TypeDescription functions = FuegoCompiler.findGlobalFunctions();
        if (functions == null) {
            return;
        }
        int length = functions.getMemberCount();
        for (int i = length - 1; i >= 0; --i) {
            MethodTypeDescription memberType = functions.getMemberType(i);
            if (!memberType.isStatic()) continue;
            String name = memberType.getName();
            if (Modifier.isConst(memberType.getModifiers()) || !memberType.isMethod() || memberType.getResultType().isVoid()) continue;
            this.symbolTable.putFunction(name, memberType);
        }
    }

    private Node findOrCreate(TypeDescription type) {
        TypeDescription parent = type.getParent();
        Node member = null;
        if (type.isMember() && type.asMethod().findIn(parent, TypeFinder.Scope.CURRENT) == null) {
            ObjectClass cl = (ObjectClass)this.findMember(parent);
            if (cl != null) {
                member = cl.addMember(type.asMethod());
                cl.addChild((AST)member);
                member.setScope(cl.getScope());
            }
        } else {
            member = this.findMember(type);
        }
        return member;
    }

    private CilException generateCode(BaseObjectClass cl, File targetDir, CilException firstError) {
        block3: {
            try {
                cl.generateCode(targetDir);
            }
            catch (Throwable unexpected) {
                InternalException e = new InternalException((Node)cl, unexpected);
                this.reportError(e);
                if (firstError != null) break block3;
                firstError = e;
            }
        }
        this.reportErrors(cl.getErrors());
        if (firstError == null && !cl.getErrors().isEmpty()) {
            firstError = cl.getErrors().get(0);
        }
        return firstError;
    }

    private FuegoParser initParser(SourceCode code) throws InvalidLanguageException {
        String language = code.getLanguage();
        FuegoParser parser = this.parsers.get(language);
        if (parser == null) {
            try {
                parser = LanguageSpec.createParser(language, !this.getDirective(1));
                this.parsers.put(language, parser);
            }
            catch (InvalidLanguageException e) {
                this.reportError(e);
                throw e;
            }
        }
        parser.reset();
        FuegoLexer lexer = parser.getLexer();
        lexer.setCode(code);
        lexer.setNoReservedWords(this.getDirective(2));
        lexer.setCompletionIndex(this.completionIndex);
        parser.setMessageListener(this.msgListener);
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportError(CilException error) {
        if (error.isReported()) {
            return;
        }
        if (error instanceof InternalException) {
            FuegoCompiler.crashReport((InternalException)error);
        }
        error.setReported(true);
        if (this.msgListener != null) {
            try {
                this.msgListener.reportError(error);
            }
            catch (Throwable e) {
                PrintStream printStream = System.err;
                synchronized (printStream) {
                    System.err.println("----- Message listener threw an exception -----");
                    System.err.println("++ Original Error: ");
                    error.printStackTrace();
                    System.err.println("++ Listener Exception: ");
                    e.printStackTrace();
                }
                throw new RuntimeExceptionShell(e, "Unexpected exception reporting error. Check logs for original error.");
            }
        }
    }

    private void reportErrors(List<CilException> errors) {
        for (CilException error : errors) {
            this.reportError(error);
        }
    }

    private CilException reportMessages(Node member) {
        this.reportErrors(member.getErrors());
        this.reportWarnings(member.getWarnings());
        return member.getErrors().isEmpty() ? null : member.getErrors().get(0);
    }

    private CilException reportWarning(CilException warning) {
        warning.setWarning(true);
        if (this.msgListener != null) {
            this.msgListener.reportWarning(warning);
        }
        return warning;
    }

    private void reportWarnings(List<CilException> warnings) {
        for (CilException warning : warnings) {
            this.reportWarning(warning);
        }
    }
}

