/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.ExitException;
import oracle.bpm.compiler.FlowContext;
import oracle.bpm.compiler.FlowException;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.InvalidExitException;
import oracle.bpm.compiler.InvalidLabelException;
import oracle.bpm.compiler.LabeledStatement;
import oracle.bpm.compiler.Logic;
import oracle.bpm.compiler.LoopStatement;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NonBooleanException;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.type.TypeFactory;

public class Exit
extends Node {
    private boolean inloop = false;
    private Node label = null;
    static final long serialVersionUID = -3038174299891766628L;
    static final long serialCheck = 8861740930001561807L;

    public Exit(Token t) {
        super(t);
    }

    Exit() {
    }

    Exit(String blockName) {
        this.setFirst(new Identifier(blockName));
    }

    public static Exit from(Node label, Node condition) {
        Exit exit = new Exit();
        exit.label = label;
        exit.setOperand(condition);
        return exit;
    }

    public boolean isInLoop() {
        return this.inloop;
    }

    public Node getLabel() {
        return this.label;
    }

    @Override
    public String getText() {
        return this.label == null ? "exit" : "exit(" + this.label + ")";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getFirst(), this.label);
    }

    @Override
    protected boolean splitToPrint() {
        return true;
    }

    void andCondition(Node cond) {
        Node when = this.getFirst();
        when = when == null ? cond : Logic.and(cond, when);
        this.setFirst(when);
    }

    @Override
    FlowContext checkFlow(FlowContext context) throws FlowException {
        Node when = this.getFirst();
        if (when != null) {
            when.checkFlow(context);
            if (when.isConstant() && ((BoolConst)when).booleanValue()) {
                context.breaksFlow(true);
            } else {
                context.breaksFlow(false);
            }
        } else {
            context.breaksFlow(true);
        }
        if (this.label != null) {
            context.addExit(this.label.getText());
        } else {
            context.addExit();
        }
        return context;
    }

    @Override
    Node checkType() throws TypeException {
        if (this.label == null) {
            Node id = this.getFirst();
            if (id != null && id.isCompletion()) {
                id.complete(6, this);
            } else if (id instanceof Identifier) {
                this.label = id;
                String labelName = id.getText();
                this.removeFirst();
                DoBlock doBlock = DoBlock.findByName(labelName, this);
                if (doBlock == null) {
                    LabeledStatement labeledStatement = LabeledStatement.find(labelName, this);
                    if (labeledStatement == null && this.getCurrentLanguage().isFuego1() && (doBlock = DoBlock.findByName(labelName, this, false)) != null) {
                        this.label = new Identifier(doBlock.getName());
                    }
                    if (labeledStatement == null && doBlock == null) {
                        throw new InvalidLabelException(id);
                    }
                }
            } else {
                this.label = null;
            }
            Node when = this.getFirst();
            if (when != null) {
                if ((when = when.checkType(TypeFactory.getBool())).getKind() != 1) {
                    throw new NonBooleanException(when);
                }
                this.setOperand(Conversion.UnBox.create(when).checkType());
            }
            this.inloop = this.findParentByClass(LoopStatement.class) != null;
            Method currentMethod = this.getCurrentMember();
            if (!currentMethod.getResultType().isVoid()) {
                String methodName = currentMethod.getName();
                if (!this.inloop || this.label != null && this.label.equals(methodName)) {
                    throw new InvalidExitException(this);
                }
            }
            this.setTypeDescription(TypeFactory.getVoid());
        }
        return this;
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        codeGenerator.generate(this);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Node pred = this.getFirst();
        if (pred != null && !((Boolean)pred.value(rm)).booleanValue()) {
            return null;
        }
        throw new ExitException((Node)this, this.label != null ? this.label.getText() : null);
    }
}

