/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.Iterator;
import java.util.LinkedList;
import oracle.bpm.compiler.StackFrame;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;

public class ExecutionStack {
    private LinkedList<StackFrame> stack = new LinkedList();

    public synchronized boolean isEmpty() {
        return this.stack.size() == 0;
    }

    public synchronized int getLevel() {
        return this.stack.size() - 1;
    }

    public synchronized StackFrame[] getFrames() {
        StackFrame[] stackTrace = new StackFrame[this.stack.size()];
        Iterator trace = this.stack.iterator();
        int level = 0;
        while (trace.hasNext()) {
            stackTrace[level++] = (StackFrame)trace.next();
        }
        return stackTrace;
    }

    public synchronized StackFrame peek() {
        return this.stack.getFirst();
    }

    public synchronized StackFrame pop() {
        return this.stack.removeFirst();
    }

    public synchronized void push(TypeDescription component, MethodTypeDescription method) {
        this.push(new StackFrame(component, method));
    }

    public synchronized void push(StackFrame frame) {
        this.stack.addFirst(frame);
    }
}

