/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.msg.CompilerMsg;

public class ExecutionInterruptedException
extends ExecutionException {
    private int column;
    private int line;
    static final long serialVersionUID = 5735390890163404704L;
    static final long serialCheck = -8980048733410216481L;

    public ExecutionInterruptedException(int line, int column) {
        super(null, CompilerMsg.INTERRUPTION);
        this.line = line;
        this.column = column;
    }

    ExecutionInterruptedException(Node node) {
        super(node, CompilerMsg.INTERRUPTION);
        if (node != null) {
            this.line = node.getLine();
            this.column = node.getColumn();
        }
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public String getMessage() {
        return "CIL interrupted";
    }
}

