/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CodeStyle;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.IncompatibleTypesException;
import oracle.bpm.compiler.Is;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NonNumericException;
import oracle.bpm.compiler.Not;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.compiler.NumDiadic;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.CompOperator;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.Operation;

public class Equality
extends Diadic {
    private CompOperator operator;
    static final long serialVersionUID = -9077124865258715856L;
    static final long serialCheck = -8537557796465498512L;

    protected Equality(Token t, CompOperator op) {
        super(t);
        this.operator = op;
    }

    @Override
    public String getText() {
        return this.isEquals() ? "==" : "/=";
    }

    @Override
    public Node negate() {
        this.operator = this.operator.negate();
        return this;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    public boolean isEquals() {
        return this.operator == CompOperator.EQ;
    }

    public CompOperator getOperator() {
        return this.operator;
    }

    static Equality equals(Node op1, Node op2) {
        Eq result = new Eq(null);
        result.setOperands(op1, op2);
        result.initialize(op1);
        return result;
    }

    static Equality notEquals(Node op1, Node op2) {
        Ne result = new Ne(null);
        result.setOperands(op1, op2);
        result.initialize(op1);
        return result;
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        Operation op1 = this.getOp1().getOperationTree();
        Operation op2 = this.getOp2().getOperationTree();
        Operation[] operands = new Operation[]{op1, op2};
        switch (this.operator) {
            case EQ: {
                return new Operation(2, "==", operands);
            }
            case NE: {
                return new Operation(3, "!=", operands);
            }
        }
        assert (false) : "Invalid operation: " + this.operator;
        return null;
    }

    @Override
    boolean checkParameter(StringBuffer query) {
        Node op1 = this.getOp1();
        Node op2 = this.getOp2();
        return (!this.isParameter() || !this.isBoolConst(op1) && !this.isBoolConst(op2)) && super.checkParameter(query);
    }

    @Override
    Node checkType() throws TypeException {
        Node result = this;
        super.checkType();
        Node o1 = this.getOp1();
        Node o2 = this.getOp2();
        Diadic n = null;
        try {
            n = NumDiadic.promote(this);
        }
        catch (NonNumericException e) {
            // empty catch block
        }
        if (n != null) {
            o1 = n.getOp1();
            o2 = n.getOp2();
        }
        this.setTypeDescription(TypeFactory.getPrimitiveBool());
        TypeDescription op1Type = o1.getTypeDescription();
        TypeDescription op2Type = o2.getTypeDescription();
        if (!op1Type.equality(op2Type)) {
            throw new IncompatibleTypesException(this, this.getOp1(), this.getOp2());
        }
        if (o1.getKind() == 12) {
            ArrayConst arrayConst;
            TypeDescription t = op1Type.promote(op2Type);
            if (!t.equals(op1Type)) {
                ArrayConst arrayConst2 = arrayConst = o1 instanceof ArrayConst ? (ArrayConst)o1 : null;
                if (arrayConst != null) {
                    arrayConst.promote(t.getElementType(), null);
                } else {
                    o1 = Conversion.promote(o1, t);
                }
            }
            if (!t.equals(op2Type)) {
                ArrayConst arrayConst3 = arrayConst = o2 instanceof ArrayConst ? (ArrayConst)o2 : null;
                if (arrayConst != null) {
                    arrayConst.promote(t.getElementType(), null);
                } else {
                    o2 = Conversion.promote(o2, t);
                }
            }
        }
        this.checkSillyOperation(o1, o2);
        if (op1Type.isPrimitive() != op2Type.isPrimitive()) {
            if (op1Type.isPrimitive()) {
                o1 = Conversion.promote(o1, op1Type.primitiveEquivalent(false));
            } else {
                o2 = Conversion.promote(o2, op2Type.primitiveEquivalent(false));
            }
        }
        this.setOperands(o1, o2);
        if (!this.isGeneratingSource()) {
            Node isnode;
            if (o1.isConstant() && o2.isConstant()) {
                result = new BoolConst(o1.equals((AST)o2) ^ !this.isEquals());
                result.initialize(o1);
            }
            if ((isnode = this.convertIsNull(o1, o2)) != null) {
                result = isnode;
            }
        }
        return result;
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        codeGenerator.generate(this);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        if (this.checkParameter(sql)) {
            return;
        }
        Node op1 = this.getOp1();
        Node op2 = this.getOp2();
        if (op1 instanceof NullConst) {
            op2.generateSQLCode(sql);
            sql.append(" is ").append(this.isEquals() ? "" : "not ");
            op1.generateSQLCode(sql);
        } else if (op2 instanceof NullConst) {
            op1.generateSQLCode(sql);
            sql.append(" is ").append(this.isEquals() ? "" : "not ");
            op2.generateSQLCode(sql);
        } else {
            if (this.isBoolConst(op1)) {
                sql.append(this.isTrue(op1) ? "1" : "0");
            } else {
                op1.generateSQLCode(sql);
            }
            sql.append(this.isEquals() ? " = " : " <> ");
            if (this.isBoolConst(op2)) {
                sql.append(this.isTrue(op2) ? "1" : "0");
            } else {
                op2.generateSQLCode(sql);
            }
        }
    }

    @Override
    Node refactor(CodeStyle ss) {
        super.refactor(ss);
        boolean isnull = ss.getReplaceEqWithIsNull() == 1;
        Node result = this;
        Node op1 = this.getOp1();
        Node op2 = this.getOp2();
        if (isnull) {
            result = this.convertIsNull(op1, op2);
        }
        if (op1.getKind() == 1 && op2.getKind() == 1 && (op1.isConstant() || op2.isConstant()) && op1.isConstant() != op2.isConstant()) {
            Node constant;
            if (op1.isConstant()) {
                result = op2;
                constant = op1;
            } else {
                result = op1;
                constant = op2;
            }
            boolean constantIsFalse = constant.getText().equals("false");
            if (!this.isEquals() != constantIsFalse) {
                result = Not.not(result);
            }
        }
        return result;
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        boolean result = Any.equals(this.getOp1().value(rm), this.getOp2().value(rm));
        return this.isEquals() ? result : !result;
    }

    private boolean isBoolConst(Node op1) {
        return op1 instanceof BoolConst;
    }

    private boolean isTrue(Node op) {
        return op.getText().equals("true");
    }

    private Node convertIsNull(Node op1, Node op2) {
        Is isnode = null;
        Node result = this;
        if (op1 instanceof NullConst || op2 instanceof NullConst) {
            assert (op1.getScope() != null) : this;
            assert (op2.getScope() != null) : this;
            isnode = op1 instanceof NullConst ? Is.nullValue(op2) : Is.nullValue(op1);
        }
        if (isnode != null) {
            try {
                result = (this.isEquals() ? isnode : Not.not(isnode)).checkType();
            }
            catch (TypeException noway) {
                noway.printStackTrace();
            }
        }
        return result;
    }

    public static class Ne
    extends Equality {
        static final long serialVersionUID = -3681003312670592564L;
        static final long serialCheck = -7339301433386781877L;

        public Ne(Token t) {
            super(t, CompOperator.NE);
        }
    }

    public static class Eq
    extends Equality {
        static final long serialVersionUID = -6344005826415056214L;
        static final long serialCheck = 7739634480069866127L;

        public Eq(Token t) {
            super(t, CompOperator.EQ);
        }
    }
}

