/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.math.BigDecimal;
import java.math.BigInteger;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstGenerator;
import oracle.bpm.compiler.ConversionException;
import oracle.bpm.compiler.InvalidNumberException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Decimal;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.Operation;

public final class DecimalConst
extends Const {
    BigDecimal value;
    private static final BigInteger TEN = BigInteger.valueOf(10L);
    static final long serialVersionUID = -4483131666701990487L;
    static final long serialCheck = 5692095853125919914L;

    public DecimalConst(Token t) {
        this(t, t.getText(), -1, -1);
    }

    DecimalConst(String txt) {
        this(txt, -1, -1);
    }

    DecimalConst(String txt, int length, int scale) {
        this(null, txt, length, scale);
    }

    private DecimalConst(Token t, String txt, int length, int scale) {
        super(t, null);
        try {
            BigDecimal newValue = txt.length() == 0 ? BigDecimal.ZERO : Decimal.valueOf(txt);
            this.value = newValue = Decimal.scale(newValue, scale);
            if (scale < 0) {
                scale = newValue.scale();
            }
            if (length < 0) {
                length = newValue.precision();
            }
        }
        catch (NumberFormatException e) {
            this.value = BigDecimal.ZERO;
            this.exception = new InvalidNumberException((Node)this, txt);
        }
        this.setTypeDescription(TypeFactory.getDecimal(length, scale));
    }

    @Override
    public String getSyntheticName() {
        return DecimalConst.createSyntheticNameFromType(this.getTypeDescription(), String.valueOf(this.value));
    }

    @Override
    public String getText() {
        return this.value.toString();
    }

    @Override
    public Node negate() {
        this.value = this.value.negate();
        return this;
    }

    @Override
    public void generate(ConstGenerator cg) {
        cg.generate(this);
    }

    @Override
    public String toString() {
        return super.toString() + this.getText() + 'D';
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    @Override
    boolean isCollectable() {
        return !this.value.equals(Decimal.ZERO);
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        return new Operation(21, null, null, this.getText());
    }

    @Override
    int compare(Node b) {
        return this.value.compareTo(((DecimalConst)b).value);
    }

    @Override
    Const compute(int op, Node bNode) {
        BigDecimal b = ((DecimalConst)bNode).value;
        switch (op) {
            case 0: {
                this.value = this.value.add(b);
                break;
            }
            case 1: {
                this.value = this.value.subtract(b);
                break;
            }
            case 2: {
                this.value = this.value.multiply(b);
                break;
            }
            case 3: {
                this.value = this.value.divide(b, 4);
                break;
            }
            case 4: {
                this.value = this.value.subtract(this.value.divide(b, 0, 1).multiply(b));
            }
        }
        return this;
    }

    @Override
    Const convertTo(TypeDescription targetType) throws TypeException {
        int length = targetType.getLength();
        BigDecimal scaled = Decimal.scale(this.value, targetType.getScale());
        try {
            Decimal.checkLength61(scaled, length);
        }
        catch (IllegalConversionException e) {
            throw new ConversionException((Node)this, this.getTypeDescription(), targetType);
        }
        return super.convertTo(targetType);
    }

    boolean equals(Node b) {
        if (!(b instanceof DecimalConst)) {
            return false;
        }
        return this.value.equals(((DecimalConst)b).value);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        sql.append(this.isParameter() ? " ? " : this.value.toString());
    }

    @Override
    Object run(RunningMonitor rm) {
        return this.value;
    }
}

