/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.bpm.compiler.Completion;
import oracle.bpm.compiler.CompletionSuggestion;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;

public class CompletionResult {
    private Completion completion;
    private String id;
    private Set<CompletionSuggestion> suggestions;
    private static final CompletionComparator COMPLETION_COMPARATOR = new CompletionComparator();

    CompletionResult(String id) {
        this.id = id;
        this.suggestions = new TreeSet<CompletionSuggestion>();
    }

    public String getId() {
        return this.id;
    }

    public CompletionSuggestion[] getSuggestions() {
        CompletionSuggestion[] result = this.suggestions.toArray(new CompletionSuggestion[this.suggestions.size()]);
        Arrays.sort(result, COMPLETION_COMPARATOR);
        return result;
    }

    public int size() {
        return this.suggestions.size();
    }

    void setCompletion(Completion completion) {
        this.completion = completion;
    }

    Completion getCompletion() {
        return this.completion;
    }

    void addSuggestion(CompletionSuggestion suggestion) {
        CompletionSuggestion completionSuggestion = this.getMatchingCompletion(suggestion);
        if (completionSuggestion == null) {
            this.suggestions.add(suggestion);
        } else if (!this.existsInSubtype(suggestion, completionSuggestion)) {
            completionSuggestion.setNeedsQualification(true);
            suggestion.setNeedsQualification(true);
            this.suggestions.add(suggestion);
        }
    }

    private boolean existsInSubtype(CompletionSuggestion newSuggestion, CompletionSuggestion existingSuggestion) {
        TypeDescription newType = newSuggestion.getType();
        TypeDescription existingType = existingSuggestion.getType();
        if (newType != null && existingType != null) {
            TypeDescription existingTypeParent = existingType.getParent();
            TypeDescription newTypeParent = newType.getParent();
            if (existingTypeParent != null && newTypeParent != null) {
                List<SuperType> superTypes = existingTypeParent.getSuperTypes();
                return this.findInSuperTypes(newTypeParent, superTypes);
            }
        }
        return false;
    }

    private boolean findInSuperTypes(TypeDescription newType, List<SuperType> types) {
        ArrayList<SuperType> superTypes = new ArrayList<SuperType>();
        for (SuperType type : types) {
            if (newType.equals(type.getType())) {
                return true;
            }
            superTypes.addAll(type.getType().getSuperTypes());
        }
        if (!superTypes.isEmpty()) {
            this.findInSuperTypes(newType, superTypes);
        }
        return false;
    }

    private CompletionSuggestion getMatchingCompletion(CompletionSuggestion suggestion) {
        TypeDescription suggestionType = suggestion.getType();
        if (suggestionType != null) {
            for (CompletionSuggestion completionSuggestion : this.suggestions) {
                if (!completionSuggestion.getId().equals(suggestion.getId())) continue;
                TypeDescription type = completionSuggestion.getType();
                if (suggestionType.isMethod() && type.isMethod()) {
                    if (!suggestionType.asMethod().matchArguments(type.asMethod())) continue;
                    return completionSuggestion;
                }
                return completionSuggestion;
            }
        }
        return null;
    }

    private static class CompletionComparator
    implements Comparator<CompletionSuggestion> {
        private CompletionComparator() {
        }

        @Override
        public int compare(CompletionSuggestion a, CompletionSuggestion b) {
            return a.compareTo(b, false);
        }
    }
}

