/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.CompletionException;
import oracle.bpm.compiler.CompletionResult;
import oracle.bpm.compiler.CompletionSuggestion;
import oracle.bpm.compiler.Display;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.InputField;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.MappedArrayReference;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.ObjectInput;
import oracle.bpm.compiler.SourceTemplate;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.SymbolTable;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.EnumTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeList;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;

public class Completion
extends Node {
    private int defaultType;
    private TypeDescription expectedType = null;
    private String id;
    private Node[] options;
    private static Set<TypeDescription> predefinedTypes;
    public static final int NONE = 0;
    public static final int EXPRESSION = 1;
    public static final int MEMBER = 2;
    public static final int INVOCATION_IN_ARGUMENT = 3;
    public static final int INVOCATION_OUT_ARGUMENT = 4;
    public static final int ARGUMENT = 5;
    public static final int LABEL = 6;
    public static final int INPUT_OPTIONS = 7;
    public static final int END_BLOCK = 8;
    public static final int STATEMENT = 9;
    public static final int TYPE = 10;
    public static final int COMPONENT_TYPE = 11;
    public static final int COMPONENT_INNER_TYPE = 12;
    public static final int OPTIONS = 13;
    public static final int SQL_TABLE = 14;
    public static final int ARRAY_ELEMENT = 15;
    public static final int EXCEPTION = 16;
    private static int MAX_SUGGESTION_SIZE;
    private static final TypeDescription VOID;
    static final long serialVersionUID = 2089885572974736140L;
    static final long serialCheck = 1952264563370789988L;

    public Completion(Token t) {
        this(t, -1);
    }

    Completion(Node[] options) {
        this(null, 13);
        this.options = options;
    }

    Completion(Token t, int defaultCompletion) {
        this(t, defaultCompletion, null);
    }

    Completion(Token t, int defaultCompletion, TypeDescription expectedType) {
        super(t);
        this.id = t != null ? t.getText() : null;
        this.id = this.id == null ? "" : this.id;
        this.defaultType = defaultCompletion;
        this.expectedType = expectedType;
    }

    @Override
    public String getText() {
        return this.id;
    }

    public void complete(Node argument) throws CompletionException {
        int completionType = this.defaultType != -1 ? this.defaultType : (this.isExpression() ? 1 : 9);
        this.complete(completionType, argument);
    }

    @Override
    public void complete(int completionType, Node argument) throws CompletionException {
        CompletionResult result = new CompletionResult(this.id);
        result.setCompletion(this);
        switch (completionType) {
            case 1: {
                this.completeExpression(result, argument);
                break;
            }
            case 5: {
                this.completeArgument(result, argument);
                break;
            }
            case 3: 
            case 4: {
                this.completeInvocationArgument(result, argument);
                break;
            }
            case 2: {
                this.completeMember(result, argument);
                break;
            }
            case 15: {
                this.completeArrayElement(result, argument);
                break;
            }
            case 6: {
                this.completeLabel(result, argument);
                break;
            }
            case 7: {
                this.completeInputOptions(result, argument);
                break;
            }
            case 8: {
                this.completeEndBlock(result, argument);
                break;
            }
            case 9: {
                this.completeStatement(result, argument);
                break;
            }
            case 10: {
                this.completeType(result, argument, true);
                break;
            }
            case 11: {
                this.completeType(result, argument, false);
                break;
            }
            case 12: {
                this.completeInner(result, argument, argument.getTypeDescription());
                break;
            }
            case 13: {
                this.completeOptions(result);
                break;
            }
            case 14: {
                this.completeType(result, argument, false);
                break;
            }
            case 16: {
                this.completeException(result, argument);
                break;
            }
            default: {
                assert (false) : completionType;
                break;
            }
        }
        throw new CompletionException((Node)this, result);
    }

    @Override
    public String toString() {
        return "Completion(" + this.getText() + ")";
    }

    @Override
    boolean isCompletion() {
        return true;
    }

    void setExpectedType(TypeDescription expectedType) {
        this.expectedType = expectedType;
    }

    TypeDescription getExpectedType() {
        return this.expectedType;
    }

    @Override
    Node checkType() throws TypeException {
        this.complete(this.getParent());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<TypeDescription> getPredefinedTypes() {
        if (predefinedTypes != null) return predefinedTypes;
        Class<Completion> clazz = Completion.class;
        synchronized (Completion.class) {
            if (predefinedTypes != null) return predefinedTypes;
            predefinedTypes = new HashSet<TypeDescription>();
            predefinedTypes.add(TypeFactory.getString());
            predefinedTypes.add(TypeFactory.getInt());
            predefinedTypes.add(TypeFactory.getDecimal());
            predefinedTypes.add(TypeFactory.getReal());
            predefinedTypes.add(TypeFactory.getInterval());
            predefinedTypes.add(TypeFactory.getTime());
            predefinedTypes.add(TypeFactory.getBinary());
            predefinedTypes.add(TypeFactory.getBool());
            predefinedTypes.add(TypeFactory.getAny());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return predefinedTypes;
        }
    }

    private void addTypes(ComponentCatalog catalog, CompletionResult result, Node partialType, long modifiers) {
        Iterator<? extends TypeRef> it = catalog.findByPartialName(this.id).values().iterator();
        while (it.hasNext()) {
            for (TypeList type : (TypeList)it.next()) {
                if (!this.mustShowType(type, modifiers)) continue;
                result.addSuggestion(CompletionSuggestion.type(this, type, partialType));
                if (result.size() != MAX_SUGGESTION_SIZE) continue;
                return;
            }
        }
    }

    private void completeArgument(CompletionResult result, Node argument) {
        Method method = argument.getCurrentMember();
        if (method != null) {
            this.completeArguments(method.getMethodType(), result, false);
        }
    }

    private TypeDescription completeArguments(MethodTypeDescription method, CompletionResult result, boolean all) {
        TypeDescription objectType = method.getParent();
        while (method != null) {
            for (Argument arg : method.getArguments()) {
                if (!this.matchId(arg.getName()) || !this.matchExpectedType(arg.getType())) continue;
                result.addSuggestion(CompletionSuggestion.argument(this, arg));
            }
            method = all ? method.getNextMethod() : null;
        }
        return objectType;
    }

    private void completeArrayElement(CompletionResult result, Node argument) {
        TypeDescription arrayType = ((MappedArrayReference)argument).getOp1().getTypeDescription();
        this.completeMember(argument, arrayType.getElementType(), false, false, false, false, result);
    }

    private void completeEndBlock(CompletionResult result, Node argument) {
        String text = argument.getText();
        if (text.endsWith(this.id)) {
            result.addSuggestion(CompletionSuggestion.id(this, text));
        }
    }

    private void completeEnum(CompletionResult result) {
        EnumTypeDescription enumType = this.getScope().getCurrentEnum();
        if (enumType != null) {
            int count = enumType.getMemberCount();
            for (int i = 0; i < count; ++i) {
                MethodTypeDescription member = enumType.getMemberType(i);
                if (!this.matchId(member.getName())) continue;
                result.addSuggestion(CompletionSuggestion.enumeration(this, member));
            }
        }
    }

    private void completeException(CompletionResult result, Node partialType) {
        ComponentCatalog catalog = this.getCatalog();
        if (this.id.length() > 0) {
            MutableComponentCatalog defaultCatalog = TypeUtils.getDefaultCatalog();
            this.addTypes(catalog, result, partialType, 262144L);
            if (catalog != defaultCatalog) {
                this.addTypes(defaultCatalog, result, partialType, 262144L);
            }
        }
    }

    private void completeExpression(CompletionResult result, Node argument) {
        ObjectClass cl = argument.getCurrentClass();
        MethodTypeDescription currentMethod = argument.getCurrentMember().getMethodType();
        this.completeMember(null, cl.getObjectType(), true, false, currentMethod.isStatic() && !currentMethod.isConstructor(), false, result);
        if (!currentMethod.isForceArgQualification()) {
            this.completeArgument(result, argument);
        }
        SymbolTable symbols = this.getSymbolTable();
        this.completeLocal(symbols, result);
        this.completeEnum(result);
        if (argument instanceof ObjectInput || argument instanceof Display) {
            this.completeComponentId(result, true);
        } else {
            this.completeComponentId(result, false);
        }
    }

    private void completeComponentId(CompletionResult result, boolean requireInit) {
        ComponentCatalog catalog = this.getCatalog();
        if (this.id.length() > 0) {
            MutableComponentCatalog defaultCatalog = TypeUtils.getDefaultCatalog();
            this.addIds(catalog, result, requireInit);
            if (catalog != defaultCatalog) {
                this.addIds(defaultCatalog, result, requireInit);
            }
        }
    }

    private void addIds(ComponentCatalog catalog, CompletionResult result, boolean requireInit) {
        Iterator<? extends TypeRef> it = catalog.findByPartialName(this.id, true).values().iterator();
        while (it.hasNext()) {
            for (TypeList type : (TypeList)it.next()) {
                if (!requireInit || type.get().hasDefaultInit()) {
                    for (int i = 0; i < type.getCount(); ++i) {
                        TypeList typeElement = type.getType(i);
                        CompletionSuggestion suggestion = CompletionSuggestion.id(this, typeElement.getName());
                        suggestion.setType(typeElement.get());
                        result.addSuggestion(suggestion);
                    }
                }
                if (result.size() != MAX_SUGGESTION_SIZE) continue;
                return;
            }
        }
    }

    private void completeInner(CompletionResult result, Node partialType, TypeDescription type) {
        TypeRef[] refs = new TypeRef[]{};
        try {
            TypeRef ref = ((MutableComponentCatalog)this.getCatalog()).findType(type.getText(), null, null, false);
            if (ref != null) {
                refs = new TypeRef[]{ref};
            }
        }
        catch (AmbiguousTypeNameException e) {
            refs = e.getPossibleTypes();
        }
        for (TypeRef typeRef : refs) {
            this.completeSingleInnerType(result, partialType, typeRef.get());
        }
    }

    private void completeSingleInnerType(CompletionResult result, Node partialType, TypeDescription type) {
        ObjectTypeDescription otd = type.asObject();
        int count = otd.getInnerTypeCount();
        for (int i = 0; i < count; ++i) {
            ObjectTypeDescription inner = otd.getInnerType(i);
            if (!this.matchId(inner.getName()) || !this.mustShowType(inner, 0L)) continue;
            result.addSuggestion(CompletionSuggestion.type(this, inner, partialType));
        }
    }

    private void completeInputOptions(CompletionResult result, Node argument) {
        InputField inputField = (InputField)argument;
        TypeDescription varType = inputField.getVar().getTypeDescription();
        ArrayList<String> options = new ArrayList<String>();
        switch (varType.getKind()) {
            case 5: {
                options.add("textarea");
                options.add("password");
                break;
            }
            case 6: {
                options.add("date");
                options.add("time");
                break;
            }
            case 7: {
                for (String option : InputField.intervalOptions) {
                    options.add(option);
                }
                break;
            }
        }
        options.add("required");
        options.add("readonly");
        options.add("radio");
        for (String option : options) {
            if (!this.matchId(option)) continue;
            result.addSuggestion(CompletionSuggestion.id(this, option));
        }
    }

    private Set completeInvocationArgument(CompletionResult result, Node argument) {
        HashSet suggestions = new HashSet();
        Args args = (Args)argument;
        Invoke invoke = args.getInvoke();
        MethodTypeDescription method = invoke.getMemberType();
        TypeDescription objectType = this.completeArguments(method, result, true);
        this.completeMember(null, objectType, true, false, false, true, result);
        this.completeEnum(result);
        return suggestions;
    }

    private void completeLabel(CompletionResult result, Node node) {
        while (node != null) {
            String name = null;
            if (node instanceof DoBlock) {
                DoBlock doBlock = (DoBlock)node;
                name = doBlock.getName();
            }
            if (name != null && !name.isEmpty() && this.matchId(name)) {
                result.addSuggestion(CompletionSuggestion.id(this, name));
            }
            node = node.getParent();
        }
    }

    private void completeLocal(SymbolTable symbols, CompletionResult result) {
        for (Symbol symbol : symbols.values()) {
            String name = symbol.getName();
            TypeDescription type = symbol.getType();
            if (symbol.isSilentAutoDeclared() || !this.matchId(name) || !this.matchExpectedType(type)) continue;
            result.addSuggestion(CompletionSuggestion.local(this, name, type));
        }
        SymbolTable parent = symbols.getDefaultTable();
        if (parent != null) {
            this.completeLocal(parent, result);
        }
    }

    private void completeMember(CompletionResult result, Node argument) {
        TypeDescription type = argument.getTypeDescription();
        this.completeMember(argument, type, false, false, false, false, result);
    }

    private void completeMember(Node object, TypeDescription type, boolean onlyExpression, boolean onlyStatement, boolean onlyStatic, boolean asArgument, CompletionResult result) {
        if (type.isTime() || type.getKind() == 7 || type.isArray()) {
            type = type.asObject();
        }
        int count = type.getMemberCount();
        for (int i = 0; i < count; ++i) {
            for (MethodTypeDescription member = type.getMemberType(i); member != null; member = member.getNextMethod()) {
                boolean statementOk;
                String name = member.getName();
                if (!this.matchId(name)) continue;
                boolean hidden = !member.isVisible();
                TypeDescription resultType = member.getResultType();
                boolean matchType = this.matchExpectedType(resultType);
                boolean isStatement = resultType.isVoid();
                boolean isVisible = matchType && !hidden && !member.isConstructor();
                boolean expressionOk = !onlyExpression || !isStatement;
                boolean staticOk = !onlyStatic || member.isStatic();
                boolean bl = statementOk = !onlyStatement || isStatement;
                if (!isVisible || !expressionOk || !staticOk || !statementOk) continue;
                if (asArgument) {
                    result.addSuggestion(CompletionSuggestion.id(this, member));
                    continue;
                }
                result.addSuggestion(CompletionSuggestion.member(this, member, object));
            }
        }
        for (SuperType superType : type.getSuperTypes()) {
            if (superType.isHidden()) continue;
            this.completeMember(object, superType.getType(), onlyExpression, false, onlyStatic, asArgument, result);
        }
        this.completeInner(result, object, type);
    }

    private void completeOptions(CompletionResult result) {
        for (Node node : this.options) {
            SourceTemplate template = new SourceTemplate(node, node.getText(), null);
            result.addSuggestion(CompletionSuggestion.template(this, template));
        }
    }

    private void completeStatement(CompletionResult result, Node argument) {
        this.completeExpression(result, argument);
        ObjectClass cl = argument.getCurrentClass();
        MethodTypeDescription currentMethod = argument.getCurrentMember().getMethodType();
        this.completeMember(null, cl.getObjectType(), false, true, currentMethod.isStatic(), false, result);
        LanguageSpec spec = this.getCurrentLanguage();
        for (SourceTemplate template : spec.getTemplates()) {
            String name = template.getId();
            if (!this.matchId(name) || !template.isAddToPopup() || !this.matchExpectedType(VOID)) continue;
            result.addSuggestion(CompletionSuggestion.template(this, template));
        }
    }

    private void completeType(CompletionResult result, Node partialType, boolean showPredefined) {
        ComponentCatalog catalog = this.getCatalog();
        if (this.id.length() > 0) {
            MutableComponentCatalog defaultCatalog = TypeUtils.getDefaultCatalog();
            this.addTypes(catalog, result, partialType, 0L);
            if (catalog != defaultCatalog) {
                this.addTypes(defaultCatalog, result, partialType, 0L);
            }
        }
        if (showPredefined) {
            Set<TypeDescription> predefinedTypes = this.getPredefinedTypes();
            for (TypeDescription type : predefinedTypes) {
                if (!this.matchId(type.getName()) || !this.mustShowType(type, 0L)) continue;
                result.addSuggestion(CompletionSuggestion.type(this, type, partialType));
            }
        }
    }

    private boolean matchExpectedType(TypeDescription type) {
        return this.expectedType == null || this.expectedType.isAssignableFrom(type);
    }

    private boolean matchId(String name) {
        return name.startsWith(this.id);
    }

    private boolean mustShowType(TypeRef ref, long modifiers) {
        if (modifiers != 0L && (ref.getModifiers() & modifiers) == 0L) {
            return false;
        }
        return this.matchExpectedType(VOID) && !ref.getText().startsWith("Fuego.Internal") && !Modifier.isHidden(ref.getModifiers());
    }

    static {
        MAX_SUGGESTION_SIZE = 200;
        VOID = TypeFactory.getVoid();
    }

    static class Type
    extends Completion {
        static final long serialVersionUID = 7532979981451166605L;
        static final long serialCheck = -3296524755230352061L;

        public Type(Token t) {
            super(t, 10);
        }
    }
}

