/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.lexer.LexerConfigurator;
import fuego.parser.FuegoToken;
import fuego.parser.MismatchedTokenException;
import fuego.parser.NoViableAltException;
import fuego.parser.RecognitionException;
import fuego.parser.Token;
import fuego.parser.TokenStreamException;
import fuego.parser.TokenStreamRecognitionException;
import fuego.parser.collections.impl.BitSet;
import java.lang.reflect.Field;
import java.util.Map;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RuleToResourceMapping;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.Str;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.SourceCode;
import org.jetbrains.annotations.Nullable;

public class CompilerParserException
extends CompilerException {
    static final long serialVersionUID = -8309387767339332414L;
    static final long serialCheck = -2868664525436056633L;

    protected CompilerParserException(Node node, Msg key) {
        super(node, key);
    }

    CompilerParserException(TokenStreamException e, SourceCode code, boolean expression) {
        super(null, CompilerMsg.IOERROR(e.getMessage()));
        if (e instanceof TokenStreamRecognitionException) {
            TokenStreamRecognitionException re = (TokenStreamRecognitionException)e;
            this.init(code, re.recog, expression);
        } else {
            this.initCause(e);
        }
    }

    CompilerParserException(RecognitionException e, SourceCode code, boolean expression) {
        super(null, CompilerMsg.SYNTAX);
        this.init(code, e, expression);
    }

    CompilerParserException(TokenStreamException e, char ch, int line, int column) {
        super(null, CompilerMsg.INVCHAR(String.valueOf(ch)));
        this.initCause(e);
        this.setLine(line);
        this.setColumn(column);
        this.setLength(1);
    }

    public void setRule(String rule) {
        String description = CompilerParserException.findRuleDescription(rule);
        this.setKey(CompilerMsg.UNCOMPLETED_CONSTRUCTION(description));
        this.fixPosition(this.sourceCode);
    }

    @Override
    public boolean isSyntactic() {
        return true;
    }

    static String findRuleDescription(String rule) {
        Msg msg = RuleToResourceMapping.INSTANCE.get(rule);
        return msg != null ? msg.getString() : rule;
    }

    static String tokenName(int token, String[] tokenNames, String language, int state, boolean expr) {
        String name;
        if (token == 1) {
            Msg msg = expr ? CompilerMsg.END_OF_EXPRESSION : CompilerMsg.END_OF_METHOD;
            name = msg.getString();
        } else if (token == 7) {
            name = CompilerMsg.IDENTIFIER.getString();
        } else if (token == 0) {
            name = "<>";
        } else if (token < 0 || token >= tokenNames.length) {
            name = "<" + String.valueOf(token) + ">";
        } else {
            name = CompilerParserException.tokenText(token, tokenNames, language, state);
            if (name != null) {
                name = "'" + name + "'";
            }
        }
        return name;
    }

    static String tokenText(int token, String[] tokenNames, String language, int state) {
        String name;
        block3: {
            name = tokenNames[token];
            try {
                LanguageSpec langSpec = LanguageSpec.getLanguageSpec(language);
                LexerConfigurator configurator = langSpec.getLexerConfigurator();
                Map tokens = configurator.getTokensByName(state);
                String text = (String)tokens.get(name);
                if (text != null) {
                    name = text;
                }
            }
            catch (InvalidLanguageException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)e);
            }
        }
        return name;
    }

    private static int getExpecting(MismatchedTokenException e) {
        Integer value = (Integer)CompilerParserException.getFieldValue(e, "expecting");
        return value;
    }

    private static Object getFieldValue(MismatchedTokenException e, String name) {
        try {
            Field field = e.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return field.get(e);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeExceptionShell(ex);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeExceptionShell(ex);
        }
    }

    private static int getMismatchType(MismatchedTokenException e) {
        Integer value = (Integer)CompilerParserException.getFieldValue(e, "mismatchType");
        return value;
    }

    private static BitSet getSet(MismatchedTokenException e) {
        return (BitSet)CompilerParserException.getFieldValue(e, "set");
    }

    private static String[] getTokenNames(MismatchedTokenException e) {
        return (String[])CompilerParserException.getFieldValue(e, "tokenNames");
    }

    private static int getUpper(MismatchedTokenException e) {
        Integer value = (Integer)CompilerParserException.getFieldValue(e, "upper");
        return value;
    }

    private void fixPosition(SourceCode code) {
        if (code != null) {
            int offset = code.getOffsetFor(this.getLine(), this.getColumn());
            char[] chars = code.getText();
            --offset;
            while (offset >= 0 && offset < chars.length && Character.isWhitespace(chars[offset])) {
                --offset;
            }
            if (chars.length > (offset = Math.max(0, offset)) + 1 && chars[offset + 1] != '\n') {
                ++offset;
            }
            this.setOffset(offset);
            String text = Str.valueOf(chars);
            text = text.substring(0, offset);
            this.setLine(Str.count(text, '\n') + 1);
            this.setColumn(offset - text.lastIndexOf(10));
            this.setLength(1);
        }
    }

    private void init(@Nullable SourceCode code, RecognitionException e, boolean expression) {
        this.sourceCode = code;
        this.initCause(e);
        this.setLine(e.getLine());
        this.setColumn(e.getColumn());
        if (code != null) {
            int offset = code.getOffsetFor(e.getLine(), e.getColumn());
            this.setOffset(offset);
        }
        if (e instanceof NoViableAltException) {
            NoViableAltException alt = (NoViableAltException)((Object)e);
            if (alt.token != null) {
                String text = this.textForToken(alt.token, expression);
                this.setKey(CompilerMsg.UNEXTOKEN(text));
                FuegoToken token = (FuegoToken)alt.token;
                this.setLength(Math.min(token.getLength(), 1));
            }
        } else if (e instanceof MismatchedTokenException) {
            MismatchedTokenException me = (MismatchedTokenException)e;
            int type = CompilerParserException.getMismatchType(me);
            int expecting = CompilerParserException.getExpecting(me);
            int upper = CompilerParserException.getUpper(me);
            int[] set = CompilerParserException.getSet(me) != null ? CompilerParserException.getSet(me).toArray() : null;
            String[] names = CompilerParserException.getTokenNames(me);
            String text = this.textForToken(me.token, expression);
            FuegoToken token = (FuegoToken)me.token;
            this.setLength(Math.min(token.getLength(), 1));
            boolean state = false;
            String language = code != null ? code.getLanguage() : null;
            switch (type) {
                case 4: {
                    this.setKey(CompilerMsg.NOTREXP(CompilerParserException.tokenName(expecting, names, language, 0, expression), CompilerParserException.tokenName(upper, names, language, 0, expression), text));
                    break;
                }
                case 6: {
                    this.setKey(CompilerMsg.NOTSEXP(this.tokenNames(set, names, language, 0, expression), text));
                    break;
                }
                case 2: {
                    this.setKey(CompilerMsg.NOTEXP(text));
                    break;
                }
                case 3: {
                    this.setKey(CompilerMsg.EXPRFOUND(CompilerParserException.tokenName(expecting, names, language, 0, expression), CompilerParserException.tokenName(upper, names, language, 0, expression), text));
                    break;
                }
                case 5: {
                    this.setKey(CompilerMsg.EXPSFOUND(this.tokenNames(set, names, language, 0, expression), text));
                    break;
                }
                case 1: {
                    this.setKey(CompilerMsg.EXPFOUND(CompilerParserException.tokenName(expecting, names, language, 0, expression), text));
                }
            }
        }
    }

    private String textForToken(Token token, boolean expression) {
        String text;
        switch (token.getType()) {
            case 1: {
                text = expression ? CompilerMsg.END_OF_EXPRESSION.getString() : CompilerMsg.END_OF_METHOD.getString();
                break;
            }
            default: {
                text = "'" + token.getText() + "'";
            }
        }
        return text;
    }

    private String tokenNames(int[] tokens, String[] tokenNames, String language, int state, boolean expr) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < tokens.length; ++i) {
            buffer.append(' ');
            buffer.append(CompilerParserException.tokenName(tokens[i], tokenNames, language, state, expr));
        }
        return buffer.toString();
    }
}

