/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.IncompatibleTypesException;
import oracle.bpm.compiler.InvalidOperandException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Not;
import oracle.bpm.compiler.NumDiadic;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.CompOperator;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.Operation;
import oracle.bpm.util.CILUtils;
import org.jetbrains.annotations.NonNls;

public class Comp
extends Diadic {
    private boolean negative;
    private CompOperator operator;

    protected Comp(Token t, CompOperator op) {
        super(t);
        this.operator = op;
    }

    public static Comp greater(Node op1, Node op2) {
        Gt result = new Gt(null);
        result.setOperands(op1, op2);
        result.initialize(op1);
        return result;
    }

    public static Comp less(Node op1, Node op2) {
        Lt result = new Lt(null);
        result.setOperands(op1, op2);
        result.initialize(op1);
        return result;
    }

    public static Comp greaterEq(Node op1, Node op2) {
        Ge result = new Ge(null);
        result.setOperands(op1, op2);
        result.initialize(op1);
        return result;
    }

    public static Comp lessEq(Node op1, Node op2) {
        Le result = new Le(null);
        result.setOperands(op1, op2);
        result.initialize(op1);
        return result;
    }

    @Override
    public String getText() {
        return this.getOperator().getSymbol();
    }

    @Override
    public Node negate() throws TypeException {
        this.negative = !this.negative;
        return this;
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    public CompOperator getOperator() {
        return this.negative ? this.operator.negate() : this.operator;
    }

    public boolean isLessThan() {
        return this.operator == CompOperator.LT;
    }

    boolean isLike() {
        return this.operator == CompOperator.LIKE || this.operator == CompOperator.NOT_LIKE;
    }

    boolean isNotLike() {
        return this.operator == CompOperator.NOT_LIKE;
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        return Comp.createOperation(this, this.getOp1().getOperationTree(), this.getOp2().getOperationTree());
    }

    @Override
    Node checkType() throws TypeException {
        Node result = this;
        if (this.getOp3() != null) {
            assert (this.getOp2() instanceof Not) : this.getOp2().getClassName();
            this.getOp2().removeFromParent();
            this.negative = true;
        }
        Diadic n = (Diadic)super.checkType();
        Node o1 = n.getOp1();
        Node o2 = n.getOp2();
        this.setTypeDescription(TypeFactory.getPrimitiveBool());
        if (Kind.isNumber(o1.getKind()) && Kind.isNumber(o2.getKind())) {
            if (!this.getScope().isSQLScope()) {
                n = NumDiadic.promote(n);
            }
            o1 = n.getOp1();
            o2 = n.getOp2();
        }
        TypeDescription t1 = o1.getTypeDescription();
        TypeDescription t2 = o2.getTypeDescription();
        if (this.operator == CompOperator.LIKE && t1.getKind() != 5) {
            throw new InvalidOperandException(o1, 5);
        }
        if (this.operator == CompOperator.LIKE && t2.getKind() != 5) {
            throw new InvalidOperandException(o1, 5);
        }
        if (!t1.isComparable(t2)) {
            throw new IncompatibleTypesException(this, o1, o2);
        }
        if (!this.isGeneratingSource() && o1.isConstant() && o2.isConstant() && this.operator != CompOperator.LIKE) {
            int cmp = o1.compare(o2);
            boolean b = false;
            switch (this.operator) {
                case LT: {
                    b = cmp < 0;
                    break;
                }
                case LE: {
                    b = cmp <= 0;
                    break;
                }
                case GE: {
                    b = cmp >= 0;
                    break;
                }
                case GT: {
                    b = cmp > 0;
                }
            }
            result = new BoolConst(b);
            result.initialize(o1);
        }
        this.checkSillyOperation(o1, o2);
        if (t1.isPrimitive() != t2.isPrimitive()) {
            if (t1.isPrimitive()) {
                o1 = Conversion.promote(o1, t1.primitiveEquivalent(false));
            } else {
                o2 = Conversion.promote(o2, t2.primitiveEquivalent(false));
            }
        }
        this.setOperands(o1, o2);
        return result;
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        codeGenerator.generate(this);
    }

    @Override
    void generateSQLCode(@NonNls StringBuffer sql) {
        if (this.checkParameter(sql)) {
            return;
        }
        if (this.negative) {
            sql.append(" NOT ");
        }
        this.getOp1().generateSQLCode(sql);
        sql.append(" ").append(this.getText()).append(" ");
        this.getOp2().generateSQLCode(sql);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Object op1 = this.getOp1().value(rm);
        Object op2 = this.getOp2().value(rm);
        boolean result = false;
        switch (this.getOperator()) {
            case LT: {
                result = Any.compare(op1, op2) < 0;
                break;
            }
            case LE: {
                result = Any.compare(op1, op2) <= 0;
                break;
            }
            case GE: {
                result = Any.compare(op1, op2) >= 0;
                break;
            }
            case GT: {
                result = Any.compare(op1, op2) > 0;
                break;
            }
            case LIKE: {
                result = CILUtils.like((String)op1, (String)op2);
                break;
            }
            case NOT_LIKE: {
                result = !CILUtils.like((String)op1, (String)op2);
            }
        }
        return result;
    }

    private static Operation createOperation(Comp comp, Operation ... operands) {
        int opcode;
        CompOperator op = comp.getOperator();
        switch (op) {
            case GT: {
                opcode = 4;
                break;
            }
            case GE: {
                opcode = 6;
                break;
            }
            case LE: {
                opcode = 7;
                break;
            }
            case LIKE: {
                opcode = 70;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal operator: " + comp.operator);
            }
        }
        return new Operation(opcode, op.getSymbol(), operands);
    }

    public static class Lt
    extends Comp {
        static final long serialVersionUID = -2333325413643418407L;
        static final long serialCheck = -9047404965366693999L;

        public Lt(Token t) {
            super(t, CompOperator.LT);
        }
    }

    public static class Like
    extends Comp {
        static final long serialVersionUID = 7170702204657349804L;
        static final long serialCheck = 6858148858102293030L;

        public Like(Token t) {
            super(t, CompOperator.LIKE);
        }
    }

    public static class Le
    extends Comp {
        static final long serialVersionUID = 3478503316766594675L;
        static final long serialCheck = -7443230776101243411L;

        public Le(Token t) {
            super(t, CompOperator.LE);
        }
    }

    public static class Gt
    extends Comp {
        static final long serialVersionUID = 4668819941369126055L;
        static final long serialCheck = -5904072181081605503L;

        public Gt(Token t) {
            super(t, CompOperator.GT);
        }
    }

    public static class Ge
    extends Comp {
        static final long serialVersionUID = -2340141147657571354L;
        static final long serialCheck = -5209380028445986475L;

        public Ge(Token t) {
            super(t, CompOperator.GE);
        }
    }
}

