/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.bpm.lang.Cast;

public class CollectionPool {
    private static final Map[] hashMaps = new Map[50];
    private static int hashMapsCount = 0;
    private static final Map[] treeMaps = new Map[50];
    private static int treeMapsCount = 0;
    private static final List[] arrayLists = new List[50];
    private static int arrayListCount = 0;
    private static final Set[] hashSets = new Set[50];
    private static int hashSetCount = 0;
    private static final List[] linkedLists = new List[10];
    private static int linkedListCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> getArrayList() {
        ArrayList list = null;
        List[] listArray = arrayLists;
        synchronized (arrayLists) {
            int lastPosition = arrayListCount - 1;
            if (lastPosition >= 0) {
                list = (ArrayList)Cast.force(arrayLists[lastPosition]);
                CollectionPool.arrayLists[lastPosition] = null;
                --arrayListCount;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (list == null) {
                list = new ArrayList();
            } else if (list.size() != 0) {
                throw new IllegalStateException();
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> Map<K, V> getHashMap() {
        HashMap map = null;
        Map[] mapArray = hashMaps;
        synchronized (hashMaps) {
            int lastPosition = hashMapsCount - 1;
            if (lastPosition >= 0) {
                map = (HashMap)Cast.force(hashMaps[lastPosition]);
                CollectionPool.hashMaps[lastPosition] = null;
                --hashMapsCount;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (map == null) {
                map = new HashMap();
            } else if (map.size() != 0) {
                throw new IllegalStateException();
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Set<T> getHashSet() {
        HashSet set = null;
        Set[] setArray = hashSets;
        synchronized (hashSets) {
            int lastPosition = hashSetCount - 1;
            if (lastPosition >= 0) {
                set = (HashSet)Cast.force(hashSets[lastPosition]);
                CollectionPool.hashSets[lastPosition] = null;
                --hashSetCount;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (set == null) {
                set = new HashSet();
            } else if (set.size() != 0) {
                throw new IllegalStateException();
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> List<E> getLinkedList() {
        LinkedList list = null;
        List[] listArray = linkedLists;
        synchronized (linkedLists) {
            int lastPosition = linkedListCount - 1;
            if (lastPosition >= 0) {
                list = (LinkedList)Cast.force(linkedLists[lastPosition]);
                CollectionPool.linkedLists[lastPosition] = null;
                --linkedListCount;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (list == null) {
                list = new LinkedList();
            } else if (list.size() != 0) {
                throw new IllegalStateException();
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> Map<K, V> getTreeMap() {
        TreeMap map = null;
        Map[] mapArray = treeMaps;
        synchronized (treeMaps) {
            int lastPosition = treeMapsCount - 1;
            if (lastPosition >= 0) {
                map = (TreeMap)Cast.force(treeMaps[lastPosition]);
                CollectionPool.treeMaps[lastPosition] = null;
                --treeMapsCount;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (map == null) {
                map = new TreeMap();
            } else if (map.size() != 0) {
                throw new IllegalStateException();
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseArrayList(List list) {
        if (list == null) return;
        list.clear();
        List[] listArray = arrayLists;
        synchronized (arrayLists) {
            if (arrayListCount >= arrayLists.length) return;
            CollectionPool.arrayLists[CollectionPool.arrayListCount++] = list;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseHashMap(Map map) {
        if (map == null) return;
        assert (map instanceof HashMap);
        map.clear();
        Map[] mapArray = hashMaps;
        synchronized (hashMaps) {
            if (hashMapsCount >= hashMaps.length) return;
            CollectionPool.hashMaps[CollectionPool.hashMapsCount++] = map;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseHashSet(Set set) {
        if (set == null) return;
        set.clear();
        Set[] setArray = hashSets;
        synchronized (hashSets) {
            if (hashSetCount >= hashSets.length) return;
            CollectionPool.hashSets[CollectionPool.hashSetCount++] = set;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseLinkedList(List list) {
        if (list == null) return;
        list.clear();
        List[] listArray = linkedLists;
        synchronized (linkedLists) {
            if (linkedListCount >= linkedLists.length) return;
            CollectionPool.linkedLists[CollectionPool.linkedListCount++] = list;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseTreeMap(Map map) {
        if (map == null) return;
        assert (map instanceof TreeMap);
        map.clear();
        Map[] mapArray = treeMaps;
        synchronized (treeMaps) {
            if (treeMapsCount >= treeMaps.length) return;
            CollectionPool.treeMaps[CollectionPool.treeMapsCount++] = map;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

