/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.util.List;
import oracle.bpm.compiler.Accessor;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.Arithmetic;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.ArrayReference;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.BitwiseOp;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.ClassConst;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Comp;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompilerParserException;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstantPool;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.DefaultConst;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.Equality;
import oracle.bpm.compiler.ErrorMapping;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.ExprIf;
import oracle.bpm.compiler.ForEach;
import oracle.bpm.compiler.ForwardedMethod;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.FuegoInvokeable;
import oracle.bpm.compiler.Function;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.If;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.Is;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.Logic;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.Not;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.Parameter;
import oracle.bpm.compiler.Return;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SetElement;
import oracle.bpm.compiler.StringCat;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.compiler.Switch;
import oracle.bpm.compiler.SwitchCases;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.Term;
import oracle.bpm.compiler.Throw;
import oracle.bpm.compiler.TransformCall;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.CompOperator;
import oracle.bpm.lang.LogicOperator;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.Variable;

public class CodeKit {
    public static Node createLocalVar(String name, TypeDescription type) throws TypeException {
        Identifier var = new Identifier(name);
        Symbol symbol = new Symbol(name, type);
        Node result = new LocalVar(symbol, var);
        result = result.checkType();
        return new Deref(result);
    }

    public static Const createConst(String value, TypeDescription type) {
        return Const.valueOf(value, type, null);
    }

    public static Node createAdd(Const op1, Const op2) {
        Term.Add result = new Term.Add(null);
        result.setOperands(op1, op2);
        return result;
    }

    public static Node createBetween(Node op1, Node op2, Node variable) {
        Node leftComparison = CodeKit.createComparison(CompOperator.LE, op1, variable);
        Node rightComparison = CodeKit.createComparison(CompOperator.LE, variable, op2);
        Node between = CodeKit.createLogical(LogicOperator.AND, leftComparison, rightComparison);
        between.setParenthesis(true);
        return between;
    }

    public static Node createNotBetween(Node op1, Node op2, Node variable) {
        Node leftComparison = CodeKit.createComparison(CompOperator.GT, op1, variable);
        Node rightComparison = CodeKit.createComparison(CompOperator.GT, variable, op2);
        Node between = CodeKit.createLogical(LogicOperator.OR, leftComparison, rightComparison);
        between.setParenthesis(true);
        return between;
    }

    public static Node createComparison(CompOperator operator, Node op1, Node op2) {
        switch (operator) {
            case EQ: {
                return Equality.equals(op1, op2);
            }
            case NE: {
                return Equality.notEquals(op1, op2);
            }
            case GT: {
                return Comp.greater(op1, op2);
            }
            case LT: {
                return Comp.less(op1, op2);
            }
            case GE: {
                return Comp.greaterEq(op1, op2);
            }
            case LE: {
                return Comp.lessEq(op1, op2);
            }
        }
        throw new IllegalStateException("IllegalAccessError operator: " + operator);
    }

    public static Node createLogical(LogicOperator operator, Node op1, Node op2) {
        return operator == LogicOperator.AND ? Logic.and(op1, op2) : Logic.or(op1, op2);
    }

    public static Node createReturn(Node expression) {
        return new Return(expression);
    }

    static Throw createThrowException(String message, String name) {
        Throw throwNode = new Throw();
        throwNode.setFirst(CodeKit.createNewException(message, name));
        return throwNode;
    }

    private static Function createNewException(String message, String name) {
        MemberReference ref = new MemberReference("Fuego", "ValidationException");
        Function func = new Function();
        func.setFirst(ref);
        Const messageNode = message == null ? new NullConst() : new StringConst(message);
        func.addArg(messageNode);
        func.addArg(new StringConst(name));
        return func;
    }

    static class ValueOfCall
    extends Node {
        private ClassConst resultClass;
        private TypeDescription resultType;

        public ValueOfCall(TypeDescription resultType) {
            this.setFirst(Deref.variable("other", this));
            this.resultType = resultType;
        }

        public ClassConst getResultClass() {
            if (this.resultClass == null) {
                this.resultClass = new ClassConst(this.resultType, (Node)this);
            }
            return this.resultClass;
        }

        public TypeDescription getResultType() {
            return this.resultType;
        }

        @Override
        Node checkType() throws TypeException {
            super.checkType();
            this.setTypeDescription(this.resultType);
            return this;
        }

        @Override
        void collectConstants(ConstantPool cp) {
            super.collectConstants(cp);
            this.getResultClass().collectConstants(cp);
        }

        @Override
        void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
            codeGenerator.generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            return null;
        }
    }

    static class ValueOf
    extends SyntheticMethod {
        ValueOf(ObjectClass current) {
            this(current.getTypeDescription());
        }

        ValueOf(TypeDescription resultType) {
            this.setOverride(true);
            MethodTypeDescription method = new MethodTypeDescription("valueOf");
            method.setStatic(true);
            method.setParent(resultType);
            method.setResultType(resultType);
            method.addArgument(new Argument("other", TypeFactory.getAny(), 1L));
            this.setMethodType(method);
            this.setTypeDescription(method.getResultType());
            this.setBody(method.getName(), new Return(new ValueOfCall(resultType)));
        }
    }

    static class Validate
    extends SyntheticMethod {
        Validate(ObjectClass current) {
            this.setOverride(true);
            TypeDescription currentType = current.getTypeDescription();
            MethodTypeDescription method = new MethodTypeDescription("validate");
            method.setParent(currentType);
            method.setResultType(TypeFactory.getArray(TypeFactory.getString()));
            this.setMethodType(method);
            this.setTypeDescription(method.getResultType());
            Block statements = new Block();
            statements.addChild((AST)new Return(new DefaultConst(statements, method.getResultType())));
            this.setBody(method.getName(), statements);
        }
    }

    static class ToString
    extends SyntheticMethod {
        static final long serialVersionUID = -3481088984593338654L;
        static final long serialCheck = 3186311591954549974L;

        ToString(TypeDescription current) {
            this.setOverride(true);
            MethodTypeDescription method = new MethodTypeDescription("toString");
            method.setParent(current);
            method.setResultType(TypeFactory.getString());
            method.setProperty("methodPrefix", "");
            this.setMethodType(method);
            this.setTypeDescription(method.getResultType());
        }

        ToString(ObjectClass current) {
            this(current.getTypeDescription());
            Block statements = new Block();
            TransformCall call = new TransformCall();
            call.addChild((AST)current.createReference(this));
            call.addChild((AST)new TypeSpec(TypeFactory.getString(), this));
            call.addChild((AST)new TypeSpec(current.getTypeDescription(), this));
            statements.addChild((AST)new Return(call));
            this.setBody("toString", statements);
            this.setWrapTypedExceptions(true);
        }

        ToString(ObjectClass current, MethodTypeDescription[] fields) {
            this(current.getTypeDescription());
            this.getMethodType().addVariable(new Variable("result", TypeFactory.getString()));
            Block statements = new Block();
            this.addText((Node)statements, "result", current.getTypeDescription().getName());
            this.addText((Node)statements, "result", "(");
            boolean first = true;
            for (MethodTypeDescription member : fields) {
                Node value = new MemberReference("this", member.getName());
                if (member.getResultType().getKind() != 5) {
                    value = Conversion.Stringify.create(value, TypeFactory.getString(), member.getResultType().getJavaType());
                }
                String label = member.getName() + ": ";
                if (!first) {
                    label = ", " + label;
                }
                first = false;
                this.addText((Node)statements, "result", label);
                this.addText((Node)statements, "result", value);
            }
            this.addText((Node)statements, "result", ")");
            statements.addChild((AST)new Return(Deref.variable("result", this)));
            this.setBody("toString", statements);
            this.setWrapTypedExceptions(true);
        }

        private void addText(Node statements, String var, String text) {
            this.addText(statements, var, new StringConst(text));
        }

        private void addText(Node statements, String var, Node text) {
            StringCat cat = new StringCat(Deref.variable(var, this), text);
            statements.addChild((AST)new Assignment(new Identifier(var), cat));
        }
    }

    static class SyntheticMethod
    extends Method {
        private boolean skipGeneration;
        static final long serialVersionUID = 7037882595900590631L;
        static final long serialCheck = -8922235601616022378L;

        SyntheticMethod() {
        }

        @Override
        public final boolean isSynthetic() {
            return true;
        }

        @Override
        public void generate(CodeGenerator cg) throws CodeGenerationException {
            if (!this.skipGeneration) {
                super.generate(cg);
            }
        }

        protected void checkDuplicates() {
            MethodTypeDescription[] closestMembers;
            MethodTypeDescription currentMethod = this.getMethodType();
            ObjectTypeDescription currentType = this.getCurrentClass().getObjectType();
            for (MethodTypeDescription closestMember : closestMembers = currentType.findClosestMembers(this.getName(), 0)) {
                if (closestMember.getParent() != currentType || !TypeUtils.sameSignature(currentMethod, closestMember)) continue;
                this.skipGeneration = true;
                break;
            }
            if (this.skipGeneration) {
                this.reportWarning(new TypeException(this, CompilerMsg.OVERRIDING_DEFAULT_PK(currentType.getText(), currentMethod.getText())));
            }
        }

        @Override
        String getFullName() {
            return this.getName();
        }

        @Override
        Node checkType() throws TypeException {
            Node node = super.checkType();
            this.checkDuplicates();
            return node;
        }

        @Override
        void parse(FuegoCompiler compiler) throws CompilerException {
            this.addDeclarationsForVariables(this.getMethodType());
        }
    }

    static class Reset
    extends SyntheticMethod {
        static final long serialVersionUID = -8676040399341875933L;
        static final long serialCheck = 374929516578504363L;

        Reset(ObjectClass current, int unitCount) {
            this.setOverride(true);
            MethodTypeDescription method = new MethodTypeDescription("_reset");
            method.setParent(current.getTypeDescription());
            this.setMethodType(method);
            Block statements = new Block();
            for (int i = 0; i < unitCount; ++i) {
                statements.addChild((AST)new ClearBitSet(i));
            }
            this.setBody(method.getName(), statements);
            this.setParent(current);
            this.initialize(current);
        }
    }

    static class OldCheck
    extends SyntheticMethod {
        public OldCheck(ObjectClass current) {
            TypeDescription currentType = current.getTypeDescription();
            MethodTypeDescription method = new MethodTypeDescription("_check");
            method.setParent(currentType);
            this.setTypeDescription(method.getResultType());
            this.setMethodType(method);
            this.setBody(method.getName(), new Block());
            Args args = new Args(1L);
            args.addInArgument(current.createReference(this));
            Invoke invoke = new Invoke("check", "Fuego.Internal.Any", args);
            Block statements = this.getStatements();
            invoke.initialize(statements);
            statements.addChild((AST)invoke);
        }
    }

    static class IsModified
    extends SyntheticMethod {
        static final long serialVersionUID = 5446794948583733897L;
        static final long serialCheck = -8017810480369719509L;

        IsModified(ObjectClass current, int unitCount) {
            this.setOverride(true);
            MethodTypeDescription method = new MethodTypeDescription("_isModified");
            method.setParent(current.getTypeDescription());
            method.setResultType(TypeFactory.getPrimitiveBool());
            method.addArgument(new Argument("field", TypeFactory.getPrimitiveInt(64), 1L));
            method.setSignature(method.getJavaSignature());
            this.setMethodType(method);
            Block statements = new Block();
            if (unitCount == 0) {
                statements.addChild((AST)new Return(Const.valueOf("false", TypeFactory.getPrimitiveBool(), statements)));
            } else if (unitCount == 1) {
                statements.addChild((AST)this.createAccessForField(0L));
            } else {
                method.addVariable(new Variable("unit", TypeFactory.getPrimitiveInt(32)));
                Const bitsPerUnit = Const.valueOf(String.valueOf(64), TypeFactory.getPrimitiveInt(32), this);
                Arithmetic unitForIndex = new Arithmetic(Deref.variable("field", this), 3, bitsPerUnit);
                statements.addChild((AST)new Assignment(new Identifier("unit", this), unitForIndex));
                Switch sw = new Switch();
                sw.setFirst(Deref.variable("unit", this));
                for (int i = 0; i < unitCount; ++i) {
                    Switch.Case c = new Switch.Case();
                    SwitchCases cases = new SwitchCases();
                    cases.setFirst(Const.valueOf(String.valueOf(i), TypeFactory.getPrimitiveInt(32), this));
                    c.setFirst(cases);
                    c.addChild((AST)new Block((AST)this.createAccessForField(i)));
                    sw.addChild((AST)c);
                }
                statements.addChild((AST)sw);
                statements.addChild((AST)new Return(Const.valueOf("false", TypeFactory.getPrimitiveBool(), statements)));
            }
            this.setBody(method.getName(), statements);
            this.setParent(current);
            this.initialize(current);
        }

        private Node createAccessForField(long unit) {
            Const one = Const.valueOf("1", TypeFactory.getPrimitiveInt(64), this);
            BitwiseOp bitForField = new BitwiseOp(one, 3, Deref.variable("field", this));
            BitwiseOp op = new BitwiseOp(new BitSetReference(unit), 0, bitForField);
            Equality eq = Equality.notEquals(op, Const.valueOf("0", TypeFactory.getPrimitiveInt(64), this));
            return new Return(eq);
        }
    }

    static class IndexForField
    extends SyntheticMethod {
        static final long serialVersionUID = 1248180768505740060L;
        static final long serialCheck = 7093291984767811977L;

        IndexForField(ObjectClass current, List accessors) {
            Node ref;
            this.setOverride(true);
            int length = accessors.size();
            MethodTypeDescription method = new MethodTypeDescription("_indexForField");
            method.setParent(current.getTypeDescription());
            method.setResultType(TypeFactory.getPrimitiveInt(32));
            method.addArgument(new Argument("field", TypeFactory.getString(), 1L));
            method.addVariable(new Variable("result", TypeFactory.getInt()));
            this.setMethodType(method);
            if (length == 0) {
                ref = new IntConst(-1L, TypeFactory.getPrimitiveInt(32));
            } else {
                ArrayConst name2index = new ArrayConst();
                name2index.setMustClone(false);
                name2index.setMap(true);
                String lastAccessor = "";
                for (int i = 0; i < length; ++i) {
                    Accessor accessor = (Accessor)accessors.get(i);
                    int index = accessor.getAttrIndex();
                    if (index == -1 || accessor.getName().equals(lastAccessor)) continue;
                    StringConst name = new StringConst(accessor.getName());
                    name.setTypeDescription(TypeFactory.getString());
                    name2index.put(name, new IntConst((long)index, TypeFactory.getInt()));
                    lastAccessor = accessor.getName();
                }
                ref = new ArrayReference(name2index, Deref.variable("field", this));
            }
            Assignment result = new Assignment(new Identifier("result"), ref);
            Block statements = new Block();
            statements.addChild((AST)result);
            Is isNull = Is.nullValue(Deref.variable("result", this));
            statements.addChild((AST)new Return(new ExprIf(isNull, new IntConst(-1L, TypeFactory.getPrimitiveInt(32)), Deref.variable("result", this))));
            this.setBody(method.getName(), statements);
            this.setParent(current);
            this.initialize(current);
        }
    }

    static class HashCode
    extends SyntheticMethod {
        static final long serialVersionUID = -6787267053429544265L;
        static final long serialCheck = 7532429276778442194L;

        HashCode(ObjectClass current, MethodTypeDescription[] fields) {
            this.setOverride(true);
            MethodTypeDescription method = new MethodTypeDescription("hashCode");
            method.setParent(current.getTypeDescription());
            method.setResultType(TypeFactory.getPrimitiveInt(32));
            method.addVariable(new Variable("result", TypeFactory.getPrimitiveInt(32)));
            method.setProperty("methodPrefix", "");
            this.setMethodType(method);
            this.setTypeDescription(method.getResultType());
            Block statements = new Block();
            Const startNumber = Const.valueOf("17", TypeFactory.getPrimitiveInt(32), this);
            Assignment assign = new Assignment(new Identifier("result"), startNumber);
            statements.addChild((AST)assign);
            for (MethodTypeDescription member : fields) {
                String name = member.getName();
                Const val = Const.valueOf("37", TypeFactory.getPrimitiveInt(32), this);
                Arithmetic mul = new Arithmetic(val, 2, Deref.variable("result", this));
                MemberReference field = new MemberReference("this", name);
                TypeDescription memberType = member.getResultType();
                Node hashForField = field;
                int len = memberType.getLength();
                switch (memberType.getKind()) {
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: {
                        Invoke invoke = new Invoke(new Identifier("hashCode"), field, new Args(1L));
                        invoke.setExpression(true);
                        hashForField = invoke;
                        break;
                    }
                    case 1: {
                        IntConst one = new IntConst(1L, TypeFactory.getPrimitiveInt(32));
                        IntConst zero = new IntConst(0L, TypeFactory.getPrimitiveInt(32));
                        hashForField = new ExprIf(field, one, zero);
                        break;
                    }
                    case 2: {
                        if (len != 64) break;
                        IntConst number = new IntConst(32L, TypeFactory.getPrimitiveInt(32));
                        BitwiseOp shift = new BitwiseOp(HashCode.deepCopy(field), 5, number);
                        hashForField = new BitwiseOp(field, 2, shift);
                        hashForField = Conversion.Narrow.create(hashForField, TypeFactory.getPrimitiveInt(32));
                        break;
                    }
                    case 4: {
                        Args args = new Args(1L);
                        args.addInArgument(field);
                        String fname = len == 32 ? "floatToIntBits" : "doubleToLongBits";
                        Invoke invoke = new Invoke(new Identifier(fname), new TypeSpec(TypeFactory.getReal(len)), args);
                        invoke.setExpression(true);
                        hashForField = invoke;
                        break;
                    }
                }
                if (!memberType.isPrimitive()) {
                    IntConst zero = new IntConst(0L, TypeFactory.getPrimitiveInt(32));
                    hashForField = new ExprIf(Is.nullValue(Node.deepCopy(field)), zero, hashForField);
                }
                Arithmetic add = new Arithmetic(mul, 0, hashForField);
                assign = new Assignment(new Identifier("result"), add);
                statements.addChild((AST)assign);
            }
            statements.addChild((AST)new Return(Deref.variable("result", this)));
            statements.setScope(this.getScope());
            this.setBody(this.getMethodType().getName(), statements);
            this.setWrapTypedExceptions(true);
        }
    }

    static class Equals
    extends SyntheticMethod {
        static final long serialVersionUID = 8743412392977269428L;
        static final long serialCheck = -3684127853050706821L;

        Equals(ObjectClass current, MethodTypeDescription[] fields) {
            this.setOverride(true);
            MethodTypeDescription method = new MethodTypeDescription("equals");
            method.setParent(current.getTypeDescription());
            method.getResultArgument().setType(TypeFactory.getPrimitiveBool());
            method.addArgument(new Argument("other", TypeFactory.getRootObject(), 1L));
            method.addVariable(new Variable("that", current.getTypeDescription()));
            method.setProperty("methodPrefix", "");
            this.setMethodType(method);
            this.setTypeDescription(method.getResultType());
            TypeDescription type = this.getMethodType().getParent();
            Block statements = new Block();
            Deref other = Deref.variable("other", this);
            Block block = new Block();
            block.addChild((AST)new Assignment(new Identifier("that"), Conversion.Cast.create(other, type)));
            Diadic compare = null;
            for (MethodTypeDescription member : fields) {
                String name = member.getName();
                MemberReference otherField = new MemberReference("that", name);
                MemberReference currentField = new MemberReference("this", name);
                Equality eq = Equality.equals(currentField, otherField);
                compare = compare == null ? eq : Logic.and(compare, eq);
            }
            block.addChild((AST)new Return(compare));
            statements.addChild((AST)If.condition(Is.create(other, new TypeSpec(type, (Token)null)), block));
            statements.addChild((AST)new Return(new BoolConst(false)));
            statements.setScope(this.getScope());
            this.setBody(this.getMethodType().getName(), statements);
            this.setWrapTypedExceptions(true);
        }
    }

    static class Copy
    extends SyntheticMethod {
        static final long serialVersionUID = 4016117810122527862L;
        static final long serialCheck = 38468437195463035L;

        Copy(ObjectClass current) {
            this.setOverride(true);
            MethodTypeDescription method = new MethodTypeDescription("xo$copy");
            method.setParent(current.getTypeDescription());
            method.addArgument(new Argument("other", TypeFactory.getAny(), 1L));
            this.setMethodType(method);
            this.setTypeDescription(method.getResultType());
            Block body = new Block();
            this.setBody(method.getName(), body);
        }
    }

    static class CompareTo
    extends SyntheticMethod {
        static final long serialVersionUID = 3851600860139674393L;
        static final long serialCheck = -4282642001272758434L;

        CompareTo(ObjectClass current, MethodTypeDescription[] fields) {
            this.setOverride(true);
            MethodTypeDescription method = new MethodTypeDescription("compareTo");
            method.setParent(current.getTypeDescription());
            Argument retArg = method.getResultArgument();
            retArg.setType(TypeFactory.getPrimitiveInt(32));
            method.addArgument(new Argument("other", TypeFactory.getAny(), 1L));
            method.addVariable(new Variable("result", TypeFactory.getPrimitiveInt(32)));
            method.addVariable(new Variable("that", method.getParent()));
            this.setMethodType(method);
            this.setTypeDescription(method.getResultType());
            TypeDescription type = this.getMethodType().getParent();
            Block statements = new Block();
            Deref other = Deref.variable("other", this);
            TypeSpec otherType = new TypeSpec(type, (Token)null);
            Block block = new Block();
            block.addChild((AST)new Assignment(new Identifier("that"), Conversion.Cast.create(other, type)));
            int length = fields.length;
            Node currentIf = null;
            for (int i = 0; i < length; ++i) {
                Diadic node;
                MethodTypeDescription field = fields[i];
                String name = field.getName();
                Node otherField = new MemberReference("that", name);
                Node thisField = new MemberReference("this", name);
                TypeDescription memberType = field.getResultType();
                int kind = memberType.getKind();
                if (kind == 2 && memberType.getLength() <= 32) {
                    node = new Arithmetic(thisField, 1, otherField);
                } else if (kind == 4 || kind == 2) {
                    Comp cond = Comp.greater(CompareTo.deepCopy(thisField), CompareTo.deepCopy(otherField));
                    ExprIf exprIf = new ExprIf(cond, this.num(1), this.num(0));
                    node = new ExprIf(Comp.less(thisField, otherField), this.num(-1), exprIf);
                } else {
                    Args args = new Args(1L);
                    if (memberType.isPrimitive()) {
                        thisField = Conversion.Box.create(thisField, memberType);
                        otherField = Conversion.Box.create(otherField, memberType);
                    }
                    args.addInArgument(thisField);
                    args.addInArgument(otherField);
                    node = new Invoke(new Identifier("compare"), this.any(), args);
                    node.setExpression(true);
                }
                Assignment assign = new Assignment(this.result(), node);
                If ifNode = If.condition(Equality.equals(this.result(), this.num(0)), assign);
                if (currentIf == null) {
                    block.addChild((AST)ifNode);
                } else {
                    currentIf.getOp2().addChild((AST)ifNode);
                }
                currentIf = ifNode;
            }
            block.addChild((AST)new Return(this.result()));
            statements.addChild((AST)If.condition(Is.create(other, otherType), block));
            statements.addChild((AST)new Return(this.num(-1)));
            statements.setScope(this.getScope());
            this.setBody(this.getMethodType().getName(), statements);
            this.setWrapTypedExceptions(true);
        }

        private TypeSpec any() {
            try {
                return new TypeSpec(TypeUtils.getDefaultCatalog().find("Fuego.Internal.Any").get(), (Token)null);
            }
            catch (AmbiguousTypeNameException e) {
                assert (false) : e;
                return null;
            }
        }

        private IntConst num(int value) {
            return new IntConst(value);
        }

        private Deref result() {
            return Deref.variable("result", this);
        }
    }

    static class CloneCall
    extends Node {
        static final long serialVersionUID = 8891379933831731966L;
        static final long serialCheck = -5830593800249505261L;

        public CloneCall(Node init) {
            this.setFirst(Deref.variable("this", init));
        }

        @Override
        Node checkType() throws TypeException {
            Node result = super.checkType();
            this.setTypeDescription(TypeFactory.getAny());
            return result;
        }

        @Override
        void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
            codeGenerator.generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            Object instance = this.getOp1().value(rm);
            return Any.deepCopy(instance);
        }
    }

    static class Clone
    extends SyntheticMethod {
        static final long serialVersionUID = -5770420684318559013L;
        static final long serialCheck = -5347560085119424789L;

        Clone(ObjectClass current) {
            this.setOverride(true);
            MethodTypeDescription method = new MethodTypeDescription("clone");
            method.setParent(current.getTypeDescription());
            method.setResultType(TypeFactory.getAny());
            this.setMethodType(method);
            this.setTypeDescription(method.getResultType());
            this.setBody(method.getName(), new Return(new CloneCall(current)));
        }
    }

    static class ClearBitSet
    extends BitSetOper {
        static final long serialVersionUID = 2764857560563015870L;
        static final long serialCheck = -97961765997039804L;

        ClearBitSet(int unit) {
            super(unit);
            this.setTypeDescription(TypeFactory.getVoid());
        }

        @Override
        public boolean isSynthetic() {
            return true;
        }

        @Override
        void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
            codeGenerator.generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            ObjectClass current = this.getCurrentClass();
            FuegoInvokeable instance = (FuegoInvokeable)current.getSymbol().getValue();
            instance.setField(this.fieldName, 0L);
            return null;
        }
    }

    static class Check
    extends SyntheticMethod {
        private boolean hasValidations = false;
        static final long serialVersionUID = 6436477001707952524L;
        static final long serialCheck = 3258239671982124202L;

        public Check(ObjectClass current) {
            TypeDescription currentType = current.getTypeDescription();
            MethodTypeDescription method = new MethodTypeDescription("_check");
            method.setParent(currentType);
            method.addArgument(new Argument("checked", TypeFactory.getSet(TypeFactory.getAny()), 1L, -1, "java.util.Set"));
            this.setTypeDescription(method.getResultType());
            this.setMethodType(method);
            Block statements = new Block();
            this.setBody(method.getName(), statements);
        }

        public void addCheck(Node expression, String name, MethodTypeDescription member) {
            this.addCheck(expression, name, member, null);
        }

        public void addCheck(Node expression, String name, MethodTypeDescription member, String message) {
            this.hasValidations = true;
            if (message != null) {
                message = "\"" + message + "\"";
            }
            String exc = "Fuego.ValidationException(" + message + ", \"" + name + "\")";
            Node assignment = this.createCode("first = Fuego.ValidationException.append(first, " + exc + ")");
            Node check = If.condition(Not.not(expression), assignment);
            Block statements = this.getStatements();
            check = new ErrorMapping(check, member, 6);
            check.initialize(statements);
            statements.addChild((AST)check);
        }

        public void addInnerCheck(String name, TypeDescription type) {
            Args args = new Args(1L);
            Node current = this.getCurrentClass().createReference(this);
            MemberReference memberRef = new MemberReference(current, new Identifier(name));
            args.addInArgument(memberRef);
            args.addInArgument(Deref.variable("checked", this));
            Invoke invoke = new Invoke("check", "Fuego.Internal.Any", args);
            Block statements = this.getStatements();
            invoke.initialize(statements);
            statements.addChild((AST)invoke);
        }

        public void addArrayCheck(String name, TypeDescription elemType) {
            Block statements = this.getStatements();
            Node current = this.getCurrentClass().createReference(this);
            MemberReference arrayRef = new MemberReference(current, new Identifier(name));
            ForEach forEach = new ForEach();
            Parameter row = new Parameter("_row_");
            Args args = new Args(1L);
            args.addInArgument(Deref.variable("_row_", forEach));
            args.addInArgument(Deref.variable("checked", this));
            Invoke invoke = new Invoke("check", "Fuego.Internal.Any", args);
            forEach.setOperands(row, arrayRef, invoke);
            forEach.initialize(statements);
            statements.addChild((AST)forEach);
        }

        @Override
        Node checkType() throws TypeException {
            if (this.hasValidations) {
                Scope scope = this.getScope();
                assert (scope != null);
                Block declarations = this.getDeclarations();
                TypeDescription type = this.findType("Fuego.ValidationException");
                assert (type != null) : "Fuego.ValidationException not found";
                declarations.addChild((AST)new Declaration("first", type, new NullConst()));
                Block statements = this.getStatements();
                statements.addChild((AST)this.createCode("if (first is not null) then throw first end"));
                declarations.setScope(scope);
                statements.setScope(this.getScope());
            }
            return super.checkType();
        }

        private Node createCode(String code) {
            Node result = null;
            try {
                result = this.getCompiler().parseFuegoCode(code, null);
            }
            catch (CompilerParserException e) {
                this.reportError(e);
            }
            catch (InvalidLanguageException e) {
                this.reportError(e);
            }
            return result;
        }
    }

    static class BitSetReference
    extends BitSetOper {
        public BitSetReference(long unit) {
            super(unit);
            this.setTypeDescription(TypeFactory.getPrimitiveInt(32));
        }

        @Override
        public boolean isSynthetic() {
            return true;
        }

        @Override
        void generate(CodeGenerator cg) throws CodeGenerationException {
            cg.generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            ObjectClass current = this.getCurrentClass();
            FuegoInvokeable instance = (FuegoInvokeable)current.getSymbol().getValue();
            return instance.getField(this.fieldName);
        }
    }

    static class BitSetOper
    extends Node {
        protected String fieldName;

        public BitSetOper(long unit) {
            this.fieldName = "__bitSet" + unit;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }

    protected static class SetBitSet
    extends BitSetOper {
        private long bitIndex;

        SetBitSet(Node init, int unit, long bitIndex) {
            super(unit);
            this.bitIndex = bitIndex;
            this.initialize(init);
            this.setTypeDescription(TypeFactory.getVoid());
            this.setSynthetic(true);
        }

        public long getBitIndex() {
            return this.bitIndex;
        }

        @Override
        void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
            codeGenerator.generate(this);
        }

        @Override
        Object run(RunningMonitor rm) throws ExecutionException {
            ObjectClass current = this.getCurrentClass();
            FuegoInvokeable instance = (FuegoInvokeable)current.getSymbol().getValue();
            Long value = (Long)instance.getField(this.fieldName);
            if (value == null) {
                value = 0L;
            }
            value = value | this.bitIndex;
            instance.setField(this.fieldName, value);
            return null;
        }
    }

    public static class MethodCache
    extends SyntheticMethod {
        public MethodTypeDescription noCacheMember;
        static final String CACHE_KEY = "cacheKey";
        private static final String CACHE_RESULT = "cacheResult";
        static final long serialVersionUID = -5770420684318559013L;
        static final long serialCheck = -5347560085119424789L;

        public MethodCache(ObjectClass objectClass, String fieldName, MethodTypeDescription member, MethodTypeDescription noCacheMember) {
            this.setMethodType(member);
            this.setTypeDescription(member.getResultType());
            this.noCacheMember = noCacheMember;
            Block statements = new Block();
            statements.addChild((AST)this.generateCacheKey());
            statements.addChild((AST)this.generateGetResultFromFieldCache(objectClass, fieldName));
            statements.addChild((AST)this.generateCodeForCheckCacheMiss(objectClass, fieldName, noCacheMember));
            if (this.getTypeDescription().getKind() != 0) {
                Return ret = new Return(this.getElementFromCache(0, this.getTypeDescription()));
                statements.addChild((AST)ret);
            }
            this.setBody(member.getName(), statements);
        }

        @Override
        protected void checkDuplicates() {
        }

        @Override
        Object run(RunningMonitor rm, Object[] argValues, FuegoInvokeable instance) throws ExecutionException {
            ObjectClass objectClass = (ObjectClass)this.getParent();
            List<Method> methodList = objectClass.getMethods();
            for (Method method : methodList) {
                if (this.noCacheMember == null || !method.getMethodType().equality(this.noCacheMember)) continue;
                return method.run(rm, argValues, instance);
            }
            throw new IllegalStateException("Illegal state exception");
        }

        @Override
        Node checkType() throws TypeException {
            return super.checkType();
        }

        private Node generateCodeForCheckCacheMiss(ObjectClass objectClass, String fieldName, MethodTypeDescription noCacheMember) {
            MethodTypeDescription member = this.getMethodType();
            If ifNode = new If();
            ifNode.addChild((AST)Is.nullValue(Deref.variable(CACHE_RESULT, this)));
            Block ifNullBlock = this.generateKeyNotInCacheBlock(objectClass, noCacheMember, member, fieldName);
            ifNode.addChild((AST)ifNullBlock);
            Block ifNotNullBlock = this.generateKeyInCacheBlock(member);
            ifNode.addChild((AST)ifNotNullBlock);
            return ifNode;
        }

        private Block generateKeyInCacheBlock(MethodTypeDescription member) {
            Block elseBlock = new Block();
            if (member.getOutputArgumentCount() > 0) {
                int argn = this.getTypeDescription().isVoid() ? 0 : 1;
                for (int i = 0; i < member.getArgumentCount(); ++i) {
                    Argument arg = member.getArgument(i);
                    if (!arg.isOut()) continue;
                    Deref var = Deref.variable(arg.getName(), this);
                    Node expr = this.getElementFromCache(argn, arg.getType());
                    Assignment assignment = new Assignment(var, expr);
                    elseBlock.addChild((AST)assignment);
                    ++argn;
                }
            }
            return elseBlock;
        }

        private Node getElementFromCache(int index, TypeDescription elemType) {
            Node expr = new ArrayReference(Deref.variable(CACHE_RESULT, this), new IntConst(index));
            expr = Conversion.Cast.create(expr, elemType.primitiveEquivalent(false));
            return expr;
        }

        private Block generateKeyNotInCacheBlock(ObjectClass objectClass, MethodTypeDescription noCacheMember, MethodTypeDescription member, String fieldName) {
            Block ifBlock = new Block();
            ifBlock.addChild((AST)new Assignment(new Identifier(CACHE_RESULT), new ArrayConst()));
            Node noCacheInvocation = ForwardedMethod.createCall(objectClass, noCacheMember, objectClass.createStaticReference(this), false);
            noCacheInvocation.setExpression(true);
            int cacheFieldIndex = 0;
            if (!this.getTypeDescription().isVoid()) {
                SetElement setNoChacheMethodResult = new SetElement();
                setNoChacheMethodResult.addChild((AST)new Identifier(CACHE_RESULT));
                setNoChacheMethodResult.addChild((AST)new IntConst(cacheFieldIndex));
                setNoChacheMethodResult.addChild((AST)noCacheInvocation);
                noCacheInvocation = setNoChacheMethodResult;
                ++cacheFieldIndex;
            }
            ifBlock.addChild((AST)noCacheInvocation);
            for (int i = 0; i < noCacheMember.getArgumentCount(); ++i) {
                Argument arg = member.getArgument(i);
                if (!arg.isOut()) continue;
                SetElement storeArgsResult = new SetElement();
                storeArgsResult.addChild((AST)new Identifier(CACHE_RESULT));
                storeArgsResult.addChild((AST)new IntConst(cacheFieldIndex));
                storeArgsResult.addChild((AST)Deref.variable(arg.getName(), this));
                ifBlock.addChild((AST)storeArgsResult);
                ++cacheFieldIndex;
            }
            Args args = new Args(1L);
            args.addChild((AST)Deref.variable(CACHE_KEY, this));
            args.addChild((AST)Conversion.Cast.create(Deref.variable(CACHE_RESULT, this), TypeFactory.getRootObject()));
            MemberReference fieldRef = new MemberReference(objectClass.createStaticReference(this), new Identifier(fieldName));
            Invoke invokePutInCache = new Invoke(new Identifier("put"), fieldRef, args);
            ifBlock.addChild((AST)invokePutInCache);
            return ifBlock;
        }

        private Node generateGetResultFromFieldCache(ObjectClass objectClass, String fieldName) {
            ArrayTypeDescription arrayOfAny = TypeFactory.getArray(TypeFactory.getAny());
            this.getMethodType().addVariable(new Variable(CACHE_RESULT, arrayOfAny));
            Args args = new Args(1L);
            args.addChild((AST)Deref.variable(CACHE_KEY, this));
            MemberReference fieldRef = new MemberReference(objectClass.createStaticReference(this), new Identifier(fieldName));
            Invoke invoke = new Invoke(new Identifier("get"), fieldRef, args);
            invoke.setStatement(false);
            return new Assignment(new Identifier(CACHE_RESULT), Conversion.Cast.create(invoke, arrayOfAny));
        }

        private Node generateCacheKey() {
            Node initializer;
            MethodTypeDescription member = this.getMethodType();
            int argc = member.getArgumentCount();
            int inputArgc = member.getInputArgumentCount();
            member.addVariable(new Variable(CACHE_KEY, TypeFactory.getAny()));
            if (inputArgc != 0) {
                initializer = new Function();
                Identifier constructorIdentifier = new Identifier("DynamicTuple");
                initializer.addChild((AST)constructorIdentifier);
                initializer.addChild((AST)new Arg.Type(1L));
                ArrayConst contArg = new ArrayConst();
                for (int i = 0; i < argc; ++i) {
                    Argument arg = member.getArgument(i);
                    if (!arg.isIn()) continue;
                    contArg.addChild((AST)Deref.variable(arg.getName(), this));
                }
                initializer.addChild((AST)contArg);
            } else {
                initializer = new BoolConst(false);
            }
            return new Assignment(new Identifier(CACHE_KEY), initializer);
        }
    }
}

