/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.bcgen.ClassCode;
import fuego.bcgen.FieldD;
import fuego.bcgen.JVMCodeBuilder;
import fuego.bcgen.MethodD;
import fuego.bcgen.Mod;
import fuego.bcgen.TD;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.FieldDeclaration;
import oracle.bpm.compiler.InternalException;
import oracle.bpm.compiler.JVMByteCodeGenerator;
import oracle.bpm.compiler.MDKit;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.io.ObjectSerialization;
import oracle.bpm.io.ReferenceManager;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jetbrains.annotations.Nullable;

public class ClassGenerator {
    protected void readObject(ObjectInputStream in) throws IOException {
        ObjectSerialization.customReadObject(this, in, false, false);
    }

    static void generate(ObjectClass objectClass, JVMByteCodeGenerator cg) throws CodeGenerationException {
        ClassGenerator.generateInterfaces(objectClass, cg.getClassCode());
        ClassGenerator.generateCustomizedReadObject(objectClass, cg.getClassCode());
        ClassGenerator.generateCustomizedWriteObject(objectClass, cg.getClassCode());
        ClassGenerator.generateCustomSerializationPersistentFields(objectClass, cg.getClassCode());
        ClassGenerator.generateTraceField(objectClass, cg.getClassCode());
        if (objectClass.hasMappings()) {
            ClassGenerator.generateMappingsField(objectClass, cg.getClassCode());
        }
        if (!objectClass.hasEmptyConstructor()) {
            cg.getClassCode().addConstructor(Mod.PRIVATE);
        }
        for (Node current = objectClass.getFirst(); current != null; current = current.getNext()) {
            try {
                objectClass.generatingMessage(current);
                current.gen(cg);
                continue;
            }
            catch (CodeGenerationException e) {
                throw e;
            }
            catch (Throwable e) {
                objectClass.reportError(new InternalException(current, e));
            }
        }
    }

    static void generateInterfaces(ObjectClass objectClass, ClassCode classCode) {
        ObjectTypeDescription objType = objectClass.getObjectType();
        for (SuperType st : objType.getSuperTypes()) {
            TypeDescription superType = st.getType();
            if (!superType.isInterface()) continue;
            classCode.addInterface(superType.javaType());
        }
        if (objectClass.isGenerateBitSets()) {
            classCode.addInterface(ObjectClass.MODIFIABLE_INTERFACE);
        }
        if (objectClass.isReplaceable()) {
            classCode.addInterface(ObjectClass.REPLACEABLE_INTERFACE);
        }
        if (Modifier.isComparable(objType.getModifiers())) {
            classCode.addInterface(ObjectClass.COMPARABLE_INTERFACE);
        }
    }

    static void generateMappingsField(ObjectClass objectClass, ClassCode classCode) throws CodeGenerationException {
        FieldD field = classCode.addField(Mod.PRIVATE.STATIC().FINAL(), (Type)TD.MAP, "_MAPPINGS");
        JVMCodeBuilder codeBuilder = classCode.getInitializer();
        codeBuilder.createMap(objectClass.getMappings());
        codeBuilder.storeField(field);
    }

    static void generateTraceField(ObjectClass objectClass, ClassCode classCode) throws CodeGenerationException {
        FieldD field = classCode.addField(Mod.PRIVATE.STATIC().FINAL(), (Type)TD.TRACE, "$TRACE");
        JVMCodeBuilder codeBuilder = classCode.getInitializer();
        codeBuilder.loadConstant(objectClass.getObjectType().getText());
        codeBuilder.invoke(MDKit.TRACE_GETINSTANCE);
        codeBuilder.storeField(field);
    }

    static void generateCustomSerializationFields(ClassCode classCode) {
        classCode.addField(Mod.PUBLIC.TRANSIENT(), (Type)TD.MAP, "existingUnsetFields");
        classCode.addField(Mod.PUBLIC.TRANSIENT(), (Type)TD.SET, "transientSetFields");
    }

    static void generateCustomSerializationPersistentFields(ObjectClass objectClass, ClassCode classCode) throws CodeGenerationException {
        ObjectTypeDescription objType = objectClass.getObjectType();
        String customizeReadObject = objType.getProperty("customizeObjectSerialization");
        if (customizeReadObject != null && Boolean.valueOf(customizeReadObject).booleanValue()) {
            List<FieldDeclaration> declarationList = objectClass.getFields();
            ArrayList persistentFields = new ArrayList();
            CollectionUtils.selectInto(declarationList, new Predicate<FieldDeclaration>(){

                @Override
                public boolean check(@Nullable FieldDeclaration value) {
                    return value != null && value.isPersistent();
                }
            }, persistentFields);
            JVMCodeBuilder codeBuilder = classCode.getInitializer();
            ObjectType objectStreamFieldType = TD.getObjectType("java.io.ObjectStreamField");
            ArrayType arrayType = TD.getArrayType((Type)objectStreamFieldType);
            FieldD field = classCode.addField(Mod.PRIVATE.STATIC().FINAL(), (Type)arrayType, "serialPersistentFields");
            codeBuilder.createArray(arrayType, persistentFields.size());
            if (!persistentFields.isEmpty()) {
                for (int position = 0; position < persistentFields.size(); ++position) {
                    FieldDeclaration fieldDeclaration = (FieldDeclaration)persistentFields.get(position);
                    TypeDescription typeDescription = fieldDeclaration.getObjectType().primitiveEquivalent(false);
                    String fieldName = fieldDeclaration.getName();
                    String javaClassName = typeDescription.isBpmObject() ? typeDescription.getJavaType() : typeDescription.getJavaClass().getName();
                    codeBuilder.dup();
                    codeBuilder.loadConstant(position);
                    codeBuilder.newObject((Type)objectStreamFieldType);
                    codeBuilder.dup();
                    codeBuilder.loadConstant(ObjectSerialization.resolvePersistentFieldName(fieldName));
                    codeBuilder.loadClassConstant(javaClassName);
                    codeBuilder.invokeConstructor(objectStreamFieldType, new Type[]{TD.STRING, TD.CLASS});
                    codeBuilder.arrayStore();
                }
            }
            codeBuilder.storeField(field);
        }
    }

    private static void generateCustomizedWriteObject(ObjectClass objectClass, ClassCode classCode) throws CodeGenerationException {
        boolean isCustomizeObjectSerialization;
        ObjectTypeDescription objType = objectClass.getObjectType();
        String customizeObjectSerialization = objType.getProperty("customizeObjectSerialization");
        boolean bl = isCustomizeObjectSerialization = customizeObjectSerialization != null && Boolean.valueOf(customizeObjectSerialization) != false;
        if (isCustomizeObjectSerialization) {
            JVMCodeBuilder cg = classCode.addMethod(Mod.PRIVATE, TD.VOID, "writeObject", new Type[]{TD.OBJECT_OUTPUT_STREAM}, new String[]{"out"}, new Type[]{TD.IO_EXCEPTION});
            MethodD customReadObject = MethodD.createStatic(TD.VOID, TD.getObjectType(ObjectSerialization.class), "customWriteObject", new Type[]{TD.OBJECT, TD.OBJECT_OUTPUT_STREAM});
            cg.loadThis();
            cg.loadArgument(0);
            cg.invoke(customReadObject);
            cg.retrn();
            cg.endCode();
        }
    }

    private static void generateCustomizedReadObject(ObjectClass objectClass, ClassCode classCode) throws CodeGenerationException {
        ObjectTypeDescription objType = objectClass.getObjectType();
        String customizeReadObject = objType.getProperty("customizeReadObject");
        String customizeObjectSerialization = objType.getProperty("customizeObjectSerialization");
        boolean isCustomizeReadObject = Boolean.parseBoolean(customizeReadObject);
        boolean isCustomizeObjectSerialization = Boolean.parseBoolean(customizeObjectSerialization);
        if (isCustomizeReadObject || isCustomizeObjectSerialization) {
            ClassGenerator.generateCustomSerializationFields(classCode);
            JVMCodeBuilder cg = classCode.addMethod(Mod.PRIVATE, TD.VOID, "readObject", new Type[]{TD.OBJECT_INPUT_STREAM}, new String[]{"in"}, new Type[]{TD.IO_EXCEPTION});
            MethodD customReadObject = MethodD.createStatic(TD.VOID, TD.getObjectType(ObjectSerialization.class), "customReadObject", new Type[]{TD.OBJECT, TD.OBJECT_INPUT_STREAM, TD.BOOLEAN, TD.BOOLEAN});
            cg.loadThis();
            cg.loadArgument(0);
            cg.loadConstant(isCustomizeObjectSerialization);
            cg.loadConstant(false);
            cg.invoke(customReadObject);
            cg.retrn();
            cg.endCode();
        } else if (ReferenceManager.isDebugEnabled()) {
            // empty if block
        }
    }
}

