/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.ConversionException;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Is;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.lang.JavaObject;
import oracle.bpm.lang.RuntimeCILExecutionException;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;

public class Cast
extends Diadic {
    private boolean funtionalSyntax;
    private boolean wrapped = false;
    static final long serialVersionUID = 1478394125643368242L;
    static final long serialCheck = -5519986685748340326L;

    public Cast(Token t) {
        super(t);
        this.setTypeDescription(TypeFactory.getNone());
    }

    public Cast(AST expr, TypeDescription type) {
        this(expr, (AST)new TypeSpec(type, (Token)null));
    }

    public Cast(AST expr, AST type) {
        super(expr, type);
    }

    Cast() {
    }

    public static boolean isConvertible(TypeDescription exprType, TypeDescription targetType) {
        return Conversion.isConvertible(exprType, targetType);
    }

    public void setFuntionalSyntax(boolean funtionalSyntax) {
        this.funtionalSyntax = funtionalSyntax;
    }

    public boolean isFuntionalSyntax() {
        return this.funtionalSyntax;
    }

    @Override
    public String getText() {
        return "cast";
    }

    public Node getExpr() {
        Node expr = this.getOp1();
        if (this.wrapped && expr.isConversion()) {
            Conversion conversion = (Conversion)expr;
            expr = conversion.getOperand();
        }
        return expr;
    }

    public Node getTargetType() {
        return this.getOp2();
    }

    @Override
    public void generate(SourceGenerator cw) {
        cw.generate(this);
    }

    @Override
    boolean isComplexExpression() {
        return true;
    }

    @Override
    Node checkType() throws TypeException {
        super.checkType();
        Node expr = this.getOp1();
        Node type = this.getOp2();
        TypeDescription exprType = expr.getTypeDescription();
        TypeDescription targetType = type.getTypeDescription();
        if (!Cast.isConvertible(exprType, targetType)) {
            throw new ConversionException((Node)this, exprType, targetType);
        }
        Node conversion = Conversion.promote(expr, targetType);
        this.wrapped = conversion != expr;
        this.setOperands(conversion, type);
        this.setTypeDescription(targetType);
        return this;
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        this.getOp1().gen(codeGenerator);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Object target;
        TypeDescription targetType = this.getTypeDescription();
        Object result = this.getOp1().run(rm);
        if (result instanceof Symbol) {
            result = ((Symbol)result).getValue();
        }
        if ((target = result instanceof JavaObject ? ((JavaObject)result).getTarget() : result) instanceof RuntimeCILExecutionException) {
            result = ((RuntimeCILExecutionException)target).getObject();
        }
        if (result != null && !Is.run(targetType, result)) {
            throw new ClassCastException("Invalid cast from '" + result.toString() + "' to '" + targetType + "'");
        }
        return result;
    }
}

