/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.cil.CilException;
import oracle.bpm.cil.UsageListener;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.compiler.CCILOptionParser;
import oracle.bpm.compiler.CompiledTemplate;
import oracle.bpm.compiler.CompilerException;
import oracle.bpm.compiler.CompletionResult;
import oracle.bpm.compiler.CompletionSuggestion;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.InternalException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.SourceTemplate;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.ComponentNotFoundException;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.catalog.DirectoryComponentBundle;
import oracle.bpm.type.catalog.JarComponentBundle;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.FixOption;
import oracle.bpm.util.FuegoDirectories;
import oracle.bpm.util.ProgressMonitor;

public class CCIL
implements UsageListener {
    private ComponentCatalog catalog;
    private FuegoCompiler compiler;
    private ObjectTypeDescription defaultTarget;
    private StringList files;
    private CCILOptionParser options;

    public CCIL(CCILOptionParser options, StringList args) {
        this.options = options;
        this.files = args;
    }

    public static void main(String[] args) {
        try {
            CCILOptionParser optionParser = new CCILOptionParser(args);
            StringList arguments = optionParser.parse();
            if (arguments.isEmpty()) {
                optionParser.printHelp();
            } else {
                CCIL compiler = new CCIL(optionParser, arguments);
                compiler.defineCatalog();
                compiler.compile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void addMethod(String file) throws FileNotFoundException, IOException {
        int read;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuffer source = new StringBuffer();
        char[] buffer = new char[1024];
        while ((read = reader.read(buffer)) > 0) {
            source.append(buffer, 0, read);
        }
        MethodTypeDescription method = new MethodTypeDescription("main");
        method.getResultArgument().setName("result");
        method.setFullParsing(!this.options.parsebody());
        char[] code = new char[source.length()];
        source.getChars(0, code.length, code, 0);
        method.setCode(code, this.options.getLanguage());
        method.setSignature(method.getJavaSignature());
        String modifiersText = this.options.getModifiers();
        if (modifiersText != null) {
            method.setModifiers(Modifier.getModifiers(modifiersText));
        }
        this.getDefaultTarget().addMember(method);
    }

    @Override
    public void reportError(CilException exception) {
        CCIL.reportError(exception, this.options);
    }

    @Override
    public void reportWarning(CilException e) {
        if (this.options.isNowarn()) {
            return;
        }
        MethodTypeDescription member = (MethodTypeDescription)e.getMember();
        String memberName = e.getMemberName();
        if (member != null && member.getParent() != null) {
            memberName = member.getParent().getText() + "." + memberName;
        }
        System.out.println("\nWarning: " + memberName + ":" + e.getLine() + ":" + e.getColumn() + ":" + e.getMessage());
        if (member != null && member.getCode() != null) {
            System.err.print(member.getCode().getLineForError(e));
        }
        CCIL.checkFix(e, this.options);
        if (this.options.printStackTrace()) {
            e.printStackTrace();
        }
    }

    @Override
    public void usage(int offset, int length, int type) {
        if (this.options.isUsages()) {
            String text = "";
            switch (type) {
                case 1: {
                    text = "local";
                    break;
                }
                case 3: {
                    text = "instance";
                    break;
                }
                case 2: {
                    text = "arg";
                }
            }
            System.out.println("Usage: offset: " + offset + ", length: " + length + ", " + text);
        }
    }

    void compile() throws CilException, ComponentNotFoundException, AmbiguousTypeNameException {
        this.setUpCompiler();
        for (String file : this.files) {
            try {
                if (this.isScript(file)) {
                    this.addMethod(file);
                    continue;
                }
                TypeRef ref = this.catalog.find(file);
                if (ref == null) {
                    throw new IOException("Type was not found in catalog: '" + file + "'");
                }
                this.compiler.addObjectClass(ref.get().asObject());
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
        if (this.defaultTarget != null) {
            String delegate = this.options.getDelegate();
            if (delegate != null) {
                this.defaultTarget.setSuperTypes(this.loadDelegates(delegate));
            }
            this.compiler.addObjectClass(this.defaultTarget);
        }
        try {
            String complete = this.options.getComplete();
            if (complete != null) {
                MethodTypeDescription memberToComplete = null;
                int offset = -1;
                int index = complete.indexOf(58);
                if (index != -1) {
                    offset = Integer.parseInt(complete.substring(index + 1));
                } else {
                    String[] memberPath = complete.split("\\.");
                    String lastPart = memberPath[memberPath.length - 1];
                    if (this.defaultTarget != null) {
                        memberToComplete = this.defaultTarget.findMember(lastPart);
                        if (memberToComplete == null) {
                            throw new IllegalArgumentException(complete);
                        }
                        String code = new String(memberToComplete.getCodeText());
                        memberToComplete.setCode(code, memberToComplete.getCodeLanguage());
                        offset = Math.max(code.length() - 1, 0);
                    }
                }
                assert (offset >= 0) : offset;
                System.out.println("Suggestions:");
                CompletionResult result = this.compiler.complete(memberToComplete, offset);
                if (result != null) {
                    CompletionSuggestion[] suggestions = result.getSuggestions();
                    for (int i = 0; i < suggestions.length; ++i) {
                        int pasteOffset = suggestions[i].getPasteOffset();
                        int length = suggestions[i].getPasteLength();
                        String code = new String(memberToComplete.getCodeText());
                        String replaced = code.substring(pasteOffset, pasteOffset + length);
                        int nl = code.substring(0, pasteOffset).lastIndexOf(10);
                        nl = nl == -1 ? 0 : nl + 1;
                        String after = code.substring(nl, pasteOffset);
                        String id = suggestions[i].getId();
                        String typeText = suggestions[i].getType() != null ? suggestions[i].getType().getText() : "";
                        String line = "[" + id + "] offset: " + pasteOffset + ", length: " + length + ", type: [" + typeText + "], replaced: [" + replaced + "] after: [" + after + "]";
                        System.out.println(line);
                        SourceTemplate template = suggestions[i].createTemplate();
                        CompiledTemplate compiledTemplate = template.compile(this.compiler, memberToComplete, offset);
                        System.out.println("template: " + compiledTemplate.getCode());
                    }
                }
            } else {
                this.compiler.compile();
            }
            String generator = this.options.getSourceGenerator();
            String selection = this.options.getSelect();
            if (!this.options.parseOnly() && generator == null && selection == null && complete == null) {
                File currentDir = new File(".");
                this.compiler.generateCode(currentDir);
            }
            if (generator != null) {
                System.out.println("Generating source code.");
                String generatorOptions = "";
                int f = generator.indexOf(58);
                if (f != -1) {
                    generatorOptions = generator.substring(f + 1);
                    generator = generator.substring(0, f);
                }
                try {
                    LanguageSpec lang = LanguageSpec.getLanguageSpec(generator);
                    SourceGenerator sg = lang.createSourceGenerator();
                    if (this.options.rewrite()) {
                        this.compiler.refactor(sg.getStyle());
                    }
                    sg.setOptions(generatorOptions);
                    String output = this.options.getOutput();
                    OutputStreamWriter writer = output == null ? new OutputStreamWriter(System.out) : new FileWriter(output);
                    sg.setWriter(writer);
                    this.compiler.generateSource(sg);
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Node selectedNode = null;
            if (selection != null) {
                int index = selection.indexOf(58);
                if (index == -1) {
                    throw new IllegalArgumentException(selection);
                }
                String member = selection.substring(0, index);
                int offset = Integer.parseInt(selection.substring(index + 1));
                selectedNode = this.compiler.selectCodeAt(this.defaultTarget.findMember(member), offset, -1);
                if (selectedNode == null) {
                    System.out.println("code not found");
                    return;
                }
            }
            if (selectedNode != null) {
                if (this.options.gotoDeclaration()) {
                    TypeDescription declaration = selectedNode.getDeclaration();
                    System.out.println("Declaration: " + declaration);
                } else {
                    while (selectedNode != null) {
                        System.out.println(Str.pad(selectedNode.getClassName(), 15) + " - " + selectedNode.getText());
                        selectedNode = selectedNode.getParent();
                    }
                }
            }
        }
        catch (CompilerException compilerException) {
            // empty catch block
        }
    }

    private static void reportError(CilException e, CCILOptionParser options) {
        String memberName;
        int line = e.getLine();
        int col = e.getColumn();
        TypeDescription member = e.getMember();
        String string = memberName = member != null ? member.getText() : e.getMemberName();
        if (member != null && member.getParent() != null) {
            memberName = member.getParent().getText() + "." + memberName;
        }
        System.err.println("\nError: " + memberName + ":" + line + ":" + col + ":" + e.getMessage());
        if (member != null && member.isMember() && member.asMethod().getCodeText() != null) {
            SourceCode code = e.getSourceCode();
            if (code == null) {
                code = member.asMethod().getCode();
            }
            if (code != null) {
                System.err.println(code.getLineForError(e));
            }
        }
        if (e instanceof InternalException) {
            InternalException ie = (InternalException)e;
            System.err.println("Cause:");
            ie.getCause().printStackTrace(System.err);
        } else if (options.printStackTrace()) {
            e.printStackTrace();
        }
        CCIL.checkFix(e, options);
    }

    private static void checkFix(CilException e, CCILOptionParser options) {
        if (e.isFixable()) {
            FixOption[] fixOptions = e.getFixOptions();
            for (int i = 0; i < fixOptions.length; ++i) {
                FixOption option = fixOptions[i];
                System.out.println("FIX  : [" + option.getDescription() + "]");
            }
        }
        if (options != null && options.fixErrors()) {
            try {
                e.getFixOptions()[0].fix();
            }
            catch (Exception ce) {
                ce.printStackTrace();
            }
        }
    }

    private ObjectTypeDescription getDefaultTarget() {
        if (this.defaultTarget == null) {
            String className = this.options.getClassName();
            if (className == null) {
                className = "Default";
            }
            this.defaultTarget = new ObjectTypeDescription(className);
            this.defaultTarget.setProperty("javaClassName", className);
            this.defaultTarget.setComponentType(ComponentType.XOBJECT.getText());
            if (this.options.generateBitSets()) {
                this.defaultTarget.setProperty("generateBitSets", "true");
            }
            this.defaultTarget.setCatalog(this.catalog);
        }
        return this.defaultTarget;
    }

    private boolean isScript(String file) {
        String[] languages = LanguageSpec.getSupportedLanguages();
        for (int i = 0; i < languages.length; ++i) {
            String language = languages[i];
            if (!file.endsWith(language)) continue;
            return true;
        }
        return file.endsWith("cil");
    }

    private File getTmpDir() {
        return new File(FuegoDirectories.temp());
    }

    private void setUpCompiler() {
        this.compiler = new FuegoCompiler();
        if (this.options.dumpAST()) {
            this.compiler.setDirective(16);
        }
        if (this.options.dumpCheckedAST()) {
            this.compiler.setDirective(32);
        }
        if (this.options.dumpTreeNodes()) {
            this.compiler.setDirective(64);
        }
        if (this.options.parseOnly()) {
            this.compiler.setDirective(128);
        }
        if (this.options.getSourceGenerator() != null) {
            this.compiler.setDirective(1);
        }
        if (this.options.isVerbose()) {
            this.compiler.setDirective(512);
        }
        if (this.options.isCompileUsingJavaFilesEnabled()) {
            this.compiler.setDirective(32768);
        }
        this.compiler.setMessageListener(this);
    }

    private void defineCatalog() throws IOException {
        ProgressMonitor monitor = null;
        if (this.options.isVerbose()) {
            monitor = new ProgressMonitor(){

                @Override
                public void progress(int percent) {
                }

                @Override
                public void phase(Msg message) {
                    System.out.println(message);
                }

                @Override
                public void info(Msg message) {
                    this.info(1, message);
                }

                @Override
                public void info(int logLevel, Msg message) {
                    System.out.println(message);
                }

                @Override
                public void warning(Msg message) {
                    System.out.println(message);
                }

                @Override
                public void error(Msg message) {
                    System.err.println(message);
                }
            };
        }
        this.catalog = this.loadRepository(monitor);
    }

    private List<SuperType> loadDelegates(String text) throws ComponentNotFoundException, AmbiguousTypeNameException {
        ArrayList<SuperType> types = new ArrayList<SuperType>();
        for (String typeText : text.split(",")) {
            TypeRef type = this.catalog.find(typeText);
            if (type == null) {
                throw new ComponentNotFoundException(typeText);
            }
            types.add(new SuperType(type, 0x808000L));
        }
        return types;
    }

    private ComponentCatalog loadRepository(ProgressMonitor monitor) throws IOException {
        MutableComponentCatalog repository = TypeUtils.createComponentCatalog(TypeUtils.getDefaultCatalog(monitor));
        repository.setMonitor(monitor);
        repository.setDescription("Repository(" + ArrayUtils.toString(this.catalog) + ")");
        if (this.options.getCatalog() != null) {
            for (String file : this.options.getCatalog().split(File.pathSeparator)) {
                File catalogFile = new File(file);
                if (!catalogFile.exists()) {
                    throw new IOException("File doesn't exist: " + file);
                }
                if (catalogFile.isDirectory()) {
                    repository.addComponentBundle(new DirectoryComponentBundle(catalogFile));
                    continue;
                }
                repository.addComponentBundle(new JarComponentBundle(catalogFile));
            }
        }
        repository.setReadOnly(true);
        repository.sync();
        return repository;
    }
}

