/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NonNumericException;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.type.TypeFactory;

class BitwiseNot
extends Node {
    static final long serialVersionUID = -7298235522296515548L;
    static final long serialCheck = -7376073406290421645L;

    BitwiseNot() {
    }

    BitwiseNot(Token t) {
        super(t);
    }

    @Override
    public String getText() {
        return "~";
    }

    static final Node not(Node b) throws TypeException {
        BitwiseNot n = new BitwiseNot();
        n.copyParentFrom(b);
        n.initialize(b);
        n.setOperand(b);
        return n.checkType();
    }

    @Override
    Node checkType() throws TypeException {
        super.checkType();
        this.setTypeDescription(TypeFactory.getPrimitiveInt(32));
        Node op = this.getFirst();
        if (op.getKind() != 2) {
            this.reportError(new NonNumericException(op));
        }
        this.setOperand(Conversion.promote(op, TypeFactory.getPrimitiveInt(32)));
        return this;
    }

    @Override
    void generate(CodeGenerator codeGenerator) throws CodeGenerationException {
        codeGenerator.generate(this);
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Long value = (Long)this.getOp1().value(rm);
        return value ^ 0xFFFFFFFFFFFFFFFFL;
    }
}

