/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.io.File;
import java.util.List;
import oracle.bpm.cil.CilException;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.FuegoCompiler;
import oracle.bpm.compiler.InvalidNodeException;
import oracle.bpm.compiler.Node;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.type.TypeRef;

public abstract class BaseObjectClass
extends Node {
    protected List<CilException> errors;
    protected TypeRef objType;
    protected List<CilException> warnings;
    private FuegoCompiler compiler;
    private String sourceName;

    protected BaseObjectClass(TypeRef ref, FuegoCompiler compiler) {
        this.objType = ref;
        this.setCompiler(compiler);
    }

    public void setSourceName(String source) {
        this.sourceName = source;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public void reportError(CilException error) {
        if (error instanceof InvalidNodeException) {
            return;
        }
        if (this.getCompiler().getDirective(16384)) {
            throw new RuntimeException(error);
        }
        if (this.errors == null) {
            this.errors = CollectionPool.getArrayList();
        }
        this.errors.add(error);
        if (!this.isTopLevel()) {
            this.getParent().reportError(error);
        }
    }

    @Override
    public void reportWarning(CilException warning) {
        if (this.warnings == null) {
            this.warnings = CollectionPool.getArrayList();
        }
        this.warnings.add(warning);
        if (!this.isTopLevel()) {
            this.getParent().reportWarning(warning);
        }
    }

    public File getTargetJavaFile(File dir) {
        return this.getTargetJavaFile(dir, ".java");
    }

    protected boolean isUpToDate(File file) {
        long lastModifiedTime = this.objType.getLastModifiedTime();
        return file.exists() && file.lastModified() > lastModifiedTime && lastModifiedTime != 0L;
    }

    abstract void generateCode(File var1) throws CilException;

    void setCompiler(FuegoCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    FuegoCompiler getCompiler() {
        return this.compiler;
    }

    @Override
    List<CilException> getErrors() {
        return this.errors == null ? super.getErrors() : this.errors;
    }

    String getName() {
        return this.getObjectType().getName();
    }

    @Override
    ObjectTypeDescription getObjectType() {
        return this.objType.get().asObject();
    }

    File getTargetJavaFile(File dir, String extension) {
        ObjectTypeDescription objectType = this.getObjectType();
        String javaPackage = objectType.getJavaPackage();
        if ("java".equals(objectType.getComponentType())) {
            javaPackage = objectType.getFuegoPackageName(objectType.getParent());
        }
        if (javaPackage != null) {
            dir = new File(dir, javaPackage.replace('.', File.separatorChar) + '/');
            dir.mkdirs();
        }
        return new File(dir, this.getName() + extension);
    }

    boolean isTopLevel() {
        return true;
    }

    void resetMessages() {
        if (this.errors != null) {
            this.errors.clear();
        }
        if (this.warnings != null) {
            this.warnings.clear();
        }
    }
}

