/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.CommonHiddenStreamToken;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpm.compiler.Aggregate;
import oracle.bpm.compiler.Alias;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.Args;
import oracle.bpm.compiler.Arithmetic;
import oracle.bpm.compiler.ArrayConst;
import oracle.bpm.compiler.ArrayReference;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.Block;
import oracle.bpm.compiler.BoolConst;
import oracle.bpm.compiler.Cast;
import oracle.bpm.compiler.CodeStyle;
import oracle.bpm.compiler.Comment;
import oracle.bpm.compiler.Comp;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.DecimalConst;
import oracle.bpm.compiler.Declaration;
import oracle.bpm.compiler.DefaultConst;
import oracle.bpm.compiler.Delete;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.Display;
import oracle.bpm.compiler.DoBlock;
import oracle.bpm.compiler.EnumConst;
import oracle.bpm.compiler.Equality;
import oracle.bpm.compiler.Exists;
import oracle.bpm.compiler.Exit;
import oracle.bpm.compiler.ExprIf;
import oracle.bpm.compiler.FieldDeclaration;
import oracle.bpm.compiler.For;
import oracle.bpm.compiler.ForEach;
import oracle.bpm.compiler.Function;
import oracle.bpm.compiler.GroupByColumns;
import oracle.bpm.compiler.Having;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.If;
import oracle.bpm.compiler.In;
import oracle.bpm.compiler.IncDecOperator;
import oracle.bpm.compiler.Input;
import oracle.bpm.compiler.InputField;
import oracle.bpm.compiler.InputFields;
import oracle.bpm.compiler.Insert;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.IntervalConst;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.Is;
import oracle.bpm.compiler.JavaFor;
import oracle.bpm.compiler.LabeledStatement;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.Log;
import oracle.bpm.compiler.Logic;
import oracle.bpm.compiler.LoopStatement;
import oracle.bpm.compiler.MappedArrayReference;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.Method;
import oracle.bpm.compiler.NList;
import oracle.bpm.compiler.NamedNode;
import oracle.bpm.compiler.NewLine;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NodeIterator;
import oracle.bpm.compiler.Not;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.compiler.ObjectClass;
import oracle.bpm.compiler.ObjectInput;
import oracle.bpm.compiler.On;
import oracle.bpm.compiler.OnExit;
import oracle.bpm.compiler.OrderBy;
import oracle.bpm.compiler.Parameter;
import oracle.bpm.compiler.Plus;
import oracle.bpm.compiler.QualifiedName;
import oracle.bpm.compiler.Range;
import oracle.bpm.compiler.RealConst;
import oracle.bpm.compiler.RegExpConst;
import oracle.bpm.compiler.Return;
import oracle.bpm.compiler.Select;
import oracle.bpm.compiler.SelectColumns;
import oracle.bpm.compiler.SetElement;
import oracle.bpm.compiler.SetMember;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.SourceWriter;
import oracle.bpm.compiler.SqlColumnReference;
import oracle.bpm.compiler.SqlSourceGenerator;
import oracle.bpm.compiler.StringCat;
import oracle.bpm.compiler.StringConst;
import oracle.bpm.compiler.Switch;
import oracle.bpm.compiler.SwitchCases;
import oracle.bpm.compiler.Symbol;
import oracle.bpm.compiler.Tables;
import oracle.bpm.compiler.Term;
import oracle.bpm.compiler.Throw;
import oracle.bpm.compiler.TimeConst;
import oracle.bpm.compiler.TokenNames;
import oracle.bpm.compiler.TransformCall;
import oracle.bpm.compiler.TypeSpec;
import oracle.bpm.compiler.UnaryArithmetic;
import oracle.bpm.compiler.Update;
import oracle.bpm.compiler.While;
import oracle.bpm.compiler.langs.fuego.FuegoCILSourceGenerator;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.NonNls;

public abstract class BaseCILSourceGenerator
implements SourceGenerator {
    protected CodeStyle codeStyle;
    protected boolean generateInnerDeclarations;
    protected boolean generateIsNullAsEq = false;
    protected boolean generateNotBeforeIs = false;
    protected LanguageSpec langSpec;
    protected SourceWriter pw;
    protected TypeRenderer renderer;
    protected Map reservedWords;
    protected SourceGenerator sqlGenerator;
    protected boolean useParenthesisForInteractiveStms = false;
    protected boolean useParenthesisForRelayTo = false;
    protected boolean verboseInputArgs;
    private TokenNames names;
    private String options;

    protected BaseCILSourceGenerator(LanguageSpec langSpec) {
        this.langSpec = langSpec;
        this.codeStyle = langSpec.createCodeStyle();
        this.reservedWords = langSpec.getLexerConfigurator().getReservedWords(0);
        this.setNames(langSpec.getTokenNames());
        this.renderer = langSpec.getTypeRenderer();
        this.generateInnerDeclarations = true;
        this.useParenthesisForInteractiveStms = false;
    }

    @Override
    public abstract void generate(JavaFor var1);

    public static String generateCILForValue(Object value) {
        if (value == null) {
            return "null";
        }
        StringBuffer text = new StringBuffer();
        if (value instanceof List) {
            text.append('[');
            List list = (List)value;
            int length = list.size();
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    text.append(", ");
                }
                text.append(FuegoCILSourceGenerator.generateCILForValue(list.get(i)));
            }
            text.append(']');
        } else if (value instanceof Map) {
            text.append('[');
            Map map = (Map)value;
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                text.append(FuegoCILSourceGenerator.generateCILForValue(entry.getKey()));
                text.append(" : ");
                text.append(FuegoCILSourceGenerator.generateCILForValue(entry.getValue()));
                if (!it.hasNext()) continue;
                text.append(", ");
            }
            text.append(']');
        } else if (value instanceof String) {
            text.append('\"');
            text.append(value);
            text.append('\"');
        } else if (value instanceof Double) {
            text.append(value);
            text.append('f');
        } else if (value instanceof Interval) {
            text.append('\'');
            text.append(value);
            text.append('\'');
        } else if (value instanceof Time) {
            text.append('\'');
            text.append(value);
            text.append('\'');
        } else {
            text.append(value);
        }
        return text.toString();
    }

    public static void generateParameter(StringBuffer template, String description) {
        template.append("{ ");
        template.append(description);
        template.append(" }");
    }

    public static String generateTemplate(AttributeTypeDescription attr, String target) {
        TypeDescription type = attr.getType();
        String reference = (target != null ? target + "." : "") + attr.getName();
        if (type.getKind() == 16 || type.getKind() == 12) {
            String id;
            TypeDescription elem = type.getElementType();
            id = elem.isObject() ? (Character.isLowerCase((id = elem.getName()).charAt(0)) ? String.valueOf(id.charAt(0)) : id.toLowerCase()) : String.valueOf(attr.getName().charAt(0));
            String msg = "// process each " + id + " (" + elem.getText() + ")";
            return "for each " + id + " in " + reference + " \ndo \n\t" + msg + "\n\t{ statements }\nend";
        }
        return reference;
    }

    public static String generateTemplate(MethodTypeDescription member, String target) {
        if (member.isAttribute()) {
            return BaseCILSourceGenerator.generateTemplate(member.asAttribute(), target);
        }
        StringBuffer template = new StringBuffer();
        boolean function = !member.getResultType().isVoid() || member.isConstructor();
        int inargc = member.getInputArgumentCount();
        template.append(member.getName());
        if (function) {
            template.append('(');
            if (!member.isConstructor()) {
                template.append(target);
            }
        } else {
            template.append(' ');
            template.append(target);
            if (inargc > 0) {
                template.append(" using \n");
            }
        }
        for (Argument arg : member.getArguments()) {
            if (!arg.isIn()) continue;
            --inargc;
            if (!function) {
                template.append('\t');
            }
            String name = arg.getName();
            template.append(name);
            template.append(" = ");
            String description = arg.getDescription();
            if (description == null || description.equals("")) {
                description = name;
            }
            FuegoCILSourceGenerator.generateParameter(template, description);
            if (inargc <= 0) continue;
            template.append(", ");
            if (function) continue;
            template.append('\n');
        }
        if (function) {
            template.append(")");
            return template.toString();
        }
        int outargc = member.getOutputArgumentCount();
        if (outargc > 0) {
            template.append(" returning ");
        }
        for (Argument arg : member.getArguments()) {
            if (!arg.isOut()) continue;
            --outargc;
            template.append('\t');
            String name = arg.getName();
            String description = arg.getDescription();
            if (description == null || description.equals("")) {
                description = name;
            }
            FuegoCILSourceGenerator.generateParameter(template, description);
            template.append(name);
            if (outargc <= 0) continue;
            template.append(',');
            template.append('\n');
        }
        return template.toString();
    }

    @Override
    public void close() {
        this.pw.close();
    }

    @Override
    public void generate(Comment comment) {
        if (comment.isMultiLine()) {
            this.generateMultiLineComment(comment.getText());
            if (comment.isStatement()) {
                this.println();
            }
        } else {
            Node prev = comment.getPrev();
            if (prev != null && !(prev instanceof Comment) && comment.isStatement()) {
                this.generateSeparatorBefore(comment);
            }
            this.generateSignleLineComment(comment.getText());
        }
    }

    @Override
    public void generate(NewLine newLine) {
        this.pw.printSeparator();
    }

    @Override
    public void generate(Term add) {
        this.generateExpr(add.getOp1());
        this.printSpaceDelimited(add.isSubstraction() ? this.getNames().arithmeticSub : this.getNames().arithmeticAdd);
        this.generateExpr(add.getOp2());
    }

    @Override
    public void generate(Arithmetic arithmetic) {
        String operator = "";
        switch (arithmetic.getOperator()) {
            case 0: {
                operator = this.getNames().arithmeticAdd;
                break;
            }
            case 1: {
                operator = this.getNames().arithmeticSub;
                break;
            }
            case 4: {
                operator = this.getNames().arithmeticRem;
                break;
            }
            case 2: {
                operator = this.getNames().arithmeticMul;
                break;
            }
            case 3: {
                operator = this.getNames().arithmeticDiv;
            }
        }
        this.generateExpr(arithmetic.getOp1());
        this.printSpaceDelimited(operator);
        this.generateExpr(arithmetic.getOp2());
    }

    @Override
    public void generate(Block block) {
        NodeIterator it = block.getChildren();
        while (it.hasNext()) {
            Node node = it.next();
            if (node.isSynthetic()) continue;
            node.generate(this);
        }
    }

    @Override
    public void generate(BoolConst bool) {
        this.print("true".equals(bool.getText()) ? this.getNames().literalTrue : this.getNames().literalFalse);
    }

    @Override
    public void generate(DecimalConst decimal) {
        this.print(decimal.getText());
    }

    @Override
    public void generate(DefaultConst defaultConst) {
        this.generateType(defaultConst.getTypeDescription(), this.getContext(defaultConst));
    }

    @Override
    public void generate(MappedArrayReference ref) {
        Node array = ref.getOp1();
        Node member = ref.getOp2();
        this.generateExpr(array);
        this.print("[].");
        member.generate(this);
    }

    @Override
    public void generate(Method method) {
        this.printIdentifier(method.getName());
        MethodTypeDescription methodType = method.getMethodType();
        this.generateMethodArgs(methodType, false);
        this.generateMethodResult(methodType);
        this.println();
        this.generateDoBlockBody(method);
        this.println();
        this.pw.close();
    }

    @Override
    public void generate(DoBlock doblock) {
        this.generate(doblock, doblock.getName());
    }

    @Override
    public void generate(EnumConst enumConst) {
        if (!enumConst.isOnlyId()) {
            this.generateType(enumConst.getTypeDescription(), this.getContext(enumConst));
            this.print(".");
        }
        this.print(enumConst.getLabel());
    }

    @Override
    public void generate(InputFields fields) {
        boolean fixed = false;
        for (Node inputField = fields.getFirst(); inputField != null; inputField = inputField.getNext()) {
            if (!fixed) {
                this.pw.fixIndentation();
                fixed = true;
            }
            boolean breakAllowed = this.pw.allowBreak(false);
            inputField.generate(this);
            if (inputField.getNext() != null) {
                this.println(",");
            }
            this.pw.allowBreak(breakAllowed);
        }
        if (fixed) {
            this.pw.unfixIndentation();
        }
    }

    @Override
    public void generate(FieldDeclaration decl) {
        if (!decl.isSynthetic()) {
            this.printIdentifier(decl.getName());
            this.printSpaceDelimited(this.getNames().getDeclarationSymbol());
            this.generateType(decl.getTypeDescription(), decl.getCurrentClass().getTypeDescription());
            Node value = decl.getFirst();
            if (value != null) {
                this.printSpaceDelimited(this.getNames().getAssignmentOperator());
            }
            this.generateStatementSeparator(decl);
        }
    }

    @Override
    public void generate(NamedNode namedNode) {
        this.printIdentifier(namedNode.getName());
        this.printSpaceDelimited(this.getNames().argumentSeparator);
        namedNode.getTargetNode().generate(this);
    }

    @Override
    public void generate(Function function) {
        if (function.isStatement()) {
            this.generateSeparatorBefore(function);
        }
        Node arg = function.getFirst();
        this.print("clone(");
        this.generateExpr(arg, Boolean.FALSE);
        this.print(")");
        if (function.isStatement()) {
            this.generateStatementSeparator(function);
            this.generateSeparatorAfter(function);
        }
    }

    @Override
    public void generate(Identifier id) {
        this.printIdentifier(id.getText());
    }

    @Override
    public void generate(Identifier.This id) {
        this.print(this.getNames().qualifiedCurrent);
    }

    @Override
    public void generate(Identifier.Super id) {
        this.print(this.getNames().qualifierSuper);
    }

    @Override
    public void generate(Identifier.TokenText id) {
        this.print(id.getText());
    }

    @Override
    public void generate(If ifnode) {
        if (!(ifnode.getParent() instanceof If)) {
            this.generateSeparatorBefore(ifnode);
        }
        this.print(this.getNames().ifSymbol);
        this.generateIfPredicate(ifnode.getPredicate());
        this.print(this.getNames().thenSymbol);
        this.println();
        this.generateIndented(ifnode.getThen());
        if (ifnode.hasElse()) {
            Node elseNode = ifnode.getElse();
            if (elseNode instanceof If) {
                this.generateElseIf(elseNode);
            } else {
                this.generateElse(elseNode);
            }
        } else {
            this.print(this.getNames().endIfSymbol);
            this.println();
        }
        this.generateSeparatorAfter(ifnode);
    }

    @Override
    public void generate(IntConst integer) {
        this.print(integer.getText());
    }

    @Override
    public void generate(IntervalConst interval) {
        String text = interval.getText();
        this.print(this.getNames().intervalStart);
        this.print(text);
        this.print(this.getNames().intervalEnd);
    }

    @Override
    public void generate(Args args) {
        if (!this.hasArgs(args)) {
            return;
        }
        boolean first = true;
        boolean breakAllowed = this.pw.allowBreak(false);
        for (Arg arg = (Arg)args.getFirst(); arg != null; arg = (Arg)arg.getNext()) {
            if (arg.isSynthetic()) continue;
            if (first) {
                first = false;
            } else {
                this.print(", ");
                this.pw.allowBreak(true);
            }
            this.pw.allowBreak(false);
            arg.generate(this);
        }
        this.pw.allowBreak(breakAllowed);
    }

    @Override
    public void generate(Arg arg) {
        this.generateArgument(arg, true);
    }

    @Override
    public void generate(LabeledStatement label) {
        Node statement = label.getStatement();
        if (!(statement instanceof JavaFor)) {
            this.generateLabel(label);
        }
        statement.generate(this);
        this.generateSeparatorAfter(label);
    }

    @Override
    public void generate(NullConst nullConst) {
        this.print(this.getNames().literalNull);
    }

    @Override
    public void generate(ObjectClass objectClass) {
        NodeIterator it = objectClass.getChildren();
        while (it.hasNext()) {
            Node node = it.next();
            if (node.isSynthetic()) continue;
            node.generate(this);
            this.println();
        }
        this.pw.flush();
    }

    @Override
    public void generate(On on) {
        this.print(this.getNames().onSymbol);
        this.printSpace();
        on.getOp2().generate(this);
        this.printSpaceDelimited(this.getNames().getDeclarationSymbol());
        on.getOp1().generate(this);
        this.println();
        this.generateIndented(on.getOp3());
    }

    @Override
    public void generate(OnExit onExit) {
        this.print(this.getNames().onExitSymbol);
        this.println();
        this.generateIndented(onExit.getFirst());
    }

    @Override
    public void generate(Parameter parameter) {
        int startOffset = this.pw.getOffset();
        parameter.setPasteOffset(startOffset);
        Node first = parameter.getFirst();
        boolean hasNewLine = false;
        if (first != null) {
            first.generate(this);
            if (first instanceof Comment) {
                Comment comment = (Comment)first;
                hasNewLine = comment.isSingleLine() || comment.isMultiLine() && comment.isStatement();
            }
        } else {
            this.printIdentifier(parameter.getText());
        }
        int endOffset = this.pw.getEndOffset();
        int pasteLength = endOffset - startOffset;
        if (hasNewLine) {
            --pasteLength;
        }
        parameter.setPasteLength(pasteLength);
    }

    @Override
    public void generate(QualifiedName qname) {
        Node id = qname.getFirst();
        while (id != null) {
            id.generate(this);
            if ((id = id.getNext()) == null) continue;
            this.print(".");
        }
    }

    @Override
    public void generate(RealConst real) {
        int length = real.getTypeDescription().getLength();
        this.print(real.getText());
        this.print(length == 32 ? this.getNames().literalReal32Suffix : this.getNames().literalReal64Suffix);
    }

    @Override
    public void generate(RegExpConst regexp) {
        this.print(this.getNames().regexpStart);
        this.print(regexp.getText());
        this.print(this.getNames().regexpEnd);
    }

    @Override
    public void generate(StringConst string) {
        this.print("\"" + Str.escape(string.getText()) + "\"");
    }

    @Override
    public void generate(TimeConst time) {
        this.print(this.getNames().getTimeStart());
        this.print(time.getText());
        this.print(this.getNames().getTimeEnd());
    }

    @Override
    public void generate(TypeSpec typeSpec) {
        if (typeSpec.isOrdered()) {
            this.print(this.getNames().getOrderedSymbol());
            this.printSpace();
        }
        TypeDescription type = typeSpec.getTypeDescription();
        if (typeSpec.getOp1() == null || type.isPredefined()) {
            this.generateType(type, this.getContext(typeSpec));
        } else {
            if (type.isIterator() || type.isSet() || type.isObject()) {
                typeSpec.getOp1().generate(this);
            } else {
                TypeDescription elementType = type;
                while (elementType.isArray() || elementType.isMap()) {
                    elementType = elementType.getElementType();
                }
                this.generateTypeName(typeSpec.getOp1(), elementType);
            }
            Node parameters = typeSpec.getOp2();
            Node firstChild = parameters.getFirst();
            if (firstChild instanceof IntConst || type.isObject() || type.isSet() || type.isIterator()) {
                this.generateTypeSpecParameters(parameters);
            } else if (firstChild instanceof TypeSpec && type.isArray()) {
                this.print(this.getNames().getArrayDeclarationStart());
                if (type.isMap()) {
                    if (type.isOrdered()) {
                        this.print(this.getNames().getOrderedSymbol());
                        this.printSpace();
                    }
                    this.generateType(type.getIndexType(), this.getContext(parameters));
                }
                this.print(this.getNames().getArrayDeclarationEnd());
            }
            Node arraySpec = typeSpec.getOp3();
            if (arraySpec != null && arraySpec.hasChildren()) {
                for (Node index = arraySpec.getFirst(); index != null; index = index.getNext()) {
                    this.print(this.getNames().getArrayDeclarationStart());
                    index.generate(this);
                    this.print(this.getNames().getArrayDeclarationEnd());
                }
            }
        }
    }

    @Override
    public void generate(Cast cast) {
        Node expr = cast.getExpr();
        if (cast.isFuntionalSyntax()) {
            cast.getTargetType().generate(this);
            expr.setParenthesis(true);
            this.generateExpr(expr);
        } else {
            expr.setParenthesis(this.isComplexExpression(expr));
            this.generateExpr(expr);
            this.print(" to ");
            cast.getTargetType().generate(this);
        }
    }

    @Override
    public void generate(Select select) {
        this.getSqlGenerator().generate(select);
    }

    @Override
    public void generate(SelectColumns selectColumns) {
        this.getSqlGenerator().generate(selectColumns);
    }

    @Override
    public void generate(GroupByColumns groupByColumns) {
        this.getSqlGenerator().generate(groupByColumns);
    }

    @Override
    public void generate(OrderBy orderBy) {
        this.getSqlGenerator().generate(orderBy);
    }

    @Override
    public void generate(Having having) {
        this.getSqlGenerator().generate(having);
    }

    @Override
    public void generate(Insert insert) {
        this.getSqlGenerator().generate(insert);
    }

    @Override
    public void generate(Insert.Values values) {
        this.getSqlGenerator().generate(values);
    }

    @Override
    public void generate(Insert.Columns columns) {
        this.getSqlGenerator().generate(columns);
    }

    @Override
    public void generate(Delete delete) {
        this.getSqlGenerator().generate(delete);
    }

    @Override
    public void generate(Update update) {
        this.getSqlGenerator().generate(update);
    }

    @Override
    public void generate(Update.SetValues setValues) {
        this.getSqlGenerator().generate(setValues);
    }

    @Override
    public void generate(Tables tables) {
        this.getSqlGenerator().generate(tables);
    }

    @Override
    public void generate(SqlColumnReference sqlColumnReference) {
        this.getSqlGenerator().generate(sqlColumnReference);
    }

    @Override
    public void generate(SwitchCases switchCases) {
        Node caseExpr = switchCases.getFirst();
        while (caseExpr != null) {
            Node value = caseExpr.getOp2();
            if (value == null) {
                value = new BoolConst(!(caseExpr instanceof Not));
            }
            value.generate(this);
            if ((caseExpr = caseExpr.getNext()) == null) continue;
            this.print(", ");
        }
    }

    @Override
    public void generate(ArrayConst arrayConst, boolean isMap) {
        this.print(this.getNames().literalArrayStart);
        int i = 0;
        NodeIterator it = arrayConst.getChildren();
        while (it.hasNext()) {
            this.generateExpr(it.next(), Boolean.FALSE);
            if (!it.hasNext()) continue;
            if (isMap && i++ % 2 == 0) {
                this.printSpaceDelimited(this.getNames().argumentSeparator);
                continue;
            }
            this.print(", ");
        }
        this.print(this.getNames().literalArrayEnd);
    }

    @Override
    public void generate(Conversion conversion, Node op) {
        if (!conversion.isSyntheticCast()) {
            this.generateType(conversion.getTypeDescription(), this.getContext(conversion));
            op.setParenthesis(true);
        }
        this.generateExpr(op);
    }

    @Override
    public void generate(Deref deref, Node op) {
        this.generateExpr(op);
    }

    @Override
    public void generate(LocalVar locarVar, Symbol symbol) {
        if (symbol.isInstanceVariable() && this.codeStyle.getQualifyInstanceVars() == 1) {
            this.print(this.getNames().qualifiedCurrent);
            this.print(".");
        } else if (symbol.isArgument() && this.codeStyle.getQualifyArguments() == 1) {
            this.print(this.getNames().qualifierArg);
            this.print(".");
        }
        String name = symbol.getName();
        Symbol replacement = symbol.getReplacement();
        if (locarVar.isCurrentReference()) {
            this.print(this.getNames().qualifiedCurrent);
        } else if (name.indexOf(46) != -1 && replacement == null) {
            this.generateType(symbol.getType(), this.getContext(locarVar));
        } else {
            if (replacement != null) {
                name = replacement.getName();
            }
            this.printIdentifier(name);
        }
    }

    @Override
    public void generate(Not not, Node op) {
        this.print(this.getNames().getLogicNot());
        this.print(" ");
        this.generateExpr(op);
    }

    @Override
    public void generate(Plus plus, Node op) {
        this.printSpaceDelimited("+");
        this.generateExpr(op);
    }

    @Override
    public void generate(Return ret, Node expr) {
        this.generateSeparatorBefore(ret);
        this.print(this.getNames().returnSymbol);
        this.print(" ");
        this.generateExpr(expr, Boolean.FALSE);
        this.generateStatementSeparator(ret);
    }

    @Override
    public void generate(Throw node, Node exception) {
        this.print(this.getNames().throwSymbol);
        this.print(" ");
        this.generateExpr(exception, Boolean.FALSE);
        this.generateStatementSeparator(node);
    }

    @Override
    public final void generate(UnaryArithmetic node) {
        this.print(node.isMinus() ? "- " : "+ ");
        node.getFirst().generate(this);
        if (node.isStatement()) {
            this.generateStatementSeparator(node);
        }
    }

    @Override
    public void generate(IncDecOperator node) {
        if (node.isExpression()) {
            this.genIncDec(node, node.getFirst());
        } else {
            this.genAssignment(node);
        }
    }

    @Override
    public void generate(Switch.Default defaultNode, Node body) {
        this.println("else ");
        this.generateIndented(body);
    }

    @Override
    public void generate(Alias alias, Node variable, Node aliasName) {
        this.getSqlGenerator().generate(alias, variable, aliasName);
    }

    @Override
    public void generate(ArrayReference ref, Node array, Node index) {
        this.generateExpr(array);
        this.print(this.getNames().arrayReferenceStart);
        this.generateExpr(index, Boolean.FALSE);
        this.print(this.getNames().arrayReferenceEnd);
    }

    @Override
    public void generate(Assignment assignment, Node target, Node value) {
        this.generateExpr(target);
        this.printSpaceDelimited(this.getNames().getAssignmentOperator());
        this.pw.fixIndentation();
        this.generateExpr(value, Boolean.FALSE);
        if (assignment.isStatement()) {
            this.generateStatementSeparator(assignment);
        }
        this.pw.unfixIndentation();
    }

    @Override
    public void generate(Declaration decl) {
        decl.getOp1().generate(this);
        this.printSpaceDelimited(this.getNames().getDeclarationSymbol());
        decl.getDeclType().generate(this);
        Node init = decl.getInit();
        if (init != null && !init.isSynthetic()) {
            this.printSpaceDelimited(this.getNames().getAssignmentOperator());
            init.generate(this);
        }
        this.generateStatementSeparator(decl);
    }

    @Override
    public void generate(Exit exit, Node predicate, Node label) {
        this.generateSeparatorBefore(exit);
        this.print(this.getNames().exitSymbol);
        if (label == null && !exit.isInLoop()) {
            Method currentMember = exit.getCurrentMember();
            Node node = label = currentMember != null ? new Identifier(currentMember.getMethodType().getName()) : null;
        }
        if (label != null) {
            this.printSpaceDelimited(":");
            label.generate(this);
        }
        if (predicate != null) {
            this.printSpaceDelimited(this.getNames().whenSymbol);
            this.generateExpr(predicate, Boolean.FALSE);
        }
        this.generateStatementSeparator(exit);
        this.generateSeparatorAfter(exit);
    }

    @Override
    public void generate(In in, Node expr, Node range) {
        this.generateExpr(expr);
        this.printSpaceDelimited(this.getNames().getInSymbol());
        range.generate(this);
    }

    @Override
    public void generate(Log log, Node message, Args inargs) {
        this.generateSeparatorBefore(log);
        this.print(this.getNames().logSymbol);
        this.print(this.useParenthesisForInteractiveStms ? "(" : " ");
        this.generateExpr(message, Boolean.FALSE);
        this.generateArgsForInteractiveStm(inargs, null);
        this.print(this.useParenthesisForInteractiveStms ? ")" : "");
        this.generateStatementSeparator(log);
        this.generateSeparatorAfter(log);
    }

    @Override
    public void generate(MemberReference ref, Node object, Node member) {
        MethodTypeDescription memberType;
        if (!object.isSynthetic()) {
            this.generateExpr(object);
            this.print(".");
        }
        if ((memberType = ref.getMemberType()) != null) {
            String replacement = memberType.getReplacement();
            this.printIdentifier(replacement != null ? replacement : memberType.getName());
        } else {
            this.printIdentifier(member.getText());
        }
    }

    @Override
    public void generate(Range range, Node from, Node to) {
        this.generateExpr(from);
        this.print(this.getNames().rangeOperator);
        this.generateExpr(to);
    }

    @Override
    public void generate(StringCat cat, Node left, Node right) {
        this.generateExpr(left, Boolean.FALSE);
        this.printSpaceDelimited(this.getNames().getConcatOperator());
        this.generateNewLine(left, right);
        this.generateExpr(right, Boolean.FALSE);
    }

    @Override
    public void generate(While whileNode, Node predicate, Node body) {
        this.generateSeparatorBefore(whileNode);
        this.print(this.getNames().whileSymbol);
        this.print(" ");
        if (this.codeStyle.getParenthesisInWhiles() != 3) {
            predicate.setParenthesis(this.codeStyle.getParenthesisInWhiles() == 1);
        }
        this.generateExpr(predicate);
        this.generateLoopBody(whileNode, body, whileNode.getName(), true);
    }

    @Override
    public void generate(Exists exists, Node op, boolean negate) {
        this.getSqlGenerator().generate(exists, op, negate);
    }

    @Override
    public void generate(Switch switchNode, Node expr, Node cases) {
        this.generateSeparatorBefore(switchNode);
        this.print(this.getNames().caseSymbol);
        this.print(" ");
        expr.generate(this);
        this.println();
        while (cases != null) {
            cases.generate(this);
            cases = cases.getNext();
        }
        this.println("end");
        this.generateSeparatorAfter(switchNode);
    }

    @Override
    public void generate(Switch.Case caseNode, Node cond, Node body) {
        this.print("when ");
        cond.generate(this);
        this.println(" then");
        this.generateIndented(body);
    }

    @Override
    public void generate(Aggregate aggregate, Node operand, int op, boolean distinct) {
        this.getSqlGenerator().generate(aggregate, operand, op, distinct);
    }

    @Override
    public void generate(Comp comp) {
        this.generateExpr(comp.getOp1());
        this.printSpaceDelimited(comp.getOperator().getSymbol());
        this.generateExpr(comp.getOp2());
    }

    @Override
    public void generate(Equality eq) {
        this.generateExpr(eq.getOp1());
        this.printSpaceDelimited(eq.isEquals() ? this.getNames().relationalEqual : this.getNames().relationalDistinct);
        this.generateExpr(eq.getOp2());
    }

    @Override
    public void generate(ExprIf exprIf, Node predicate, Node a, Node b) {
        this.generateExpr(predicate);
        this.printSpaceDelimited("?");
        this.generateExpr(a);
        this.printSpaceDelimited(":");
        this.generateExpr(b);
    }

    @Override
    public void generate(For fornode, Node index, Node range, Node body) {
        this.generateSeparatorBefore(fornode);
        this.print(this.getNames().forSymbol);
        this.printSpace();
        index.generate(this);
        this.printSpace();
        this.print(this.getNames().getInSymbol());
        this.print(" ");
        this.generateExpr(range);
        this.generateLoopBody(fornode, body, fornode.getName(), true);
    }

    @Override
    public void generate(ObjectInput input, Node object, Args inargs, Args outargs) {
        this.generateSeparatorBefore(input);
        this.print(this.getNames().inputSymbol);
        this.print(this.useParenthesisForInteractiveStms ? "(" : " ");
        this.pw.fixIndentation();
        this.generateExpr(object);
        this.generateArgsForInteractiveStm(inargs, outargs);
        this.print(this.useParenthesisForInteractiveStms ? ")" : "");
        this.pw.unfixIndentation();
        this.generateStatementSeparator(input);
        this.generateSeparatorAfter(input);
    }

    @Override
    public void generate(Is is, Node expr, TypeDescription type, boolean negative) {
        if (this.generateIsNullAsEq && type == TypeFactory.getNull()) {
            this.generateExpr(expr);
            this.printSpaceDelimited(negative ? this.getNames().relationalDistinct : this.getNames().relationalEqual);
            this.print(this.getNames().literalNull);
        } else {
            if (negative && this.generateNotBeforeIs) {
                this.print(this.getNames().getLogicNot());
                this.print(" ");
            }
            this.generateExpr(expr);
            this.printSpaceDelimited(this.getNames().isSymbol);
            if (negative && !this.generateNotBeforeIs) {
                this.print(this.getNames().getLogicNot());
                this.print(" ");
            }
            if (type == TypeFactory.getNull()) {
                this.print(this.getNames().literalNull);
            } else {
                is.getOp2().generate(this);
            }
        }
    }

    @Override
    public void generate(Logic logic) {
        this.generateExpr(logic.getOp1());
        String opname = "";
        switch (logic.getOperator()) {
            case AND: {
                opname = this.getNames().getLogicAnd();
                break;
            }
            case OR: {
                opname = this.getNames().getLogicOr();
                break;
            }
            case IMPLIES: {
                opname = this.getNames().getLogicImplies();
                break;
            }
            case XOR: {
                opname = this.getNames().getLogicXor();
            }
        }
        this.printSpaceDelimited(opname);
        this.generateExpr(logic.getOp2());
    }

    @Override
    public void generate(SetElement element, Node array, Node index, Node value) {
        this.generateExpr(array);
        if (value == null) {
            value = index;
            index = null;
        }
        this.print(this.getNames().arrayReferenceStart);
        if (index != null) {
            this.generateExpr(index, Boolean.FALSE);
        }
        this.print(this.getNames().arrayReferenceEnd);
        this.printSpaceDelimited(this.getNames().getAssignmentOperator());
        this.generateExpr(value, Boolean.FALSE);
        this.generateStatementSeparator(element);
    }

    @Override
    public void generate(SetMember setMember, Node object, Node member, Node value) {
        MethodTypeDescription memberType;
        if (!object.isSynthetic()) {
            this.generateExpr(object);
            this.print(".");
        }
        if ((memberType = setMember.getMemberType()) != null) {
            String replacement = memberType.getReplacement();
            this.printIdentifier(replacement != null ? replacement : memberType.getName());
        } else {
            member.generate(this);
        }
        this.printSpaceDelimited(this.getNames().getAssignmentOperator());
        this.generateExpr(value, Boolean.FALSE);
        this.generateStatementSeparator(setMember);
    }

    @Override
    public void generate(TransformCall transformCall, Node source, Node target, Node library) {
        this.generateTransformArgs(source);
        this.printSpaceDelimited(this.getNames().transformCallSymbol);
        this.generateExpr(target);
        this.generateTransformLibrary(library);
    }

    @Override
    public void generate(Display display, Node message, Args inargs, Args outargs, Invoke targetInvoke) {
        this.generateSeparatorBefore(display);
        this.print(this.getNames().displaySymbol);
        this.print(this.useParenthesisForInteractiveStms ? "(" : " ");
        this.generateExpr(message, Boolean.FALSE);
        this.generateArgsForInteractiveStm(inargs, outargs);
        this.print(this.useParenthesisForInteractiveStms ? ")" : "");
        if (targetInvoke != null) {
            this.generateRelayTo(targetInvoke);
        }
        this.generateStatementSeparator(display);
        this.generateSeparatorAfter(display);
    }

    @Override
    public void generate(InputField field, Node label, Node variable, List<Node> options, Node validValues) {
        Iterator<Node> it;
        label.generate(this);
        String fieldSep = this.getNames().inputFieldSeparator;
        if (fieldSep.equals("")) {
            this.printSpace();
        } else {
            this.printSpaceDelimited(fieldSep);
        }
        variable.generate(this);
        if (options != null) {
            it = options.iterator();
            while (it.hasNext()) {
                Node n = it.next();
                if (!n.isSynthetic()) continue;
                it.remove();
            }
        }
        if (options != null && options.size() > 0) {
            this.print(" (");
            it = options.iterator();
            while (it.hasNext()) {
                StringConst option = (StringConst)it.next();
                String text = option.getText();
                int dot = text.indexOf(58);
                if (dot != -1) {
                    String name = text.substring(0, dot);
                    String value = text.substring(dot + 1);
                    this.print(name.toLowerCase());
                    this.print(" = ");
                    this.printQuoted(value);
                } else {
                    this.print(text.toLowerCase());
                }
                if (!it.hasNext()) continue;
                this.print(", ");
            }
            this.print(")");
        }
        if (validValues != null && !(validValues instanceof NullConst)) {
            this.printSpaceDelimited(this.getNames().getInSymbol());
            validValues.generate(this);
        }
    }

    @Override
    public void generate(ForEach foreach, Node index, Node array, Node where, Node body) {
        this.generateSeparatorBefore(foreach);
        this.print(this.getNames().forEachSymbol);
        this.printSpace();
        index.generate(this);
        this.printSpaceDelimited(this.getNames().getInSymbol());
        this.generateExpr(array);
        if (where != null) {
            this.generateWhere(where);
        }
        boolean isSql = array instanceof Select;
        this.generateLoopBody(foreach, body, foreach.getName(), !isSql);
    }

    @Override
    public void generate(Input input, InputFields fields, Args inargs, Args outargs, Invoke targetInvoke) {
        this.generateSeparatorBefore(input);
        this.print(this.getNames().inputSymbol);
        this.print(this.useParenthesisForInteractiveStms ? "(" : " ");
        this.pw.fixIndentation();
        fields.generate(this);
        this.pw.unfixIndentation();
        this.generateArgsForInteractiveStm(inargs, outargs);
        this.print(this.useParenthesisForInteractiveStms ? ")" : "");
        if (targetInvoke != null) {
            this.generateRelayTo(targetInvoke);
        }
        this.generateStatementSeparator(input);
        this.generateSeparatorAfter(input);
    }

    @Override
    public void generate(Invoke invoke, Node object, Args inArgs, Args outArgs, String memberName) {
        this.checkIfFunction(invoke, outArgs);
        MethodTypeDescription member = invoke.getMemberType();
        if (!member.isConstructor() && !object.isSynthetic()) {
            this.generateTargetObjectExpression(object, invoke);
        }
        if (member.isConstructor()) {
            this.generateConstructorName(invoke, member);
        } else {
            this.printIdentifier(memberName);
        }
        this.print("(");
        this.pw.fixIndentation();
        this.generate(inArgs);
        if (this.hasArgs(outArgs)) {
            if (this.hasArgs(inArgs)) {
                this.print(", ");
            }
            this.generate(outArgs);
        }
        this.print(")");
        this.pw.unfixIndentation();
        Invoke targetInvoke = invoke.getTargetInvoke();
        if (targetInvoke != null) {
            this.generateRelayTo(targetInvoke);
        }
        if (invoke.isStatement()) {
            this.generateStatementSeparator(invoke);
            this.generateSeparatorAfter(invoke);
        }
    }

    public void generateTargetObjectExpression(Node object, Invoke invoke) {
        if (this.isComplexExpression(object)) {
            object.setParenthesis(true);
        }
        this.generateExpr(object);
        this.print(".");
    }

    public void generateType(TypeDescription type, TypeDescription context) {
        this.print(this.renderer.render((TypeRef)type, context, 8));
    }

    public String getOptions() {
        return this.options;
    }

    @Override
    public CodeStyle getStyle() {
        return this.codeStyle;
    }

    @Override
    public void setOptions(String options) {
        this.options = options;
    }

    @Override
    public void setStyle(CodeStyle style) {
        this.codeStyle = style;
    }

    @Override
    public void setWriter(Writer writer) {
        if (writer != null) {
            this.pw = writer instanceof SourceWriter ? (SourceWriter)writer : new SourceWriter(new PrintWriter(writer, true));
            if (this.sqlGenerator != null) {
                this.sqlGenerator.setWriter(this.pw);
            }
        }
    }

    public TokenNames getNames() {
        return this.names;
    }

    public void setNames(TokenNames names) {
        this.names = names;
    }

    protected boolean checkIfFunction(Invoke invoke, Args outArgs) {
        boolean isReturnOnly;
        MethodTypeDescription member = invoke.getMemberType();
        boolean bl = isReturnOnly = outArgs != null && outArgs.isReturnOnly();
        if (member.isFunction() && invoke.isStatement() && isReturnOnly && this.writeAsFunction(member)) {
            Arg retNode = outArgs.getReturnArg();
            outArgs.setFirst(null);
            retNode.getValue().generate(this);
            this.printSpaceDelimited(this.getNames().getAssignmentOperator());
            return true;
        }
        return false;
    }

    protected SourceGenerator createSqlGenerator() {
        SqlSourceGenerator sqlGenerator = new SqlSourceGenerator(this.langSpec);
        sqlGenerator.setWriter(this.pw);
        sqlGenerator.getNames().setSqlSeparator(this.getNames().getSqlSeparator());
        sqlGenerator.getNames().singleLineComment = this.getNames().singleLineComment;
        sqlGenerator.getNames().multiLineCommentStart = this.getNames().multiLineCommentStart;
        sqlGenerator.getNames().multiLineCommentEnd = this.getNames().multiLineCommentEnd;
        return sqlGenerator;
    }

    protected String escapeId(String id) {
        return "@" + id;
    }

    protected void generate(DoBlock doblock, String label) {
        this.generateDoBlockHeader(doblock);
        this.generateDoBlockBody(doblock);
        if (label != null && !label.equals("")) {
            this.printSpace();
            this.generateLabel(label);
        }
        this.generateStatementSeparator(doblock);
        this.generateSeparatorAfter(doblock);
    }

    protected void generateAfterHiddenToken(CommonHiddenStreamToken after) {
        switch (after.getType()) {
            case 8: {
                this.generateSignleLineComment(after.getText());
                break;
            }
            case 9: {
                this.generateMultiLineComment(after.getText());
            }
        }
        after.setType(0);
        CommonHiddenStreamToken next = after.getHiddenAfter();
        if (next != null) {
            this.generateAfterHiddenToken(next);
        }
    }

    protected void generateArgsForInteractiveStm(Args inargs, Args outargs) {
        if (this.hasArgs(inargs)) {
            this.print(", ");
            inargs.generate(this);
        }
        if (this.hasArgs(outargs)) {
            this.print(", ");
            outargs.generate(this);
        }
    }

    protected void generateArgsForRelayTo(Args args) {
        args.generate(this);
    }

    protected void generateArgument(Arg arg, boolean namedArgs) {
        Node value;
        Arg targetArg;
        String name;
        if (arg.isSynthetic()) {
            return;
        }
        if (arg.isOut()) {
            this.print(this.getNames().outQualifier);
            this.print(" ");
        }
        if ((name = arg.getArgument().getName()) != null && !name.equals("") && namedArgs) {
            this.printIdentifier(name);
            this.printSpaceDelimited(this.getNames().argumentSeparator);
        }
        Arg arg2 = targetArg = (value = arg.getValue()) instanceof Arg ? (Arg)value : null;
        if (targetArg != null) {
            this.printIdentifier(targetArg.getArgument().getName());
        } else if (value != null) {
            this.generateExpr(arg.getValue(), Boolean.FALSE);
        }
    }

    protected void generateArgument(Argument argument, TypeDescription context) {
        if (argument.isIn() && argument.isOut()) {
            this.print(this.getNames().inoutQualifier);
        } else if (argument.isIn()) {
            this.print(this.getNames().getInQualifier());
        } else {
            this.print(this.getNames().outQualifier);
        }
        this.print(" ");
        this.printIdentifier(argument.getName());
        this.printSpaceDelimited(this.getNames().getDeclarationSymbol());
        this.generateType(argument.getType(), context);
    }

    protected void generateBeforeHiddenToken(CommonHiddenStreamToken before) {
        CommonHiddenStreamToken prev = before.getHiddenBefore();
        if (prev != null) {
            this.generateBeforeHiddenToken(prev);
        }
        switch (before.getType()) {
            case 8: {
                this.generateSignleLineComment(before.getText());
                break;
            }
            case 9: {
                this.generateMultiLineComment(before.getText());
            }
        }
        before.setType(0);
    }

    protected void generateCommaDelimited(Node node) {
        while (node != null) {
            node.generate(this);
            if ((node = node.getNext()) == null) continue;
            this.print(", ");
        }
    }

    protected void generateConstructorName(Invoke invoke, MethodTypeDescription member) {
        String memberName;
        TypeDescription currentType;
        ObjectClass currentClass = invoke.getParent() != null ? invoke.getCurrentClass() : null;
        boolean ambiguous = false;
        if (currentClass != null && (currentType = currentClass.getTypeDescription()).findClosestMembers(memberName = member.getName(), 0).length != 0) {
            ambiguous = true;
        }
        if (ambiguous) {
            StringBuilder buffer = new StringBuilder();
            this.renderer.renderObjectType(member.getResultType(), this.getContext(invoke), buffer, 2);
            this.print(buffer.toString());
        } else {
            this.generateType(member.getParent(), this.getContext(invoke));
        }
    }

    protected void generateDoBlockBody(DoBlock doblock) {
        OnExit onExit;
        Block declarations = doblock.getDeclarations();
        if (!this.generateInnerDeclarations && declarations != null) {
            this.generateIndented(declarations);
        }
        this.print(this.getNames().startBlockSymbol);
        this.println();
        if (this.generateInnerDeclarations && declarations != null) {
            this.generateIndented(declarations);
        }
        this.generateIndented(doblock.getStatements());
        Block exceptions = doblock.getExceptions();
        if (exceptions != null) {
            ((Node)exceptions).generate(this);
        }
        if ((onExit = doblock.getOnExit()) != null) {
            onExit.generate(this);
        }
        this.print(this.getNames().endBlockSymbol);
    }

    protected void generateDoBlockHeader(DoBlock doblock) {
        String label = doblock.getName();
        if (label != null && !label.equals("")) {
            this.generateLabel(label);
        }
    }

    protected void generateElse(Node elseNode) {
        this.print(this.getNames().elseSymbol);
        this.println();
        this.generateIndented(elseNode);
        this.print(this.getNames().endIfSymbol);
        this.println();
    }

    protected void generateElseIf(Node elseNode) {
        this.print(this.getNames().elseSymbol);
        elseNode.generate(this);
    }

    protected void generateExpr(Node expr) {
        CommonHiddenStreamToken before = expr.getHiddenBefore();
        if (before != null && before.getType() != 0) {
            this.generateBeforeHiddenToken(before);
        }
        this.generateExpr(expr, null);
        CommonHiddenStreamToken after = expr.getHiddenAfter();
        if (after != null && after.getType() != 0) {
            this.generateAfterHiddenToken(after);
        }
    }

    protected void generateExpr(Node expr, Boolean generateParenthesis) {
        boolean needsParenthesis;
        boolean bl = needsParenthesis = generateParenthesis != null ? generateParenthesis.booleanValue() : expr.getParenthesis();
        if (needsParenthesis) {
            this.print("(");
        }
        expr.setParenthesis(needsParenthesis);
        expr.generate(this);
        if (needsParenthesis) {
            this.print(")");
        }
    }

    protected void generateIfPredicate(Node predicate) {
        if (this.codeStyle.getParenthesisInIfs() != 3) {
            predicate.setParenthesis(this.codeStyle.getParenthesisInIfs() == 1);
        }
        this.print(" ");
        this.generateExpr(predicate);
        this.print(" ");
    }

    protected void generateIndented(Node node) {
        if (node != null) {
            this.indent();
            node.generate(this);
            this.unindent();
        }
    }

    protected void generateLabel(LabeledStatement label) {
        this.generateSeparatorBefore(label);
        this.printIdentifier(label.getText());
        this.print(this.getNames().getLabelSuffix());
        this.print(" ");
    }

    protected void generateLabel(String label) {
        this.printIdentifier(label);
        this.println();
    }

    protected void generateLoopBody(LoopStatement loop, Node body, String name, boolean separateWithSpace) {
        if (name != null && !name.equals("")) {
            this.println();
            this.println(name);
        } else if (separateWithSpace) {
            this.print(" ");
        }
        if (body instanceof DoBlock) {
            DoBlock doBlock = (DoBlock)body;
            this.generate(doBlock, name);
        } else {
            this.print(this.getNames().startBlockSymbol);
            this.println();
            this.indent();
            body.generate(this);
            this.unindent();
            this.print(this.getNames().endBlockSymbol);
            if (name != null && !name.equals("")) {
                this.printSpace();
                this.printIdentifier(name);
            }
            this.println();
        }
        this.generateSeparatorAfter(loop);
    }

    protected void generateMethodArgs(MethodTypeDescription method, boolean paranethesisMandatory) {
        int argc = method.getArgumentCount();
        if (argc > 0 || paranethesisMandatory) {
            this.print("(");
        }
        for (int i = 0; i < argc; ++i) {
            this.generateArgument(method.getArgument(i), method.getParent());
            if (i + 1 >= argc) continue;
            this.print(", ");
        }
        if (argc > 0 | paranethesisMandatory) {
            this.print(")");
        }
    }

    protected void generateMethodResult(MethodTypeDescription methodType) {
        if (methodType.getResultType() != TypeFactory.getVoid()) {
            this.printSpaceDelimited(this.getNames().getDeclarationSymbol());
            this.generateType(methodType.getResultType(), methodType.getParent());
        }
    }

    protected void generateMultiLineComment(String comment) {
        this.print(this.getNames().multiLineCommentStart);
        String[] strings = comment.split("\n");
        for (int i = 0; i < strings.length; ++i) {
            String string = strings[i];
            this.print(string);
            if (i == strings.length - 1) continue;
            this.print("\n");
        }
        this.print(this.getNames().multiLineCommentEnd);
    }

    protected void generateRelayTo(Invoke targetInvoke) {
        this.println();
        this.indent();
        this.print(this.getNames().relayToSymbol);
        this.printSpace();
        this.printIdentifier(targetInvoke.getMethodName());
        if (this.useParenthesisForRelayTo) {
            this.print("(");
        }
        this.generateArgsForRelayTo(targetInvoke.getInputArgs());
        if (this.useParenthesisForRelayTo) {
            this.print(")");
        }
        this.unindent();
    }

    protected void generateSeparatorAfter(Node node) {
        Node next = node.getNext();
        CommonHiddenStreamToken hiddenAfter = node.getHiddenAfter();
        if (next == null && hiddenAfter != null) {
            this.generateAfterHiddenToken(hiddenAfter);
        }
        while (next != null) {
            if (!next.isSynthetic() && !next.isFormat()) {
                this.pw.printSeparator();
                break;
            }
            next = next.getNext();
        }
    }

    protected void generateSeparatorBefore(Node node) {
        CommonHiddenStreamToken before;
        for (Node prev = node.getPrev(); prev != null && !prev.isFormat(); prev = prev.getPrev()) {
            if (prev.isSynthetic()) continue;
            this.pw.printSeparator();
            break;
        }
        if ((before = node.getHiddenBefore()) != null) {
            this.generateBeforeHiddenToken(before);
        }
    }

    protected void generateSignleLineComment(String comment) {
        this.print(this.getNames().singleLineComment);
        if (!comment.startsWith(" ")) {
            this.printSpace();
        }
        this.println(comment);
    }

    protected void generateSqlStatementSeparator(Node statement) {
        this.print(this.getNames().getSqlSeparator());
    }

    protected void generateStatementSeparator(Node statement) {
        this.println();
    }

    protected void generateTransformArgs(Node source) {
        if (source instanceof NList) {
            int childCount = source.childCount();
            if (childCount > 1) {
                this.print("(");
            }
            Node sourceArg = source.getFirst();
            while (sourceArg != null) {
                this.generateExpr(sourceArg, Boolean.FALSE);
                if ((sourceArg = sourceArg.getNext()) == null) continue;
                this.print(", ");
            }
            if (childCount > 1) {
                this.print(")");
            }
        } else {
            this.generateExpr(source);
        }
    }

    protected void generateTransformLibrary(Node library) {
        this.print(" using ");
        this.generateExpr(library);
    }

    protected void generateTypeSpecParameters(Node parameters) {
        if (parameters.hasChildren()) {
            this.print(this.getNames().getParameterStart());
            this.generateCommaDelimited(parameters.getFirst());
            this.print(this.getNames().getParameterEnd());
        }
    }

    protected void generateWhere(Node where) {
        this.println();
        this.indent();
        this.print(this.getNames().whereSymbol);
        this.print(" ");
        where.generate(this.getSqlGenerator());
        this.unindent();
        this.println();
    }

    protected TypeDescription getContext(Node node) {
        ObjectClass cl = node.getCurrentClass();
        return cl != null ? cl.getTypeDescription() : null;
    }

    protected int getLongestDeclarationLength(Node declarations) {
        int maxlength = 0;
        for (Declaration declaration = (Declaration)declarations.getFirst(); declaration != null; declaration = (Declaration)declaration.getNext()) {
            Symbol symbol = declaration.getSymbol();
            if (symbol.isSilentAutoDeclared()) continue;
            int length = declaration.getName().length();
            maxlength = length > maxlength ? length : maxlength;
        }
        return maxlength;
    }

    protected SourceGenerator getSqlGenerator() {
        if (this.sqlGenerator == null) {
            this.sqlGenerator = this.createSqlGenerator();
        }
        return this.sqlGenerator;
    }

    protected boolean hasArgs(Args args) {
        if (args != null && args.hasChildren()) {
            for (Node arg = args.getFirst(); arg != null; arg = arg.getNext()) {
                if (arg.isSynthetic()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasChildren(Node node) {
        return node != null && node.hasChildren();
    }

    protected String identifier(String id) {
        if (id.startsWith(".")) {
            id = id.substring(1);
        }
        if (this.reservedWords.containsKey(id)) {
            id = this.escapeId(id);
        }
        return id;
    }

    protected void indent() {
        this.pw.indent();
    }

    protected boolean isComplexExpression(Node node) {
        return node.isComplexExpression();
    }

    protected void print(@NonNls String text) {
        this.pw.print(text);
    }

    protected void print(long value) {
        this.print(String.valueOf(value));
    }

    protected void printIdentifier(String id) {
        this.print(this.identifier(id));
    }

    protected void printIndentedLn(String text) {
        this.indent();
        this.println(text);
        this.unindent();
    }

    protected void println() {
        this.pw.println();
    }

    protected void println(String text) {
        this.pw.println(text);
    }

    protected void printSpace() {
        this.print(" ");
    }

    protected void printSpaceDelimited(String text) {
        this.print(" " + text + " ");
    }

    protected void unindent() {
        this.pw.dedent();
    }

    protected boolean writeAsFunction(MethodTypeDescription member) {
        return true;
    }

    protected void clearSynthetic(Node where) {
        this.clearSyntheticSingle(where);
        NodeIterator nodeIterator = where.getChildren();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.next();
            this.clearSynthetic(node);
        }
    }

    protected void genIncDec(IncDecOperator node, Node operand) {
        if (node.isPostfix()) {
            this.generateExpr(operand);
            this.print(node.isIncrement() ? "++" : "--");
        } else {
            this.print(node.isIncrement() ? "++" : "--");
            this.generateExpr(operand);
        }
    }

    void generateTypeName(Node name, TypeDescription type) {
        TypeDescription context = this.getContext(name);
        this.print(this.renderer.render((TypeRef)type, context, 24));
    }

    private void genAssignment(IncDecOperator node) {
        Node op = node.getFirst();
        op.generate(this);
        this.printSpaceDelimited(this.getNames().getAssignmentOperator());
        op.generate(this);
        this.print(node.isIncrement() ? " + 1" : " - 1");
        this.generateStatementSeparator(node);
    }

    private void generateNewLine(Node left, Node right) {
        int lastLeftLine = left.getLine();
        NodeIterator children = left.getChildren();
        while (children.hasNext()) {
            Node node = children.next();
            int nodeLine = node.getLine();
            if (lastLeftLine >= nodeLine) continue;
            lastLeftLine = nodeLine;
        }
        int rightLine = right.getLine();
        if (lastLeftLine != rightLine) {
            this.println();
        }
    }

    private void printQuoted(String value) {
        this.print("\"");
        this.print(value);
        this.print("\"");
    }

    private void clearSyntheticSingle(Node where) {
        if (where instanceof MemberReference) {
            MemberReference memberReference = (MemberReference)where;
            memberReference.getObject().setSynthetic(false);
        }
    }
}

