/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import fuego.parser.collections.AST;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import oracle.bpm.compiler.ArrayReferenceException;
import oracle.bpm.compiler.ClassConst;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.ConstantPool;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.InvalidIndexException;
import oracle.bpm.compiler.InvalidIndexTypeException;
import oracle.bpm.compiler.LocalVar;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.MissingIndexException;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.UndefinedVariableException;
import oracle.bpm.compiler.ValueReference;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.util.ArrayUtils;

public class ArrayReference
extends Diadic {
    private boolean autoinit = false;
    private ClassConst elementType;
    private String member;
    private Node object;
    static final long serialVersionUID = 4160643947782453918L;
    static final long serialCheck = 3124434347112834921L;

    public ArrayReference(Token t) {
        super(t);
    }

    ArrayReference() {
    }

    ArrayReference(Node array, Node index) {
        this.copyParentFrom(array);
        this.setOperands(array, index);
        this.initialize(array);
    }

    ArrayReference(AST array, AST index) {
        this((Node)array, (Node)index);
    }

    public boolean isAutoInit() {
        return this.autoinit;
    }

    public ClassConst getElementType() {
        if (this.elementType == null) {
            this.elementType = new ClassConst(this.getTypeDescription(), (Node)this);
        }
        return this.elementType;
    }

    public String getMember() {
        return this.member;
    }

    public Node getObject() {
        return this.object;
    }

    @Override
    public Node getTargetValue() {
        return this;
    }

    @Override
    public String getText() {
        return "[]";
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this, this.getOp1(), this.getOp2());
    }

    @Override
    boolean isComplexExpression() {
        return false;
    }

    @Override
    Node checkType() throws TypeException {
        if (this.getKind() != -1) {
            return this;
        }
        Node op1 = this.getOp1();
        Node op2 = this.getOp2();
        op1.setLeftValue(true);
        Node array = op1.checkType();
        if (array == null) {
            throw new UndefinedVariableException(op1);
        }
        TypeDescription arrayType = (array = array.externalNode()).getTypeDescription();
        if (!arrayType.isArray() && arrayType.getKind() != 15) {
            throw new ArrayReferenceException(array, arrayType);
        }
        TypeDescription arrayIndexType = arrayType.getIndexType();
        if (arrayIndexType == null) {
            arrayIndexType = TypeFactory.getPrimitiveInt(32);
        }
        arrayIndexType = this.canonicalType(arrayIndexType);
        if (op2 == null) {
            throw new MissingIndexException(this);
        }
        Node index = op2.checkType(arrayIndexType);
        TypeDescription indexType = index.getTypeDescription();
        if (!arrayIndexType.isAssignableFrom(indexType)) {
            throw new InvalidIndexTypeException(index, arrayIndexType);
        }
        if (arrayType.getKind() == 15 && index.getKind() == 2) {
            arrayIndexType = TypeFactory.getPrimitiveInt(32);
        }
        index = Conversion.promote(index, arrayIndexType);
        TypeDescription elementType = arrayType.getElementType();
        if (!arrayType.isPrimitive() && elementType.isPrimitive()) {
            elementType = elementType.primitiveEquivalent(false);
        }
        this.setTypeDescription(elementType);
        if (arrayType.getKind() != 13 && arrayType.isPrimitive() && array instanceof MemberReference) {
            boolean attribute;
            MemberReference ref = (MemberReference)array;
            TypeDescription objType = ref.getObjType();
            MethodTypeDescription memberType = ref.getMemberType();
            long modifs = memberType.getModifiers();
            this.object = ref.getMemberType().isStatic() ? null : ref.getFirst();
            this.member = MemberAccess.getWriteSignature(objType, memberType);
            boolean bl = attribute = this.member != null && this.member.charAt(0) == 'A';
            if (!Modifier.hasSetter(modifs) && !Modifier.isIn(modifs) || !attribute || objType.isInvokeable()) {
                this.autoinit = false;
            } else {
                this.autoinit = true;
                if (this.getKind() != 12 && this.getKind() != 13) {
                    this.setTypeDescription(this.getTypeDescription().primitiveEquivalent(false));
                }
            }
        }
        if (array instanceof LocalVar) {
            array = new Deref(array);
            array = array.checkType();
        }
        this.setOperands(array, index);
        if (array.isExternal()) {
            String type = Conversion.getElementType(array.getJavaType());
            return Conversion.Import.create(this, type, elementType).checkType(elementType);
        }
        return this;
    }

    @Override
    void collectConstants(ConstantPool cp) {
        super.collectConstants(cp);
        if (this.elementType != null) {
            this.elementType.collectConstants(cp);
        }
    }

    @Override
    void generate(CodeGenerator cg) throws CodeGenerationException {
        cg.generate(this);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        sql.append(" ? ");
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        Class elemClass;
        TypeDescription arrayType = this.getOp1().getTypeDescription();
        if (this.autoinit) {
            Object instance = this.object.notNullValue(rm);
            Object index = this.getOp2().notNullValue(rm);
            Number indexVal = (Number)index;
            try {
                String field = JavaClass.getFieldNameFromSignature(this.member);
                return ArrayUtils.reference(instance, field, indexVal.longValue());
            }
            catch (NoSuchFieldException e) {
                throw new CompilerExceptionShell((Node)this, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new CompilerExceptionShell((Node)this, (Throwable)e);
            }
        }
        Object index = arrayType.getKind() == 13 ? this.getOp2().value(rm) : this.getOp2().notNullValue(rm);
        Object array = this.getOp1().notNullValue(rm);
        if (arrayType.isPrimitive()) {
            Number indexValue = (Number)index;
            return Array.get(array, indexValue.intValue());
        }
        if (arrayType.getKind() != 13) {
            List list = (List)Cast.force(array);
            Number indexValue = (Number)index;
            int intIndex = indexValue.intValue();
            if (this.isLeftValue()) {
                Class elemClass2 = (Class)Cast.force(this.getElementType().run(rm, false));
                try {
                    Object result;
                    if (elemClass2 != null) {
                        result = ArrayUtils.reference(list, elemClass2, (long)intIndex);
                    } else {
                        TypeDescription elementType = arrayType.getElementType();
                        if (list.size() == intIndex) {
                            result = this.newElement(rm, list, elementType);
                            list.add(result);
                        } else {
                            result = list.get(intIndex);
                            if (result == null) {
                                result = this.newElement(rm, list, elementType);
                                list.set(intIndex, result);
                            }
                        }
                    }
                    return result;
                }
                catch (Exception e) {
                    throw new CompilerExceptionShell((Node)this, (Throwable)e);
                }
            }
            if (intIndex < 0 || intIndex >= list.size()) {
                ValueReference arr = this.reference(list, arrayType);
                ValueReference idx = this.reference(indexValue.intValue(), TypeFactory.getInt());
                rm.exceptionEvent(new InvalidIndexException(this, arr, idx));
                list = (List)Cast.force(arr.get());
                indexValue = (Number)idx.get();
                intIndex = indexValue.intValue();
            }
            return list.get(intIndex);
        }
        Map map = (Map)Cast.force(array);
        Object value = !this.isLeftValue() ? map.get(index) : ((elemClass = (Class)Cast.force(this.getElementType().run(rm, false))) == null ? map.get(index) : ArrayUtils.reference(map, elemClass, index));
        return value;
    }

    private Object newElement(RunningMonitor rm, List list, TypeDescription elementType) throws ExecutionException {
        try {
            if (list instanceof ArrayUtils.Extendable) {
                ArrayUtils.Extendable extendable = (ArrayUtils.Extendable)((Object)list);
                return extendable.createNewElement();
            }
            Const c = Const.valueOf("", elementType, this);
            return c.run(rm);
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CompilerExceptionShell((Node)this, (Throwable)e);
        }
    }
}

