/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.math.BigDecimal;
import oracle.bpm.compiler.CodeGenerationException;
import oracle.bpm.compiler.CodeGenerator;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.DecimalConst;
import oracle.bpm.compiler.Diadic;
import oracle.bpm.compiler.DivideByZeroException;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NumDiadic;
import oracle.bpm.compiler.RealConst;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.lang.Decimal;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.filter.Operation;

public class Arithmetic
extends Diadic {
    private int operator;
    static final String[] OPMETHOD = new String[]{"add", "sub", "mul", "div", "rem"};
    static final int ADD = 0;
    static final int SUB = 1;
    static final int MUL = 2;
    static final int DIV = 3;
    static final int REM = 4;
    private static final String[] opname = new String[]{"+", "-", "*", "/", "%"};
    static final long serialVersionUID = -6646250457644205669L;
    static final long serialCheck = -5788559968087664475L;

    Arithmetic(int op) {
        this(null, op);
    }

    Arithmetic(Token t, int op) {
        super(t);
        if (op != 0 && op != 1 && op != 2 && op != 3 && op != 4) {
            throw Arithmetic.illegal(op);
        }
        this.operator = op;
    }

    Arithmetic(Node op1, int op, Node op2) {
        this(null, op);
        op1.setNext(op2);
        this.setFirst(op1);
        this.initialize(op1);
    }

    public String getOperatorText() {
        return opname[this.operator];
    }

    @Override
    public String getText() {
        return this.getOperatorText();
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    boolean isDecimal() {
        return this.getTypeDescription().isDecimal();
    }

    String getOpMethod() {
        return OPMETHOD[this.operator];
    }

    @Override
    Operation getOperationTree() {
        if (this.isParameter()) {
            return new Operation(0, "?", null);
        }
        Operation op1 = this.getOp1().getOperationTree();
        Operation op2 = this.getOp2().getOperationTree();
        Operation[] operands = new Operation[]{op1, op2};
        switch (this.operator) {
            case 0: {
                return new Operation(13, opname[this.operator], operands);
            }
            case 1: {
                return new Operation(14, opname[this.operator], operands);
            }
            case 2: {
                return new Operation(15, opname[this.operator], operands);
            }
            case 3: {
                return new Operation(16, opname[this.operator], operands);
            }
            case 4: {
                return new Operation(120, opname[this.operator], operands);
            }
        }
        throw Arithmetic.illegal(this.operator);
    }

    int getOperator() {
        return this.operator;
    }

    @Override
    Node checkType() throws TypeException {
        if (this.isSQLScope() && this.getFirst() == null) {
            this.setTypeDescription(TypeFactory.getVoid());
            this.setParametric(false);
            return this;
        }
        Diadic n = NumDiadic.promote((Diadic)super.checkType());
        Node o1 = n.getOp1();
        Node o2 = n.getOp2();
        Node operand = o2 instanceof Conversion ? o2.getOp1() : o2;
        if (this.operator == 3 && operand.isConstant()) {
            if (operand instanceof IntConst) {
                if (((IntConst)operand).value == 0L) {
                    this.reportError(new DivideByZeroException(o2));
                    return o2;
                }
            } else if (operand instanceof DecimalConst && ((DecimalConst)operand).value.intValue() == 0) {
                this.reportError(new DivideByZeroException(o2));
                return o2;
            }
        }
        if (!this.isGeneratingSource() && o1.isConstant() && o2.isConstant()) {
            return ((Const)o1).compute(this.operator, o2).dettach();
        }
        TypeDescription t1 = o1.getTypeDescription();
        if (t1.isDecimal()) {
            TypeDescription t2 = o2.getTypeDescription();
            int t1Scale = t1.getScale();
            int t2Scale = t2.getScale();
            int t1Length = t1.getLength();
            int t2Length = t2.getLength();
            switch (this.operator) {
                case 0: 
                case 1: 
                case 4: {
                    int scale = t1Scale < 0 || t2Scale < 0 ? -1 : Math.max(t1Scale, t2Scale);
                    int t1Digits = Arithmetic.getDecimalDigits(t1Length, t1Scale);
                    int t2Digits = Arithmetic.getDecimalDigits(t2Length, t2Scale);
                    int maxDigits = Math.max(t1Digits, t2Digits);
                    if (maxDigits != Integer.MAX_VALUE && this.operator != 4) {
                        ++maxDigits;
                    }
                    int length = maxDigits == Integer.MAX_VALUE ? -1 : (scale < 0 ? maxDigits : maxDigits + scale);
                    t1 = TypeFactory.getDecimal(length, scale);
                    break;
                }
                case 2: {
                    int length = t1Length < 0 || t2Length < 0 ? -1 : t1Length + t2Length;
                    int scale = t1Scale < 0 || t2Scale < 0 ? -1 : t1Scale + t2Scale;
                    t1 = TypeFactory.getDecimal(length, scale);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw Arithmetic.illegal(this.operator);
                }
            }
        }
        n.setTypeDescription(t1);
        return n;
    }

    @Override
    void generate(CodeGenerator cg) throws CodeGenerationException {
        cg.generate(this);
    }

    @Override
    void generateSQLCode(StringBuffer sql) {
        if (!this.checkParameter(sql)) {
            if (this.getKind() == 0) {
                sql.append(" * ");
            } else {
                this.getOp1().generateSQLCode(sql);
                sql.append(" ").append(this.getText()).append(" ");
                this.getOp2().generateSQLCode(sql);
            }
        }
    }

    @Override
    Object run(RunningMonitor rm) throws ExecutionException {
        TypeDescription t = this.getOp1().getTypeDescription();
        Object op1 = this.getOp1().value(rm);
        Object op2 = this.getOp2().value(rm);
        switch (t.getKind()) {
            case 3: {
                BigDecimal o1 = (BigDecimal)op1;
                BigDecimal o2 = (BigDecimal)op2;
                switch (this.operator) {
                    case 0: {
                        return Decimal.add(o1, o2);
                    }
                    case 1: {
                        return Decimal.sub(o1, o2);
                    }
                    case 2: {
                        return Decimal.mul(o1, o2);
                    }
                    case 3: {
                        return Decimal.div(o1, o2);
                    }
                    case 4: {
                        return Decimal.rem(o1, o2);
                    }
                }
                throw Arithmetic.illegal(this.operator);
            }
            case 2: {
                Number o1 = (Number)op1;
                Number o2 = (Number)op2;
                o1 = o1 != null ? (Number)o1 : (Number)0L;
                o2 = o2 != null ? (Number)o2 : (Number)0L;
                long result = 0L;
                switch (this.operator) {
                    case 0: {
                        result = o1.longValue() + o2.longValue();
                        break;
                    }
                    case 1: {
                        result = o1.longValue() - o2.longValue();
                        break;
                    }
                    case 2: {
                        result = o1.longValue() * o2.longValue();
                        break;
                    }
                    case 3: {
                        result = o1.longValue() / o2.longValue();
                        break;
                    }
                    case 4: {
                        result = o1.longValue() % o2.longValue();
                    }
                }
                return IntConst.createValue(result, t);
            }
            case 4: {
                Number o1 = (Number)op1;
                Number o2 = (Number)op2;
                o1 = o1 != null ? (Number)o1 : (Number)0.0;
                o2 = o2 != null ? (Number)o2 : (Number)0.0;
                double result = 0.0;
                switch (this.operator) {
                    case 0: {
                        result = o1.doubleValue() + o2.doubleValue();
                        break;
                    }
                    case 1: {
                        result = o1.doubleValue() - o2.doubleValue();
                        break;
                    }
                    case 2: {
                        result = o1.doubleValue() * o2.doubleValue();
                        break;
                    }
                    case 3: {
                        result = o1.doubleValue() / o2.doubleValue();
                        break;
                    }
                    case 4: {
                        result = o1.doubleValue() % o2.doubleValue();
                    }
                }
                return RealConst.createValue(result, t);
            }
        }
        return null;
    }

    private static int getDecimalDigits(int length, int scale) {
        return length < 0 ? Integer.MAX_VALUE : (scale < 0 ? length : length - scale);
    }

    private static RuntimeException illegal(int operator) {
        return new IllegalStateException("Invalid Operator: " + operator);
    }

    public static class Rem
    extends Arithmetic {
        static final long serialVersionUID = 4227896736046332202L;
        static final long serialCheck = -589157407589276497L;

        public Rem(Token t) {
            super(t, 4);
        }
    }

    public static class Mul
    extends Arithmetic {
        static final long serialVersionUID = -1213398257503909801L;
        static final long serialCheck = -1527704258300556586L;

        public Mul(Token t) {
            super(t, 2);
        }
    }

    public static class Div
    extends Arithmetic {
        static final long serialVersionUID = -4306174297072310289L;
        static final long serialCheck = 7868926778719087065L;

        public Div(Token t) {
            super(t, 3);
        }
    }
}

