/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import fuego.parser.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.bpm.compiler.Arg;
import oracle.bpm.compiler.ArgumentNumberException;
import oracle.bpm.compiler.ArgumentTypeException;
import oracle.bpm.compiler.ArrayReference;
import oracle.bpm.compiler.Assignment;
import oracle.bpm.compiler.CollectionPool;
import oracle.bpm.compiler.CompilerExceptionShell;
import oracle.bpm.compiler.Const;
import oracle.bpm.compiler.Conversion;
import oracle.bpm.compiler.Deref;
import oracle.bpm.compiler.DuplicatedArgumentException;
import oracle.bpm.compiler.ExecutionException;
import oracle.bpm.compiler.Identifier;
import oracle.bpm.compiler.IllegalArgumentException;
import oracle.bpm.compiler.IndexedNamedNode;
import oracle.bpm.compiler.IntConst;
import oracle.bpm.compiler.InvalidAssignmentException;
import oracle.bpm.compiler.Invoke;
import oracle.bpm.compiler.MemberAccess;
import oracle.bpm.compiler.MemberReference;
import oracle.bpm.compiler.NamedNode;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.NotAnInputArgumentException;
import oracle.bpm.compiler.NotAnOutputArgumentException;
import oracle.bpm.compiler.NullConst;
import oracle.bpm.compiler.RunningMonitor;
import oracle.bpm.compiler.Scope;
import oracle.bpm.compiler.SourceGenerator;
import oracle.bpm.compiler.Template;
import oracle.bpm.compiler.TemplateFactory;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.UndefinedVariableException;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.JavaEnumTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.Argument;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.util.ArrayUtils;
import org.jetbrains.annotations.NonNls;

public class Args
extends Node {
    private Invoke invoke;
    private Map<String, TypeDescription> namedArgs;
    private Arg returnArg;
    private String[] synteticArgs;
    private int totalArgc;
    private int totalNumberArg;
    private long type;
    private TypeDescription[] unnamedArgs;
    private boolean wasRelay;
    private static final TypeDescription[] EMPTY_ARGS = new TypeDescription[0];
    static final long IN = 1L;
    public static final long OUT = 2L;
    public static final long RELAY = 256L;
    private static final String[] EMPTY_STRING = new String[0];
    static final long serialVersionUID = 4449091466371536328L;
    static final long serialCheck = 6889115104308335707L;

    public Args(Token t) {
        this(t, 1L);
    }

    Args(long type) {
        this(null, type);
    }

    Args(long type, Node args) {
        this.type = type;
        if (args != null) {
            this.copyParentFrom(args);
            this.setFirst(args);
            this.initialize(args);
        }
    }

    private Args(Token t, long type) {
        super(t);
        this.type = type;
    }

    @Override
    public String getText() {
        return this.type == 2L ? "out" : (this.type == 1L ? "in" : "relay-to");
    }

    public void setWasRelay(boolean b) {
        this.wasRelay = b;
    }

    public void addParametersTo(Template refactor) {
        int argno = 1;
        Arg arg = (Arg)this.getFirst();
        while (arg != null) {
            refactor.addParameter(String.valueOf(argno), arg.getValue());
            arg = (Arg)arg.getNext();
            ++argno;
        }
    }

    public Object[] runBindings(RunningMonitor rm) throws ExecutionException {
        ArrayList<Object> bindings = new ArrayList<Object>();
        for (Arg argNode = (Arg)this.getFirst(); argNode != null; argNode = (Arg)argNode.getNext()) {
            argNode.runBinding(rm, bindings);
        }
        return bindings.toArray(new Object[bindings.size()]);
    }

    public void setArgType(long type) {
        this.type = type;
    }

    public void addOutArgument(Node arg) {
        assert (this.isOut()) : "Output arguments can only be added only if Args isOut()";
        arg.setNext(null);
        arg.initialize(this);
        Node first = this.getFirst();
        if (first == null) {
            this.setFirst(arg);
        } else {
            first.getLast().setNext(arg);
        }
    }

    @Override
    public void generate(SourceGenerator cg) {
        cg.generate(this);
    }

    static Args empty(Scope scp, long type) {
        Args args = new Args(type);
        args.setScope(scp);
        return args;
    }

    static Args ensureNotNullArgs(Invoke invokeNode, Args args, Scope scp) {
        if (args == null) {
            args = new Args(1L);
            args.initialize(invokeNode);
            args.setScope(scp);
            args.setParent(invokeNode);
        }
        if (args.getNext() == null) {
            if (args.isIn()) {
                Args out = new Args(2L);
                out.initialize(invokeNode);
                out.setScope(scp);
                out.setParent(invokeNode);
                args.setNext(out);
            } else {
                Args in = new Args(1L);
                in.initialize(invokeNode);
                in.setScope(scp);
                in.setParent(invokeNode);
                in.setNext(args);
                args = in;
            }
        }
        return args;
    }

    int getArgCount() {
        return this.totalArgc;
    }

    void setInvoke(Invoke invoke) {
        this.invoke = invoke;
        if (this.getNext() != null) {
            Args next = (Args)this.getNext();
            next.setInvoke(invoke);
        }
    }

    Invoke getInvoke() {
        return this.invoke;
    }

    boolean isOut() {
        return this.type == 2L;
    }

    int getPrintableArgCount() {
        return this.getArgCount() - this.getSynteticArgs().length;
    }

    boolean isRelay() {
        return this.type == 256L;
    }

    Arg getReturnArg() {
        return this.returnArg;
    }

    void setSyntheticArgs(String[] args) {
        this.synteticArgs = args;
    }

    boolean getWasRelay() {
        return this.wasRelay;
    }

    void addInArgument(Node value) {
        assert (this.isIn() || this.isRelay()) : this.type;
        value.setNext(null);
        value.initialize(this);
        Node first = this.getFirst();
        if (first == null) {
            this.setFirst(value);
        } else {
            first.getLast().setNext(value);
        }
    }

    void addInArgument(@NonNls String argName, Node value) {
        this.addInArgument(new NamedNode(argName, value));
    }

    void addOutArgument(Node lvalue, String argName) {
        this.addOutArgument(new NamedNode(argName, lvalue));
    }

    void addOutputOnlyHolders() throws TypeException {
        MethodTypeDescription method = this.invoke.getMemberType();
        int argc = method.getArgumentCount();
        for (int i = 0; i < argc; ++i) {
            Argument argument = method.getArgument(i);
            if (!argument.isOut() || argument.isIn()) continue;
            String name = argument.getName();
            Argument arg = this.invoke.findArgument(i, name, this);
            Node holder = this.invoke.isDynamic() ? new NullConst(this) : this.autodeclareHolder(arg);
            Arg argNode = this.addArg(arg, arg.getType(), holder, -1);
            argNode.setSynthetic(true);
            if (this.invoke.isDynamic()) continue;
            argNode.init(new NullConst(this));
        }
    }

    void checkArguments() throws TypeException {
        MethodTypeDescription method;
        int argc;
        if (this.getKind() != -1) {
            return;
        }
        assert (!this.isRelay()) : "Args must be IN or OUT";
        this.setFirst(null);
        for (Node current = this.getFirst(); current != null; current = current.getNext()) {
            Node node = current;
            node.setNext(null);
            this.checkArgument(node);
        }
        if (this.isIn() && this.totalNumberArg != (argc = (method = this.invoke.getMemberType()).getInputArgumentCount())) {
            for (int i = 0; i < argc; ++i) {
                boolean relayToFromFuego1;
                Arg argNode = this.getArgByPosition(i);
                if (argNode != null) continue;
                Argument arg = this.getInvoke().findArgument(i, null, this);
                boolean optional = arg.isOptional();
                boolean bl = relayToFromFuego1 = this.getInvoke().isRelay() && this.getCurrentLanguage().isFuego1();
                if (!optional && !relayToFromFuego1) {
                    throw new ArgumentNumberException((Node)this, method);
                }
                if (arg.isAttribute()) continue;
                String defValue = arg.getDefaultValue();
                TypeDescription argType = arg.getType();
                try {
                    Node defaultValue;
                    if (defValue != null && !defValue.equals("")) {
                        defaultValue = TemplateFactory.defaultValue(argType, defValue);
                        defaultValue.initialize(this);
                    } else {
                        defaultValue = argType.isPredefined() && argType.isPrimitive() ? Const.valueOf("", argType, this) : new NullConst(this);
                    }
                    if (this.invoke.isDynamic() || this.invoke.isRelay()) {
                        argType = argType.setReferenceType(true);
                    }
                    defaultValue = defaultValue.checkType();
                    defaultValue = Conversion.promote(defaultValue, argType);
                    Arg addedArg = this.addArg(arg, argType, defaultValue, -1);
                    addedArg.setSynthetic(!relayToFromFuego1);
                    continue;
                }
                catch (TypeException e) {
                    this.reportError(e);
                }
            }
        }
        this.setTypeDescription(TypeFactory.getVoid());
    }

    Arg getArgByName(String name) {
        Argument arg;
        Arg result;
        for (result = (Arg)this.getFirst(); !(result == null || (arg = result.getArgument()) != null && name.equals(arg.getName())); result = (Arg)result.getNext()) {
        }
        return result;
    }

    String[] getBindings() {
        String[] result = new String[2 * this.getArgCount()];
        int index = 0;
        for (Arg arg = (Arg)this.getFirst(); arg != null; arg = (Arg)arg.getNext()) {
            Argument targetArg = arg.getArgument();
            assert (targetArg.isArgument()) : "targetArg is not an argument";
            Argument sourceArg = arg.getSourceArgument();
            if (sourceArg == null) {
                result[index++] = null;
            } else {
                String signature;
                if (sourceArg.isArgument()) {
                    signature = "#" + sourceArg.getNumber();
                } else if (sourceArg.isReturnValue()) {
                    signature = "#R";
                } else {
                    signature = sourceArg.getType().getSignature();
                    Arg sourceArgNode = (Arg)arg.getValue();
                    if (sourceArgNode.isIndexed()) {
                        signature = JavaClass.buildIndexedSignature(signature, sourceArgNode.getIndex());
                    }
                }
                result[index++] = signature;
            }
            result[index++] = targetArg.getName();
        }
        return result;
    }

    Map<String, TypeDescription> getNamedArgs() throws TypeException {
        if (this.namedArgs == null) {
            this.loadArgs();
        }
        return this.namedArgs;
    }

    boolean isReturnOnly() {
        return this.getFirst() != null && this.getFirst() == this.returnArg && this.getFirst().getNext() == null;
    }

    TypeDescription[] getUnnamedArgs() throws TypeException {
        if (this.unnamedArgs == null) {
            this.loadArgs();
        }
        return this.unnamedArgs;
    }

    Arg findArgument(String name) {
        Arg arg;
        for (arg = (Arg)this.getFirst(); arg != null && !name.equals(arg.getName()); arg = (Arg)arg.getNext()) {
        }
        return arg;
    }

    Node removeFirstArgument() {
        Node first = this.getFirst();
        this.setFirst(first != null ? first.getNext() : null);
        if (this.unnamedArgs != null) {
            TypeDescription[] array = new TypeDescription[this.unnamedArgs.length - 1];
            System.arraycopy(this.unnamedArgs, 1, array, 0, this.unnamedArgs.length - 1);
            this.unnamedArgs = array;
        }
        return first;
    }

    Object runHolderInit(RunningMonitor rm) throws ExecutionException {
        for (Arg argNode = (Arg)this.getFirst(); argNode != null; argNode = (Arg)argNode.getNext()) {
            Argument arg = argNode.getArgument();
            if (!arg.isArgument() || !arg.isOut()) continue;
            argNode.runInitCode(rm);
        }
        return null;
    }

    Object runInputArgs(RunningMonitor rm) throws ExecutionException {
        TypeDescription objType = this.invoke.getObjType();
        Arg argNode = (Arg)this.getFirst();
        List array = CollectionPool.getArrayList();
        while (argNode != null) {
            Arg next = (Arg)argNode.getNext();
            Argument arg = argNode.getArgument();
            if (this.invoke.isDynamic()) {
                String signature;
                String string = signature = arg.isArgument() ? "#" + arg.getNumber() : MemberAccess.getWriteSignature(objType, arg.getType().asAttribute());
                if (signature == null) assert (false) : "Signature for " + arg.getName() + " from " + objType + " is null";
                array.add(signature);
                array.add(argNode.getValue().value(rm));
            } else if (arg.isArgument()) {
                array.add(argNode.getValue().value(rm));
            }
            argNode = next;
        }
        Object[] result = array.toArray();
        CollectionPool.releaseArrayList(array);
        return result;
    }

    Object runInputAttr(RunningMonitor rm, Object instance) throws ExecutionException {
        TypeDescription objType = this.invoke.getObjType();
        for (Arg argNode = (Arg)this.getFirst(); argNode != null; argNode = (Arg)argNode.getNext()) {
            Argument arg = argNode.getArgument();
            if (!arg.isAttribute()) continue;
            Object argValue = argNode.getValue().value(rm);
            try {
                AttributeTypeDescription attr = arg.getType().asAttribute();
                String signature = MemberAccess.getWriteSignature(objType, attr);
                objType.invokeMethod(signature, instance, new Object[]{argValue});
                continue;
            }
            catch (ComponentExecutionException e) {
                throw new CompilerExceptionShell((Node)this, (Throwable)e);
            }
        }
        return null;
    }

    Object runOutputArgs() throws ExecutionException {
        if (!this.invoke.isDynamic()) {
            return null;
        }
        Arg argNode = (Arg)this.getFirst();
        List array = CollectionPool.getArrayList();
        while (argNode != null) {
            Arg next = (Arg)argNode.getNext();
            Argument arg = argNode.getArgument();
            if (arg.isArgument()) {
                array.add("#" + arg.getNumber());
            } else if (arg.isAttribute()) {
                array.add(arg.getType().getSignature());
            }
            argNode = next;
        }
        Object[] result = array.isEmpty() ? null : array.toArray();
        CollectionPool.releaseArrayList(array);
        return result;
    }

    Object runOutputAttr(RunningMonitor rm) throws ExecutionException {
        for (Arg argNode = (Arg)this.getFirst(); argNode != null; argNode = (Arg)argNode.getNext()) {
            Node n;
            if (!argNode.isOut() || (n = argNode.getPostInvocationInstruction()) == null) continue;
            n.run(rm);
        }
        return null;
    }

    private Arg getArgByPosition(int position) {
        for (Arg arg = (Arg)this.getFirst(); arg != null; arg = (Arg)arg.getNext()) {
            Argument argument = arg.getArgument();
            if (!argument.isArgument() || argument.getNumber() != position) continue;
            return arg;
        }
        return null;
    }

    private boolean isIn() {
        return this.type == 1L;
    }

    private int getNextArgNumber() {
        int result = 0;
        for (Node n = this.getFirst(); n != null; n = n.getNext()) {
            Argument a = ((Arg)n).getArgument();
            if (!a.isArgument() || a.getNumber() != result) continue;
            ++result;
        }
        return result;
    }

    private String[] getSynteticArgs() {
        return this.synteticArgs != null ? this.synteticArgs : EMPTY_STRING;
    }

    private Arg addArg(Argument argument, TypeDescription type, Node node, int index) {
        Argument a;
        Node current;
        Arg arg = new Arg(argument, node, index, this.type, ArrayUtils.contains(this.getSynteticArgs(), (Object)argument.getName()));
        arg.setTypeDescription(type);
        arg.setScope(this.getScope());
        if (argument.isReturnValue()) {
            this.returnArg = arg;
        }
        int argno = -1;
        if (argument.isArgument()) {
            argno = argument.getNumber();
            ++this.totalNumberArg;
        }
        Node prevnode = null;
        for (current = this.getFirst(); !(current == null || this.isIn() && (a = ((Arg)current).getArgument()).isArgument() && a.getNumber() > argno); current = current.getNext()) {
            prevnode = current;
        }
        arg.setNext(current);
        if (prevnode == null) {
            this.setFirst(arg);
        } else {
            prevnode.setNext(arg);
        }
        if (!arg.getArgument().isReturnValue()) {
            ++this.totalArgc;
        }
        return arg;
    }

    private Node autodeclareHolder(Argument arg) throws TypeException {
        return this.autodeclareHolder(arg, null);
    }

    private Node autodeclareHolder(Argument arg, Node init) throws TypeException {
        return Identifier.autodeclare(this.invoke.getArgPrefix(), arg, init != null ? init : this);
    }

    private void checkArgument(Node node) throws TypeException {
        if (this.isOut()) {
            this.checkOutputArg(node);
        } else {
            this.checkInputArg(node);
        }
    }

    private void checkInputArg(Node node) throws TypeException {
        Node expr;
        Argument arg;
        TypeException relayToException = null;
        MethodTypeDescription memberType = this.invoke.getMemberType();
        if (node instanceof NamedNode) {
            NamedNode namedNode;
            Node op2 = node.getOp2();
            if (op2 instanceof Deref && this.invoke.isRelay()) {
                node.setOperands(node.getOp1(), op2.getFirst());
            }
            if ((arg = this.invoke.findArgument((namedNode = (NamedNode)node).getName(), namedNode.getOp1(), this.type)).isAttribute()) {
                if (this.invoke.isRelay()) {
                    throw new IllegalArgumentException(namedNode, memberType, arg.getName());
                }
                if (memberType.isStatic() && !memberType.isConstructor() && !Modifier.isStatic(arg.getModifiers())) {
                    throw new IllegalArgumentException(namedNode, memberType, arg.getName());
                }
            }
            expr = namedNode.getTargetNode();
            if (this.invoke.isRelay() && (expr instanceof Identifier || expr instanceof Deref)) {
                Invoke parentInvoke = (Invoke)this.invoke.getParent();
                Argument sourceArg = null;
                String argName = expr instanceof Deref ? expr.getOp1().getText() : expr.getText();
                try {
                    sourceArg = parentInvoke.findArgument(argName, expr, this.type);
                }
                catch (TypeException ignore) {
                    relayToException = ignore;
                }
                if (sourceArg != null) {
                    if (!sourceArg.isOut() && !sourceArg.isReturnValue()) {
                        throw new NotAnOutputArgumentException(expr, parentInvoke.getMemberType(), argName);
                    }
                    Arg source = new Arg(sourceArg, this.type);
                    source.initialize(expr);
                    source.setParent(this);
                    TypeDescription srcType = sourceArg.getType();
                    TypeDescription typeDescription = srcType = srcType.isAttribute() ? srcType.asAttribute().getResultType() : srcType;
                    if (namedNode instanceof IndexedNamedNode) {
                        IndexedNamedNode indexedNamedNode = (IndexedNamedNode)namedNode;
                        source.setIndex(indexedNamedNode.getIndex());
                    }
                    srcType = namedNode.getNameType() != null ? namedNode.getNameType() : srcType;
                    source.setTypeDescription(srcType);
                    expr = source;
                }
            }
        } else {
            arg = this.invoke.findArgument(this.getNextArgNumber(), null, node);
            expr = node;
        }
        TypeDescription argType = arg.getType();
        argType = arg.isAttribute() ? argType.asAttribute().getResultType() : argType;
        Node originalExpr = expr;
        expr = expr.checkType(argType);
        if (expr == null) {
            if (relayToException != null) {
                throw relayToException;
            }
            throw new UndefinedVariableException(originalExpr);
        }
        if (!arg.isIn()) {
            node = node instanceof NamedNode ? node.getFirst() : node;
            throw new NotAnInputArgumentException(node, arg.getName(), memberType);
        }
        if (this.invoke.isDynamic() || this.invoke.isRelay()) {
            argType = argType.setReferenceType(true);
        }
        if (!argType.isAssignableFrom(expr.getTypeDescription())) {
            if (this.isAssignableFrom45(argType, expr.getTypeDescription())) {
                expr = Conversion.promoteFrom45(expr, argType);
            } else {
                throw new ArgumentTypeException(expr, arg, memberType);
            }
        }
        if (!(expr instanceof Arg)) {
            expr = Conversion.promote(expr, argType);
        }
        if (arg.isExternal()) {
            expr = Conversion.Export.create(expr, arg.getJavaType(), argType).checkType(argType);
        }
        if (arg.isArgument() && arg.isOut() && !this.invoke.isDynamic() && !this.invoke.isRelay() && !this.isGeneratingSource()) {
            Node holder = this.autodeclareHolder(arg, node);
            Arg argNode = this.addArg(arg, argType, holder, -1);
            argNode.init(expr);
        } else {
            this.addArg(arg, argType, expr, -1);
        }
    }

    private void checkOutputArg(Node node) throws TypeException {
        TypeDescription lvalueType;
        Node lvalue;
        TypeDescription castType;
        TypeDescription argType;
        Argument arg;
        boolean isArrayReference = false;
        int index = -1;
        MethodTypeDescription member = this.invoke.getMemberType();
        if (node instanceof NamedNode) {
            NamedNode namedNode = (NamedNode)node.checkType();
            if (namedNode.getOp1().isCompletion()) {
                namedNode.getOp1().complete(4, this);
            }
            arg = this.invoke.findArgument(namedNode.getName(), namedNode, this.type);
            if (node instanceof IndexedNamedNode) {
                index = ((IndexedNamedNode)namedNode).getIndex();
                isArrayReference = true;
            }
            if (arg.isReturnValue()) {
                if (arg.getType().isVoid()) {
                    throw new NotAnInputArgumentException(node, "return", member);
                }
            } else if (!arg.isOut()) {
                throw new NotAnOutputArgumentException(node, member, arg.getName());
            }
            argType = arg.getType();
            argType = arg.isAttribute() ? argType.asAttribute().getResultType() : argType;
            castType = namedNode.getNameType();
            if (castType == null) {
                castType = argType;
            }
            Node targetNode = namedNode.getTargetNode();
            lvalue = targetNode.getAutoDeclared(castType);
        } else {
            Argument ret = member.getResultArgument();
            castType = argType = ret.getType();
            if (argType.isVoid()) {
                throw new NotAnOutputArgumentException(this.invoke.getObject(), member, "return");
            }
            arg = new Argument(member.getResultArgument().getName(), argType, 16L);
            arg.setJavaType(ret.getJavaType());
            if (Modifier.isExternal(ret.getModifiers())) {
                arg.setExternal(true);
            }
            lvalue = node.getAutoDeclared(argType);
        }
        if (this.invoke.isDynamic()) {
            argType = argType.setReferenceType(true);
            castType = castType.setReferenceType(true);
        }
        if (!(lvalueType = lvalue.getTypeDescription()).isAssignableFrom(castType)) {
            throw new InvalidAssignmentException(node, castType, lvalueType);
        }
        if (arg.isReturnValue()) {
            this.addArg(arg, argType, lvalue, index);
        } else {
            Node rval = null;
            if (this.invoke.isDynamic()) {
                Node ret = this.invoke.getReturnArray();
                rval = new ArrayReference(Node.deepCopy(ret), new IntConst((long)this.totalArgc, ret));
                rval = Conversion.promote(rval.checkType(), argType);
                if (isArrayReference) {
                    rval = new ArrayReference(rval, new IntConst(index));
                    rval = Conversion.promote(rval.checkType(), castType);
                }
            } else if (arg.isAttribute()) {
                rval = new MemberReference(this.invoke.getObjectNode(), new Identifier(arg.getName()), arg.getType().asAttribute());
            } else if (arg.isArgument()) {
                rval = this.autodeclareHolder(arg, lvalue);
                rval = new Deref(rval);
            }
            Node post = new Assignment(lvalue, rval);
            post.setParent(this);
            post.initialize(rval);
            post.setScope(this.invoke.getScope());
            post = ((Node)post).checkType();
            Arg addedArg = this.addArg(arg, argType, lvalue, index);
            addedArg.setPostInvocationInstruction(post);
        }
    }

    private void loadArgs() throws TypeException {
        assert (!this.isRelay()) : "Args must be IN or OUT";
        List<TypeDescription> argTypes = null;
        Map<String, TypeDescription> namedArgs = CollectionPool.getHashMap();
        Node current = this.getFirst();
        Node prev = null;
        while (current != null) {
            Node next = current.getNext();
            if (current.isCompletion()) {
                current.complete(3, this);
            } else if (current instanceof NamedNode) {
                NamedNode namedNode = (NamedNode)current;
                TypeDescription type = null;
                try {
                    if (this.invoke != null && this.invoke.isRelay()) {
                        try {
                            Argument arg = this.invoke.findArgument(namedNode.getName(), namedNode.getOp1(), this.type);
                            type = arg.getType();
                        }
                        catch (IllegalArgumentException ignore) {
                            // empty catch block
                        }
                    }
                    if (type == null) {
                        namedNode = (NamedNode)current.checkType();
                    }
                }
                catch (UndefinedVariableException e) {
                    namedNode.setTypeDescription(new JavaEnumTypeDescription.Unknown(e.getId()));
                }
                String name = namedNode.getName();
                if (!(current instanceof IndexedNamedNode) && namedArgs.containsKey(name)) {
                    this.reportError(new DuplicatedArgumentException(namedNode, this.invoke.getMemberType(), name));
                }
                if (type == null && this.isOut()) {
                    Argument arg = this.invoke.findArgument(name, namedNode, this.type);
                    type = arg.getType();
                } else if (type == null) {
                    type = namedNode.getTypeDescription();
                }
                namedArgs.put(name, type);
            } else if (this.isOut()) {
                if (argTypes == null) {
                    argTypes = CollectionPool.getArrayList();
                }
                argTypes.add(TypeFactory.getAny());
            } else {
                TypeDescription exprType;
                try {
                    current = current.checkType();
                    exprType = current.getTypeDescription();
                }
                catch (UndefinedVariableException e) {
                    exprType = new JavaEnumTypeDescription.Unknown(e.getId());
                }
                if (prev == null) {
                    this.setFirst(current);
                } else {
                    prev.setNext(current);
                }
                current.setNext(next);
                if (argTypes == null) {
                    argTypes = CollectionPool.getArrayList();
                }
                argTypes.add(exprType);
            }
            prev = current;
            current = next;
        }
        if (argTypes == null) {
            this.unnamedArgs = EMPTY_ARGS;
        } else {
            this.unnamedArgs = new TypeDescription[argTypes.size()];
            argTypes.toArray(this.unnamedArgs);
        }
        this.namedArgs = namedArgs;
        CollectionPool.releaseArrayList(argTypes);
    }
}

