/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import java.util.List;
import oracle.bpm.compiler.Node;
import oracle.bpm.compiler.TypeException;
import oracle.bpm.compiler.msg.CompilerMsg;
import oracle.bpm.lang.MethodTypeDescription;

public class AmbiguousCallException
extends TypeException {
    static final long serialVersionUID = 8363017321184465036L;
    static final long serialCheck = -182963963283974622L;

    AmbiguousCallException(Node call, List methods, MethodTypeDescription methodToInvoke) {
        super(call);
        int size = methods.size();
        assert (size >= 2) : size;
        String components = "";
        for (int i = 0; i < size; ++i) {
            MethodTypeDescription method = (MethodTypeDescription)methods.get(i);
            if (i != 0) {
                components = components + " / ";
            }
            components = components + this.getMethodText(method);
        }
        this.setKey(CompilerMsg.AMBIGUOUSCALL(components, this.getMethodText(methodToInvoke)));
    }

    private String getMethodText(MethodTypeDescription mtd) {
        return (mtd.getParentRef() != null ? mtd.getParentRef().getText() + "." : "") + mtd.getText();
    }
}

