/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.compiler;

import oracle.bpm.compiler.Method;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFinder;

class Accessor
extends Method {
    protected AttributeTypeDescription attr;
    protected int attrIndex;
    private int attrCount;
    private static final long ATTRIBUTE_MODIFIERS = 47L;
    static final long serialVersionUID = 3714162806277184351L;
    static final long serialCheck = -6856620864117510909L;

    Accessor(AttributeTypeDescription attr, int attrIndex) {
        super(attr);
        this.attr = attr;
        this.attrIndex = attrIndex;
        this.setName(this.attr.getName());
        this.setTypeDescription(attr);
    }

    @Override
    public boolean isGenerateAdaptor() {
        return false;
    }

    protected void checkOverridings(MethodTypeDescription method) {
        TypeDescription currentType = this.getCurrentClass().getTypeDescription();
        AttributeTypeDescription baseMember = currentType.findAttribute(method.getName(), TypeFinder.Scope.INHERITED);
        if (baseMember != null && baseMember.isAttribute()) {
            boolean currentIsExternal;
            AttributeTypeDescription baseAttribute = baseMember.asAttribute();
            boolean baseIsExternal = baseAttribute.isExternal();
            if (baseIsExternal != (currentIsExternal = this.attr.isExternal())) {
                if (baseIsExternal) {
                    this.attr.addModifiers(2048L);
                    this.attr.setJavaType(baseAttribute.getJavaType());
                } else {
                    this.attr.clearModifier(2048L);
                    this.attr.setJavaType(null);
                }
            }
            this.setOverride(true);
            this.setWrapTypedExceptions(true);
            if (!baseMember.getResultType().equals(this.attr.getResultType())) {
                // empty if block
            }
        }
    }

    int getAttrIndex() {
        return this.attrIndex;
    }

    void setAttrCount(int count) {
        this.attrCount = count;
    }

    long getBitIndex() {
        return 1L << this.attrIndex % 64;
    }

    @Override
    String getFullName() {
        return JavaClass.getMethodNameFromSignature(this.getJavaSignature());
    }

    int getUnit() {
        return this.attrIndex / 64;
    }

    MethodTypeDescription createMethod() {
        ObjectTypeDescription objType = this.getCurrentClass().getObjectType();
        MethodTypeDescription method = new MethodTypeDescription(this.getName());
        method.setParent(objType);
        long mods = this.attr.getModifiers();
        method.setModifiers(mods &= 0xFFFFFFFFFFFFFFD0L);
        return method;
    }
}

