/*
 * Decompiled with CFR 0.152.
 */
package fuego.debugger;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import fuego.debugger.DebugSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import oracle.bpm.io.StreamUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LocalDebugSession
extends DebugSession {
    private final String[] args;
    private final String className;
    @NonNls
    private static final String JDI_COMMAND_LINE_LAUNCH = "com.sun.jdi.CommandLineLaunch";
    @NonNls
    private static final String MAIN_ARG = "main";
    @NonNls
    private static final String OPTIONS_ARG = "options";

    LocalDebugSession(String className, String ... args) {
        this.className = className;
        this.args = (String[])args.clone();
    }

    public int waitFinish() throws InterruptedException {
        return this.getVirtualMachine().process().waitFor();
    }

    @Override
    VirtualMachine doConnect() throws IOException, IllegalConnectorArgumentsException {
        VirtualMachine result;
        LaunchingConnector connector = LocalDebugSession.findLaunchingConnector();
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        StringBuilder mainArgs = new StringBuilder().append(LocalDebugSession.quote(this.className));
        for (String arg : this.args) {
            mainArgs.append(' ').append(LocalDebugSession.quote(arg));
        }
        Connector.Argument mainArg = arguments.get(MAIN_ARG);
        assert (mainArg != null) : "Bad launching connector";
        mainArg.setValue(mainArgs.toString());
        String classPath = System.getProperty("java.class.path");
        if (classPath != null) {
            Connector.Argument options = arguments.get(OPTIONS_ARG);
            assert (options != null) : "Bad launching connector";
            options.setValue("-cp " + LocalDebugSession.quote(classPath));
        }
        try {
            result = connector.launch(arguments);
        }
        catch (VMStartException e) {
            IOException ioe = new IOException(e.getLocalizedMessage());
            ioe.initCause(e);
            throw ioe;
        }
        LocalDebugSession.redirectOutput(result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static LaunchingConnector findLaunchingConnector() throws IOException {
        LaunchingConnector launchingConnector = LocalDebugSession.findConnector(JDI_COMMAND_LINE_LAUNCH, Bootstrap.virtualMachineManager().launchingConnectors());
        if (launchingConnector == null) {
            throw new IllegalArgumentException("@NotNull method fuego/debugger/LocalDebugSession.findLaunchingConnector must not return null");
        }
        return launchingConnector;
    }

    private static boolean hasWhitespace(String str) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static String quote(String str) {
        if (!LocalDebugSession.hasWhitespace(str)) {
            return str;
        }
        return '\"' + str + '\"';
    }

    private static void redirectStream(String name, final InputStream inStream, final OutputStream outStream) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    StreamUtils.copy(inStream, outStream);
                }
                catch (IOException exc) {
                    System.err.println("Child I/O Transfer - " + exc);
                }
            }
        }, name);
        thread.setDaemon(true);
        thread.start();
    }

    private static void redirectOutput(VirtualMachine vm) {
        Process process = vm.process();
        LocalDebugSession.redirectStream("error reader", process.getErrorStream(), System.err);
        LocalDebugSession.redirectStream("output reader", process.getInputStream(), System.out);
    }
}

