/*
 * Decompiled with CFR 0.152.
 */
package fuego.debugger;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import fuego.debugger.DebugSession;
import fuego.debugger.DebugThread;
import fuego.debugger.DebugValue;
import fuego.debugger.IDebugLocalVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bpm.lang.ObjectTypeDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugStackFrame {
    @Nullable
    private String declaringTypeName;
    @Nullable
    private IDebugLocalVariable[] localVariables;
    @NotNull
    private final Location location;
    @NotNull
    private final StackFrame stackFrame;
    private final DebugThread thread;

    DebugStackFrame(DebugThread thread, StackFrame frame, ObjectTypeDescription otd) {
        this.thread = thread;
        this.stackFrame = frame;
        this.location = frame.location();
        this.declaringTypeName = otd.getText();
    }

    public String getMethodName() {
        return this.getLocation().method().name();
    }

    @Nullable
    public String getSourcePath() {
        try {
            return this.getLocation().sourcePath();
        }
        catch (AbsentInformationException e) {
            return null;
        }
    }

    public int getLineNumber() {
        return this.getLocation().lineNumber();
    }

    public String toString() {
        return this.getDeclaringTypeName() + '.' + this.getMethodName() + ':' + this.getLineNumber();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getDeclaringTypeName() {
        String result = this.declaringTypeName;
        if (result == null) {
            this.declaringTypeName = result = this.getLocation().declaringType().name();
        }
        String string = result;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugStackFrame.getDeclaringTypeName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public IDebugLocalVariable[] getLocalVariables() {
        IDebugLocalVariable[] result = this.localVariables;
        if (result == null) {
            List<LocalVariable> variableList;
            StackFrame stackFrame = this.getStackFrame();
            try {
                variableList = stackFrame.visibleVariables();
            }
            catch (AbsentInformationException e) {
                variableList = Collections.emptyList();
            }
            ObjectReference thisReference = stackFrame.thisObject();
            int start = thisReference == null ? 0 : 1;
            ArrayList<IDebugLocalVariable> variables = new ArrayList<IDebugLocalVariable>(variableList.size() + start);
            if (start > 0) {
                variables.add(this.buildThis(thisReference));
            }
            for (LocalVariable variable : variableList) {
                if (variable.name().indexOf(36) != -1) continue;
                variables.add(this.buildLocalVariable(variable));
            }
            result = new IDebugLocalVariable[variables.size()];
            variables.toArray(result);
            this.localVariables = result;
        }
        IDebugLocalVariable[] iDebugLocalVariableArray = (IDebugLocalVariable[])result.clone();
        if (iDebugLocalVariableArray == null) {
            throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugStackFrame.getLocalVariables must not return null");
        }
        return iDebugLocalVariableArray;
    }

    DebugSession getSession() {
        return this.thread.getSession();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private DebugValue createDebugValue(@Nullable Value value) {
        DebugValue debugValue = DebugValue.create(this.thread, value);
        if (debugValue == null) {
            throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugStackFrame.createDebugValue must not return null");
        }
        return debugValue;
    }

    private IDebugLocalVariable buildThis(final ObjectReference thisReference) {
        return new IDebugLocalVariable(){

            @Override
            public String getName() {
                return thisReference.referenceType().name().endsWith(".Instance") ? "Instance" : "this";
            }

            @Override
            public String getTypeName() {
                ObjectTypeDescription otd = DebugStackFrame.this.getSession().findCatalogObject(thisReference);
                return otd != null ? otd.getText() : thisReference.type().name();
            }

            @Override
            @NotNull
            public DebugValue getValue() {
                return DebugStackFrame.this.createDebugValue(thisReference);
            }
        };
    }

    private IDebugLocalVariable buildLocalVariable(final LocalVariable variable) {
        return new IDebugLocalVariable(){
            @NotNull
            private final DebugValue value;
            {
                this.value = DebugStackFrame.this.createDebugValue(DebugStackFrame.this.getStackFrame().getValue(variable));
            }

            @Override
            public String getName() {
                return variable.name();
            }

            @Override
            public String getTypeName() {
                return variable.typeName();
            }

            @Override
            @NotNull
            public DebugValue getValue() {
                return this.value;
            }

            public String toString() {
                return String.valueOf(variable);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private StackFrame getStackFrame() {
        StackFrame stackFrame = this.stackFrame;
        if (stackFrame == null) {
            throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugStackFrame.getStackFrame must not return null");
        }
        return stackFrame;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Location getLocation() {
        Location location = this.location;
        if (location == null) {
            throw new IllegalArgumentException("@NotNull method fuego/debugger/DebugStackFrame.getLocation must not return null");
        }
        return location;
    }
}

