/*
 * Decompiled with CFR 0.152.
 */
package fuego.bcgen;

import fuego.bcgen.JVMCodeBuilderImpl;
import fuego.bcgen.JVMStack;
import fuego.bcgen.TD;
import java.util.ArrayList;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.Type;

public class WhileBlock {
    private JVMCodeBuilderImpl builder;
    private ArrayList<BranchHandle> endList;
    private String label;
    private boolean labeledBlock;
    private InstructionHandle top;

    WhileBlock(JVMCodeBuilderImpl builder) {
        this(builder, null);
    }

    WhileBlock(JVMCodeBuilderImpl builder, String label) {
        this.builder = builder;
        this.label = label;
        this.top = builder.getCurrentLocation();
    }

    public static WhileBlock labeledBlock(JVMCodeBuilderImpl jvmCodeBuilder, String text) {
        WhileBlock result = new WhileBlock(jvmCodeBuilder, text);
        result.endList = new ArrayList();
        result.labeledBlock = true;
        return result;
    }

    public void addBody(BranchHandle branchHandle) {
        if (this.endList != null) {
            throw new IllegalStateException("Only one body!. Forgot to call end?");
        }
        this.endList = new ArrayList();
        this.endList.add(branchHandle);
    }

    public void exit() {
        if (this.endList == null) {
            throw new IllegalStateException("Forgot to call addBody ?");
        }
        this.endList.add(this.builder.goTo());
    }

    public String getLabel() {
        return this.label;
    }

    public void endLabeledBlock() {
        if (this.endList == null || !this.labeledBlock) {
            throw new IllegalStateException("Not labeledBlock!");
        }
        for (BranchHandle handle : this.endList) {
            this.builder.fixTargetWithNext(handle);
        }
    }

    void addBody() {
        JVMStack stack = this.builder.getStack();
        Type predicate = stack.pop();
        if (predicate != TD.BOOLEAN) {
            throw stack.stackException("Not a boolean: " + predicate);
        }
        this.addBody(this.builder.append(InstructionFactory.createBranchInstruction((short)153, null)));
    }

    void end() {
        if (this.endList == null) {
            throw new IllegalStateException("Forgot to call addBody ?");
        }
        if (this.labeledBlock) {
            throw new IllegalStateException("LabeledBlock!");
        }
        this.builder.append(InstructionFactory.createBranchInstruction((short)167, (InstructionHandle)this.top.getNext()));
        for (BranchHandle anEndList : this.endList) {
            this.builder.fixTargetWithNext(anEndList);
        }
    }
}

