/*
 * Decompiled with CFR 0.152.
 */
package fuego.bcgen;

import fuego.bcgen.StackException;
import fuego.bcgen.TD;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.generic.Type;

public final class JVMStack
implements Cloneable {
    private final List<Type> stack;

    public JVMStack() {
        this.stack = new ArrayList<Type>(20);
    }

    private JVMStack(List<Type> initial) {
        this.stack = new ArrayList<Type>(initial);
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Type type : this.stack) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(type);
        }
        return result.toString();
    }

    protected JVMStack clone() {
        return new JVMStack(this.stack);
    }

    void assign(JVMStack other) {
        List<Type> thisStack = this.stack;
        thisStack.clear();
        thisStack.addAll(other.stack);
    }

    void mergeWith(JVMStack other) {
        if (this == other) {
            return;
        }
        List<Type> otherStack = other.stack;
        List<Type> thisStack = this.stack;
        int stackLen = thisStack.size();
        if (stackLen != otherStack.size()) {
            throw this.unmergeableStackException();
        }
        for (int i = 0; i < stackLen; ++i) {
            Type otherType;
            Type thisType = thisStack.get(i);
            if (TD.isAssignableFrom(thisType, otherType = otherStack.get(i))) continue;
            if (!TD.isAssignableFrom(otherType, thisType)) {
                throw this.unmergeableStackException();
            }
            thisStack.set(i, otherType);
        }
    }

    Type pop() {
        try {
            return this.stack.remove(this.stack.size() - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.emptyStackException();
        }
    }

    void push(Type type) {
        if (type != Type.VOID) {
            this.stack.add(type);
        }
    }

    void remove(int n) {
        int size = this.stack.size();
        if (size < n) {
            throw this.stackException("Trying to remove (" + n + "), stack has only: " + size);
        }
        while (n-- > 0) {
            this.stack.remove(--size);
        }
    }

    Type top() {
        try {
            return this.stack.get(this.stack.size() - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.emptyStackException();
        }
    }

    void verifyIsEmpty() {
        if (!this.isEmpty()) {
            throw this.stackException("Stack not empty !");
        }
    }

    StackException stackException(String msg) {
        return new StackException(msg, this);
    }

    private StackException unmergeableStackException() {
        return this.stackException("Unmergeable stacks!");
    }

    private StackException emptyStackException() {
        return this.stackException("Trying to pop from an Empty Stack");
    }
}

