/*
 * Decompiled with CFR 0.152.
 */
package fuego.bcgen;

import fuego.bcgen.JVMCodeBuilderImpl;
import fuego.bcgen.JVMStack;
import fuego.bcgen.TD;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.Type;

public class IfBlock {
    private JVMCodeBuilderImpl builder;
    private List<BranchHandle> endList;
    private BranchHandle previous;
    private JVMStack savedStack;

    IfBlock(JVMCodeBuilderImpl builder) {
        this.builder = builder;
    }

    void addElse() {
        if (this.previous == null) {
            throw new IllegalStateException("Else without if clauses or called twice");
        }
        if (this.endList == null) {
            this.endList = new ArrayList<BranchHandle>();
        }
        JVMStack stack = this.builder.getStack();
        JVMStack thenStack = stack.clone();
        this.endList.add(this.builder.goTo());
        this.builder.fixTargetWithNext(this.previous);
        this.previous = null;
        stack.assign(this.savedStack);
        this.savedStack = thenStack;
    }

    void addThen() {
        if (this.previous != null) {
            throw new IllegalStateException("addThen called twice??");
        }
        JVMStack stack = this.builder.getStack();
        Type predicate = stack.pop();
        if (predicate != TD.BOOLEAN) {
            throw stack.stackException("Not a boolean: " + predicate);
        }
        this.savedStack = stack.clone();
        this.previous = this.builder.append(InstructionFactory.createBranchInstruction((short)153, null));
    }

    void end() {
        if (this.previous != null) {
            this.builder.fixTargetWithNext(this.previous);
        } else if (this.endList == null) {
            throw new IllegalStateException("EndIf without clauses.");
        }
        this.builder.getStack().mergeWith(this.savedStack);
        if (this.endList != null) {
            for (BranchHandle handle : this.endList) {
                this.builder.fixTargetWithNext(handle);
            }
        }
    }
}

