/*
 * Decompiled with CFR 0.152.
 */
package fuego.boot;

import fuego.boot.ByteArrayPool;
import fuego.boot.ClassCache;
import fuego.boot.ClassHelper;
import fuego.boot.LoadedResource;
import fuego.boot.Loader;
import java.security.CodeSource;

final class ResourceFromHelper
extends LoadedResource {
    private final ClassHelper helper;
    private final CodeSource codeSource;
    private final String name;
    private final boolean isClass;

    private ResourceFromHelper(ClassCache classCache, ClassHelper helper, String name, boolean isClass) {
        super(classCache);
        this.codeSource = helper.getCodeSource();
        this.name = name;
        this.helper = helper;
        this.isClass = isClass;
    }

    @Override
    public final String getClassName() {
        assert (this.isClass) : "Not a class " + this.getName();
        return this.name;
    }

    @Override
    public String getPackageName() {
        return ClassHelper.extractPackage(this.name, this.isClass);
    }

    static ResourceFromHelper fromClass(ClassCache classCache, String className, ClassHelper helper) {
        return new ResourceFromHelper(classCache, helper, className, true);
    }

    @Override
    final ByteArrayPool.Entry getBytecode() throws ClassNotFoundException {
        assert (this.isClass) : "Not a class " + this.getName();
        ByteArrayPool.Entry entry = this.helper.loadBytecode(this.name, this.getByteArrayPool());
        if (entry == null) {
            Loader.classNotFound(this.name, null);
        }
        return entry;
    }

    @Override
    final CodeSource getCodeSource() {
        return this.codeSource;
    }

    @Override
    final String getName() {
        return this.name;
    }
}

