/*
 * Decompiled with CFR 0.152.
 */
package fuego.boot;

import fuego.boot.BaseClassLoader;
import fuego.boot.BootHashMap;
import fuego.boot.Loader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public final class ClassPath {
    private File jarFile = null;
    private final BootHashMap<File, Set<File>> jarPath_d = new BootHashMap();
    private LinkedHashSet<File> path_d = null;
    private Properties props_d = null;
    private String tag = null;
    private Loader.JarWalker walker_d = null;
    private static final String CACHE_SUFFIX = "cache" + File.separatorChar;
    private static File cache_sd;
    private static final String DEFAULT_ENCODING;
    private static final String BOOT_TAG = "fuego.boot.tag";
    private static final String BOOT_PROPERTIES = "boot.properties";
    private static final String CLASSPATH_FILE = "ftclasspath.conf";
    private static final String SKIP_EXT = "skip-ext";
    private static final String SKIP_FTCLASSPATH = "skip-ftclasspath";
    private static File baseDir_sd;
    private static File ext_sd;
    private static File libraries_sd;
    private static File lib_sd;
    private static File conf_sd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassPath(File jarFile, Loader.JarWalker walker, boolean verbose) {
        this.jarFile = jarFile;
        this.walker_d = walker;
        this.tag = System.getProperty(BOOT_TAG);
        if (this.tag == null) {
            this.tag = this.jarFile != null ? this.jarFile.getName() : "FuegoPlugins";
        }
        try {
            File confFile = new File(ClassPath.getConf(), BOOT_PROPERTIES);
            if (verbose) {
                System.out.print("[" + this.tag + "] boot properties:" + confFile + "...");
            }
            Properties p = new Properties();
            FileInputStream fis = new FileInputStream(confFile);
            try {
                p.load(new BufferedInputStream(fis));
            }
            finally {
                fis.close();
            }
            if (verbose) {
                System.out.print("loaded");
            }
            this.props_d = p;
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (verbose) {
            System.out.println(".");
        }
    }

    public static void setBaseDir(File baseDir) {
        baseDir_sd = baseDir;
        ext_sd = null;
        lib_sd = null;
        conf_sd = null;
    }

    public static File getCache() {
        if (cache_sd == null) {
            cache_sd = new File(ClassPath.getBaseDir(), CACHE_SUFFIX);
        }
        return cache_sd;
    }

    public static Set<String> getClassPathFromManifest(Manifest manifest) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Attributes attr = manifest.getMainAttributes();
        String cp = attr.getValue(Attributes.Name.CLASS_PATH);
        if (cp != null) {
            result.add(cp);
        }
        for (Attributes attributes : manifest.getEntries().values()) {
            cp = attributes.getValue(Attributes.Name.CLASS_PATH);
            if (cp == null) continue;
            result.add(cp);
        }
        return result;
    }

    public static File getConf() {
        if (conf_sd == null) {
            conf_sd = new File(ClassPath.getBaseDir(), "conf/");
        }
        return conf_sd;
    }

    public static File getExt() {
        if (ext_sd == null) {
            ext_sd = new File(ClassPath.getBaseDir(), "ext/");
        }
        return ext_sd;
    }

    public static File getLib() {
        if (lib_sd == null) {
            lib_sd = new File(ClassPath.getBaseDir(), "lib/");
        }
        return lib_sd;
    }

    public static File getLibraries() {
        if (libraries_sd == null) {
            libraries_sd = new File(ClassPath.getBaseDir(), "libraries/");
        }
        return libraries_sd;
    }

    public static void addClassPathToSet(String classpath, Set<File> set) {
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            File file = new File(token);
            set.add(file);
        }
    }

    public static void addFilesToClassPath(File[] file) {
        BaseClassLoader cl = ClassPath.findBaseClassLoader();
        if (cl != null) {
            BaseClassLoader bcl = cl;
            for (File aFile : file) {
                bcl.addFile(aFile);
            }
        }
    }

    public static BaseClassLoader findBaseClassLoader() {
        return ClassPath.findBaseClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public static File[] loadExternalClassPathFrom(File ext) {
        LinkedHashSet<File> path = new LinkedHashSet<File>();
        try {
            File[] files = ext.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar") || name.endsWith(".zip");
                }
            });
            path.addAll(Arrays.asList(files));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path.toArray(new File[path.size()]);
    }

    public Set<File> getClassPath() {
        if (this.path_d == null) {
            this.path_d = new LinkedHashSet();
            if (this.jarFile != null) {
                this.path_d.addAll(this.getClassPathFromJar(this.jarFile));
            }
            if (!this.skipLoadExternalClassPath()) {
                this.path_d.addAll(this.loadExternalClassPath());
                if (!this.skipLoadExternalClassPathFile()) {
                    this.path_d.addAll(this.loadExternalClassPathFile());
                }
            }
        }
        this.checkPreload();
        return this.path_d;
    }

    static File getBaseDir() {
        if (baseDir_sd == null) {
            try {
                baseDir_sd = new File(ClassPath.getBaseDir(ClassPath.class), "..").getCanonicalFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return baseDir_sd;
    }

    static BaseClassLoader findBaseClassLoader(ClassLoader classLoader) {
        ClassLoader cl;
        for (cl = classLoader; cl != null && !(cl instanceof BaseClassLoader); cl = cl.getParent()) {
        }
        return (BaseClassLoader)cl;
    }

    static File getManifestContainer(URL manifestUrl) {
        try {
            String tmp = URLDecoder.decode(manifestUrl.toString(), DEFAULT_ENCODING);
            if (tmp.startsWith("jar:") || tmp.startsWith("zip:")) {
                tmp = tmp.substring(4, tmp.lastIndexOf("!/"));
            } else if (tmp.startsWith("wsjar:")) {
                tmp = tmp.substring(6, tmp.lastIndexOf("!/"));
            }
            if (tmp.startsWith("file:")) {
                int strip = 5;
                if (tmp.indexOf(58, strip) != -1) {
                    boolean slash;
                    boolean bl = slash = tmp.charAt(strip) == '/';
                    if (slash) {
                        ++strip;
                    }
                }
                if (tmp.endsWith("META-INF/MANIFEST.MF")) {
                    tmp = tmp.substring(0, tmp.length() - 20);
                }
                tmp = tmp.substring(strip).replace('/', File.separatorChar);
            }
            return new File(tmp);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static File getBaseDir(Class clazz) {
        try {
            String className = clazz.getName();
            String classFileName = className.substring(className.lastIndexOf(46) + 1) + ".class";
            URL url = clazz.getResource(classFileName);
            String tmp = URLDecoder.decode(url.toString(), DEFAULT_ENCODING);
            if (tmp.startsWith("jar:") || tmp.startsWith("zip:")) {
                tmp = tmp.substring(4, tmp.lastIndexOf("!/"));
            } else if (tmp.startsWith("wsjar:")) {
                tmp = tmp.substring(6, tmp.lastIndexOf("!/"));
            }
            if (tmp.startsWith("file:")) {
                int strip = 5;
                if (tmp.indexOf(58, strip) != -1) {
                    boolean slash;
                    boolean bl = slash = tmp.charAt(strip) == '/';
                    if (slash) {
                        ++strip;
                    }
                }
                tmp = tmp.substring(strip).replace('/', File.separatorChar);
            }
            return new File(tmp).getParentFile().getCanonicalFile();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static File getToolsJar() {
        File baseDir = ClassPath.getBaseDir(Object.class);
        File rt = new File(baseDir, "../../lib/tools.jar");
        if (!rt.exists()) {
            rt = new File(baseDir, "ext/tools.jar");
        }
        return rt.exists() ? rt : null;
    }

    void addProperties(Properties properties) {
        if (this.props_d == null) {
            this.props_d = new Properties();
        }
        this.props_d.putAll((Map<?, ?>)properties);
    }

    private static boolean setContainsValue(Set<File> set, String value) {
        for (File tmp : set) {
            if (!tmp.toString().endsWith(value)) continue;
            return true;
        }
        return false;
    }

    private boolean getBooleanProperty(String propName, boolean defaultValue) {
        if (this.props_d == null) {
            return defaultValue;
        }
        String result = this.props_d.getProperty(this.tag + "." + propName);
        if (result == null) {
            result = this.props_d.getProperty(propName, defaultValue ? "true" : "false");
        }
        return Boolean.valueOf(result);
    }

    private Set<File> getClassPathFromJar(File jarFileArg) {
        if (this.jarPath_d.containsKey(jarFileArg)) {
            return this.jarPath_d.get(jarFileArg);
        }
        LinkedHashSet<File> path = new LinkedHashSet<File>();
        if (this.skipJarFile(jarFileArg)) {
            return path;
        }
        this.jarPath_d.put(jarFileArg, path);
        try {
            Attributes attr;
            FileInputStream fis = new FileInputStream(jarFileArg);
            BufferedInputStream bis = new BufferedInputStream(fis);
            JarInputStream jar = new JarInputStream(bis);
            path.add(jarFileArg);
            Manifest mf = jar.getManifest();
            if (mf == null) {
                return path;
            }
            if (this.walker_d != null) {
                this.walker_d.visitJar(jarFileArg, mf);
            }
            if ((attr = mf.getMainAttributes()) == null) {
                return path;
            }
            String classPath = (String)attr.get(Attributes.Name.CLASS_PATH);
            if (classPath == null) {
                return path;
            }
            StringTokenizer st = new StringTokenizer(classPath);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.processJarPathRef(path, jarFileArg, token);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.jarPath_d.put(jarFileArg, path);
        return path;
    }

    private String getProperty(String prefix, String propName) {
        String name;
        if (this.props_d == null) {
            return null;
        }
        Enumeration<?> enumeration = this.props_d.propertyNames();
        while (enumeration.hasMoreElements()) {
            String tmp;
            name = (String)enumeration.nextElement();
            if (!name.startsWith(tmp = this.tag + "." + prefix) || !propName.endsWith(name.substring(tmp.length()))) continue;
            return this.props_d.getProperty(name).trim();
        }
        enumeration = this.props_d.propertyNames();
        while (enumeration.hasMoreElements()) {
            name = (String)enumeration.nextElement();
            if (!name.startsWith(prefix) || !propName.endsWith(name.substring(prefix.length()))) continue;
            return this.props_d.getProperty(name).trim();
        }
        return null;
    }

    private void checkPreload() {
        Iterator it = this.path_d.iterator();
        LinkedHashSet<File> loaded = new LinkedHashSet<File>();
        LinkedHashSet<File> toBeAdded = new LinkedHashSet<File>();
        block0: while (it.hasNext()) {
            File tmp = (File)it.next();
            loaded.add(tmp);
            String preload = this.getProperty("preload.", tmp.getName());
            if (preload == null) continue;
            StringTokenizer st = new StringTokenizer(preload);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!ClassPath.setContainsValue(this.path_d, token) || ClassPath.setContainsValue(loaded, token)) continue;
                it.remove();
                toBeAdded.add(tmp);
                continue block0;
            }
        }
        this.path_d.addAll(toBeAdded);
    }

    private Set<File> loadExternalClassPath() {
        LinkedHashSet<File> path = new LinkedHashSet<File>();
        try {
            File ext = ClassPath.getExt();
            File[] files = ext.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar") || name.endsWith(".zip");
                }
            });
            if (files != null) {
                for (File file : files) {
                    path.addAll(this.getClassPathFromJar(file));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return path;
    }

    private Set<File> loadExternalClassPathFile() {
        LinkedHashSet<File> path = new LinkedHashSet<File>();
        try {
            String line;
            File cpFile = new File(ClassPath.getExt(), CLASSPATH_FILE);
            BufferedReader br = new BufferedReader(new FileReader(cpFile));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                LinkedHashSet<File> classPath = new LinkedHashSet<File>();
                ClassPath.addClassPathToSet(line, classPath);
                for (File file : classPath) {
                    this.processJarPathRef(path, file, file.toString());
                }
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return path;
    }

    private boolean processJarPathRef(Set<File> path, File parent, String jar) {
        boolean exists;
        File referencedJar;
        if (!parent.isDirectory()) {
            parent = parent.getParentFile();
        }
        if (!((referencedJar = new File(parent, jar = jar.replace('/', File.separatorChar))).exists() || (referencedJar = new File(ClassPath.getLib(), jar)).exists() || (referencedJar = new File(ClassPath.getExt(), jar)).exists())) {
            referencedJar = new File(ClassPath.getLibraries(), jar);
        }
        if (!referencedJar.exists()) {
            referencedJar = new File(jar);
        }
        if (exists = referencedJar.exists()) {
            if (jar.endsWith(".jar") || jar.endsWith(".zip")) {
                path.addAll(this.getClassPathFromJar(referencedJar));
            } else {
                path.add(referencedJar);
            }
        }
        return exists;
    }

    private boolean skipJarFile(File jarFileArg) {
        return Boolean.valueOf(this.getProperty("skip.", jarFileArg.getName()));
    }

    private boolean skipLoadExternalClassPath() {
        return this.getBooleanProperty(SKIP_EXT, false);
    }

    private boolean skipLoadExternalClassPathFile() {
        return this.getBooleanProperty(SKIP_FTCLASSPATH, false);
    }

    static {
        DEFAULT_ENCODING = System.getProperty("file.encoding", "ASCII");
        baseDir_sd = null;
    }
}

