/*
 * Decompiled with CFR 0.152.
 */
package fuego.boot;

import fuego.boot.BaseHashSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class BootHashSet
extends BaseHashSet {
    static final long serialVersionUID = 2857752308549067215L;
    static final long serialCheck = 5513976629871245863L;

    BootHashSet() {
    }

    public final boolean add(Object obj) {
        int index = this.insertionIndex(obj);
        if (index < 0) {
            return false;
        }
        Object old = this.objectSet[index];
        this.objectSet[index] = obj;
        this.postInsertHook(old == null);
        return true;
    }

    public final Iterator iterator() {
        return new MyIterator();
    }

    public final Object unify(Object object) {
        int index = this.index(object);
        if (index == -1) {
            this.add(object);
        } else {
            object = this.objectSet[index];
        }
        return object;
    }

    @Override
    protected final void rehash(int newCapacity) {
        int oldCapacity = this.objectSet.length;
        Object[] oldSet = this.objectSet;
        this.objectSet = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldSet[i] == null || oldSet[i] == DELETED) continue;
            Object o = oldSet[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                BootHashSet.hashcodeContractViolation(this.objectSet[-index - 1], o);
            }
            this.objectSet[index] = o;
        }
    }

    final Object get(Object object) {
        int index = this.index(object);
        return index == -1 ? null : this.objectSet[index];
    }

    final class MyIterator
    implements Iterator {
        private int index;
        private int originalSize;

        MyIterator() {
            this.originalSize = BootHashSet.this.size();
            this.index = BootHashSet.this.capacity();
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() >= 0;
        }

        public Object next() {
            this.advance();
            return this.objectAtIndex(this.index);
        }

        @Override
        public void remove() {
            if (this.originalSize != BootHashSet.this.size()) {
                throw new ConcurrentModificationException();
            }
            BootHashSet.this.removeAt(this.index);
            --this.originalSize;
        }

        private void advance() {
            this.index = this.nextIndex();
            if (this.index < 0) {
                throw new NoSuchElementException();
            }
        }

        private int nextIndex() {
            if (this.originalSize != BootHashSet.this.size()) {
                throw new ConcurrentModificationException();
            }
            Object[] set = BootHashSet.this.objectSet;
            int i = this.index;
            while (i-- > 0 && (set[i] == null || set[i] == BaseHashSet.DELETED)) {
            }
            return i;
        }

        private Object objectAtIndex(int index) {
            return BootHashSet.this.objectSet[index];
        }
    }
}

