/*
 * Decompiled with CFR 0.152.
 */
package fuego.boot;

import fuego.boot.BootHashMap;
import fuego.boot.ByteArrayPool;
import fuego.boot.ClassCache;
import fuego.boot.LoadedResource;
import fuego.boot.Loader;
import java.io.File;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

final class BaseClassLoader
extends ClassLoader {
    private final ClassCache classCache;
    private final File[] classPath;
    private final long creationTime;
    private final BootHashMap<CodeSource, ProtectionDomain> domains = new BootHashMap();
    private int loadedClasses;
    private boolean preload;
    private static final boolean PRELOAD_ENABLED;

    BaseClassLoader(ClassCache classCache, File[] classPath, ClassLoader parent) {
        super(parent);
        this.classCache = classCache;
        this.classPath = classPath;
        this.creationTime = System.currentTimeMillis();
        if (Loader.isSystemClassLoader()) {
            Loader.registerClassLoader(this);
        }
    }

    public Class findClass(String className) throws ClassNotFoundException {
        Class result = null;
        LoadedResource resource = this.classCache.findClass(className);
        if (resource != null) {
            result = this.defineClass(resource);
        }
        if (result == null) {
            return super.findClass(className);
        }
        ++this.loadedClasses;
        return result;
    }

    public String toString() {
        return "BaseClassLoader(creationTime: " + new Date(this.creationTime) + ", hashCode: " + this.hashCode() + ")";
    }

    @Override
    protected URL findResource(String resourceName) {
        return this.classCache == null ? null : this.classCache.findResource(resourceName);
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        Vector<URL> v = new Vector<URL>();
        if (this.classCache != null) {
            this.classCache.findResources(name, v);
        }
        return v.elements();
    }

    protected Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class result = this.findLoadedClass(className);
        if (result == null && this.preload && this.classCache != null && this.classCache.isEnabled() && BaseClassLoader.safe(className)) {
            result = this.loadFromCache(className);
        }
        if (result == null) {
            result = super.loadClass(className, false);
        }
        if (resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    File[] getClassPath() {
        return this.classPath;
    }

    int getLoadedClasses() {
        return this.loadedClasses;
    }

    void addFile(File file) {
        this.classCache.addFileToHelpers(file);
    }

    void close() {
        if (this.classCache != null) {
            this.classCache.close();
        }
    }

    ClassCache getClassCache() {
        return this.classCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class defineClass(LoadedResource loadedClass) throws ClassNotFoundException {
        String className = loadedClass.getClassName();
        ByteArrayPool.Entry bytecode = loadedClass.getBytecode();
        try {
            Class<?> c;
            byte[] bcode = bytecode.getBytes();
            int length = bytecode.getLength();
            ProtectionDomain pd = this.getDefaultProtectionDomain(loadedClass.getCodeSource());
            Package pkg = this.getPackage(loadedClass.getPackageName());
            if (pkg == null) {
                this.definePackage(loadedClass.getPackageName(), null, null, null, null, null, null, null);
            }
            Class<?> clazz = c = this.defineClass(className, bcode, 0, length, pd);
            return clazz;
        }
        finally {
            bytecode.release();
        }
    }

    void enablePreload() {
        if (PRELOAD_ENABLED && !this.preload) {
            boolean preload = true;
            for (ClassLoader cl = this.getParent(); cl != null; cl = cl.getParent()) {
                if (!(cl instanceof BaseClassLoader)) continue;
                preload = false;
                break;
            }
            this.preload = preload;
        }
    }

    private static boolean safe(String name) {
        return name.startsWith("fuego") || name.startsWith("com.jidesoft") || name.startsWith("org.netbeans");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain getDefaultProtectionDomain(CodeSource cs) {
        ProtectionDomain pd;
        BootHashMap<CodeSource, ProtectionDomain> bootHashMap = this.domains;
        synchronized (bootHashMap) {
            pd = this.domains.get(cs);
            if (pd == null) {
                Permissions perms = new Permissions();
                perms.add(new AllPermission());
                pd = new ProtectionDomain(cs, perms);
                this.domains.put(cs, pd);
            }
        }
        return pd;
    }

    private synchronized Class loadFromCache(String className) throws ClassNotFoundException {
        Class result = null;
        LoadedResource clazz = this.classCache.findClass(className);
        if (clazz != null) {
            result = this.defineClass(clazz);
        }
        return result;
    }

    static {
        boolean bl = PRELOAD_ENABLED = !Boolean.getBoolean("fuego.boot.disable.preload");
        if (!PRELOAD_ENABLED) {
            System.out.println("Preload Disabled");
        }
    }
}

