/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.pc.services.util.xml.pipeline;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import oracle.tip.pc.services.translation.framework.TranslationContext;
import oracle.tip.pc.services.translation.framework.Translator;
import oracle.tip.pc.services.translation.framework.TranslatorFactory;
import oracle.tip.pc.services.translation.xlators.nxsd.ExtendedXMLSAXSerializer;
import oracle.tip.pc.services.translation.xlators.nxsd.NXSDTranslatorImpl;
import oracle.tip.pc.services.util.xml.pipeline.BatchedXformHandler;
import oracle.xml.binxml.BinXMLEncoder;
import oracle.xml.binxml.BinXMLProcessor;
import oracle.xml.binxml.BinXMLProcessorFactory;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.v2.XMLDocument;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLPipeline {
    public static void doBatchedXform(InputStream in, OutputStream out, InputStream xslIn, int batchingSize, Map properties) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        ExtendedXMLSAXSerializer xmlSerializer = new ExtendedXMLSAXSerializer(out);
        BatchedXformHandler inputHandler = new BatchedXformHandler(xslIn, (ContentHandler)((Object)xmlSerializer), batchingSize, properties);
        parser.parse(in, (DefaultHandler)inputHandler);
    }

    public static void doBatchedXformSDOM(XMLDocument doc, OutputStream out, InputStream xslIn, int batchingSize, Map properties) throws Exception {
        boolean outputIsFile = false;
        if (out instanceof FileOutputStream) {
            outputIsFile = true;
        }
        Object cntHandler = null;
        if (outputIsFile) {
            cntHandler = new ExtendedXMLSAXSerializer(out);
        } else {
            BinXMLProcessor mBinaryXMLProcessor = BinXMLProcessorFactory.createProcessor();
            BinXMLStream bstr = mBinaryXMLProcessor.createBinXMLStream(out);
            BinXMLEncoder enc = bstr.getEncoder();
            enc.setProperty(1, false);
            enc.setProperty(4, true);
            cntHandler = enc.getContentHandler();
        }
        BatchedXformHandler inputHandler = new BatchedXformHandler(xslIn, (ContentHandler)cntHandler, batchingSize, properties);
        cntHandler.startDocument();
        doc.reportSAXEvents((ContentHandler)inputHandler);
    }

    public static void doBatchedXformSDOMToOutputStream(XMLDocument doc, OutputStream out, InputStream xslIn, int batchingSize, Map properties) throws Exception {
        ExtendedXMLSAXSerializer cntHandler = new ExtendedXMLSAXSerializer(out);
        BatchedXformHandler inputHandler = new BatchedXformHandler(xslIn, (ContentHandler)((Object)cntHandler), batchingSize, properties);
        cntHandler.startDocument();
        doc.reportSAXEvents((ContentHandler)inputHandler);
    }

    public static void doBatchedXformSDOMToNative(XMLDocument doc, InputStream xslIn, InputStream nxsdIn, String root, OutputStream out, int batchingSize, Map properties) throws Exception {
        XSDBuilder builder = new XSDBuilder();
        XMLSchema outSchema = builder.build(nxsdIn, null);
        String targetNS = outSchema.getSchemaTargetNS();
        XSDElement fRoot = outSchema.getElement(targetNS, root);
        TranslatorFactory xf = TranslatorFactory.getInstance();
        Translator xlator = xf.createTranslator(outSchema, fRoot);
        NXSDTranslatorImpl nxsdTranslator = (NXSDTranslatorImpl)xlator;
        ContentHandler cntHandler = nxsdTranslator.getContentHandler(out, new TranslationContext());
        BatchedXformHandler inputHandler = new BatchedXformHandler(xslIn, cntHandler, batchingSize, properties);
        cntHandler.startDocument();
        doc.reportSAXEvents((ContentHandler)inputHandler);
    }

    public static void doBatchedTransform_TranslateToNative(InputStream in, OutputStream out, InputStream xslIn, InputStream nxsdIn, String root, int batchingSize, Map properties) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        XSDBuilder builder = new XSDBuilder();
        XMLSchema outSchema = builder.build(nxsdIn, null);
        String targetNS = outSchema.getSchemaTargetNS();
        XSDElement fRoot = outSchema.getElement(targetNS, root);
        TranslatorFactory xf = TranslatorFactory.getInstance();
        Translator xlator = xf.createTranslator(outSchema, fRoot);
        NXSDTranslatorImpl nxsdTranslator = (NXSDTranslatorImpl)xlator;
        ContentHandler mXlatorHandler = nxsdTranslator.getContentHandler(out, new TranslationContext());
        BatchedXformHandler inputHandler = new BatchedXformHandler(xslIn, mXlatorHandler, batchingSize, properties);
        parser.parse(in, (DefaultHandler)inputHandler);
    }

    public static void doBatchedTranslateFromNative_Transform(InputStream in, OutputStream out, InputStream xslIn, InputStream nxsdIn, String root, int batchingSize, Map properties) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        XSDBuilder builder = new XSDBuilder();
        XMLSchema outSchema = builder.build(nxsdIn, null);
        String targetNS = outSchema.getSchemaTargetNS();
        XSDElement fRoot = outSchema.getElement(targetNS, root);
        TranslatorFactory xf = TranslatorFactory.getInstance();
        Translator xlator = xf.createTranslator(outSchema, fRoot);
        ExtendedXMLSAXSerializer xmlSerializer = new ExtendedXMLSAXSerializer(out);
        BatchedXformHandler inputHandler = new BatchedXformHandler(xslIn, (ContentHandler)((Object)xmlSerializer), batchingSize, properties);
        xlator.translateFromNative(in, (Result)new SAXResult(inputHandler), new TranslationContext());
    }

    public static void doBatchedTranslateFromNative_Transform(InputStream in, ContentHandler contentHandler, InputStream xslIn, InputStream nxsdIn, String root, int batchingSize, Map properties) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        XSDBuilder builder = new XSDBuilder();
        XMLSchema outSchema = builder.build(nxsdIn, null);
        String targetNS = outSchema.getSchemaTargetNS();
        XSDElement fRoot = outSchema.getElement(targetNS, root);
        TranslatorFactory xf = TranslatorFactory.getInstance();
        Translator xlator = xf.createTranslator(outSchema, fRoot);
        BatchedXformHandler inputHandler = new BatchedXformHandler(xslIn, contentHandler, batchingSize, properties);
        xlator.translateFromNative(in, (Result)new SAXResult(inputHandler), new TranslationContext());
    }

    public static void doBatchedTranslateFromNative_Transform_Translate2Native(InputStream in, OutputStream out, InputStream xslIn, InputStream sourceNXSDIn, String rootSource, InputStream targetNXSDIn, String rootTarget, int batchingSize, Map properties) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        XSDBuilder builder1 = new XSDBuilder();
        XSDBuilder builder2 = new XSDBuilder();
        XMLSchema sourceSchema = builder1.build(sourceNXSDIn, null);
        XMLSchema targetSchema = builder2.build(targetNXSDIn, null);
        String targetNSSource = sourceSchema.getSchemaTargetNS();
        XSDElement sourceRoot = sourceSchema.getElement(targetNSSource, rootSource);
        String targetNSTarget = targetSchema.getSchemaTargetNS();
        XSDElement targetRoot = targetSchema.getElement(targetNSTarget, rootTarget);
        TranslatorFactory xf = TranslatorFactory.getInstance();
        Translator xlatorInbound = xf.createTranslator(sourceSchema, sourceRoot);
        NXSDTranslatorImpl nxsdTranslatorInbound = (NXSDTranslatorImpl)xlatorInbound;
        Translator xlatorOutbound = xf.createTranslator(targetSchema, targetRoot);
        NXSDTranslatorImpl nxsdTranslatorOutbound = (NXSDTranslatorImpl)xlatorOutbound;
        TranslationContext ctx = new TranslationContext();
        ContentHandler mXlatorHandlerOutbound = nxsdTranslatorOutbound.getContentHandler(out, ctx);
        BatchedXformHandler inputHandler = new BatchedXformHandler(xslIn, mXlatorHandlerOutbound, batchingSize, properties);
        xlatorInbound.translateFromNative(in, (Result)new SAXResult(inputHandler), new TranslationContext());
    }

    public static String genGUID() {
        try {
            Class<?> clz = Class.forName("java.util.UUID");
            Method method = clz.getMethod("randomUUID", null);
            Object result = method.invoke(null, (Object[])null);
            return result.toString();
        }
        catch (Exception e) {
            return String.valueOf("GUID" + System.currentTimeMillis());
        }
    }
}

